/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.Cause;
import zio.Exit$;
import zio.ZIO;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Cookie;
import zio.http.ErrorResponseConfig;
import zio.http.Flash;
import zio.http.Flash$Setter$;
import zio.http.Handler;
import zio.http.Handler$;
import zio.http.Header;
import zio.http.Header$SetCookie$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.MediaType;
import zio.http.Path;
import zio.http.Path$;
import zio.http.Response$;
import zio.http.Response$Patch$;
import zio.http.Response$Patch$AddHeaders$;
import zio.http.Response$Patch$Combine$;
import zio.http.Response$Patch$Empty$;
import zio.http.Response$Patch$RemoveHeaders$;
import zio.http.Response$Patch$SetStatus$;
import zio.http.Response$Patch$UpdateHeaders$;
import zio.http.ServerSentEvent;
import zio.http.Status;
import zio.http.URL;
import zio.http.WebSocketApp;
import zio.http.internal.HeaderOps;
import zio.http.template.Html;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.schema.StandardType;
import zio.schema.codec.BinaryCodec;
import zio.stream.ZStream;

public final class Response
implements HeaderOps<Response>,
Product,
Serializable {
    private final Status status;
    private final Headers headers;
    private final Body body;
    private Object encoded;

    public static Response apply(Status status, Headers headers, Body body) {
        return Response$.MODULE$.apply(status, headers, body);
    }

    public static Response badGateway() {
        return Response$.MODULE$.badGateway();
    }

    public static Response badGateway(String string) {
        return Response$.MODULE$.badGateway(string);
    }

    public static Response badRequest() {
        return Response$.MODULE$.badRequest();
    }

    public static Response badRequest(String string) {
        return Response$.MODULE$.badRequest(string);
    }

    public static Response error(Status.Error error) {
        return Response$.MODULE$.error(error);
    }

    public static Response error(Status.Error error, Body body) {
        return Response$.MODULE$.error(error, body);
    }

    public static Response error(Status.Error error, String string) {
        return Response$.MODULE$.error(error, string);
    }

    public static Response forbidden() {
        return Response$.MODULE$.forbidden();
    }

    public static Response forbidden(String string) {
        return Response$.MODULE$.forbidden(string);
    }

    public static Response fromCause(Cause<Object> cause) {
        return Response$.MODULE$.fromCause(cause);
    }

    public static Response fromCause(Cause<Object> cause, ErrorResponseConfig errorResponseConfig) {
        return Response$.MODULE$.fromCause(cause, errorResponseConfig);
    }

    public static <E> Response fromCauseWith(Cause<E> cause, ErrorResponseConfig errorResponseConfig, Function1<E, Response> function1) {
        return Response$.MODULE$.fromCauseWith(cause, errorResponseConfig, function1);
    }

    public static Response fromProduct(Product product) {
        return Response$.MODULE$.fromProduct(product);
    }

    public static <T> Response fromServerSentEvent(ServerSentEvent<T> serverSentEvent, Schema<T> schema, Object object) {
        return Response$.MODULE$.fromServerSentEvent(serverSentEvent, schema, object);
    }

    public static <T> Response fromServerSentEvents(Iterable<ServerSentEvent<T>> iterable, Schema<T> schema, Object object) {
        return Response$.MODULE$.fromServerSentEvents(iterable, schema, object);
    }

    public static <T> Response fromServerSentEvents(ZStream<Object, Nothing$, ServerSentEvent<T>> zStream, Schema<T> schema, Object object) {
        return Response$.MODULE$.fromServerSentEvents(zStream, schema, object);
    }

    public static <R> ZIO<R, Nothing$, Response> fromSocketApp(WebSocketApp<R> webSocketApp, Object object) {
        return Response$.MODULE$.fromSocketApp(webSocketApp, object);
    }

    public static Response fromThrowable(Throwable throwable) {
        return Response$.MODULE$.fromThrowable(throwable);
    }

    public static Response fromThrowable(Throwable throwable, ErrorResponseConfig errorResponseConfig) {
        return Response$.MODULE$.fromThrowable(throwable, errorResponseConfig);
    }

    public static Response gatewayTimeout() {
        return Response$.MODULE$.gatewayTimeout();
    }

    public static Response gatewayTimeout(String string) {
        return Response$.MODULE$.gatewayTimeout(string);
    }

    public static Response html(Html html, Status status) {
        return Response$.MODULE$.html(html, status);
    }

    public static Response httpVersionNotSupported() {
        return Response$.MODULE$.httpVersionNotSupported();
    }

    public static Response httpVersionNotSupported(String string) {
        return Response$.MODULE$.httpVersionNotSupported(string);
    }

    public static Response internalServerError() {
        return Response$.MODULE$.internalServerError();
    }

    public static Response internalServerError(String string) {
        return Response$.MODULE$.internalServerError(string);
    }

    public static Response json(CharSequence charSequence) {
        return Response$.MODULE$.json(charSequence);
    }

    public static Response networkAuthenticationRequired() {
        return Response$.MODULE$.networkAuthenticationRequired();
    }

    public static Response networkAuthenticationRequired(String string) {
        return Response$.MODULE$.networkAuthenticationRequired(string);
    }

    public static Response notExtended() {
        return Response$.MODULE$.notExtended();
    }

    public static Response notExtended(String string) {
        return Response$.MODULE$.notExtended(string);
    }

    public static Response notFound() {
        return Response$.MODULE$.notFound();
    }

    public static Response notFound(String string) {
        return Response$.MODULE$.notFound(string);
    }

    public static Response notImplemented() {
        return Response$.MODULE$.notImplemented();
    }

    public static Response notImplemented(String string) {
        return Response$.MODULE$.notImplemented(string);
    }

    public static Response ok() {
        return Response$.MODULE$.ok();
    }

    public static Response redirect(URL uRL, boolean bl) {
        return Response$.MODULE$.redirect(uRL, bl);
    }

    public static Response seeOther(URL uRL) {
        return Response$.MODULE$.seeOther(uRL);
    }

    public static Response serviceUnavailable() {
        return Response$.MODULE$.serviceUnavailable();
    }

    public static Response serviceUnavailable(String string) {
        return Response$.MODULE$.serviceUnavailable(string);
    }

    public static Response text(CharSequence charSequence) {
        return Response$.MODULE$.text(charSequence);
    }

    public static Response unapply(Response response) {
        return Response$.MODULE$.unapply(response);
    }

    public static Response unauthorized() {
        return Response$.MODULE$.unauthorized();
    }

    public static Response unauthorized(String string) {
        return Response$.MODULE$.unauthorized(string);
    }

    public static Status $lessinit$greater$default$1() {
        return Response$.MODULE$.$lessinit$greater$default$1();
    }

    public static Headers $lessinit$greater$default$2() {
        return Response$.MODULE$.$lessinit$greater$default$2();
    }

    public static Status html$default$2() {
        return Response$.MODULE$.html$default$2();
    }

    public static boolean redirect$default$2() {
        return Response$.MODULE$.redirect$default$2();
    }

    public static Body $lessinit$greater$default$3() {
        return Response$.MODULE$.$lessinit$greater$default$3();
    }

    public Response(Status status, Headers headers, Body body) {
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.encoded = null;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Response)) return false;
        Response response = (Response)object;
        Status status = this.status();
        Status status2 = response.status();
        if (status == null) {
            if (status2 != null) {
                return false;
            }
        } else if (!status.equals(status2)) return false;
        Headers headers = this.headers();
        Headers headers2 = response.headers();
        if (headers == null) {
            if (headers2 != null) {
                return false;
            }
        } else if (!headers.equals(headers2)) return false;
        Body body = this.body();
        Body body2 = response.body();
        if (body == null) {
            if (body2 == null) return true;
            return false;
        } else {
            if (!body.equals(body2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Response;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "Response";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "status";
            }
            case 1: {
                return "headers";
            }
            case 2: {
                return "body";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Status status() {
        return this.status;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    public Body body() {
        return this.body;
    }

    public Object encoded() {
        return this.encoded;
    }

    public void encoded_$eq(Object x$1) {
        this.encoded = x$1;
    }

    public Response addCookie(Cookie.Response cookie) {
        Headers headers = this.headers().$plus$plus(Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$SetCookie$.MODULE$.apply(cookie)})));
        Status status = this.copy$default$1();
        Body body = this.copy$default$3();
        return this.copy(status, headers, body);
    }

    public Response addCookies(Cookie.Response cookie, Seq<Cookie.Response> cookies) {
        return this.updateHeaders((Function1 & Serializable)_$1 -> (Headers)_$1.addHeaders(Headers$.MODULE$.fromIterable((Iterable<Header>)((Iterable)((IterableOps)cookies.$plus$colon((Object)cookie)).map((Function1 & Serializable)_$2 -> Header$SetCookie$.MODULE$.apply((Cookie.Response)_$2))))), (Object)"zio.http.Response.addCookies(Response.scala:46)");
    }

    public <A> Response addFlash(Flash.Setter<A> setter) {
        Cookie.Response response = Flash$Setter$.MODULE$.run(setter);
        Some some = Some$.MODULE$.apply((Object)Path$.MODULE$.root());
        String string = response.copy$default$1();
        String string2 = response.copy$default$2();
        Option<String> option = response.copy$default$3();
        boolean bl = response.copy$default$5();
        boolean bl2 = response.copy$default$6();
        Option<Duration> option2 = response.copy$default$7();
        Option<Cookie.SameSite> option3 = response.copy$default$8();
        return this.addCookie(response.copy(string, string2, option, (Option<Path>)some, bl, bl2, option2, option3));
    }

    public ZIO<Object, Nothing$, Response> collect(Object trace) {
        return this.body().materialize(trace).map((Function1 & Serializable)b -> {
            if (b == this.body()) {
                return this;
            }
            return this.copy(this.copy$default$1(), this.copy$default$2(), (Body)b);
        }, trace);
    }

    public Response contentType(MediaType mediaType) {
        return (Response)this.addHeader("content-type", mediaType.fullType(), Schema$.MODULE$.primitive((StandardType)StandardType.StringType$.MODULE$));
    }

    public ZIO<Object, Nothing$, Response> ignoreBody(Object trace) {
        Body body = Body$.MODULE$.empty();
        Status status = this.copy$default$1();
        Headers headers = this.copy$default$2();
        Response out = this.copy(status, headers, body);
        Body body0 = this.body();
        if (body0.isComplete()) {
            return Exit$.MODULE$.succeed((Object)out);
        }
        return body0.asStream(trace).runDrain(trace).ignore(trace).as(() -> Response.ignoreBody$$anonfun$1(out), trace);
    }

    public Response patch(Patch p, Object trace) {
        return p.apply(this, trace);
    }

    public Response status(Status status) {
        return this.copy(status, this.copy$default$2(), this.copy$default$3());
    }

    public <A> ZIO<Object, Throwable, A> bodyAs(BinaryCodec<A> codec, Object trace) {
        return this.body().to(codec, trace);
    }

    public Handler<Object, Nothing$, Object, Response> toHandler(Object trace) {
        return Handler$.MODULE$.fromResponse((Function0<Response>)((Function0 & Serializable)this::toHandler$$anonfun$1));
    }

    @Override
    public Response updateHeaders(Function1<Headers, Headers> update, Object trace) {
        Headers headers = (Headers)update.apply((Object)this.headers());
        Status status = this.copy$default$1();
        Body body = this.copy$default$3();
        return this.copy(status, headers, body);
    }

    public Response copy(Status status, Headers headers, Body body) {
        return new Response(status, headers, body);
    }

    public Status copy$default$1() {
        return this.status();
    }

    public Headers copy$default$2() {
        return this.headers();
    }

    public Body copy$default$3() {
        return this.body();
    }

    public Status _1() {
        return this.status();
    }

    public Headers _2() {
        return this.headers();
    }

    public Body _3() {
        return this.body();
    }

    private static final Response ignoreBody$$anonfun$1(Response out$1) {
        return out$1;
    }

    private final Response toHandler$$anonfun$1() {
        return this;
    }

    public static interface Patch {
        public static Patch addHeader(CharSequence charSequence, CharSequence charSequence2) {
            return Response$Patch$.MODULE$.addHeader(charSequence, charSequence2);
        }

        public static Patch addHeader(Header header) {
            return Response$Patch$.MODULE$.addHeader(header);
        }

        public static Patch addHeader(Header.HeaderType headerType, Header header) {
            return Response$Patch$.MODULE$.addHeader(headerType, header);
        }

        public static Patch addHeaders(Headers headers) {
            return Response$Patch$.MODULE$.addHeaders(headers);
        }

        public static Patch empty() {
            return Response$Patch$.MODULE$.empty();
        }

        public static int ordinal(Patch patch) {
            return Response$Patch$.MODULE$.ordinal(patch);
        }

        public static Patch removeHeaders(Set<Header.HeaderType> set) {
            return Response$Patch$.MODULE$.removeHeaders(set);
        }

        public static Patch status(Status status) {
            return Response$Patch$.MODULE$.status(status);
        }

        public static Patch updateHeaders(Function1<Headers, Headers> function1) {
            return Response$Patch$.MODULE$.updateHeaders(function1);
        }

        public static Patch $plus$plus$(Patch $this, Patch that) {
            return $this.$plus$plus(that);
        }

        default public Patch $plus$plus(Patch that) {
            return Response$Patch$Combine$.MODULE$.apply(this, that);
        }

        public static Response apply$(Patch $this, Response res, Object trace) {
            return $this.apply(res, trace);
        }

        default public Response apply(Response res, Object trace) {
            return this.loop$1(trace, res, this);
        }

        private Response loop$1(Object trace$1, Response res, Patch patch) {
            Patch patch2;
            while (true) {
                if (Response$Patch$Empty$.MODULE$.equals(patch2 = patch)) {
                    return res;
                }
                if (patch2 instanceof AddHeaders) {
                    Headers headers;
                    AddHeaders addHeaders = Response$Patch$AddHeaders$.MODULE$.unapply((AddHeaders)patch2);
                    Headers headers2 = headers = addHeaders._1();
                    return (Response)res.addHeaders(headers2);
                }
                if (patch2 instanceof RemoveHeaders) {
                    Set<String> set;
                    RemoveHeaders removeHeaders = Response$Patch$RemoveHeaders$.MODULE$.unapply((RemoveHeaders)patch2);
                    Set<String> headers = set = removeHeaders._1();
                    return (Response)res.removeHeaders((Set)headers);
                }
                if (patch2 instanceof SetStatus) {
                    Status status;
                    SetStatus setStatus = Response$Patch$SetStatus$.MODULE$.unapply((SetStatus)patch2);
                    Status status2 = status = setStatus._1();
                    return res.status(status2);
                }
                if (!(patch2 instanceof Combine)) break;
                Combine combine = Response$Patch$Combine$.MODULE$.unapply((Combine)patch2);
                Patch patch3 = combine._1();
                Patch patch4 = combine._2();
                Patch self = patch3;
                Patch other = patch4;
                Response response = self.apply(res, trace$1);
                Patch patch5 = other;
                res = response;
                patch = patch5;
            }
            if (patch2 instanceof UpdateHeaders) {
                Function1<Headers, Headers> function1;
                UpdateHeaders updateHeaders = Response$Patch$UpdateHeaders$.MODULE$.unapply((UpdateHeaders)patch2);
                Function1<Headers, Headers> f = function1 = updateHeaders._1();
                return res.updateHeaders((Function1)f, trace$1);
            }
            throw new MatchError((Object)patch2);
        }

        public static final class AddHeaders
        implements Patch,
        Product,
        Serializable {
            private final Headers headers;

            public static AddHeaders fromProduct(Product product) {
                return Response$Patch$AddHeaders$.MODULE$.fromProduct(product);
            }

            public static AddHeaders unapply(AddHeaders addHeaders) {
                return Response$Patch$AddHeaders$.MODULE$.unapply(addHeaders);
            }

            public AddHeaders(Headers headers) {
                this.headers = headers;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof AddHeaders)) return false;
                AddHeaders addHeaders = (AddHeaders)object;
                Headers headers = this.headers();
                Headers headers2 = addHeaders.headers();
                if (headers != null) {
                    if (!headers.equals(headers2)) return false;
                    return true;
                }
                if (headers2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof AddHeaders;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "AddHeaders";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "headers";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Headers headers() {
                return this.headers;
            }

            public AddHeaders copy(Headers headers) {
                return new AddHeaders(headers);
            }

            public Headers copy$default$1() {
                return this.headers();
            }

            public Headers _1() {
                return this.headers();
            }
        }

        public static final class Combine
        implements Patch,
        Product,
        Serializable {
            private final Patch left;
            private final Patch right;

            public static Combine fromProduct(Product product) {
                return Response$Patch$Combine$.MODULE$.fromProduct(product);
            }

            public static Combine unapply(Combine combine) {
                return Response$Patch$Combine$.MODULE$.unapply(combine);
            }

            public Combine(Patch left, Patch right) {
                this.left = left;
                this.right = right;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Combine)) return false;
                Combine combine = (Combine)object;
                Patch patch = this.left();
                Patch patch2 = combine.left();
                if (patch == null) {
                    if (patch2 != null) {
                        return false;
                    }
                } else if (!patch.equals(patch2)) return false;
                Patch patch3 = this.right();
                Patch patch4 = combine.right();
                if (patch3 == null) {
                    if (patch4 == null) return true;
                    return false;
                } else {
                    if (!patch3.equals(patch4)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Combine;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "Combine";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "left";
                }
                if (1 == n2) {
                    return "right";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Patch left() {
                return this.left;
            }

            public Patch right() {
                return this.right;
            }

            public Combine copy(Patch left, Patch right) {
                return new Combine(left, right);
            }

            public Patch copy$default$1() {
                return this.left();
            }

            public Patch copy$default$2() {
                return this.right();
            }

            public Patch _1() {
                return this.left();
            }

            public Patch _2() {
                return this.right();
            }
        }

        public static final class RemoveHeaders
        implements Patch,
        Product,
        Serializable {
            private final Set headers;

            public static RemoveHeaders fromProduct(Product product) {
                return Response$Patch$RemoveHeaders$.MODULE$.fromProduct(product);
            }

            public static RemoveHeaders unapply(RemoveHeaders removeHeaders) {
                return Response$Patch$RemoveHeaders$.MODULE$.unapply(removeHeaders);
            }

            public RemoveHeaders(Set<String> headers) {
                this.headers = headers;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof RemoveHeaders)) return false;
                RemoveHeaders removeHeaders = (RemoveHeaders)object;
                Set<String> set = this.headers();
                Set<String> set2 = removeHeaders.headers();
                if (set != null) {
                    if (!set.equals(set2)) return false;
                    return true;
                }
                if (set2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof RemoveHeaders;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "RemoveHeaders";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "headers";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Set<String> headers() {
                return this.headers;
            }

            public RemoveHeaders copy(Set<String> headers) {
                return new RemoveHeaders(headers);
            }

            public Set<String> copy$default$1() {
                return this.headers();
            }

            public Set<String> _1() {
                return this.headers();
            }
        }

        public static final class SetStatus
        implements Patch,
        Product,
        Serializable {
            private final Status status;

            public static SetStatus fromProduct(Product product) {
                return Response$Patch$SetStatus$.MODULE$.fromProduct(product);
            }

            public static SetStatus unapply(SetStatus setStatus) {
                return Response$Patch$SetStatus$.MODULE$.unapply(setStatus);
            }

            public SetStatus(Status status) {
                this.status = status;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof SetStatus)) return false;
                SetStatus setStatus = (SetStatus)object;
                Status status = this.status();
                Status status2 = setStatus.status();
                if (status != null) {
                    if (!status.equals(status2)) return false;
                    return true;
                }
                if (status2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof SetStatus;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "SetStatus";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "status";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Status status() {
                return this.status;
            }

            public SetStatus copy(Status status) {
                return new SetStatus(status);
            }

            public Status copy$default$1() {
                return this.status();
            }

            public Status _1() {
                return this.status();
            }
        }

        public static final class UpdateHeaders
        implements Patch,
        Product,
        Serializable {
            private final Function1 f;

            public static UpdateHeaders fromProduct(Product product) {
                return Response$Patch$UpdateHeaders$.MODULE$.fromProduct(product);
            }

            public static UpdateHeaders unapply(UpdateHeaders updateHeaders) {
                return Response$Patch$UpdateHeaders$.MODULE$.unapply(updateHeaders);
            }

            public UpdateHeaders(Function1<Headers, Headers> f) {
                this.f = f;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof UpdateHeaders)) return false;
                UpdateHeaders updateHeaders = (UpdateHeaders)object;
                Function1<Headers, Headers> function1 = this.f();
                Function1<Headers, Headers> function12 = updateHeaders.f();
                if (function1 != null) {
                    if (!function1.equals(function12)) return false;
                    return true;
                }
                if (function12 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof UpdateHeaders;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "UpdateHeaders";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "f";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Function1<Headers, Headers> f() {
                return this.f;
            }

            public UpdateHeaders copy(Function1<Headers, Headers> f) {
                return new UpdateHeaders(f);
            }

            public Function1<Headers, Headers> copy$default$1() {
                return this.f();
            }

            public Function1<Headers, Headers> _1() {
                return this.f();
            }
        }
    }
}

