/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.NotDirectoryException;
import java.time.Duration;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.Exit;
import zio.Exit$;
import zio.NonEmptyChunk;
import zio.StackTrace;
import zio.Unsafe$;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.Charsets$;
import zio.http.ErrorResponseConfig;
import zio.http.ErrorResponseConfig$;
import zio.http.Handler;
import zio.http.Handler$ContraFlatMap$;
import zio.http.Handler$FromFunction$;
import zio.http.Handler$FromFunctionEither$;
import zio.http.Handler$FromFunctionExit$;
import zio.http.Handler$FromFunctionHandler$;
import zio.http.Handler$FromFunctionZIO$;
import zio.http.Handler$IsRequest$;
import zio.http.Handler$ParamExtractorBuilder$;
import zio.http.Handler$ResponseOutputSyntax$;
import zio.http.Handler$ScopedPartiallyApplied$;
import zio.http.HandlerPlatformSpecific;
import zio.http.HandlerVersionSpecific;
import zio.http.Header;
import zio.http.Header$Accept$;
import zio.http.Header$Accept$MediaTypeWithQFactor$;
import zio.http.Header$ContentLength$;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Method;
import zio.http.Middleware$;
import zio.http.Path;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Status;
import zio.http.Status$BadRequest$;
import zio.http.Status$Forbidden$;
import zio.http.Status$InternalServerError$;
import zio.http.Status$MethodNotAllowed$;
import zio.http.Status$NotFound$;
import zio.http.Status$Ok$;
import zio.http.Status$RequestEntityTooLarge$;
import zio.http.Status$RequestTimeout$;
import zio.http.ToHandler;
import zio.http.ToHandler$;
import zio.http.URL;
import zio.http.WebSocketApp;
import zio.http.WebSocketApp$;
import zio.http.WebSocketFrame;
import zio.http.package$;
import zio.http.template.Html;
import zio.http.template.Template$;
import zio.stream.ZStream;

public final class Handler$
implements HandlerPlatformSpecific,
HandlerVersionSpecific,
Serializable {
    public static final List<MediaType> zio$http$Handler$$$errorMediaTypes;
    public static final Handler$IsRequest$ IsRequest;
    private static final Handler badRequest;
    private static final Handler notFound;
    private static final Handler ok;
    private static final Handler tooLarge;
    private static final Handler unit;
    public static final Handler$ResponseOutputSyntax$ ResponseOutputSyntax;
    public static final Handler$ContraFlatMap$ ContraFlatMap;
    public static final Handler$FromFunction$ FromFunction;
    public static final Handler$FromFunctionHandler$ FromFunctionHandler;
    public static final Handler$FromFunctionEither$ FromFunctionEither;
    public static final Handler$FromFunctionExit$ FromFunctionExit;
    public static final Handler$FromFunctionZIO$ FromFunctionZIO;
    public static final Handler$ParamExtractorBuilder$ ParamExtractorBuilder;
    public static final Handler$ScopedPartiallyApplied$ ScopedPartiallyApplied;
    private static final boolean scopedPartiallyApplied;
    public static final Handler$ MODULE$;

    private Handler$() {
    }

    static {
        MODULE$ = new Handler$();
        zio$http$Handler$$$errorMediaTypes = (List)new .colon.colon((Object)MediaType$.MODULE$.text().html(), (List)new .colon.colon((Object)MediaType$.MODULE$.application().json(), (List)new .colon.colon((Object)MediaType$.MODULE$.text().plain(), (List)Nil$.MODULE$)));
        badRequest = MODULE$.error((Function0<Status.Error>)((Function0 & Serializable)MODULE$::$init$$$anonfun$1));
        BoxedUnit boxedUnit = MODULE$.fromFunctionHandler();
        notFound = Handler$FromFunctionHandler$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)request -> this.error((Function0<Status.Error>)((Function0 & Serializable)this::$init$$$anonfun$2$$anonfun$1), (Function0<String>)((Function0 & Serializable)() -> this.$init$$$anonfun$2$$anonfun$2(request))));
        ok = MODULE$.status((Function0<Status>)((Function0 & Serializable)MODULE$::$init$$$anonfun$3));
        tooLarge = MODULE$.status((Function0<Status>)((Function0 & Serializable)MODULE$::$init$$$anonfun$4));
        unit = MODULE$.fromExit(MODULE$::$init$$$anonfun$5);
        scopedPartiallyApplied = Handler$ScopedPartiallyApplied$.MODULE$.$lessinit$greater$default$1();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Handler$.class);
    }

    public Handler<Object, Throwable, Object, Chunk<Object>> asChunkBounded(Request request, int limit, Object trace) {
        return this.fromZIO(() -> Handler$.asChunkBounded$$anonfun$1(request, trace, limit));
    }

    public <Out> Handler<Object, Throwable, Object, Out> attempt(Function0<Out> out) {
        return this.fromExit(() -> Handler$.attempt$$anonfun$1(out));
    }

    public Handler<Object, Nothing$, Object, Response> badRequest() {
        return badRequest;
    }

    public Handler<Object, Nothing$, Object, Response> badRequest(Function0<String> message) {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)Handler$::badRequest$$anonfun$1), message);
    }

    public Handler<Object, Nothing$, Object, Nothing$> die(Function0<Throwable> failure) {
        return this.fromExit(() -> Handler$.die$$anonfun$1(failure));
    }

    public Handler<Object, Nothing$, Object, Nothing$> dieMessage(Function0<String> message) {
        return this.die((Function0<Throwable>)((Function0 & Serializable)() -> Handler$.dieMessage$$anonfun$1(message)));
    }

    public Handler<Object, Nothing$, Object, Response> error(Function0<Status.Error> status) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> Handler$.error$$anonfun$1(status)));
    }

    public Handler<Object, Nothing$, Object, Response> error(Function0<Status.Error> status, Function0<String> message) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> Handler$.error$$anonfun$2(status))).$at$at(Middleware$.MODULE$.interceptHandlerStateful(package$.MODULE$.handler(Handler$::error$$anonfun$3, ToHandler$.MODULE$.functionIsHandlerConstructor()), package$.MODULE$.handler(() -> this.error$$anonfun$4(status, message), ToHandler$.MODULE$.function2ZIOIsHandlerConstructor())), Handler$IsRequest$.MODULE$.request(), (.less.colon.less<Response, Response>)$less$colon$less$.MODULE$.refl(), (.less.colon.less<Nothing$, Response>)$less$colon$less$.MODULE$.refl());
    }

    public <Err> Handler<Object, Err, Object, Nothing$> fail(Function0<Err> err) {
        return this.fromExit(() -> Handler$.fail$$anonfun$1(err));
    }

    public <Err> Handler<Object, Err, Object, Nothing$> failCause(Function0<Cause<Err>> cause) {
        return this.fromExit(() -> Handler$.failCause$$anonfun$1(cause));
    }

    public <R, Err, In, Out> Handler<R, Err, In, Out> firstSuccessOf(NonEmptyChunk<Handler<R, Err, In, Out>> handlers, Function1<Cause<Err>, Object> isRecoverable, Object trace) {
        return (Handler)handlers.tail().foldLeft(handlers.head(), (Function2 & Serializable)(acc, handler) -> acc.catchAllCause((Function1 & Serializable)cause -> {
            if (BoxesRunTime.unboxToBoolean((Object)isRecoverable.apply(cause))) {
                return handler;
            }
            return MODULE$.failCause(() -> Handler$.firstSuccessOf$$anonfun$1$$anonfun$1$$anonfun$1(cause));
        }, trace));
    }

    public <R, Err, In, Out> Function1<Cause<Err>, Object> firstSuccessOf$default$2() {
        return (Function1 & Serializable)cause -> !cause.isDie();
    }

    public Handler<Object, Nothing$, Object, Response> forbidden() {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)Handler$::forbidden$$anonfun$1));
    }

    public Handler<Object, Nothing$, Object, Response> forbidden(Function0<String> message) {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)Handler$::forbidden$$anonfun$2), message);
    }

    public <H> Handler<Object, Object, Object, Object> from(Function0<H> handler, ToHandler<H> h) {
        return h.toHandler(handler);
    }

    public Handler<Object, Nothing$, Object, Response> fromBody(Function0<Body> body) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> Handler$.fromBody$$anonfun$1(body)));
    }

    public <Err, Out> Handler<Object, Err, Object, Out> fromEither(Function0<Either<Err, Out>> either) {
        return this.fromExit(() -> Handler$.fromEither$$anonfun$1(either));
    }

    public <Err, Out> Handler<Object, Err, Object, Out> fromExit(Function0<Exit<Err, Out>> exit) {
        return new Handler<Object, Err, Object, Out>(exit){
            private final Function0 exit$1;
            {
                this.exit$1 = exit$2;
            }

            public ZIO apply(Object in) {
                ZIO zIO;
                try {
                    zIO = (ZIO)this.exit$1.apply();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable error = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(error)) {
                        zIO = Exit$.MODULE$.die(error);
                    }
                    throw throwable;
                }
                return zIO;
            }
        };
    }

    public <In> BoxedUnit fromFunction() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionHandler() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionEither() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionExit() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionZIO() {
        return BoxedUnit.UNIT;
    }

    public Option<MediaType> determineMediaType(String filePath) {
        int n = filePath.lastIndexOf(".");
        if (-1 == n) {
            return None$.MODULE$;
        }
        int i = n;
        String ext = filePath.substring(i + 1);
        return MediaType$.MODULE$.forFileExtension(ext);
    }

    public <R> Handler<R, Throwable, Object, Response> fromFile(Function0<File> makeFile, Charset charset, Object trace) {
        return this.fromFileZIO(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$4 -> (File)makeFile.apply(), trace), charset, trace);
    }

    public <R> Charset fromFile$default$2() {
        return Charsets$.MODULE$.Utf8();
    }

    public <R> Handler<R, Throwable, Object, Response> fromFileZIO(ZIO<R, Throwable, File> getFile, Charset charset, Object trace) {
        return this.fromZIO(() -> Handler$.fromFileZIO$$anonfun$1(getFile, trace, charset));
    }

    public <R> Charset fromFileZIO$default$2() {
        return Charsets$.MODULE$.Utf8();
    }

    public <R> Handler<R, Throwable, Object, Response> fromStream(ZStream<R, Throwable, String> stream, long contentLength, Charset charset, Object trace) {
        return this.fromZIO(() -> Handler$.fromStream$$anonfun$1(trace, stream, contentLength, charset)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public <R> Charset fromStream$default$3() {
        return Charsets$.MODULE$.Http();
    }

    public <R> Handler<R, Throwable, Object, Response> fromStream(ZStream<R, Throwable, Object> stream, long contentLength, Object trace) {
        return this.fromZIO(() -> Handler$.fromStream$$anonfun$2(trace, stream, contentLength)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public <R> Handler<R, Throwable, Object, Response> fromStreamChunked(ZStream<R, Throwable, String> stream, Charset charset, Object trace) {
        return this.fromZIO(() -> Handler$.fromStreamChunked$$anonfun$1(trace, stream, charset)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public <R> Charset fromStreamChunked$default$2() {
        return Charsets$.MODULE$.Http();
    }

    public <R> Handler<R, Throwable, Object, Response> fromStreamChunked(ZStream<R, Throwable, Object> stream, Object trace) {
        return this.fromZIO(() -> Handler$.fromStreamChunked$$anonfun$2(trace, stream)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public <R, Err, Out> Handler<R, Err, Object, Out> fromZIO(Function0<ZIO<R, Err, Out>> zio) {
        return new Handler<R, Err, Object, Out>(zio){
            private final Function0 zio$1;
            {
                this.zio$1 = zio$2;
            }

            public ZIO apply(Object in) {
                ZIO zIO;
                try {
                    zIO = (ZIO)this.zio$1.apply();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable error = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(error)) {
                        zIO = ZIO$.MODULE$.die(() -> Handler$.zio$http$Handler$$anon$17$$_$apply$$anonfun$12(error), (Object)"zio.http.Handler.fromZIO.$anon.apply(Handler.scala:997)");
                    }
                    throw throwable;
                }
                return zIO;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$http$Handler$$anon$17$$_$apply$$anonfun$12(java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    public Handler<Object, Nothing$, Object, Response> html(Function0<Html> view) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> Handler$.html$$anonfun$1(view)));
    }

    public <A> Handler<Object, Nothing$, A, A> identity() {
        return new Handler<Object, Nothing$, A, A>(){

            public ZIO apply(Object in) {
                return Exit$.MODULE$.succeed(in);
            }
        };
    }

    public Handler<Object, Nothing$, Object, Response> internalServerError() {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)Handler$::internalServerError$$anonfun$1));
    }

    public Handler<Object, Nothing$, Object, Response> internalServerError(Function0<String> message) {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)Handler$::internalServerError$$anonfun$2), message);
    }

    public Handler<Object, Nothing$, Object, Response> methodNotAllowed() {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)Handler$::methodNotAllowed$$anonfun$1));
    }

    public Handler<Object, Nothing$, Object, Response> methodNotAllowed(Function0<String> message) {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)Handler$::methodNotAllowed$$anonfun$2), message);
    }

    public Handler<Object, Nothing$, Request, Response> notFound() {
        return notFound;
    }

    public Handler<Object, Nothing$, Object, Response> notFound(Function0<String> message) {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)Handler$::notFound$$anonfun$1), message);
    }

    public Handler<Object, Nothing$, Object, Response> ok() {
        return ok;
    }

    public <A> BoxedUnit param() {
        return BoxedUnit.UNIT;
    }

    public Handler<Object, Nothing$, Object, Response> fromResponse(Function0<Response> response) {
        return this.succeed(response);
    }

    public <R, Err> Handler<R, Err, Object, Response> fromResponseZIO(ZIO<R, Err, Response> getResponse) {
        return this.fromZIO(() -> Handler$.fromResponseZIO$$anonfun$1(getResponse));
    }

    public boolean scoped() {
        return scopedPartiallyApplied;
    }

    public Handler<Object, Nothing$, Object, StackTrace> stackTrace(Object trace) {
        return this.fromZIO(() -> Handler$.stackTrace$$anonfun$1(trace));
    }

    public Handler<Object, Nothing$, Object, Response> status(Function0<Status> code) {
        return this.succeed(() -> Handler$.status$$anonfun$2(code));
    }

    public <Out> Handler<Object, Nothing$, Object, Out> succeed(Function0<Out> out) {
        return this.fromExit(() -> Handler$.succeed$$anonfun$1(out));
    }

    public Handler<Object, Nothing$, Object, Response> template(Function0<CharSequence> heading, Html view) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> Handler$.template$$anonfun$1(heading, view)));
    }

    public Handler<Object, Nothing$, Object, Response> text(Function0<CharSequence> text) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> Handler$.text$$anonfun$1(text)));
    }

    public Handler<Object, Nothing$, Object, Response> timeout(Duration duration, Object trace) {
        return this.status((Function0<Status>)((Function0 & Serializable)Handler$::timeout$$anonfun$2)).delay(duration, trace);
    }

    public Handler<Object, Nothing$, Object, Response> tooLarge() {
        return tooLarge;
    }

    public Handler<Object, Nothing$, Object, BoxedUnit> unit() {
        return unit;
    }

    public final <Env> WebSocketApp<Env> webSocket(Function1<Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>>, ZIO<Env, Throwable, Object>> f) {
        BoxedUnit boxedUnit = this.fromFunctionZIO();
        return WebSocketApp$.MODULE$.apply(Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit, f));
    }

    public final <R, Err> Handler.RequestHandlerSyntax<R, Err> RequestHandlerSyntax(Handler<R, Err, Request, Response> self) {
        return new Handler.RequestHandlerSyntax<R, Err>(self);
    }

    public final <R, Err, In> Handler ResponseOutputSyntax(Handler<R, Err, In, Response> self) {
        return self;
    }

    private final Status.Error $init$$$anonfun$1() {
        return Status$BadRequest$.MODULE$;
    }

    private final Status.Error $init$$$anonfun$2$$anonfun$1() {
        return Status$NotFound$.MODULE$;
    }

    private final String $init$$$anonfun$2$$anonfun$2(Request request$1) {
        return request$1.url().path().encode();
    }

    private final Status $init$$$anonfun$3() {
        return Status$Ok$.MODULE$;
    }

    private final Status $init$$$anonfun$4() {
        return Status$RequestEntityTooLarge$.MODULE$;
    }

    private final Exit $init$$$anonfun$5() {
        return Exit$.MODULE$.unit();
    }

    private static final Chunk asChunkBounded$$anonfun$1$$anonfun$1() {
        return Chunk$.MODULE$.empty();
    }

    private static final Exception asChunkBounded$$anonfun$1$$anonfun$2$$anonfun$3() {
        return new Exception("Too large input");
    }

    private static final ZIO asChunkBounded$$anonfun$1(Request request$2, Object trace$20, int limit$1) {
        return request$2.body().asStream(trace$20).chunks(trace$20).runFoldZIO(Handler$::asChunkBounded$$anonfun$1$$anonfun$1, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Chunk acc = (Chunk)tuple2._1();
                Chunk bytes = (Chunk)tuple2._2();
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace$20, (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                    return acc.$plus$plus(bytes);
                }).filterOrFail((Function1 & Serializable)_$33 -> _$33.size() < limit$1, Handler$::asChunkBounded$$anonfun$1$$anonfun$2$$anonfun$3, trace$20);
            }
            throw new MatchError((Object)tuple2);
        }, trace$20);
    }

    private static final Exit attempt$$anonfun$1(Function0 out$11) {
        Exit exit;
        try {
            exit = Exit$.MODULE$.succeed(out$11.apply());
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(error)) {
                exit = Exit$.MODULE$.fail((Object)error);
            }
            throw throwable;
        }
        return exit;
    }

    private static final Status.Error badRequest$$anonfun$1() {
        return Status$BadRequest$.MODULE$;
    }

    private static final Exit die$$anonfun$1(Function0 failure$1) {
        return Exit$.MODULE$.die((Throwable)failure$1.apply());
    }

    private static final Throwable dieMessage$$anonfun$1(Function0 message$1) {
        return new RuntimeException((String)message$1.apply());
    }

    private static final Response error$$anonfun$1(Function0 status$5) {
        return Response$.MODULE$.error((Status.Error)status$5.apply());
    }

    private static final Response error$$anonfun$2(Function0 status$6) {
        return Response$.MODULE$.status((Status)status$6.apply());
    }

    private static final Function1 error$$anonfun$3() {
        return (Function1 & Serializable)req -> Tuple2$.MODULE$.apply((Object)req.header(Header$Accept$.MODULE$), (Object)Tuple2$.MODULE$.apply(req, (Object)BoxedUnit.UNIT));
    }

    public static final /* synthetic */ boolean zio$http$Handler$$anon$15$$_$isDefinedAt$$anonfun$1(MediaType mt$1, MediaType _$36) {
        return mt$1.matches(_$36, true);
    }

    public static final /* synthetic */ boolean zio$http$Handler$$anon$15$$_$applyOrElse$$anonfun$1(MediaType mt$2, MediaType _$36) {
        return mt$2.matches(_$36, true);
    }

    public static final /* synthetic */ boolean zio$http$Handler$$anon$15$$_$applyOrElse$$anonfun$2(MediaType mt$3, MediaType _$37) {
        return mt$3.matches(_$37, true);
    }

    private static final MediaType $anonfun$2(ErrorResponseConfig cfg$1) {
        return cfg$1.errorFormat().mediaType();
    }

    private final Function2 error$$anonfun$4(Function0 status$8, Function0 message$3) {
        return (Function2 & Serializable)(accept, res) -> ErrorResponseConfig$.MODULE$.configRef().get((Object)"zio.http.Handler.error(Handler.scala:774)").map((Function1 & Serializable)cfg -> {
            if (cfg.withErrorBody()) {
                MediaType mediaType;
                MediaType mediaType2 = mediaType = (MediaType)accept.flatMap((Function1 & Serializable)_$34 -> _$34.mimeTypes().sorted(Header$Accept$MediaTypeWithQFactor$.MODULE$.ordering()).map((Function1 & Serializable)_$35 -> _$35.mediaType()).collectFirst((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(MediaType x) {
                        MediaType mediaType = x;
                        MediaType mt = mediaType;
                        return Handler$.zio$http$Handler$$$errorMediaTypes.exists(arg_0 -> Handler$.zio$http$Handler$$anon$15$$_$isDefinedAt$$anonfun$1(mt, arg_0));
                    }

                    public final Object applyOrElse(MediaType x, Function1 function1) {
                        MediaType mediaType = x;
                        MediaType mt = mediaType;
                        if (Handler$.zio$http$Handler$$$errorMediaTypes.exists(arg_0 -> Handler$.zio$http$Handler$$anon$15$$_$applyOrElse$$anonfun$1(mt, arg_0))) {
                            return Handler$.zio$http$Handler$$$errorMediaTypes.find(arg_0 -> Handler$.zio$http$Handler$$anon$15$$_$applyOrElse$$anonfun$2(mt, arg_0)).get();
                        }
                        return function1.apply((Object)x);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$http$Handler$$anon$15$$_$isDefinedAt$$anonfun$1(zio.http.MediaType zio.http.MediaType ), zio$http$Handler$$anon$15$$_$applyOrElse$$anonfun$1(zio.http.MediaType zio.http.MediaType ), zio$http$Handler$$anon$15$$_$applyOrElse$$anonfun$2(zio.http.MediaType zio.http.MediaType )}, serializedLambda);
                    }
                })).getOrElse(() -> Handler$.$anonfun$2(cfg));
                MediaType mediaType3 = MediaType$.MODULE$.application().json();
                MediaType mediaType4 = mediaType2;
                if (!(mediaType3 != null ? !((Object)mediaType3).equals(mediaType4) : mediaType4 != null)) {
                    Status.Error error = (Status.Error)status$8.apply();
                    Body body = Body$.MODULE$.fromString(new StringBuilder(27).append("{\"status\": \"").append(status$8.apply()).append("\", \"error\": \"").append(message$3.apply()).append("\"}").toString(), Body$.MODULE$.fromString$default$2());
                    Headers headers = Response$.MODULE$.$lessinit$greater$default$2();
                    return Response$.MODULE$.apply(error, headers, body).contentType(MediaType$.MODULE$.application().json());
                }
                MediaType mediaType5 = MediaType$.MODULE$.text().html();
                MediaType mediaType6 = mediaType2;
                if (!(mediaType5 != null ? !((Object)mediaType5).equals(mediaType6) : mediaType6 != null)) {
                    Status.Error error = (Status.Error)status$8.apply();
                    Body body = Body$.MODULE$.fromString(new StringBuilder(85).append("<!DOCTYPE html><html><head><title>").append(status$8.apply()).append("</title></head><body><h1>").append(status$8.apply()).append("</h1><p>").append(message$3.apply()).append("</p></body></html>").toString(), Body$.MODULE$.fromString$default$2());
                    Headers headers = Response$.MODULE$.$lessinit$greater$default$2();
                    return Response$.MODULE$.apply(error, headers, body).contentType(MediaType$.MODULE$.text().html());
                }
                MediaType mediaType7 = MediaType$.MODULE$.text().plain();
                MediaType mediaType8 = mediaType2;
                if (!(mediaType7 != null ? !((Object)mediaType7).equals(mediaType8) : mediaType8 != null)) {
                    Status.Error error = (Status.Error)status$8.apply();
                    Body body = Body$.MODULE$.fromString((String)message$3.apply(), Body$.MODULE$.fromString$default$2());
                    Headers headers = Response$.MODULE$.$lessinit$greater$default$2();
                    return Response$.MODULE$.apply(error, headers, body).contentType(MediaType$.MODULE$.text().plain());
                }
                throw new Exception("Unsupported media type");
            }
            return res;
        }, (Object)"zio.http.Handler.error(Handler.scala:800)");
    }

    private static final Exit fail$$anonfun$1(Function0 err$11) {
        return Exit$.MODULE$.fail(err$11.apply());
    }

    private static final Exit failCause$$anonfun$1(Function0 cause$8) {
        return Exit$.MODULE$.failCause((Cause)cause$8.apply());
    }

    private static final Cause firstSuccessOf$$anonfun$1$$anonfun$1$$anonfun$1(Cause cause$9) {
        return cause$9;
    }

    private static final Status.Error forbidden$$anonfun$1() {
        return Status$Forbidden$.MODULE$;
    }

    private static final Status.Error forbidden$$anonfun$2() {
        return Status$Forbidden$.MODULE$;
    }

    private static final Response fromBody$$anonfun$1(Function0 body$5) {
        Body body = (Body)body$5.apply();
        Status status = Response$.MODULE$.$lessinit$greater$default$1();
        Headers headers = Response$.MODULE$.$lessinit$greater$default$2();
        return Response$.MODULE$.apply(status, headers, body);
    }

    private static final Exit fromEither$$anonfun$1(Function0 either$1) {
        return Exit$.MODULE$.fromEither((Either)either$1.apply());
    }

    private static final FileNotFoundException fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return new FileNotFoundException();
    }

    private static final AccessDeniedException fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(File file$1) {
        return new AccessDeniedException(file$1.getAbsolutePath());
    }

    private static final /* synthetic */ Response fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(Response response$1, MediaType mediaType$1, Option charset0$1) {
        Unsafe$ unsafe$2 = Unsafe$.MODULE$;
        return (Response)response$1.addHeader(Header$ContentType$.MODULE$.apply(mediaType$1, Header$ContentType$.MODULE$.$lessinit$greater$default$2(), (Option<Charset>)charset0$1));
    }

    private static final NotDirectoryException fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$4() {
        return new NotDirectoryException("Found directory instead of a file.");
    }

    private static final ZIO fromFileZIO$$anonfun$1$$anonfun$1(ZIO getFile$2, Object trace$24, Charset charset$2) {
        return getFile$2.flatMap((Function1 & Serializable)file -> {
            if (!file.exists()) {
                return ZIO$.MODULE$.fail(Handler$::fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1, trace$24);
            }
            if (file.isFile() && !file.canRead()) {
                return ZIO$.MODULE$.fail(() -> Handler$.fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(file), trace$24);
            }
            if (file.isFile()) {
                return Body$.MODULE$.fromFile((File)file, Body$.MODULE$.fromFile$default$2(), trace$24).flatMap((Function1 & Serializable)body -> {
                    Response response = Response$.MODULE$.apply(Response$.MODULE$.$lessinit$greater$default$1(), Response$.MODULE$.$lessinit$greater$default$2(), (Body)body);
                    String pathName = file.toPath().toString();
                    Option<MediaType> option = MODULE$.determineMediaType(pathName);
                    if (option instanceof Some) {
                        MediaType mediaType = (MediaType)((Some)option).value();
                        String string = mediaType.mainType();
                        String string2 = "text";
                        Some charset0 = !(string == null ? string2 != null : !string.equals(string2)) || !mediaType.binary() ? Some$.MODULE$.apply((Object)charset$2) : None$.MODULE$;
                        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace$24, () -> Handler$.fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(response, mediaType, (Option)charset0));
                    }
                    if (None$.MODULE$.equals(option)) {
                        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace$24, (Function0 & Serializable)() -> {
                            Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                            return response;
                        });
                    }
                    throw new MatchError(option);
                }, trace$24);
            }
            return ZIO$.MODULE$.fail(Handler$::fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$4, trace$24);
        }, trace$24);
    }

    private static final ZIO fromFileZIO$$anonfun$1(ZIO getFile$1, Object trace$23, Charset charset$1) {
        return ZIO$.MODULE$.blocking(() -> Handler$.fromFileZIO$$anonfun$1$$anonfun$1(getFile$1, trace$23, charset$1), trace$23);
    }

    private static final ZEnvironment fromStream$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(ZEnvironment env$2) {
        return env$2;
    }

    private static final Body fromStream$$anonfun$1$$anonfun$1$$anonfun$1(ZStream stream$3, ZEnvironment env$1, Object trace$29, long contentLength$3, Charset charset$7) {
        return Body$.MODULE$.fromCharSequenceStream((ZStream<Object, Throwable, CharSequence>)stream$3.provideEnvironment(() -> Handler$.fromStream$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(env$1), trace$29), contentLength$3, charset$7, trace$29);
    }

    private static final ZIO fromStream$$anonfun$1(Object trace$27, ZStream stream$1, long contentLength$1, Charset charset$5) {
        return ZIO$.MODULE$.environment(trace$27).map((Function1 & Serializable)env -> MODULE$.fromBody((Function0<Body>)((Function0 & Serializable)() -> Handler$.fromStream$$anonfun$1$$anonfun$1$$anonfun$1(stream$1, env, trace$27, contentLength$1, charset$5))), trace$27);
    }

    private static final ZEnvironment fromStream$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(ZEnvironment env$4) {
        return env$4;
    }

    private static final Body fromStream$$anonfun$2$$anonfun$1$$anonfun$1(ZStream stream$6, ZEnvironment env$3, Object trace$32, long contentLength$6) {
        return Body$.MODULE$.fromStream((ZStream<Object, Throwable, Object>)stream$6.provideEnvironment(() -> Handler$.fromStream$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(env$3), trace$32), contentLength$6);
    }

    private static final ZIO fromStream$$anonfun$2(Object trace$30, ZStream stream$4, long contentLength$4) {
        return ZIO$.MODULE$.environment(trace$30).map((Function1 & Serializable)env -> MODULE$.fromBody((Function0<Body>)((Function0 & Serializable)() -> Handler$.fromStream$$anonfun$2$$anonfun$1$$anonfun$1(stream$4, env, trace$30, contentLength$4))), trace$30);
    }

    private static final ZEnvironment fromStreamChunked$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(ZEnvironment env$6) {
        return env$6;
    }

    private static final Body fromStreamChunked$$anonfun$1$$anonfun$1$$anonfun$1(ZStream stream$9, ZEnvironment env$5, Object trace$35, Charset charset$10) {
        return Body$.MODULE$.fromCharSequenceStreamChunked((ZStream<Object, Throwable, CharSequence>)stream$9.provideEnvironment(() -> Handler$.fromStreamChunked$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(env$5), trace$35), charset$10, trace$35);
    }

    private static final ZIO fromStreamChunked$$anonfun$1(Object trace$33, ZStream stream$7, Charset charset$8) {
        return ZIO$.MODULE$.environment(trace$33).map((Function1 & Serializable)env -> MODULE$.fromBody((Function0<Body>)((Function0 & Serializable)() -> Handler$.fromStreamChunked$$anonfun$1$$anonfun$1$$anonfun$1(stream$7, env, trace$33, charset$8))), trace$33);
    }

    private static final ZEnvironment fromStreamChunked$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(ZEnvironment env$8) {
        return env$8;
    }

    private static final Body fromStreamChunked$$anonfun$2$$anonfun$1$$anonfun$1(ZStream stream$12, ZEnvironment env$7, Object trace$38) {
        return Body$.MODULE$.fromStreamChunked((ZStream<Object, Throwable, Object>)stream$12.provideEnvironment(() -> Handler$.fromStreamChunked$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(env$7), trace$38));
    }

    private static final ZIO fromStreamChunked$$anonfun$2(Object trace$36, ZStream stream$10) {
        return ZIO$.MODULE$.environment(trace$36).map((Function1 & Serializable)env -> MODULE$.fromBody((Function0<Body>)((Function0 & Serializable)() -> Handler$.fromStreamChunked$$anonfun$2$$anonfun$1$$anonfun$1(stream$10, env, trace$36))), trace$36);
    }

    public static final Throwable zio$http$Handler$$anon$17$$_$apply$$anonfun$12(Throwable error$1) {
        return error$1;
    }

    private static final Response html$$anonfun$1(Function0 view$1) {
        return Response$.MODULE$.html((Html)view$1.apply(), Response$.MODULE$.html$default$2());
    }

    private static final Status.Error internalServerError$$anonfun$1() {
        return Status$InternalServerError$.MODULE$;
    }

    private static final Status.Error internalServerError$$anonfun$2() {
        return Status$InternalServerError$.MODULE$;
    }

    private static final Status.Error methodNotAllowed$$anonfun$1() {
        return Status$MethodNotAllowed$.MODULE$;
    }

    private static final Status.Error methodNotAllowed$$anonfun$2() {
        return Status$MethodNotAllowed$.MODULE$;
    }

    private static final Status.Error notFound$$anonfun$1() {
        return Status$NotFound$.MODULE$;
    }

    private static final ZIO fromResponseZIO$$anonfun$1(ZIO getResponse$1) {
        return getResponse$1;
    }

    private static final ZIO stackTrace$$anonfun$1(Object trace$39) {
        return ZIO$.MODULE$.stackTrace(trace$39);
    }

    private static final Response status$$anonfun$2(Function0 code$1) {
        return Response$.MODULE$.apply((Status)code$1.apply(), Response$.MODULE$.$lessinit$greater$default$2(), Response$.MODULE$.$lessinit$greater$default$3());
    }

    private static final Exit succeed$$anonfun$1(Function0 out$12) {
        return Exit$.MODULE$.succeed(out$12.apply());
    }

    private static final Response template$$anonfun$1(Function0 heading$1, Html view$2) {
        return Response$.MODULE$.html(Template$.MODULE$.container((CharSequence)heading$1.apply(), view$2), Response$.MODULE$.html$default$2());
    }

    private static final Response text$$anonfun$1(Function0 text$1) {
        return Response$.MODULE$.text((CharSequence)text$1.apply());
    }

    private static final Status timeout$$anonfun$2() {
        return Status$RequestTimeout$.MODULE$;
    }

    public static final /* synthetic */ Response zio$http$Handler$RequestHandlerSyntax$$_$patch$$anonfun$1(Response.Patch patch$1, Object trace$40, Response _$38) {
        return patch$1.apply(_$38, trace$40);
    }

    public static final /* synthetic */ Request zio$http$Handler$RequestHandlerSyntax$$_$method$$anonfun$1(Method method$1, Request _$39) {
        return _$39.copy(_$39.copy$default$1(), method$1, _$39.copy$default$3(), _$39.copy$default$4(), _$39.copy$default$5(), _$39.copy$default$6(), _$39.copy$default$7());
    }

    public static final /* synthetic */ Request zio$http$Handler$RequestHandlerSyntax$$_$path$$anonfun$1(Path path$1, Request _$40) {
        return _$40.path(path$1);
    }

    public static final /* synthetic */ Request zio$http$Handler$RequestHandlerSyntax$$_$url$$anonfun$1(URL url$2, Request _$41) {
        return _$41.copy(_$41.copy$default$1(), _$41.copy$default$2(), url$2, _$41.copy$default$4(), _$41.copy$default$5(), _$41.copy$default$6(), _$41.copy$default$7());
    }

    public static final /* synthetic */ Response zio$http$Handler$RequestHandlerSyntax$$_$updateHeaders$$anonfun$1(Function1 update$1, Object trace$41, Response _$42) {
        return _$42.updateHeaders(update$1, trace$41);
    }

    public static final /* synthetic */ Body zio$http$Handler$ResponseOutputSyntax$$$_$body$extension$$anonfun$1(Response _$43) {
        return _$43.body();
    }

    public static final /* synthetic */ Option zio$http$Handler$ResponseOutputSyntax$$$_$contentLength$extension$$anonfun$1(Response _$44) {
        return _$44.header(Header$ContentLength$.MODULE$);
    }

    public static final /* synthetic */ Headers zio$http$Handler$ResponseOutputSyntax$$$_$headers$extension$$anonfun$1(Response _$45) {
        return _$45.headers();
    }

    public static final /* synthetic */ Option zio$http$Handler$ResponseOutputSyntax$$$_$header$extension$$anonfun$1(Header.HeaderType headerType$2, Response _$46) {
        return _$46.header(headerType$2);
    }

    private static final String headerOrFail$extension$$anonfun$1$$anonfun$1(String error$2) {
        return error$2;
    }

    private static final Some headerOrFail$extension$$anonfun$1$$anonfun$2(Header value$1) {
        return Some$.MODULE$.apply((Object)value$1);
    }

    private static final None$ headerOrFail$extension$$anonfun$1$$anonfun$3() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ Handler zio$http$Handler$ResponseOutputSyntax$$$_$headerOrFail$extension$$anonfun$1(Header.HeaderType headerType$3, Response response) {
        Option option = response.headerOrFail(headerType$3);
        if (option instanceof Some) {
            Either either = (Either)((Some)option).value();
            if (either instanceof Left) {
                String error = (String)((Left)either).value();
                return MODULE$.fail(() -> Handler$.headerOrFail$extension$$anonfun$1$$anonfun$1(error));
            }
            if (either instanceof Right) {
                Header value = (Header)((Right)either).value();
                return MODULE$.succeed(() -> Handler$.headerOrFail$extension$$anonfun$1$$anonfun$2(value));
            }
        }
        if (None$.MODULE$.equals(option)) {
            return MODULE$.succeed(Handler$::headerOrFail$extension$$anonfun$1$$anonfun$3);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ Option zio$http$Handler$ResponseOutputSyntax$$$_$rawHeader$extension$$anonfun$1(CharSequence name$1, Response _$47) {
        return _$47.rawHeader(name$1);
    }

    public static final /* synthetic */ Status zio$http$Handler$ResponseOutputSyntax$$$_$status$extension$$anonfun$1(Response _$48) {
        return _$48.status();
    }

    public static final Throwable zio$http$Handler$FromFunctionHandler$$anon$20$$_$apply$$anonfun$13(Throwable error$3) {
        return error$3;
    }

    public static final Throwable zio$http$Handler$FromFunctionZIO$$anon$23$$_$apply$$anonfun$14(Throwable error$4) {
        return error$4;
    }
}

