/*
 * Copyright 2021 - 2023 Sporta Technologies PVT LTD & the ZIO HTTP contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package zio.http.template2

/**
 * Trait containing all HTML element definitions. This trait can be mixed into
 * package objects or other contexts. Elements are sorted alphabetically for
 * easy maintenance.
 */
trait HtmlElements {

  val a: Dom.Element             = Dom.element("a")
  val abbr: Dom.Element          = Dom.element("abbr")
  val address: Dom.Element       = Dom.element("address")
  val area: Dom.Element          = Dom.element("area")
  val article: Dom.Element       = Dom.element("article")
  val aside: Dom.Element         = Dom.element("aside")
  val audio: Dom.Element         = Dom.element("audio")
  val b: Dom.Element             = Dom.element("b")
  val base: Dom.Element          = Dom.element("base")
  val bdi: Dom.Element           = Dom.element("bdi")
  val bdo: Dom.Element           = Dom.element("bdo")
  val blockquote: Dom.Element    = Dom.element("blockquote")
  val body: Dom.Element          = Dom.element("body")
  val br: Dom.Element            = Dom.element("br")
  val button: Dom.Element        = Dom.element("button")
  val canvas: Dom.Element        = Dom.element("canvas")
  val caption: Dom.Element       = Dom.element("caption")
  val cite: Dom.Element          = Dom.element("cite")
  val code: Dom.Element          = Dom.element("code")
  val col: Dom.Element           = Dom.element("col")
  val colgroup: Dom.Element      = Dom.element("colgroup")
  val datalist: Dom.Element      = Dom.element("datalist")
  val dd: Dom.Element            = Dom.element("dd")
  val del: Dom.Element           = Dom.element("del")
  val details: Dom.Element       = Dom.element("details")
  val dfn: Dom.Element           = Dom.element("dfn")
  val dialog: Dom.Element        = Dom.element("dialog")
  val div: Dom.Element           = Dom.element("div")
  val dl: Dom.Element            = Dom.element("dl")
  val dt: Dom.Element            = Dom.element("dt")
  val em: Dom.Element            = Dom.element("em")
  val embed: Dom.Element         = Dom.element("embed")
  val fieldset: Dom.Element      = Dom.element("fieldset")
  val footer: Dom.Element        = Dom.element("footer")
  val form: Dom.Element          = Dom.element("form")
  val h1: Dom.Element            = Dom.element("h1")
  val h2: Dom.Element            = Dom.element("h2")
  val h3: Dom.Element            = Dom.element("h3")
  val h4: Dom.Element            = Dom.element("h4")
  val h5: Dom.Element            = Dom.element("h5")
  val h6: Dom.Element            = Dom.element("h6")
  val head: Dom.Element          = Dom.element("head")
  val header: Dom.Element        = Dom.element("header")
  val hr: Dom.Element            = Dom.element("hr")
  val html: Dom.Element          = Dom.element("html")
  val i: Dom.Element             = Dom.element("i")
  val iframe: Dom.Element        = Dom.element("iframe")
  val img: Dom.Element           = Dom.element("img")
  val input: Dom.Element         = Dom.element("input")
  val ins: Dom.Element           = Dom.element("ins")
  val kbd: Dom.Element           = Dom.element("kbd")
  val label: Dom.Element         = Dom.element("label")
  val legend: Dom.Element        = Dom.element("legend")
  val li: Dom.Element            = Dom.element("li")
  val link: Dom.Element          = Dom.element("link")
  val main: Dom.Element          = Dom.element("main")
  val map: Dom.Element           = Dom.element("map")
  val mark: Dom.Element          = Dom.element("mark")
  val math: Dom.Element          = Dom.element("math")
  val meta: Dom.Element          = Dom.element("meta")
  val meter: Dom.Element         = Dom.element("meter")
  val nav: Dom.Element           = Dom.element("nav")
  val `object`: Dom.Element      = Dom.element("object")
  val ol: Dom.Element            = Dom.element("ol")
  val optgroup: Dom.Element      = Dom.element("optgroup")
  val option: Dom.Element        = Dom.element("option")
  val output: Dom.Element        = Dom.element("output")
  val p: Dom.Element             = Dom.element("p")
  val param: Dom.Element         = Dom.element("param")
  val pre: Dom.Element           = Dom.element("pre")
  val progress: Dom.Element      = Dom.element("progress")
  val q: Dom.Element             = Dom.element("q")
  val rp: Dom.Element            = Dom.element("rp")
  val rt: Dom.Element            = Dom.element("rt")
  val ruby: Dom.Element          = Dom.element("ruby")
  val s: Dom.Element             = Dom.element("s")
  val samp: Dom.Element          = Dom.element("samp")
  val script: Dom.Element.Script = Dom.script
  val section: Dom.Element       = Dom.element("section")
  val select: Dom.Element        = Dom.element("select")
  val slot: Dom.Element          = Dom.element("slot")
  val small: Dom.Element         = Dom.element("small")
  val source: Dom.Element        = Dom.element("source")
  val span: Dom.Element          = Dom.element("span")
  val strong: Dom.Element        = Dom.element("strong")
  val style: Dom.Element.Style   = Dom.style
  val sub: Dom.Element           = Dom.element("sub")
  val summary: Dom.Element       = Dom.element("summary")
  val sup: Dom.Element           = Dom.element("sup")
  val svg: Dom.Element           = Dom.element("svg")
  val table: Dom.Element         = Dom.element("table")
  val tbody: Dom.Element         = Dom.element("tbody")
  val td: Dom.Element            = Dom.element("td")
  val template: Dom.Element      = Dom.element("template")
  val textarea: Dom.Element      = Dom.element("textarea")
  val tfoot: Dom.Element         = Dom.element("tfoot")
  val th: Dom.Element            = Dom.element("th")
  val thead: Dom.Element         = Dom.element("thead")
  val time: Dom.Element          = Dom.element("time")
  val title: Dom.Element         = Dom.element("title")
  val tr: Dom.Element            = Dom.element("tr")
  val track: Dom.Element         = Dom.element("track")
  val u: Dom.Element             = Dom.element("u")
  val ul: Dom.Element            = Dom.element("ul")
  val `var`: Dom.Element         = Dom.element("var")
  val video: Dom.Element         = Dom.element("video")
  val wbr: Dom.Element           = Dom.element("wbr")

  def text(content: String): Dom.Text        = Dom.text(content)
  def raw(content: String): Dom.RawHtml      = Dom.raw(content)
  val empty: Dom                             = Dom.empty
  def fragment(children: Dom*): Dom.Fragment = Dom.fragment(children: _*)
}

/**
 * Trait containing all HTML attribute definitions. This trait can be mixed into
 * package objects or other contexts. Attributes are sorted alphabetically for
 * easy maintenance.
 */
trait HtmlAttributes {

  val accept: Dom.PartialAttribute               = Dom.attr("accept")
  val accesskey: Dom.PartialAttribute            = Dom.attr("accesskey")
  val action: Dom.PartialAttribute               = Dom.attr("action")
  val alt: Dom.PartialAttribute                  = Dom.attr("alt")
  val ariaActivedescendant: Dom.PartialAttribute = Dom.attr("aria-activedescendant")
  val ariaAutocomplete: Dom.PartialAttribute     = Dom.attr("aria-autocomplete")
  val ariaChecked: Dom.PartialAttribute          = Dom.attr("aria-checked")
  val ariaColcount: Dom.PartialAttribute         = Dom.attr("aria-colcount")
  val ariaColindex: Dom.PartialAttribute         = Dom.attr("aria-colindex")
  val ariaColspan: Dom.PartialAttribute          = Dom.attr("aria-colspan")
  val ariaControls: Dom.PartialMultiAttribute    = Dom.multiAttr("aria-controls")
  val ariaDescribedby: Dom.PartialMultiAttribute = Dom.multiAttr("aria-describedby")
  val ariaDisabled: Dom.PartialAttribute         = Dom.attr("aria-disabled")
  val ariaDropeffect: Dom.PartialAttribute       = Dom.attr("aria-dropeffect")
  val ariaExpanded: Dom.PartialAttribute         = Dom.attr("aria-expanded")
  val ariaFlowto: Dom.PartialMultiAttribute      = Dom.multiAttr("aria-flowto")
  val ariaGrabbed: Dom.PartialAttribute          = Dom.attr("aria-grabbed")
  val ariaHaspopup: Dom.PartialAttribute         = Dom.attr("aria-haspopup")
  val ariaHidden: Dom.PartialAttribute           = Dom.attr("aria-hidden")
  val ariaInvalid: Dom.PartialAttribute          = Dom.attr("aria-invalid")
  val ariaLabel: Dom.PartialAttribute            = Dom.attr("aria-label")
  val ariaLabelledby: Dom.PartialMultiAttribute  = Dom.multiAttr("aria-labelledby")
  val ariaLevel: Dom.PartialAttribute            = Dom.attr("aria-level")
  val ariaLive: Dom.PartialAttribute             = Dom.attr("aria-live")
  val ariaMultiline: Dom.PartialAttribute        = Dom.attr("aria-multiline")
  val ariaMultiselectable: Dom.PartialAttribute  = Dom.attr("aria-multiselectable")
  val ariaOrientation: Dom.PartialAttribute      = Dom.attr("aria-orientation")
  val ariaOwns: Dom.PartialMultiAttribute        = Dom.multiAttr("aria-owns")
  val ariaPosinset: Dom.PartialAttribute         = Dom.attr("aria-posinset")
  val ariaPressed: Dom.PartialAttribute          = Dom.attr("aria-pressed")
  val ariaReadonly: Dom.PartialAttribute         = Dom.attr("aria-readonly")
  val ariaRequired: Dom.PartialAttribute         = Dom.attr("aria-required")
  val ariaRowcount: Dom.PartialAttribute         = Dom.attr("aria-rowcount")
  val ariaRowindex: Dom.PartialAttribute         = Dom.attr("aria-rowindex")
  val ariaRowspan: Dom.PartialAttribute          = Dom.attr("aria-rowspan")
  val ariaSelected: Dom.PartialAttribute         = Dom.attr("aria-selected")
  val ariaSetsize: Dom.PartialAttribute          = Dom.attr("aria-setsize")
  val ariaSort: Dom.PartialAttribute             = Dom.attr("aria-sort")
  val ariaValuemax: Dom.PartialAttribute         = Dom.attr("aria-valuemax")
  val ariaValuemin: Dom.PartialAttribute         = Dom.attr("aria-valuemin")
  val ariaValuenow: Dom.PartialAttribute         = Dom.attr("aria-valuenow")
  val ariaValuetext: Dom.PartialAttribute        = Dom.attr("aria-valuetext")
  val async: Dom.BooleanAttribute                = Dom.boolAttr("async")
  val autocomplete: Dom.PartialAttribute         = Dom.attr("autocomplete")
  val autofocus: Dom.BooleanAttribute            = Dom.boolAttr("autofocus")
  val autoplay: Dom.PartialAttribute             = Dom.attr("autoplay")
  val charset: Dom.PartialAttribute              = Dom.attr("charset")
  val checked: Dom.BooleanAttribute              = Dom.boolAttr("checked")
  val `class`: Dom.PartialMultiAttribute         = Dom.multiAttr("class")
  val className: Dom.PartialMultiAttribute       = Dom.multiAttr("class")
  val cols: Dom.PartialAttribute                 = Dom.attr("cols")
  val content: Dom.PartialAttribute              = Dom.attr("content")
  val contenteditable: Dom.PartialAttribute      = Dom.attr("contenteditable")
  val controls: Dom.PartialAttribute             = Dom.attr("controls")
  val defer: Dom.BooleanAttribute                = Dom.boolAttr("defer")
  val dir: Dom.PartialAttribute                  = Dom.attr("dir")
  val disabled: Dom.BooleanAttribute             = Dom.boolAttr("disabled")
  val draggable: Dom.PartialAttribute            = Dom.attr("draggable")
  val enctype: Dom.PartialAttribute              = Dom.attr("enctype")
  val `for`: Dom.PartialAttribute                = Dom.attr("for")
  val formNoValidate: Dom.BooleanAttribute       = Dom.boolAttr("formnovalidate")
  val height: Dom.PartialAttribute               = Dom.attr("height")
  val hidden: Dom.BooleanAttribute               = Dom.boolAttr("hidden")
  val href: Dom.PartialAttribute                 = Dom.attr("href")
  val id: Dom.PartialAttribute                   = Dom.attr("id")
  val itemScope: Dom.BooleanAttribute            = Dom.boolAttr("itemscope")
  val lang: Dom.PartialAttribute                 = Dom.attr("lang")
  val list: Dom.PartialAttribute                 = Dom.attr("list")
  val loop: Dom.PartialAttribute                 = Dom.attr("loop")
  val max: Dom.PartialAttribute                  = Dom.attr("max")
  val maxlength: Dom.PartialAttribute            = Dom.attr("maxlength")
  val method: Dom.PartialAttribute               = Dom.attr("method")
  val min: Dom.PartialAttribute                  = Dom.attr("min")
  val minlength: Dom.PartialAttribute            = Dom.attr("minlength")
  val multiple: Dom.BooleanAttribute             = Dom.boolAttr("multiple")
  val muted: Dom.PartialAttribute                = Dom.attr("muted")
  val name: Dom.PartialAttribute                 = Dom.attr("name")
  val noValidate: Dom.BooleanAttribute           = Dom.boolAttr("novalidate")
  val open: Dom.BooleanAttribute                 = Dom.boolAttr("open")
  val pattern: Dom.PartialAttribute              = Dom.attr("pattern")
  val placeholder: Dom.PartialAttribute          = Dom.attr("placeholder")
  val poster: Dom.PartialAttribute               = Dom.attr("poster")
  val preload: Dom.PartialAttribute              = Dom.attr("preload")
  val readOnly: Dom.BooleanAttribute             = Dom.boolAttr("readonly")
  val rel: Dom.PartialMultiAttribute             = Dom.multiAttr("rel")
  val required: Dom.BooleanAttribute             = Dom.boolAttr("required")
  val reversed: Dom.BooleanAttribute             = Dom.boolAttr("reversed")
  val role: Dom.PartialAttribute                 = Dom.attr("role")
  val rows: Dom.PartialAttribute                 = Dom.attr("rows")
  val scoped: Dom.BooleanAttribute               = Dom.boolAttr("scoped")
  val seamless: Dom.BooleanAttribute             = Dom.boolAttr("seamless")
  val selected: Dom.BooleanAttribute             = Dom.boolAttr("selected")
  val size: Dom.PartialAttribute                 = Dom.attr("size")
  val spellcheck: Dom.PartialAttribute           = Dom.attr("spellcheck")
  val src: Dom.PartialAttribute                  = Dom.attr("src")
  val step: Dom.PartialAttribute                 = Dom.attr("step")
  val styleAttr: Dom.PartialAttribute            = Dom.attr("style")
  val tabindex: Dom.PartialAttribute             = Dom.attr("tabindex")
  val target: Dom.PartialAttribute               = Dom.attr("target")
  val titleAttr: Dom.PartialAttribute            = Dom.attr("title")
  val translate: Dom.PartialAttribute            = Dom.attr("translate")
  val `type`: Dom.PartialAttribute               = Dom.attr("type")
  val value: Dom.PartialAttribute                = Dom.attr("value")
  val width: Dom.PartialAttribute                = Dom.attr("width")
  val wrap: Dom.PartialAttribute                 = Dom.attr("wrap")

  def aria(name: String): Dom.PartialAttribute   = Dom.attr(s"aria-$name")
  def custom(name: String): Dom.PartialAttribute = Dom.attr(name)
  def data(name: String): Dom.PartialAttribute   = Dom.attr(s"data-$name")
}
