/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import zio.http.SSLConfig;
import zio.http.SSLConfig$HttpBehaviour$Accept$;
import zio.http.Server;
import zio.http.netty.package$Names$;
import zio.http.netty.server.SSLUtil$;
import zio.http.netty.server.ServerHttpsHandler;

public class ServerSSLDecoder
extends ByteToMessageDecoder {
    private final SSLConfig sslConfig;
    private final Server.Config cfg;

    public ServerSSLDecoder(SSLConfig sslConfig, Server.Config cfg) {
        this.sslConfig = sslConfig;
        this.cfg = cfg;
    }

    public void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        ChannelPipeline pipeline = context.channel().pipeline();
        SslContext sslContext = SSLUtil$.MODULE$.sslConfigToSslContext(this.sslConfig);
        SSLConfig.HttpBehaviour httpBehaviour = this.sslConfig.behaviour();
        if (in.readableBytes() < 5) {
            return;
        }
        if (SslHandler.isEncrypted((ByteBuf)in, (boolean)false)) {
            pipeline.replace((ChannelHandler)this, package$Names$.MODULE$.SSLHandler(), (ChannelHandler)sslContext.newHandler(context.alloc()));
            return;
        }
        SSLConfig.HttpBehaviour httpBehaviour2 = httpBehaviour;
        if (SSLConfig$HttpBehaviour$Accept$.MODULE$.equals(httpBehaviour2)) {
            pipeline.remove((ChannelHandler)this);
            return;
        }
        pipeline.remove(package$Names$.MODULE$.HttpRequestHandler());
        if (this.cfg.keepAlive()) {
            pipeline.remove(package$Names$.MODULE$.HttpKeepAliveHandler());
        }
        pipeline.remove((ChannelHandler)this);
        pipeline.addLast(new ChannelHandler[]{new ServerHttpsHandler(httpBehaviour)});
    }
}

