/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import zio.Config;
import zio.http.ClientSSLCertConfig;
import zio.http.ClientSSLCertConfig$FromClientCertFile$;
import zio.http.ClientSSLCertConfig$FromClientCertResource$;
import zio.http.ClientSSLConfig;
import zio.http.ClientSSLConfig$Default$;
import zio.http.ClientSSLConfig$FromCertFile$;
import zio.http.ClientSSLConfig$FromCertResource$;
import zio.http.ClientSSLConfig$FromClientAndServerCert$;
import zio.http.ClientSSLConfig$FromJavaxNetSsl$;
import zio.http.ClientSSLConfig$FromJavaxNetSsl$Empty$;
import zio.http.ClientSSLConfig$FromJavaxNetSsl$File$;
import zio.http.ClientSSLConfig$FromJavaxNetSsl$Resource$;
import zio.http.ClientSSLConfig$FromTrustStoreFile$;
import zio.http.ClientSSLConfig$FromTrustStoreResource$;

public final class ClientSSLConverter$
implements Serializable {
    public static final ClientSSLConverter$ MODULE$ = new ClientSSLConverter$();

    private ClientSSLConverter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClientSSLConverter$.class);
    }

    private SslContextBuilder keyManagerTrustManagerToSslContext(Option<Tuple3<String, InputStream, Option<Config.Secret>>> keyManagerInfo, Option<Tuple3<String, InputStream, Option<Config.Secret>>> trustManagerInfo, SslContextBuilder sslContextBuilder) {
        Option mkeyManagerFactory = keyManagerInfo.map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                String keyStoreType = (String)tuple3._1();
                InputStream inputStream = (InputStream)tuple3._2();
                Option maybePassword = (Option)tuple3._3();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                char[] password = (char[])maybePassword.map((Function1 & Serializable)_$1 -> (char[])_$1.value().toArray(ClassTag$.MODULE$.apply(Character.TYPE))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                keyStore.load(inputStream, password);
                keyManagerFactory.init(keyStore, password);
                return keyManagerFactory;
            }
            throw new MatchError((Object)tuple3);
        });
        Option mtrustManagerFactory = trustManagerInfo.map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                String keyStoreType = (String)tuple3._1();
                InputStream inputStream = (InputStream)tuple3._2();
                Option maybePassword = (Option)tuple3._3();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                char[] password = (char[])maybePassword.map((Function1 & Serializable)_$2 -> (char[])_$2.value().toArray(ClassTag$.MODULE$.apply(Character.TYPE))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                keyStore.load(inputStream, password);
                trustManagerFactory.init(keyStore);
                return trustManagerFactory;
            }
            throw new MatchError((Object)tuple3);
        });
        ObjectRef bldr = ObjectRef.create((Object)SslContextBuilder.forClient());
        mkeyManagerFactory.foreach((Function1)(JProcedure1 & Serializable)kmf -> {
            bldr$1.elem = ((SslContextBuilder)bldr$1.elem).keyManager(kmf);
        });
        mtrustManagerFactory.foreach((Function1)(JProcedure1 & Serializable)tmf -> {
            bldr$2.elem = ((SslContextBuilder)bldr$2.elem).trustManager(tmf);
        });
        return (SslContextBuilder)bldr.elem;
    }

    private SslContextBuilder trustStoreToSslContext(InputStream trustStoreStream, Config.Secret trustStorePassword, SslContextBuilder sslContextBuilder) {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustStore.load(trustStoreStream, (char[])trustStorePassword.value().toArray(ClassTag$.MODULE$.apply(Character.TYPE)));
        trustManagerFactory.init(trustStore);
        return sslContextBuilder.trustManager(trustManagerFactory);
    }

    private SslContextBuilder buildNettySslContextBuilder(ClientSSLConfig sslConfig, SslContextBuilder sslContextBuilder) {
        ClientSSLConfig clientSSLConfig = sslConfig;
        if (ClientSSLConfig$Default$.MODULE$.equals(clientSSLConfig)) {
            return sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        if (clientSSLConfig instanceof ClientSSLConfig.FromCertFile) {
            String string;
            ClientSSLConfig.FromCertFile fromCertFile = ClientSSLConfig$FromCertFile$.MODULE$.unapply((ClientSSLConfig.FromCertFile)clientSSLConfig);
            String certPath = string = fromCertFile._1();
            FileInputStream certStream = new FileInputStream(certPath);
            return sslContextBuilder.trustManager((InputStream)certStream);
        }
        if (clientSSLConfig instanceof ClientSSLConfig.FromCertResource) {
            String string;
            ClientSSLConfig.FromCertResource fromCertResource = ClientSSLConfig$FromCertResource$.MODULE$.unapply((ClientSSLConfig.FromCertResource)clientSSLConfig);
            String certPath = string = fromCertResource._1();
            InputStream certStream = this.getClass().getClassLoader().getResourceAsStream(certPath);
            return sslContextBuilder.trustManager(certStream);
        }
        if (clientSSLConfig instanceof ClientSSLConfig.FromTrustStoreResource) {
            ClientSSLConfig.FromTrustStoreResource fromTrustStoreResource = ClientSSLConfig$FromTrustStoreResource$.MODULE$.unapply((ClientSSLConfig.FromTrustStoreResource)clientSSLConfig);
            String string = fromTrustStoreResource._1();
            Config.Secret secret = fromTrustStoreResource._2();
            String trustStorePath = string;
            Config.Secret trustStorePassword = secret;
            InputStream trustStoreStream = this.getClass().getClassLoader().getResourceAsStream(trustStorePath);
            return this.trustStoreToSslContext(trustStoreStream, trustStorePassword, sslContextBuilder);
        }
        if (clientSSLConfig instanceof ClientSSLConfig.FromClientAndServerCert) {
            ClientSSLConfig.FromClientAndServerCert fromClientAndServerCert = ClientSSLConfig$FromClientAndServerCert$.MODULE$.unapply((ClientSSLConfig.FromClientAndServerCert)clientSSLConfig);
            ClientSSLConfig clientSSLConfig2 = fromClientAndServerCert._1();
            ClientSSLCertConfig clientSSLCertConfig = fromClientAndServerCert._2();
            ClientSSLConfig serverCertConfig = clientSSLConfig2;
            if (clientSSLCertConfig instanceof ClientSSLCertConfig.FromClientCertFile) {
                ClientSSLCertConfig.FromClientCertFile fromClientCertFile = ClientSSLCertConfig$FromClientCertFile$.MODULE$.unapply((ClientSSLCertConfig.FromClientCertFile)clientSSLCertConfig);
                String string = fromClientCertFile._1();
                String string2 = fromClientCertFile._2();
                String certPath = string;
                String keyPath = string2;
                SslContextBuilder newBuilder = this.buildNettySslContextBuilder(serverCertConfig, sslContextBuilder);
                return (SslContextBuilder)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                    FileInputStream certInputStream = (FileInputStream)use.apply((Object)new FileInputStream(new File(certPath)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    FileInputStream keyInputStream = (FileInputStream)use.apply((Object)new FileInputStream(new File(keyPath)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    return newBuilder.keyManager((InputStream)certInputStream, (InputStream)keyInputStream);
                }).get();
            }
            ClientSSLConfig serverCertConfig2 = clientSSLConfig2;
            if (clientSSLCertConfig instanceof ClientSSLCertConfig.FromClientCertResource) {
                ClientSSLCertConfig.FromClientCertResource fromClientCertResource = ClientSSLCertConfig$FromClientCertResource$.MODULE$.unapply((ClientSSLCertConfig.FromClientCertResource)clientSSLCertConfig);
                String string = fromClientCertResource._1();
                String string3 = fromClientCertResource._2();
                String certPath = string;
                String keyPath = string3;
                SslContextBuilder newBuilder = this.buildNettySslContextBuilder(serverCertConfig2, sslContextBuilder);
                return (SslContextBuilder)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                    ClassLoader classLoader = MODULE$.getClass().getClassLoader();
                    InputStream certInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    InputStream keyInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    return newBuilder.keyManager(certInputStream, keyInputStream);
                }).get();
            }
        }
        if (clientSSLConfig instanceof ClientSSLConfig.FromTrustStoreFile) {
            ClientSSLConfig.FromTrustStoreFile fromTrustStoreFile = ClientSSLConfig$FromTrustStoreFile$.MODULE$.unapply((ClientSSLConfig.FromTrustStoreFile)clientSSLConfig);
            String string = fromTrustStoreFile._1();
            Config.Secret secret = fromTrustStoreFile._2();
            String trustStorePath = string;
            Config.Secret trustStorePassword = secret;
            FileInputStream trustStoreStream = new FileInputStream(trustStorePath);
            return this.trustStoreToSslContext(trustStoreStream, trustStorePassword, sslContextBuilder);
        }
        if (clientSSLConfig instanceof ClientSSLConfig.FromJavaxNetSsl) {
            None$ none$;
            None$ none$2;
            ClientSSLConfig.FromJavaxNetSsl fromJavaxNetSsl = ClientSSLConfig$FromJavaxNetSsl$.MODULE$.unapply((ClientSSLConfig.FromJavaxNetSsl)clientSSLConfig);
            String string = fromJavaxNetSsl._1();
            ClientSSLConfig.FromJavaxNetSsl.Source source = fromJavaxNetSsl._2();
            Option<Config.Secret> option = fromJavaxNetSsl._3();
            String string4 = fromJavaxNetSsl._4();
            ClientSSLConfig.FromJavaxNetSsl.Source source2 = fromJavaxNetSsl._5();
            Option<Config.Secret> option2 = fromJavaxNetSsl._6();
            String keyManagerKeyStoreType = string;
            ClientSSLConfig.FromJavaxNetSsl.Source keyManagerSource = source;
            Option<Config.Secret> keyManagerPassword = option;
            String trustManagerKeyStoreType = string4;
            ClientSSLConfig.FromJavaxNetSsl.Source trustManagerSource = source2;
            Option<Config.Secret> trustManagerPassword = option2;
            ClientSSLConfig.FromJavaxNetSsl.Source source3 = keyManagerSource;
            if (source3 instanceof ClientSSLConfig.FromJavaxNetSsl.File) {
                String string5;
                ClientSSLConfig.FromJavaxNetSsl.File file = ClientSSLConfig$FromJavaxNetSsl$File$.MODULE$.unapply((ClientSSLConfig.FromJavaxNetSsl.File)source3);
                String path = string5 = file._1();
                none$2 = Option$.MODULE$.apply((Object)new FileInputStream(path)).map((Function1 & Serializable)inputStream -> Tuple3$.MODULE$.apply((Object)keyManagerKeyStoreType, inputStream, (Object)keyManagerPassword));
            } else if (source3 instanceof ClientSSLConfig.FromJavaxNetSsl.Resource) {
                String string6;
                ClientSSLConfig.FromJavaxNetSsl.Resource resource = ClientSSLConfig$FromJavaxNetSsl$Resource$.MODULE$.unapply((ClientSSLConfig.FromJavaxNetSsl.Resource)source3);
                String path = string6 = resource._1();
                none$2 = Option$.MODULE$.apply((Object)this.getClass().getClassLoader().getResourceAsStream(path)).map((Function1 & Serializable)inputStream -> Tuple3$.MODULE$.apply((Object)keyManagerKeyStoreType, inputStream, (Object)keyManagerPassword));
            } else if (ClientSSLConfig$FromJavaxNetSsl$Empty$.MODULE$.equals(source3)) {
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError((Object)source3);
            }
            None$ keyManagerInfo = none$2;
            ClientSSLConfig.FromJavaxNetSsl.Source source4 = trustManagerSource;
            if (source4 instanceof ClientSSLConfig.FromJavaxNetSsl.File) {
                String string7;
                ClientSSLConfig.FromJavaxNetSsl.File file = ClientSSLConfig$FromJavaxNetSsl$File$.MODULE$.unapply((ClientSSLConfig.FromJavaxNetSsl.File)source4);
                String path = string7 = file._1();
                none$ = Option$.MODULE$.apply((Object)new FileInputStream(path)).map((Function1 & Serializable)inputStream -> Tuple3$.MODULE$.apply((Object)trustManagerKeyStoreType, inputStream, (Object)trustManagerPassword));
            } else if (source4 instanceof ClientSSLConfig.FromJavaxNetSsl.Resource) {
                String string8;
                ClientSSLConfig.FromJavaxNetSsl.Resource resource = ClientSSLConfig$FromJavaxNetSsl$Resource$.MODULE$.unapply((ClientSSLConfig.FromJavaxNetSsl.Resource)source4);
                String path = string8 = resource._1();
                none$ = Option$.MODULE$.apply((Object)this.getClass().getClassLoader().getResourceAsStream(path)).map((Function1 & Serializable)inputStream -> Tuple3$.MODULE$.apply((Object)trustManagerKeyStoreType, inputStream, (Object)trustManagerPassword));
            } else if (ClientSSLConfig$FromJavaxNetSsl$Empty$.MODULE$.equals(source4)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)source4);
            }
            None$ trustManagerInfo = none$;
            return this.keyManagerTrustManagerToSslContext((Option<Tuple3<String, InputStream, Option<Config.Secret>>>)keyManagerInfo, (Option<Tuple3<String, InputStream, Option<Config.Secret>>>)trustManagerInfo, sslContextBuilder);
        }
        throw new MatchError((Object)clientSSLConfig);
    }

    public SslContext toNettySSLContext(ClientSSLConfig sslConfig) {
        return this.buildNettySslContextBuilder(sslConfig, SslContextBuilder.forClient()).build();
    }
}

