/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.Chunk;
import zio.Chunk$;
import zio.Exit$;
import zio.Promise;
import zio.Queue;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.http.ChannelEvent;
import zio.http.ChannelEvent$;
import zio.http.ChannelEvent$UserEvent$HandshakeComplete$;
import zio.http.ChannelEvent$UserEvent$HandshakeTimeout$;
import zio.http.WebSocketFrame;
import zio.http.WebSocketFrame$Binary$;
import zio.http.WebSocketFrame$Close$;
import zio.http.WebSocketFrame$Continuation$;
import zio.http.WebSocketFrame$Ping$;
import zio.http.WebSocketFrame$Pong$;
import zio.http.WebSocketFrame$Text$;
import zio.http.internal.ChannelState;
import zio.http.internal.ChannelState$Invalid$;
import zio.http.netty.NettyRuntime;

public final class WebSocketAppHandler
extends SimpleChannelInboundHandler<io.netty.handler.codec.http.websocketx.WebSocketFrame> {
    private final NettyRuntime zExec;
    private final Queue<ChannelEvent<WebSocketFrame>> queue;
    private final Promise<Nothing$, Object> handshakeCompleted;
    private final Option<Promise<Throwable, ChannelState>> onComplete;
    private final Object trace;
    private final Unsafe unsafeClass;

    public WebSocketAppHandler(NettyRuntime zExec, Queue<ChannelEvent<WebSocketFrame>> queue, Promise<Nothing$, Object> handshakeCompleted, Option<Promise<Throwable, ChannelState>> onComplete, Object trace) {
        this.zExec = zExec;
        this.queue = queue;
        this.handshakeCompleted = handshakeCompleted;
        this.onComplete = onComplete;
        this.trace = trace;
        this.unsafeClass = Unsafe$.MODULE$.unsafe();
    }

    private void dispatch(ChannelEvent<io.netty.handler.codec.http.websocketx.WebSocketFrame> event) {
        boolean bl = BoxesRunTime.unboxToBoolean(this.zExec.unsafeRunSync(this.queue.offer(event.map((Function1 & Serializable)jFrame -> this.frameFromNetty((io.netty.handler.codec.http.websocketx.WebSocketFrame)jFrame)), this.trace), this.unsafeClass, this.trace));
    }

    public void channelRead0(ChannelHandlerContext ctx, io.netty.handler.codec.http.websocketx.WebSocketFrame msg) {
        this.dispatch(ChannelEvent$.MODULE$.read(msg));
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        this.dispatch(ChannelEvent$.MODULE$.registered());
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        this.dispatch(ChannelEvent$.MODULE$.unregistered());
        Option<Promise<Throwable, ChannelState>> option = this.onComplete;
        if (option instanceof Some) {
            Promise promise = (Promise)((Some)option).value();
            promise.unsafe().done((ZIO)Exit$.MODULE$.succeed((Object)ChannelState$Invalid$.MODULE$), this.unsafeClass);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.dispatch(ChannelEvent$.MODULE$.exceptionCaught(cause));
        Option<Promise<Throwable, ChannelState>> option = this.onComplete;
        if (option instanceof Some) {
            Promise promise = (Promise)((Some)option).value();
            promise.unsafe().done((ZIO)Exit$.MODULE$.fail((Object)cause), this.unsafeClass);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object msg) {
        block11: {
            block8: {
                Object object;
                WebSocketClientProtocolHandler.ClientHandshakeStateEvent clientHandshakeStateEvent;
                block10: {
                    Object object2;
                    block9: {
                        Object object3;
                        WebSocketServerProtocolHandler.ServerHandshakeStateEvent serverHandshakeStateEvent;
                        block7: {
                            block6: {
                                block4: {
                                    Object object4;
                                    WebSocketClientProtocolHandler.ClientHandshakeStateEvent clientHandshakeStateEvent2;
                                    block5: {
                                        object2 = msg;
                                        if (object2 instanceof WebSocketServerProtocolHandler.HandshakeComplete) break block4;
                                        clientHandshakeStateEvent2 = WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE;
                                        object4 = object2;
                                        if (clientHandshakeStateEvent2 != null) break block5;
                                        if (object4 == null) break block4;
                                        break block6;
                                    }
                                    if (!clientHandshakeStateEvent2.equals(object4)) break block6;
                                }
                                this.handshakeCompleted.unsafe().succeed((Object)BoxesRunTime.boxToBoolean((boolean)true), this.trace, this.unsafeClass);
                                this.dispatch(ChannelEvent$.MODULE$.userEventTriggered(ChannelEvent$UserEvent$HandshakeComplete$.MODULE$));
                                return;
                            }
                            serverHandshakeStateEvent = WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT;
                            object3 = object2;
                            if (serverHandshakeStateEvent != null) break block7;
                            if (object3 == null) break block8;
                            break block9;
                        }
                        if (serverHandshakeStateEvent.equals(object3)) break block8;
                    }
                    clientHandshakeStateEvent = WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT;
                    object = object2;
                    if (clientHandshakeStateEvent != null) break block10;
                    if (object == null) break block8;
                    break block11;
                }
                if (!clientHandshakeStateEvent.equals(object)) break block11;
            }
            this.handshakeCompleted.unsafe().succeed((Object)BoxesRunTime.boxToBoolean((boolean)false), this.trace, this.unsafeClass);
            this.dispatch(ChannelEvent$.MODULE$.userEventTriggered(ChannelEvent$UserEvent$HandshakeTimeout$.MODULE$));
            return;
        }
        super.userEventTriggered(ctx, msg);
    }

    private WebSocketFrame frameFromNetty(io.netty.handler.codec.http.websocketx.WebSocketFrame jFrame) {
        WebSocketFrame webSocketFrame;
        io.netty.handler.codec.http.websocketx.WebSocketFrame webSocketFrame2 = jFrame;
        if (webSocketFrame2 instanceof PingWebSocketFrame) {
            webSocketFrame = WebSocketFrame$Ping$.MODULE$;
        } else if (webSocketFrame2 instanceof PongWebSocketFrame) {
            webSocketFrame = WebSocketFrame$Pong$.MODULE$;
        } else if (webSocketFrame2 instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame m = (BinaryWebSocketFrame)webSocketFrame2;
            webSocketFrame = WebSocketFrame$Binary$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes((ByteBuf)m.content())), m.isFinalFragment());
        } else if (webSocketFrame2 instanceof TextWebSocketFrame) {
            TextWebSocketFrame m = (TextWebSocketFrame)webSocketFrame2;
            webSocketFrame = WebSocketFrame$Text$.MODULE$.apply(m.text(), m.isFinalFragment());
        } else if (webSocketFrame2 instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame m = (CloseWebSocketFrame)webSocketFrame2;
            webSocketFrame = WebSocketFrame$Close$.MODULE$.apply(m.statusCode(), (Option<String>)Option$.MODULE$.apply((Object)m.reasonText()));
        } else if (webSocketFrame2 instanceof ContinuationWebSocketFrame) {
            ContinuationWebSocketFrame m = (ContinuationWebSocketFrame)webSocketFrame2;
            webSocketFrame = WebSocketFrame$Continuation$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes((ByteBuf)m.content())), m.isFinalFragment());
        } else {
            webSocketFrame = null;
        }
        return webSocketFrame;
    }
}

