/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.util.AsciiString;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import zio.Chunk;
import zio.Chunk$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Header;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$;
import zio.http.netty.NettyBody$AsciiStringBody$;
import zio.http.netty.NettyBody$AsyncBody$;
import zio.http.netty.NettyBody$UnsafeAsync$Aggregating$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class NettyBody {
    public static Body fromAsciiString(AsciiString asciiString) {
        return NettyBody$.MODULE$.fromAsciiString(asciiString);
    }

    public static Body fromAsync(Function1<UnsafeAsync, BoxedUnit> function1, Option<Object> option, Option<Header.ContentType> option2, Function0<BoxedUnit> function0) {
        return NettyBody$.MODULE$.fromAsync(function1, option, option2, function0);
    }

    public static Body fromByteBuf(ByteBuf byteBuf, Option<Header.ContentType> option) {
        return NettyBody$.MODULE$.fromByteBuf(byteBuf, option);
    }

    public static Body fromCharSequence(CharSequence charSequence, Charset charset) {
        return NettyBody$.MODULE$.fromCharSequence(charSequence, charset);
    }

    public static Option<Header.ContentType> fromAsync$default$3() {
        return NettyBody$.MODULE$.fromAsync$default$3();
    }

    public static Function0<BoxedUnit> fromAsync$default$4() {
        return NettyBody$.MODULE$.fromAsync$default$4();
    }

    public static final class AsciiStringBody
    extends Body.UnsafeBytes
    implements Product,
    Serializable {
        private final AsciiString asciiString;
        private final Option contentType;

        public static AsciiStringBody apply(AsciiString asciiString, Option<Body.ContentType> option) {
            return NettyBody$AsciiStringBody$.MODULE$.apply(asciiString, option);
        }

        public static AsciiStringBody fromProduct(Product product) {
            return NettyBody$AsciiStringBody$.MODULE$.fromProduct(product);
        }

        public static AsciiStringBody unapply(AsciiStringBody asciiStringBody) {
            return NettyBody$AsciiStringBody$.MODULE$.unapply(asciiStringBody);
        }

        public static Option<Body.ContentType> $lessinit$greater$default$2() {
            return NettyBody$AsciiStringBody$.MODULE$.$lessinit$greater$default$2();
        }

        public AsciiStringBody(AsciiString asciiString, Option<Body.ContentType> contentType) {
            this.asciiString = asciiString;
            this.contentType = contentType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AsciiStringBody)) return false;
            AsciiStringBody asciiStringBody = (AsciiStringBody)object;
            AsciiString asciiString = this.asciiString();
            AsciiString asciiString2 = asciiStringBody.asciiString();
            if (asciiString == null) {
                if (asciiString2 != null) {
                    return false;
                }
            } else if (!asciiString.equals(asciiString2)) return false;
            Option<Body.ContentType> option = this.contentType();
            Option<Body.ContentType> option2 = asciiStringBody.contentType();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof AsciiStringBody;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AsciiStringBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "asciiString";
            }
            if (1 == n2) {
                return "contentType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AsciiString asciiString() {
            return this.asciiString;
        }

        @Override
        public Option<Body.ContentType> contentType() {
            return this.contentType;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                return this.asciiString().array();
            });
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.asciiString().isEmpty();
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                return Chunk$.MODULE$.fromArray((Object)this.asciiString().array());
            });
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.unwrap(() -> this.asStream$$anonfun$1(trace), trace);
        }

        public String toString() {
            return new StringBuilder(22).append("Body.fromAsciiString(").append((CharSequence)this.asciiString()).append(")").toString();
        }

        @Override
        public byte[] unsafeAsArray(Unsafe unsafe) {
            return this.asciiString().array();
        }

        @Override
        public Body contentType(Body.ContentType newContentType) {
            Some some = Some$.MODULE$.apply((Object)newContentType);
            AsciiString asciiString = this.copy$default$1();
            return this.copy(asciiString, (Option<Body.ContentType>)some);
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.asciiString().length()));
        }

        public AsciiStringBody copy(AsciiString asciiString, Option<Body.ContentType> contentType) {
            return new AsciiStringBody(asciiString, contentType);
        }

        public AsciiString copy$default$1() {
            return this.asciiString();
        }

        public Option<Body.ContentType> copy$default$2() {
            return this.contentType();
        }

        public AsciiString _1() {
            return this.asciiString();
        }

        public Option<Body.ContentType> _2() {
            return this.contentType();
        }

        private final ZIO asStream$$anonfun$1(Object trace$1) {
            return this.asChunk(trace$1).map(arg_0 -> NettyBody$.zio$http$netty$NettyBody$AsciiStringBody$$_$asStream$$anonfun$1$$anonfun$1(trace$1, arg_0), trace$1);
        }
    }

    public static final class AsyncBody
    implements Body,
    Product,
    Serializable {
        private final Function1 unsafeAsync;
        private final Option knownContentLength;
        private final Option contentType;
        private final Function0 nettyRead;

        public static AsyncBody apply(Function1<UnsafeAsync, BoxedUnit> function1, Option<Object> option, Option<Body.ContentType> option2, Function0<BoxedUnit> function0) {
            return NettyBody$AsyncBody$.MODULE$.apply(function1, option, option2, function0);
        }

        public static AsyncBody fromProduct(Product product) {
            return NettyBody$AsyncBody$.MODULE$.fromProduct(product);
        }

        public static AsyncBody unapply(AsyncBody asyncBody) {
            return NettyBody$AsyncBody$.MODULE$.unapply(asyncBody);
        }

        public static Option<Body.ContentType> $lessinit$greater$default$3() {
            return NettyBody$AsyncBody$.MODULE$.$lessinit$greater$default$3();
        }

        public AsyncBody(Function1<UnsafeAsync, BoxedUnit> unsafeAsync, Option<Object> knownContentLength, Option<Body.ContentType> contentType, Function0<BoxedUnit> nettyRead) {
            this.unsafeAsync = unsafeAsync;
            this.knownContentLength = knownContentLength;
            this.contentType = contentType;
            this.nettyRead = nettyRead;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AsyncBody)) return false;
            AsyncBody asyncBody = (AsyncBody)object;
            Function1<UnsafeAsync, BoxedUnit> function1 = this.unsafeAsync();
            Function1<UnsafeAsync, BoxedUnit> function12 = asyncBody.unsafeAsync();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Option<Object> option = this.knownContentLength();
            Option<Object> option2 = asyncBody.knownContentLength();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Body.ContentType> option3 = this.contentType();
            Option<Body.ContentType> option4 = asyncBody.contentType();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Function0<BoxedUnit> function0 = this.nettyRead();
            Function0<BoxedUnit> function02 = asyncBody.nettyRead();
            if (function0 == null) {
                if (function02 == null) return true;
                return false;
            } else {
                if (!function0.equals(function02)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof AsyncBody;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "AsyncBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "unsafeAsync";
                }
                case 1: {
                    return "knownContentLength";
                }
                case 2: {
                    return "contentType";
                }
                case 3: {
                    return "nettyRead";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<UnsafeAsync, BoxedUnit> unsafeAsync() {
            return this.unsafeAsync;
        }

        @Override
        public Option<Object> knownContentLength() {
            return this.knownContentLength;
        }

        @Override
        public Option<Body.ContentType> contentType() {
            return this.contentType;
        }

        public Function0<BoxedUnit> nettyRead() {
            return this.nettyRead;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return this.asChunk(trace).map(NettyBody$::zio$http$netty$NettyBody$AsyncBody$$_$asArray$$anonfun$2, trace);
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return ZIO$.MODULE$.async((Function1 & Serializable)evidence$3 -> (JProcedure1 & Serializable)cb -> {
                try {
                    this.unsafeAsync().apply((Object)NettyBody$UnsafeAsync$Aggregating$.MODULE$.apply(this.bufferSize(102400), (Function1<ZIO<Object, Throwable, Chunk<Object>>, BoxedUnit>)cb, trace));
                }
                catch (Throwable e) {
                    cb.apply((Object)ZIO$.MODULE$.fail(() -> NettyBody$.zio$http$netty$NettyBody$AsyncBody$$_$asChunk$$anonfun$2$$anonfun$1$$anonfun$1(e), trace));
                }
            }, NettyBody$::zio$http$netty$NettyBody$AsyncBody$$_$asChunk$$anonfun$3, trace);
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return NettyBody$.MODULE$.zio$http$netty$NettyBody$$$asyncUnboundedStream((JProcedure1 & Serializable)emit -> {
                try {
                    this.unsafeAsync().apply((Object)new UnsafeAsync.Streaming((ZStream.Emit<Object, Throwable, Object, BoxedUnit>)emit, trace));
                }
                catch (Throwable e) {
                    emit.apply(ZIO$.MODULE$.fail(() -> NettyBody$.zio$http$netty$NettyBody$AsyncBody$$_$asStream$$anonfun$2$$anonfun$1(e), trace));
                }
            }, (ZIO<Object, Nothing$, BoxedUnit>)ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                this.nettyRead().apply$mcV$sp();
            }), trace);
        }

        private int bufferSize(int maxSize) {
            long cl = BoxesRunTime.unboxToLong((Object)this.knownContentLength().getOrElse(NettyBody$::zio$http$netty$NettyBody$AsyncBody$$_$_$$anonfun$1));
            if (cl <= 16L) {
                return 16;
            }
            if (cl >= (long)maxSize) {
                return maxSize;
            }
            return Integer.highestOneBit((int)cl - 1) << 1;
        }

        @Override
        public boolean isComplete() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public String toString() {
            return new StringBuilder(11).append("AsyncBody(").append(this.unsafeAsync()).append(")").toString();
        }

        @Override
        public Body contentType(Body.ContentType newContentType) {
            Some some = Some$.MODULE$.apply((Object)newContentType);
            Function1<UnsafeAsync, BoxedUnit> function1 = this.copy$default$1();
            Option<Object> option = this.copy$default$2();
            Function0<BoxedUnit> function0 = this.copy$default$4();
            return this.copy(function1, option, (Option<Body.ContentType>)some, function0);
        }

        public AsyncBody copy(Function1<UnsafeAsync, BoxedUnit> unsafeAsync, Option<Object> knownContentLength, Option<Body.ContentType> contentType, Function0<BoxedUnit> nettyRead) {
            return new AsyncBody(unsafeAsync, knownContentLength, contentType, nettyRead);
        }

        public Function1<UnsafeAsync, BoxedUnit> copy$default$1() {
            return this.unsafeAsync();
        }

        public Option<Object> copy$default$2() {
            return this.knownContentLength();
        }

        public Option<Body.ContentType> copy$default$3() {
            return this.contentType();
        }

        public Function0<BoxedUnit> copy$default$4() {
            return this.nettyRead();
        }

        public Function1<UnsafeAsync, BoxedUnit> _1() {
            return this.unsafeAsync();
        }

        public Option<Object> _2() {
            return this.knownContentLength();
        }

        public Option<Body.ContentType> _3() {
            return this.contentType();
        }

        public Function0<BoxedUnit> _4() {
            return this.nettyRead();
        }
    }

    public static interface UnsafeAsync {
        public void apply(Chunk<Object> var1, boolean var2);

        public void fail(Throwable var1);
    }
}

