/*
 * Decompiled with CFR 0.152.
 */
package zio.http.internal;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import zio.http.QueryParams;
import zio.http.QueryParams$;

public final class QueryParamEncoding$
implements Serializable {
    public static final QueryParamEncoding$ MODULE$ = new QueryParamEncoding$();

    private QueryParamEncoding$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QueryParamEncoding$.class);
    }

    public QueryParams decode(String queryStringFragment, Charset charset) {
        if (queryStringFragment == null || queryStringFragment.isEmpty()) {
            return QueryParams$.MODULE$.empty();
        }
        int length = queryStringFragment.length();
        int count = 1;
        for (int i = 0; i < length; ++i) {
            if (queryStringFragment.charAt(i) != '&') continue;
            ++count;
        }
        int paramCount = count;
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>(paramCount);
        int startIndex = 0;
        if (startIndex < length && queryStringFragment.charAt(startIndex) == '?') {
            ++startIndex;
        }
        while (startIndex < length) {
            List<String> values;
            int eqIndex = -1;
            int ampIndex = queryStringFragment.indexOf(38, startIndex);
            if (ampIndex == -1) {
                ampIndex = length;
            }
            for (int i = startIndex; i < ampIndex && eqIndex == -1; ++i) {
                if (queryStringFragment.charAt(i) != '=') continue;
                eqIndex = i;
            }
            String key = eqIndex != -1 ? this.decodeComponent(queryStringFragment, startIndex, eqIndex, charset) : this.decodeComponent(queryStringFragment, startIndex, ampIndex, charset);
            String value = eqIndex != -1 ? this.decodeComponent(queryStringFragment, eqIndex + 1, ampIndex, charset) : "";
            String string = key;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                key = value;
                value = "";
            }
            if ((values = params.get(key)) == null) {
                values = new ArrayList<String>(1);
                params.put(key, values);
            }
            values.add(value);
            startIndex = ampIndex + 1;
        }
        return QueryParams$.MODULE$.apply(params);
    }

    public String encode(java.lang.StringBuilder baseUri, QueryParams queryParams, Charset charset) {
        if (queryParams.isEmpty()) {
            return baseUri.toString();
        }
        int paramCount = queryParams.seq().size();
        baseUri.ensureCapacity(baseUri.length() + Math.min(paramCount * 20, 1024));
        boolean isFirst = true;
        for (Map.Entry entry : queryParams.seq()) {
            String key;
            String string = key = (String)entry.getKey();
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2))) continue;
            List values = (List)entry.getValue();
            if (values.isEmpty()) {
                java.lang.StringBuilder stringBuilder;
                if (isFirst) {
                    baseUri.append('?');
                    isFirst = false;
                    stringBuilder = BoxedUnit.UNIT;
                } else {
                    stringBuilder = baseUri.append('&');
                }
                this.encodeComponentInto(key, charset, baseUri);
                baseUri.append('=');
                continue;
            }
            int valuesSize = values.size();
            for (int j = 0; j < valuesSize; ++j) {
                java.lang.StringBuilder stringBuilder;
                if (isFirst) {
                    baseUri.append('?');
                    isFirst = false;
                    stringBuilder = BoxedUnit.UNIT;
                } else {
                    stringBuilder = baseUri.append('&');
                }
                this.encodeComponentInto(key, charset, baseUri);
                baseUri.append('=');
                this.encodeComponentInto((String)values.get(j), charset, baseUri);
            }
        }
        return baseUri.toString();
    }

    private String decodeComponent(String component, int start, int end, Charset charset) {
        int i;
        if (start >= end) {
            return "";
        }
        boolean needsDecoding = false;
        for (i = start; i < end && !needsDecoding; ++i) {
            char c = component.charAt(i);
            needsDecoding = c == '%' || c == '+';
        }
        if (!needsDecoding) {
            return component.substring(start, end);
        }
        StringBuilder result = new StringBuilder(end - start);
        i = start;
        while (i < end) {
            char c = component.charAt(i);
            if (c == '%' && i + 2 < end) {
                int digit1 = Character.digit(component.charAt(i + 1), 16);
                int digit2 = Character.digit(component.charAt(i + 2), 16);
                if (digit1 >= 0 && digit2 >= 0) {
                    int decoded = digit1 << 4 | digit2;
                    result.append((char)decoded);
                    i += 3;
                    continue;
                }
                result.append('%');
                ++i;
                continue;
            }
            if (c == '+') {
                result.append(' ');
                ++i;
                continue;
            }
            result.append(c);
            ++i;
        }
        return new String(result.toString().getBytes(charset));
    }

    private void encodeComponentInto(String component, Charset charset, java.lang.StringBuilder target) {
        int j;
        boolean isUtf8;
        int i;
        if (component.isEmpty()) {
            return;
        }
        boolean needsEncoding = false;
        int len = component.length();
        for (i = 0; i < len && !needsEncoding; ++i) {
            char c = component.charAt(i);
            needsEncoding = !this.needsNoEncoding(c);
        }
        if (!needsEncoding) {
            target.append(component);
            return;
        }
        Charset charset2 = charset;
        Charset charset3 = StandardCharsets.UTF_8;
        boolean bl = !(charset2 == null ? charset3 != null : !((Object)charset2).equals(charset3)) || charset.name().equalsIgnoreCase("UTF-8") ? true : (isUtf8 = false);
        if (i > 1) {
            target.append(component, 0, i - 1);
        }
        int n = j = i == 0 ? 0 : i - 1;
        if (isUtf8) {
            while (j < len) {
                java.lang.StringBuilder stringBuilder;
                char c = component.charAt(j);
                if (this.needsNoEncoding(c)) {
                    stringBuilder = target.append(c);
                } else if (c == ' ') {
                    stringBuilder = target.append('+');
                } else if (c < '\u0080') {
                    target.append('%');
                    target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(c >> 4 & 0xF, 16))));
                    stringBuilder = target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(c & 0xF, 16))));
                } else if (c < '\u0800') {
                    int byte1 = 0xC0 | c >> 6;
                    int byte2 = 0x80 | c & 0x3F;
                    target.append('%');
                    target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(byte1 >> 4 & 0xF, 16))));
                    target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(byte1 & 0xF, 16))));
                    target.append('%');
                    target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(byte2 >> 4 & 0xF, 16))));
                    stringBuilder = target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(byte2 & 0xF, 16))));
                } else {
                    int byte1 = 0xE0 | c >> 12;
                    int byte2 = 0x80 | c >> 6 & 0x3F;
                    int byte3 = 0x80 | c & 0x3F;
                    target.append('%');
                    target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(byte1 >> 4 & 0xF, 16))));
                    target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(byte1 & 0xF, 16))));
                    target.append('%');
                    target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(byte2 >> 4 & 0xF, 16))));
                    target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(byte2 & 0xF, 16))));
                    target.append('%');
                    target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(byte3 >> 4 & 0xF, 16))));
                    stringBuilder = target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(byte3 & 0xF, 16))));
                }
                ++j;
            }
            return;
        }
        byte[] bytes = component.getBytes(charset);
        int bytesLen = bytes.length;
        for (int k = 0; k < bytesLen; ++k) {
            java.lang.StringBuilder stringBuilder;
            int unsignedByte = bytes[k] & 0xFF;
            if (unsignedByte >= 97 && unsignedByte <= 122 || unsignedByte >= 65 && unsignedByte <= 90 || unsignedByte >= 48 && unsignedByte <= 57 || unsignedByte == 45 || unsignedByte == 46 || unsignedByte == 95 || unsignedByte == 126 || unsignedByte == 42) {
                stringBuilder = target.append((char)unsignedByte);
                continue;
            }
            if (unsignedByte == 32) {
                stringBuilder = target.append('+');
                continue;
            }
            target.append('%');
            target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(unsignedByte >> 4 & 0xF, 16))));
            stringBuilder = target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(unsignedByte & 0xF, 16))));
        }
    }

    private boolean needsNoEncoding(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~' || c == '*';
    }
}

