/*
 * Decompiled with CFR 0.152.
 */
package zio.http.internal;

import java.io.Serializable;
import java.time.Duration;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Chunk$;
import zio.http.Cookie;
import zio.http.Cookie$Request$;
import zio.http.Cookie$Response$;
import zio.http.Cookie$SameSite$Lax$;
import zio.http.Cookie$SameSite$None$;
import zio.http.Cookie$SameSite$Strict$;
import zio.http.Path;
import zio.http.Path$;

public final class CookieEncoding$
implements Serializable {
    private static final BitSet validNameCharSet;
    private static final BitSet validValueCharSet;
    public static final CookieEncoding$ MODULE$;

    private CookieEncoding$() {
    }

    static {
        MODULE$ = new CookieEncoding$();
        validNameCharSet = (BitSet)BitSet$.MODULE$.apply((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(33), 126).filter((Function1)(JFunction1.mcZI.sp & Serializable)c -> StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString("!#$%&'*+-.^_`|~0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), (char)c)));
        validValueCharSet = (BitSet)BitSet$.MODULE$.apply((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(33), 126).filter((Function1)(JFunction1.mcZI.sp & Serializable)c -> c == 33 || RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(35), 43).contains(c) || RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(45), 58).contains(c) || RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(60), 91).contains(c) || RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(93), 126).contains(c)));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CookieEncoding$.class);
    }

    private boolean isValidInBitSet(String s, BitSet set) {
        for (int i = 0; i < s.length(); ++i) {
            if (set.contains((int)s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String encodeRequestCookie(Cookie.Request cookie, boolean validate2) {
        String string;
        String string2;
        if (validate2) {
            Predef$.MODULE$.require(this.isValidInBitSet(cookie.name(), validNameCharSet), () -> CookieEncoding$.$anonfun$1(cookie));
            string2 = cookie.name();
        } else {
            string2 = cookie.name();
        }
        String name = string2;
        Predef$.MODULE$.require(cookie.content() != null, CookieEncoding$::encodeRequestCookie$$anonfun$1);
        if (validate2) {
            Predef$.MODULE$.require(this.isValidInBitSet(cookie.content(), validValueCharSet), () -> CookieEncoding$.$anonfun$2(cookie));
            string = cookie.content();
        } else {
            string = cookie.content();
        }
        String value = string;
        return new StringBuilder(1).append(name).append("=").append(value).toString();
    }

    public Chunk<Cookie.Request> decodeRequestCookie(String header, boolean validate2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])header.split(";"));
        return Chunk$.MODULE$.fromIterator(ArrayOps$.MODULE$.iterator$extension(object).map((Function1 & Serializable)_$1 -> _$1.trim()).filter((Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2))).flatMap((Function1 & Serializable)pair -> {
            Object object;
            String[] stringArray = pair.split("=", 2);
            if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String name = string;
                String value = string2;
                if (validate2) {
                    if (this.isValidName$1(name) && this.isValidValue$1(value)) {
                        return Some$.MODULE$.apply((Object)Cookie$Request$.MODULE$.apply(name, value));
                    }
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply((Object)Cookie$Request$.MODULE$.apply(name, value));
            }
            return None$.MODULE$;
        }));
    }

    public String encodeResponseCookie(Cookie.Response cookie, boolean validate2) {
        String string;
        String string2;
        if (validate2) {
            Predef$.MODULE$.require(this.isValidInBitSet(cookie.name(), validNameCharSet), () -> CookieEncoding$.$anonfun$3(cookie));
            string2 = cookie.name();
        } else {
            string2 = cookie.name();
        }
        String name = string2;
        Predef$.MODULE$.require(cookie.content() != null, CookieEncoding$::encodeResponseCookie$$anonfun$1);
        if (validate2) {
            Predef$.MODULE$.require(this.isValidInBitSet(cookie.content(), validValueCharSet), () -> CookieEncoding$.$anonfun$4(cookie));
            string = cookie.content();
        } else {
            string = cookie.content();
        }
        String value = string;
        scala.collection.mutable.StringBuilder b = new scala.collection.mutable.StringBuilder(new StringBuilder(1).append(name).append("=").append(value).toString());
        cookie.domain().foreach((Function1 & Serializable)d -> b.append(new StringBuilder(9).append("; Domain=").append((String)d).toString()));
        cookie.path().foreach((Function1 & Serializable)p -> b.append(new StringBuilder(7).append("; Path=").append(p.encode()).toString()));
        cookie.maxAge().foreach((Function1 & Serializable)m -> b.append(new StringBuilder(10).append("; Max-Age=").append(m.getSeconds()).toString()));
        if (cookie.isSecure()) {
            b.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            b.append("; HTTPOnly");
        }
        cookie.sameSite().foreach((Function1 & Serializable)x$1 -> {
            Cookie.SameSite sameSite = x$1;
            if (Cookie$SameSite$Strict$.MODULE$.equals(sameSite)) {
                return b.append("; SameSite=Strict");
            }
            if (Cookie$SameSite$Lax$.MODULE$.equals(sameSite)) {
                return b.append("; SameSite=Lax");
            }
            if (Cookie$SameSite$None$.MODULE$.equals(sameSite)) {
                return b.append("; SameSite=None");
            }
            throw new MatchError((Object)sameSite);
        });
        return b.result();
    }

    public Cookie.Response decodeResponseCookie(String header, boolean validate2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])header.split(";"));
        Object[] parts = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> _$3.trim(), ClassTag$.MODULE$.apply(String.class));
        Object object2 = Predef$.MODULE$.refArrayOps(parts);
        Tuple2 tuple2 = (Tuple2)ArrayOps$.MODULE$.headOption$extension(object2).flatMap((Function1 & Serializable)nv -> {
            Object object;
            String[] stringArray = nv.split("=", 2);
            if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String n = string;
                String v = string2;
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)n, (Object)v));
            }
            return None$.MODULE$;
        }).getOrElse(CookieEncoding$::$anonfun$7);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)name, (Object)value);
        String name2 = (String)tuple22._1();
        String value2 = (String)tuple22._2();
        if (validate2) {
            Predef$.MODULE$.require(this.isValidInBitSet(name2, validNameCharSet), () -> CookieEncoding$.decodeResponseCookie$$anonfun$1(name2));
            Predef$.MODULE$.require(this.isValidInBitSet(value2, validValueCharSet), () -> CookieEncoding$.decodeResponseCookie$$anonfun$2(value2));
        }
        ObjectRef domain = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef path = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef maxAge = ObjectRef.create((Object)None$.MODULE$);
        BooleanRef isSecure = BooleanRef.create((boolean)false);
        BooleanRef isHttpOnly = BooleanRef.create((boolean)false);
        ObjectRef sameSite = ObjectRef.create((Object)None$.MODULE$);
        Object object3 = Predef$.MODULE$.refArrayOps(parts);
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])((String[])ArrayOps$.MODULE$.tail$extension(object3)));
        ArrayOps$.MODULE$.foreach$extension(object4, (Function1)(JProcedure1 & Serializable)attr -> {
            String lower = attr.toLowerCase();
            if (lower.startsWith("domain=")) {
                domain$1.elem = Some$.MODULE$.apply((Object)attr.substring(7));
                return;
            }
            if (lower.startsWith("path=")) {
                path$1.elem = Some$.MODULE$.apply((Object)Path$.MODULE$.decode(attr.substring(5)));
                return;
            }
            if (lower.startsWith("max-age=")) {
                String v = attr.substring(8);
                try {
                    maxAge$1.elem = Some$.MODULE$.apply((Object)Duration.ofSeconds(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(v))));
                }
                catch (NumberFormatException numberFormatException) {}
                return;
            }
            String string = lower;
            String string2 = "secure";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                isSecure$1.elem = true;
                return;
            }
            String string3 = lower;
            String string4 = "httponly";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                isHttpOnly$1.elem = true;
                return;
            }
            if (lower.startsWith("samesite=")) {
                String string5 = attr.substring(9).toLowerCase();
                switch (string5 == null ? 0 : string5.hashCode()) {
                    case -891986231: {
                        if (!"strict".equals(string5)) break;
                        sameSite$1.elem = Some$.MODULE$.apply((Object)Cookie$SameSite$Strict$.MODULE$);
                        return;
                    }
                    case 106915: {
                        if (!"lax".equals(string5)) break;
                        sameSite$1.elem = Some$.MODULE$.apply((Object)Cookie$SameSite$Lax$.MODULE$);
                        return;
                    }
                    case 3387192: {
                        if (!"none".equals(string5)) break;
                        sameSite$1.elem = Some$.MODULE$.apply((Object)Cookie$SameSite$None$.MODULE$);
                        return;
                    }
                }
                if (validate2) {
                    throw new IllegalArgumentException(new StringBuilder(24).append("Invalid SameSite value: ").append(attr.substring(9)).toString());
                }
                return;
            }
        });
        return Cookie$Response$.MODULE$.apply(name2, value2, (Option<String>)((Option)domain.elem), (Option<Path>)((Option)path.elem), isSecure.elem, isHttpOnly.elem, (Option<Duration>)((Option)maxAge.elem), (Option<Cookie.SameSite>)((Option)sameSite.elem));
    }

    private static final Object $anonfun$1(Cookie.Request cookie$1) {
        return new StringBuilder(21).append("Invalid cookie name: ").append(cookie$1.name()).toString();
    }

    private static final Object encodeRequestCookie$$anonfun$1() {
        return "Cookie value cannot be null";
    }

    private static final Object $anonfun$2(Cookie.Request cookie$2) {
        return new StringBuilder(22).append("Invalid cookie value: ").append(cookie$2.content()).toString();
    }

    private final boolean isValidName$1(String s) {
        return this.isValidInBitSet(s, validNameCharSet);
    }

    private final boolean isValidValue$1(String s) {
        return this.isValidInBitSet(s, validValueCharSet);
    }

    private static final Object $anonfun$3(Cookie.Response cookie$3) {
        return new StringBuilder(21).append("Invalid cookie name: ").append(cookie$3.name()).toString();
    }

    private static final Object encodeResponseCookie$$anonfun$1() {
        return "Cookie value cannot be null";
    }

    private static final Object $anonfun$4(Cookie.Response cookie$4) {
        return new StringBuilder(22).append("Invalid cookie value: ").append(cookie$4.content()).toString();
    }

    private static final Tuple2 $anonfun$7() {
        throw new IllegalArgumentException("Invalid Set-Cookie header");
    }

    private static final Object decodeResponseCookie$$anonfun$1(String name$1) {
        return new StringBuilder(21).append("Invalid cookie name: ").append(name$1).toString();
    }

    private static final Object decodeResponseCookie$$anonfun$2(String value$1) {
        return new StringBuilder(22).append("Invalid cookie value: ").append(value$1).toString();
    }
}

