/*
 * Decompiled with CFR 0.152.
 */
package zio.http.endpoint.internal;

import java.io.Serializable;
import java.net.InetAddress;
import java.security.cert.Certificate;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.CanFail;
import zio.CanFail$;
import zio.IsSubtypeOfError$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Header$Accept$;
import zio.http.Headers;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Method;
import zio.http.Request;
import zio.http.Response;
import zio.http.URL;
import zio.http.Version;
import zio.http.ZClient;
import zio.http.codec.CodecConfig;
import zio.http.codec.CodecConfig$;
import zio.http.codec.Combiner;
import zio.http.codec.HttpCodecError;
import zio.http.endpoint.AuthType;
import zio.http.endpoint.Endpoint;
import zio.http.endpoint.Invocation;
import zio.http.endpoint.internal.EndpointClient$;

public final class EndpointClient<P, I, E, O, A extends AuthType>
implements Product,
Serializable {
    private final URL endpointRoot;
    private final Endpoint endpoint;

    public static <P, I, E, O, A extends AuthType> EndpointClient<P, I, E, O, A> apply(URL uRL, Endpoint<P, I, E, O, A> endpoint) {
        return EndpointClient$.MODULE$.apply(uRL, endpoint);
    }

    public static EndpointClient<?, ?, ?, ?, ?> fromProduct(Product product) {
        return EndpointClient$.MODULE$.fromProduct(product);
    }

    public static MediaType protobufMediaType() {
        return EndpointClient$.MODULE$.protobufMediaType();
    }

    public static <P, I, E, O, A extends AuthType> EndpointClient<P, I, E, O, A> unapply(EndpointClient<P, I, E, O, A> endpointClient) {
        return EndpointClient$.MODULE$.unapply(endpointClient);
    }

    public EndpointClient(URL endpointRoot, Endpoint<P, I, E, O, A> endpoint) {
        this.endpointRoot = endpointRoot;
        this.endpoint = endpoint;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof EndpointClient)) return false;
        EndpointClient endpointClient = (EndpointClient)object;
        URL uRL = this.endpointRoot();
        URL uRL2 = endpointClient.endpointRoot();
        if (uRL == null) {
            if (uRL2 != null) {
                return false;
            }
        } else if (!((Object)uRL).equals(uRL2)) return false;
        Endpoint<P, I, E, O, A> endpoint = this.endpoint();
        Endpoint<P, I, E, O, A> endpoint2 = endpointClient.endpoint();
        if (endpoint == null) {
            if (endpoint2 == null) return true;
            return false;
        } else {
            if (!((Object)endpoint).equals(endpoint2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof EndpointClient;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "EndpointClient";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "endpointRoot";
        }
        if (1 == n2) {
            return "endpoint";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public URL endpointRoot() {
        return this.endpointRoot;
    }

    public Endpoint<P, I, E, O, A> endpoint() {
        return this.endpoint;
    }

    public <R, ReqEnv> ZIO<R, E, O> execute(ZClient<Object, ReqEnv, Body, Throwable, Response> client, Invocation<P, I, E, O, A> invocation, ZIO<R, Nothing$, Object> authProvider, Combiner<I, Object> combiner, Object trace) {
        ZIO requested = authProvider.flatMap((Function1 & Serializable)authInput -> CodecConfig$.MODULE$.codecRef().get(trace).flatMap((Function1 & Serializable)config -> client.request(this.withDefaultAcceptHeader$1(invocation, combiner, (CodecConfig)config, authInput), (.less.colon.less<Body, Body>)$less$colon$less$.MODULE$.refl(), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (CanFail)CanFail$.MODULE$, trace).map((Function1 & Serializable)response -> response, trace), trace), trace);
        return requested.flatMap((Function1 & Serializable)response -> {
            if (this.endpoint().output().matchesStatus(response.status())) {
                return this.endpoint().output().decodeResponse((Response)response, this.endpoint().output().decodeResponse$default$2(), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (CanFail)CanFail$.MODULE$, trace);
            }
            if (this.endpoint().error().matchesStatus(response.status())) {
                return this.endpoint().error().decodeResponse((Response)response, this.endpoint().error().decodeResponse$default$2(), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (CanFail)CanFail$.MODULE$, trace).flip(trace);
            }
            ZIO<Object, Throwable, HttpCodecError> error = this.endpoint().codecError().decodeResponse((Response)response, this.endpoint().codecError().decodeResponse$default$2(), trace);
            return error.flatMap((Function1 & Serializable)codecError -> ZIO$.MODULE$.die(() -> EndpointClient.execute$$anonfun$1$$anonfun$1$$anonfun$1(codecError), trace), trace).orElse(() -> EndpointClient.execute$$anonfun$1$$anonfun$2(response, trace), (CanFail)CanFail$.MODULE$, trace);
        }, trace);
    }

    public <P, I, E, O, A extends AuthType> EndpointClient<P, I, E, O, A> copy(URL endpointRoot, Endpoint<P, I, E, O, A> endpoint) {
        return new EndpointClient<P, I, E, O, A>(endpointRoot, endpoint);
    }

    public <P, I, E, O, A extends AuthType> URL copy$default$1() {
        return this.endpointRoot();
    }

    public <P, I, E, O, A extends AuthType> Endpoint<P, I, E, O, A> copy$default$2() {
        return this.endpoint();
    }

    public URL _1() {
        return this.endpointRoot();
    }

    public Endpoint<P, I, E, O, A> _2() {
        return this.endpoint();
    }

    private final Request request0$1(Invocation invocation$1, Combiner combiner$1, CodecConfig config, Object authInput) {
        Object input = authInput instanceof BoxedUnit ? invocation$1.input() : combiner$1.combine(invocation$1.input(), authInput);
        return this.endpoint().authedInput(combiner$1).encodeRequest(input, config);
    }

    private final Request request$1(Invocation invocation$4, Combiner combiner$4, CodecConfig config, Object authInput) {
        Request req0 = this.request0$1(invocation$4, combiner$4, config, authInput);
        URL uRL = this.endpointRoot().$plus$plus(req0.url());
        Version version = req0.copy$default$1();
        Method method = req0.copy$default$2();
        Headers headers = req0.copy$default$4();
        Body body = req0.copy$default$5();
        Option<InetAddress> option = req0.copy$default$6();
        Option<Certificate> option2 = req0.copy$default$7();
        return req0.copy(version, method, uRL, headers, body, option, option2);
    }

    private final Request withDefaultAcceptHeader$1(Invocation invocation$5, Combiner combiner$5, CodecConfig config, Object authInput) {
        Request req = this.request$1(invocation$5, combiner$5, config, authInput);
        if (req.headers().exists((Function1 & Serializable)_$1 -> {
            String string = _$1.headerName();
            String string2 = Header$Accept$.MODULE$.name();
            return !(string != null ? !string.equals(string2) : string2 != null);
        })) {
            return req;
        }
        return (Request)req.addHeader(Header$Accept$.MODULE$.apply(MediaType$.MODULE$.application().json(), (Seq<MediaType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MediaType[]{EndpointClient$.MODULE$.protobufMediaType(), MediaType$.MODULE$.text().plain()})));
    }

    private static final Throwable execute$$anonfun$1$$anonfun$1$$anonfun$1(HttpCodecError codecError$1) {
        return (Throwable)((Object)codecError$1);
    }

    private static final Throwable execute$$anonfun$1$$anonfun$2$$anonfun$1(Response response$2) {
        return new IllegalStateException(new StringBuilder(44).append("Status code: ").append(response$2.status()).append(" is not defined in the endpoint").toString());
    }

    private static final ZIO execute$$anonfun$1$$anonfun$2(Response response$1, Object trace$5) {
        return ZIO$.MODULE$.die(() -> EndpointClient.execute$$anonfun$1$$anonfun$2$$anonfun$1(response$1), trace$5);
    }
}

