/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Using;
import zio.http.ClientAuth;
import zio.http.ClientAuth$Optional$;
import zio.http.ClientAuth$Required$;
import zio.http.SSLConfig;
import zio.http.SSLConfig$Data$FromFile$;
import zio.http.SSLConfig$Data$FromResource$;
import zio.http.SSLConfig$Data$Generate$;
import zio.http.netty.server.SSLUtil;

public final class SSLUtil$
implements Serializable {
    public static final SSLUtil$ MODULE$ = new SSLUtil$();

    private SSLUtil$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SSLUtil$.class);
    }

    public io.netty.handler.ssl.ClientAuth getClientAuth(ClientAuth clientAuth) {
        ClientAuth clientAuth2 = clientAuth;
        if (ClientAuth$Required$.MODULE$.equals(clientAuth2)) {
            return io.netty.handler.ssl.ClientAuth.REQUIRE;
        }
        if (ClientAuth$Optional$.MODULE$.equals(clientAuth2)) {
            return io.netty.handler.ssl.ClientAuth.OPTIONAL;
        }
        return io.netty.handler.ssl.ClientAuth.NONE;
    }

    public final SSLUtil.SslContextBuilderOps SslContextBuilderOps(SslContextBuilder self) {
        return new SSLUtil.SslContextBuilderOps(self);
    }

    public SslContext buildSslServerContext(SSLConfig sslConfig, InputStream certInputStream, InputStream keyInputStream, Option<InputStream> trustCertCollectionPath) {
        SslContextBuilder sslServerContext = SslContextBuilder.forServer((InputStream)certInputStream, (InputStream)keyInputStream);
        trustCertCollectionPath.foreach((Function1 & Serializable)stream -> sslServerContext.trustManager(stream));
        return this.SslContextBuilderOps(sslServerContext).buildWithDefaultOptions(sslConfig);
    }

    public SslContext sslConfigToSslContext(SSLConfig sslConfig) {
        SSLConfig.Data data = sslConfig.data();
        if (SSLConfig$Data$Generate$.MODULE$.equals(data)) {
            SelfSignedCertificate selfSigned = new SelfSignedCertificate();
            return this.SslContextBuilderOps(SslContextBuilder.forServer((PrivateKey)selfSigned.key(), (X509Certificate[])new X509Certificate[]{selfSigned.cert()})).buildWithDefaultOptions(sslConfig);
        }
        if (data instanceof SSLConfig.Data.FromFile) {
            SSLConfig.Data.FromFile fromFile = SSLConfig$Data$FromFile$.MODULE$.unapply((SSLConfig.Data.FromFile)data);
            String string = fromFile._1();
            String string2 = fromFile._2();
            Option<String> option = fromFile._3();
            String certPath = string;
            String keyPath = string2;
            Option<String> trustCertCollectionPath = option;
            return (SslContext)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                FileInputStream certInputStream = (FileInputStream)use.apply((Object)new FileInputStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                FileInputStream keyInputStream = (FileInputStream)use.apply((Object)new FileInputStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                Option trustCertInputStream = trustCertCollectionPath.map((Function1 & Serializable)path -> (FileInputStream)use.apply((Object)new FileInputStream((String)path), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                return this.buildSslServerContext(sslConfig, certInputStream, keyInputStream, (Option<InputStream>)trustCertInputStream);
            }).get();
        }
        if (data instanceof SSLConfig.Data.FromResource) {
            SSLConfig.Data.FromResource fromResource = SSLConfig$Data$FromResource$.MODULE$.unapply((SSLConfig.Data.FromResource)data);
            String string = fromResource._1();
            String string3 = fromResource._2();
            Option<String> option = fromResource._3();
            String certPath = string;
            String keyPath = string3;
            Option<String> trustCertCollectionPath = option;
            ClassLoader classLoader = this.getClass().getClassLoader();
            return (SslContext)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                InputStream certInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                InputStream keyInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                Option trustCertInputStream = trustCertCollectionPath.map((Function1 & Serializable)path -> (InputStream)use.apply((Object)classLoader.getResourceAsStream((String)path), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                return this.buildSslServerContext(sslConfig, certInputStream, keyInputStream, (Option<InputStream>)trustCertInputStream);
            }).get();
        }
        throw new MatchError((Object)data);
    }
}

