/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.Serializable;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import zio.Unsafe;
import zio.http.Body;
import zio.http.Method;
import zio.http.Method$HEAD$;
import zio.http.Response;
import zio.http.Status;
import zio.http.netty.CachedDateHeader;
import zio.http.netty.CachedDateHeader$;
import zio.http.netty.model.Conversions$;

public final class NettyResponseEncoder$
implements Serializable {
    private static final CachedDateHeader dateHeaderCache;
    public static final NettyResponseEncoder$ MODULE$;

    private NettyResponseEncoder$() {
    }

    static {
        MODULE$ = new NettyResponseEncoder$();
        dateHeaderCache = CachedDateHeader$.MODULE$.default();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NettyResponseEncoder$.class);
    }

    public HttpResponse encode(Method method, Response response, Unsafe unsafe) {
        Object object;
        Body body = response.body();
        if (body instanceof Body.UnsafeBytes) {
            Body.UnsafeBytes body2 = (Body.UnsafeBytes)body;
            return this.fastEncode(method, response, body2.unsafeAsArray(unsafe), unsafe);
        }
        Body body3 = body;
        Status status = response.status();
        HttpHeaders jHeaders = Conversions$.MODULE$.headersToNetty(response.headers());
        HttpResponseStatus jStatus = Conversions$.MODULE$.statusToNetty(status);
        this.maybeAddDateHeader(jHeaders, status);
        boolean hasContentLength = jHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        Method method2 = method;
        Method$HEAD$ method$HEAD$ = Method$HEAD$.MODULE$;
        if (!(method2 != null ? !method2.equals(method$HEAD$) : method$HEAD$ != null) && hasContentLength) {
            object = BoxedUnit.UNIT;
        } else {
            Option<Object> option = body3.knownContentLength();
            if (option instanceof Some) {
                long contentLength = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                object = jHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToLong((long)contentLength));
            } else {
                object = !hasContentLength ? jHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED) : BoxedUnit.UNIT;
            }
        }
        return new DefaultHttpResponse(HttpVersion.HTTP_1_1, jStatus, jHeaders);
    }

    public FullHttpResponse fastEncode(Method method, Response response, byte[] bytes, Unsafe unsafe) {
        if (response.encoded() == null) {
            response.encoded_$eq(this.doEncode(method, response, bytes));
        }
        return (FullHttpResponse)response.encoded();
    }

    private FullHttpResponse doEncode(Method method, Response response, byte[] bytes) {
        HttpHeaders jHeaders = Conversions$.MODULE$.headersToNetty(response.headers());
        Status status = response.status();
        this.maybeAddDateHeader(jHeaders, status);
        HttpResponseStatus jStatus = Conversions$.MODULE$.statusToNetty(status);
        ByteBuf jContent = Unpooled.wrappedBuffer((byte[])bytes);
        Method method2 = method;
        Method$HEAD$ method$HEAD$ = Method$HEAD$.MODULE$;
        Object object = !(method2 != null ? !method2.equals(method$HEAD$) : method$HEAD$ != null) && jHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) ? BoxedUnit.UNIT : jHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToInteger((int)bytes.length));
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, jStatus, jContent, jHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    private void maybeAddDateHeader(HttpHeaders headers, Status status) {
        if (status.isInformational() || status.isServerError() || headers.contains((CharSequence)HttpHeaderNames.DATE)) {
            return;
        }
        HttpHeaders httpHeaders = headers.set((CharSequence)HttpHeaderNames.DATE, (Object)dateHeaderCache.get());
    }
}

