/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import javax.net.ssl.TrustManagerFactory;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Using;
import zio.Config;
import zio.http.ClientSSLCertConfig;
import zio.http.ClientSSLCertConfig$FromClientCertFile$;
import zio.http.ClientSSLCertConfig$FromClientCertResource$;
import zio.http.ClientSSLConfig;
import zio.http.ClientSSLConfig$Default$;
import zio.http.ClientSSLConfig$FromCertFile$;
import zio.http.ClientSSLConfig$FromCertResource$;
import zio.http.ClientSSLConfig$FromClientAndServerCert$;
import zio.http.ClientSSLConfig$FromTrustStoreFile$;
import zio.http.ClientSSLConfig$FromTrustStoreResource$;

public final class ClientSSLConverter$
implements Serializable {
    public static final ClientSSLConverter$ MODULE$ = new ClientSSLConverter$();

    private ClientSSLConverter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClientSSLConverter$.class);
    }

    private SslContextBuilder trustStoreToSslContext(InputStream trustStoreStream, Config.Secret trustStorePassword, SslContextBuilder sslContextBuilder) {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustStore.load(trustStoreStream, (char[])trustStorePassword.value().toArray(ClassTag$.MODULE$.apply(Character.TYPE)));
        trustManagerFactory.init(trustStore);
        return sslContextBuilder.trustManager(trustManagerFactory);
    }

    private SslContextBuilder buildNettySslContextBuilder(ClientSSLConfig sslConfig, SslContextBuilder sslContextBuilder) {
        ClientSSLConfig clientSSLConfig = sslConfig;
        if (ClientSSLConfig$Default$.MODULE$.equals(clientSSLConfig)) {
            return sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        if (clientSSLConfig instanceof ClientSSLConfig.FromCertFile) {
            String string;
            ClientSSLConfig.FromCertFile fromCertFile = ClientSSLConfig$FromCertFile$.MODULE$.unapply((ClientSSLConfig.FromCertFile)clientSSLConfig);
            String certPath = string = fromCertFile._1();
            FileInputStream certStream = new FileInputStream(certPath);
            return sslContextBuilder.trustManager((InputStream)certStream);
        }
        if (clientSSLConfig instanceof ClientSSLConfig.FromCertResource) {
            String string;
            ClientSSLConfig.FromCertResource fromCertResource = ClientSSLConfig$FromCertResource$.MODULE$.unapply((ClientSSLConfig.FromCertResource)clientSSLConfig);
            String certPath = string = fromCertResource._1();
            InputStream certStream = this.getClass().getClassLoader().getResourceAsStream(certPath);
            return sslContextBuilder.trustManager(certStream);
        }
        if (clientSSLConfig instanceof ClientSSLConfig.FromTrustStoreResource) {
            ClientSSLConfig.FromTrustStoreResource fromTrustStoreResource = ClientSSLConfig$FromTrustStoreResource$.MODULE$.unapply((ClientSSLConfig.FromTrustStoreResource)clientSSLConfig);
            String string = fromTrustStoreResource._1();
            Config.Secret secret = fromTrustStoreResource._2();
            String trustStorePath = string;
            Config.Secret trustStorePassword = secret;
            InputStream trustStoreStream = this.getClass().getClassLoader().getResourceAsStream(trustStorePath);
            return this.trustStoreToSslContext(trustStoreStream, trustStorePassword, sslContextBuilder);
        }
        if (clientSSLConfig instanceof ClientSSLConfig.FromClientAndServerCert) {
            ClientSSLConfig.FromClientAndServerCert fromClientAndServerCert = ClientSSLConfig$FromClientAndServerCert$.MODULE$.unapply((ClientSSLConfig.FromClientAndServerCert)clientSSLConfig);
            ClientSSLConfig clientSSLConfig2 = fromClientAndServerCert._1();
            ClientSSLCertConfig clientSSLCertConfig = fromClientAndServerCert._2();
            ClientSSLConfig serverCertConfig = clientSSLConfig2;
            if (clientSSLCertConfig instanceof ClientSSLCertConfig.FromClientCertFile) {
                ClientSSLCertConfig.FromClientCertFile fromClientCertFile = ClientSSLCertConfig$FromClientCertFile$.MODULE$.unapply((ClientSSLCertConfig.FromClientCertFile)clientSSLCertConfig);
                String string = fromClientCertFile._1();
                String string2 = fromClientCertFile._2();
                String certPath = string;
                String keyPath = string2;
                SslContextBuilder newBuilder = this.buildNettySslContextBuilder(serverCertConfig, sslContextBuilder);
                return (SslContextBuilder)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                    FileInputStream certInputStream = (FileInputStream)use.apply((Object)new FileInputStream(new File(certPath)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    FileInputStream keyInputStream = (FileInputStream)use.apply((Object)new FileInputStream(new File(keyPath)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    return newBuilder.keyManager((InputStream)certInputStream, (InputStream)keyInputStream);
                }).get();
            }
            ClientSSLConfig serverCertConfig2 = clientSSLConfig2;
            if (clientSSLCertConfig instanceof ClientSSLCertConfig.FromClientCertResource) {
                ClientSSLCertConfig.FromClientCertResource fromClientCertResource = ClientSSLCertConfig$FromClientCertResource$.MODULE$.unapply((ClientSSLCertConfig.FromClientCertResource)clientSSLCertConfig);
                String string = fromClientCertResource._1();
                String string3 = fromClientCertResource._2();
                String certPath = string;
                String keyPath = string3;
                SslContextBuilder newBuilder = this.buildNettySslContextBuilder(serverCertConfig2, sslContextBuilder);
                return (SslContextBuilder)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    InputStream certInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    InputStream keyInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    return newBuilder.keyManager(certInputStream, keyInputStream);
                }).get();
            }
        }
        if (clientSSLConfig instanceof ClientSSLConfig.FromTrustStoreFile) {
            ClientSSLConfig.FromTrustStoreFile fromTrustStoreFile = ClientSSLConfig$FromTrustStoreFile$.MODULE$.unapply((ClientSSLConfig.FromTrustStoreFile)clientSSLConfig);
            String string = fromTrustStoreFile._1();
            Config.Secret secret = fromTrustStoreFile._2();
            String trustStorePath = string;
            Config.Secret trustStorePassword = secret;
            FileInputStream trustStoreStream = new FileInputStream(trustStorePath);
            return this.trustStoreToSslContext(trustStoreStream, trustStorePassword, sslContextBuilder);
        }
        throw new MatchError((Object)clientSSLConfig);
    }

    public SslContext toNettySSLContext(ClientSSLConfig sslConfig) {
        return this.buildNettySslContextBuilder(sslConfig, SslContextBuilder.forClient()).build();
    }
}

