/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport.client;

import com.twitter.finagle.Service;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Status;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http2.MultiplexHandlerBuilder$;
import com.twitter.finagle.http2.transport.client.ClientServiceImpl;
import com.twitter.finagle.http2.transport.client.ClientSessionImpl;
import com.twitter.finagle.http2.transport.client.DeferredCloseSession;
import com.twitter.finagle.http2.transport.client.H2ClientFilter;
import com.twitter.finagle.http2.transport.client.H2ClientFilter$;
import com.twitter.finagle.http2.transport.client.Http2UpgradingTransport;
import com.twitter.finagle.http2.transport.client.Http2UpgradingTransport$UpgradeAborted$;
import com.twitter.finagle.http2.transport.client.Http2UpgradingTransport$UpgradeRejected$;
import com.twitter.finagle.http2.transport.client.SingleDispatchTransport;
import com.twitter.finagle.http2.transport.client.UpgradeRequestHandler$;
import com.twitter.finagle.http2.transport.common.H2StreamChannelInit$;
import com.twitter.finagle.netty4.Netty4Listener;
import com.twitter.finagle.netty4.http.package$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.transport.Transport;
import com.twitter.util.Future;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001\u0002\f\u0018\r\u0011B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0019\t\b\u0001)A\u0005e\"1q\u000f\u0001Q\u0001\nIDa\u0001\u001f\u0001!\u0002\u0013I\bB\u0002?\u0001A\u0003%\u0011\u0010\u0003\u0004~\u0001\u0001\u0006I!\u001f\u0005\u0006}\u0002!\ta \u0005\t\u00037\u0001\u0001\u0015\"\u0003\u0002\u001e!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\t\u0003#\u0002\u0001\u0015\"\u0003\u0002T\u001d9\u0011\u0011N\f\t\n\u0005-dA\u0002\f\u0018\u0011\u0013\ti\u0007\u0003\u0004j#\u0011\u0005\u0011Q\u000f\u0005\n\u0003o\n\"\u0019!C\u0001\u0003sB\u0001\"!!\u0012A\u0003%\u00111\u0010\u0005\b\u0003\u0007\u000bB\u0011BAC\u0005U)\u0006o\u001a:bI\u0016\u0014V-];fgRD\u0015M\u001c3mKJT!\u0001G\r\u0002\r\rd\u0017.\u001a8u\u0015\tQ2$A\u0005ue\u0006t7\u000f]8si*\u0011A$H\u0001\u0006QR$\bO\r\u0006\u0003=}\tqAZ5oC\u001edWM\u0003\u0002!C\u00059Ao^5ui\u0016\u0014(\"\u0001\u0012\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001)\u0003C\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u0003\u001d\u0019\u0007.\u00198oK2T!AK\u0016\u0002\u000b9,G\u000f^=\u000b\u00031\n!![8\n\u00059:#\u0001F\"iC:tW\r\u001c#va2,\u0007\u0010S1oI2,'/\u0001\u0004qCJ\fWn\u001d\t\u0003cUr!AM\u001a\u000e\u0003uI!\u0001N\u000f\u0002\u000bM#\u0018mY6\n\u0005Y:$A\u0002)be\u0006l7O\u0003\u00025;\u0005YqN\u001c%3'\u0016\u0014h/[2f!\tQDJ\u0004\u0002<\u0015:\u0011A(\u0013\b\u0003{!s!AP$\u000f\u0005}2eB\u0001!F\u001d\t\tE)D\u0001C\u0015\t\u00195%\u0001\u0004=e>|GOP\u0005\u0002E%\u0011\u0001%I\u0005\u0003=}I!\u0001H\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\tYu#\u0001\u0004IeA{w\u000e\\\u0005\u0003\u001b:\u00131b\u00148IeM+'O^5dK*\u00111jF\u0001\u0010QR$\bo\u00117jK:$8i\u001c3fGB\u0011\u0011\u000bW\u0007\u0002%*\u00111\u000bV\u0001\u0005QR$\bO\u0003\u0002V-\u0006)1m\u001c3fG*\u0011q+K\u0001\bQ\u0006tG\r\\3s\u0013\tI&KA\bIiR\u00048\t\\5f]R\u001cu\u000eZ3d\u0003!iw\u000eZ5gS\u0016\u0014\b\u0003\u0002/`C\u0006l\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\n\rVt7\r^5p]F\u0002BA\u00193gM6\t1M\u0003\u0002\u001b;%\u0011Qm\u0019\u0002\n)J\fgn\u001d9peR\u0004\"\u0001X4\n\u0005!l&aA!os\u00061A(\u001b8jiz\"Ra[7o_B\u0004\"\u0001\u001c\u0001\u000e\u0003]AQaL\u0003A\u0002ABQ\u0001O\u0003A\u0002eBQaT\u0003A\u0002ACQAW\u0003A\u0002m\u000bQa\u001d;biN\u0004\"a];\u000e\u0003QT!!]\u000f\n\u0005Y$(!D*uCR\u001c(+Z2fSZ,'/A\u0007ti\u0006$8OU3dK&4XM]\u0001\u000fCR$X-\u001c9u\u0007>,h\u000e^3s!\t\u0019(0\u0003\u0002|i\n91i\\;oi\u0016\u0014\u0018AD;qOJ\fG-Z\"pk:$XM]\u0001\u000fS\u001etwN]3e\u0007>,h\u000e^3s\u0003yIg.\u001b;jC2L'0Z+qOJ\fG-Z*ue\u0016\fWn\u00115b]:,G\u000e\u0006\u0004\u0002\u0002\u0005\u001d\u0011\u0011\u0003\t\u00049\u0006\r\u0011bAA\u0003;\n!QK\\5u\u0011\u001d\tIa\u0003a\u0001\u0003\u0017\t!a\u00195\u0011\u0007\u0019\ni!C\u0002\u0002\u0010\u001d\u0012qa\u00115b]:,G\u000eC\u0004\u0002\u0014-\u0001\r!!\u0006\u0002\u0013A\f'/\u001a8u\u0007RD\bc\u0001\u0014\u0002\u0018%\u0019\u0011\u0011D\u0014\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\u0006\t\u0012\r\u001a3Va\u001e\u0014\u0018\rZ3IC:$G.\u001a:\u0015\t\u0005\u0005\u0011q\u0004\u0005\b\u0003Ca\u0001\u0019AA\u000b\u0003\r\u0019G\u000f_\u0001\u0006oJLG/\u001a\u000b\t\u0003\u0003\t9#!\u000b\u0002>!9\u0011\u0011E\u0007A\u0002\u0005U\u0001bBA\u0016\u001b\u0001\u0007\u0011QF\u0001\u0004[N<\u0007\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\u0005Y\u0006twM\u0003\u0002\u00028\u0005!!.\u0019<b\u0013\u0011\tY$!\r\u0003\r=\u0013'.Z2u\u0011\u001d\ty$\u0004a\u0001\u0003\u0003\nq\u0001\u001d:p[&\u001cX\rE\u0002'\u0003\u0007J1!!\u0012(\u00059\u0019\u0005.\u00198oK2\u0004&o\\7jg\u0016\f!#^:fe\u00163XM\u001c;Ue&<w-\u001a:fIR1\u0011\u0011AA&\u0003\u001bBq!!\t\u000f\u0001\u0004\t)\u0002\u0003\u0004\u0002P9\u0001\rAZ\u0001\u0006KZ,g\u000e^\u0001\n]>,\u0006o\u001a:bI\u0016$b!!\u0001\u0002V\u0005]\u0003bBA\u0011\u001f\u0001\u0007\u0011Q\u0003\u0005\b\u00033z\u0001\u0019AA.\u0003\u0019\u0011Xm];miB!\u0011QLA2\u001d\ra\u0017qL\u0005\u0004\u0003C:\u0012a\u0006%uiB\u0014T\u000b]4sC\u0012Lgn\u001a+sC:\u001c\bo\u001c:u\u0013\u0011\t)'a\u001a\u0003\u001bU\u0003xM]1eKJ+7/\u001e7u\u0015\r\t\tgF\u0001\u0016+B<'/\u00193f%\u0016\fX/Z:u\u0011\u0006tG\r\\3s!\ta\u0017cE\u0002\u0012\u0003_\u00022\u0001XA9\u0013\r\t\u0019(\u0018\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005-\u0014a\u0003%b]\u0012dWM\u001d(b[\u0016,\"!a\u001f\u0011\t\u0005=\u0012QP\u0005\u0005\u0003\u007f\n\tD\u0001\u0004TiJLgnZ\u0001\r\u0011\u0006tG\r\\3s\u001d\u0006lW\rI\u0001\u000eG2,\u0017M\u001c)ja\u0016d\u0017N\\3\u0015\t\u0005\u0005\u0011q\u0011\u0005\b\u0003\u0013+\u0002\u0019AAF\u0003!\u0001\u0018\u000e]3mS:,\u0007c\u0001\u0014\u0002\u000e&\u0019\u0011qR\u0014\u0003\u001f\rC\u0017M\u001c8fYBK\u0007/\u001a7j]\u0016\u0004")
public final class UpgradeRequestHandler
extends ChannelDuplexHandler {
    private final Stack.Params params;
    private final Function1<Service<Request, Response>, BoxedUnit> onH2Service;
    private final HttpClientCodec httpClientCodec;
    private final Function1<Transport<Object, Object>, Transport<Object, Object>> modifier;
    private final StatsReceiver stats;
    private final StatsReceiver statsReceiver;
    private final Counter attemptCounter;
    private final Counter upgradeCounter;
    private final Counter ignoredCounter;

    public static String HandlerName() {
        return UpgradeRequestHandler$.MODULE$.HandlerName();
    }

    public void initializeUpgradeStreamChannel(Channel ch, ChannelHandlerContext parentCtx) {
        ChannelPipeline p = parentCtx.pipeline();
        UpgradeRequestHandler$.MODULE$.com$twitter$finagle$http2$transport$client$UpgradeRequestHandler$$cleanPipeline(p);
        H2ClientFilter pingDetectionHandler = new H2ClientFilter(this.params);
        p.addBefore(UpgradeRequestHandler$.MODULE$.HandlerName(), H2ClientFilter$.MODULE$.HandlerName(), (ChannelHandler)pingDetectionHandler);
        ChannelInitializer<Channel> streamChannelInit = H2StreamChannelInit$.MODULE$.initClient(this.params);
        ClientSessionImpl clientSession = new ClientSessionImpl(this.params, streamChannelInit, parentCtx.channel(), (Function0<Status>)(Function0 & Serializable)() -> pingDetectionHandler.status());
        this.upgradeCounter.incr();
        parentCtx.pipeline().remove((ChannelHandler)this);
        ch.pipeline().addLast(new ChannelHandler[]{streamChannelInit});
        Transport<Object, Object> trans = clientSession.newChildTransport(ch);
        DeferredCloseSession session = new DeferredCloseSession(clientSession, (Future<BoxedUnit>)trans.onClose().unit());
        this.onH2Service.apply((Object)new ClientServiceImpl(session, this.stats, this.modifier));
        parentCtx.fireChannelRead((Object)new Http2UpgradingTransport.UpgradeSuccessful((Transport<Object, Object>)new SingleDispatchTransport(trans)));
    }

    private void addUpgradeHandler(ChannelHandlerContext ctx) {
        ChannelInitializer<Channel> upgradeStreamhandler = new ChannelInitializer<Channel>(this, ctx){
            private final /* synthetic */ UpgradeRequestHandler $outer;
            private final ChannelHandlerContext ctx$1;

            public void initChannel(Channel ch) {
                this.$outer.initializeUpgradeStreamChannel(ch, this.ctx$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$1 = ctx$1;
            }
        };
        Tuple2<Http2FrameCodec, Http2MultiplexHandler> tuple2 = MultiplexHandlerBuilder$.MODULE$.clientFrameCodec(this.params, (Option<ChannelHandler>)new Some((Object)upgradeStreamhandler));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Http2FrameCodec codec = (Http2FrameCodec)tuple2._1();
        Http2MultiplexHandler handler = (Http2MultiplexHandler)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)codec, (Object)handler);
        Tuple2 tuple23 = tuple22;
        Http2FrameCodec codec2 = (Http2FrameCodec)tuple23._1();
        Http2MultiplexHandler handler2 = (Http2MultiplexHandler)tuple23._2();
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec(null, codec2, handler2){
            private final Http2FrameCodec codec$1;
            private final Http2MultiplexHandler handler$1;

            public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) {
                ctx.pipeline().addAfter(ctx.name(), package$.MODULE$.Http2CodecName(), (ChannelHandler)this.codec$1).addAfter(package$.MODULE$.Http2CodecName(), package$.MODULE$.Http2MultiplexHandlerName(), (ChannelHandler)this.handler$1);
                this.codec$1.onHttpClientUpgrade();
            }
            {
                this.codec$1 = codec$1;
                this.handler$1 = handler$1;
                super((Http2ConnectionHandler)codec$1);
            }
        };
        HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)this.httpClientCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 0);
        ctx.pipeline().addBefore(ctx.name(), "httpUpgradeHandler", (ChannelHandler)upgradeHandler);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        FullHttpRequest fullHttpRequest;
        Object object = msg;
        if (object instanceof FullHttpRequest && (fullHttpRequest = (FullHttpRequest)object).content().readableBytes() == 0) {
            this.addUpgradeHandler(ctx);
            this.attemptCounter.incr();
            super.write(ctx, msg, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.ignoredCounter.incr();
            this.noUpgrade(ctx, Http2UpgradingTransport$UpgradeAborted$.MODULE$);
            ctx.write(msg, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) {
        Object object = event;
        if (HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED.equals(object)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED.equals(object)) {
            this.noUpgrade(ctx, Http2UpgradingTransport$UpgradeRejected$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            super.userEventTriggered(ctx, event);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void noUpgrade(ChannelHandlerContext ctx, Http2UpgradingTransport.UpgradeResult result) {
        ctx.pipeline().remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)result);
        ctx.channel().config().setAutoRead(!((Netty4Listener.BackPressure)this.params.apply(Netty4Listener.BackPressure$.MODULE$.param())).enabled());
        ctx.read();
    }

    public UpgradeRequestHandler(Stack.Params params, Function1<Service<Request, Response>, BoxedUnit> onH2Service, HttpClientCodec httpClientCodec, Function1<Transport<Object, Object>, Transport<Object, Object>> modifier) {
        this.params = params;
        this.onH2Service = onH2Service;
        this.httpClientCodec = httpClientCodec;
        this.modifier = modifier;
        this.stats = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
        this.statsReceiver = this.stats.scope("upgrade");
        this.attemptCounter = this.statsReceiver.counter((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"attempt"}));
        this.upgradeCounter = this.statsReceiver.counter((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"success"}));
        this.ignoredCounter = this.statsReceiver.counter((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ignored"}));
    }
}

