/*
 * Decompiled with CFR 0.152.
 */
package tethys.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import scala.Byte$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import tethys.writers.tokens.TokenWriter;

public class JacksonTokenWriter
implements TokenWriter {
    private final JsonGenerator jsonGenerator;

    public JacksonTokenWriter(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
    }

    public JacksonTokenWriter writeArrayStart() {
        this.jsonGenerator.writeStartArray();
        return this;
    }

    public JacksonTokenWriter writeArrayEnd() {
        this.jsonGenerator.writeEndArray();
        return this;
    }

    public JacksonTokenWriter writeObjectStart() {
        this.jsonGenerator.writeStartObject();
        return this;
    }

    public JacksonTokenWriter writeObjectEnd() {
        this.jsonGenerator.writeEndObject();
        return this;
    }

    public JacksonTokenWriter writeFieldName(String name) {
        this.jsonGenerator.writeFieldName(name);
        return this;
    }

    public JacksonTokenWriter writeString(String v) {
        this.jsonGenerator.writeString(v);
        return this;
    }

    public JacksonTokenWriter writeNumber(byte v) {
        this.jsonGenerator.writeNumber(Byte$.MODULE$.byte2short(v));
        return this;
    }

    public JacksonTokenWriter writeNumber(short v) {
        this.jsonGenerator.writeNumber(v);
        return this;
    }

    public JacksonTokenWriter writeNumber(int v) {
        this.jsonGenerator.writeNumber(v);
        return this;
    }

    public JacksonTokenWriter writeNumber(long v) {
        this.jsonGenerator.writeNumber(v);
        return this;
    }

    public JacksonTokenWriter writeNumber(BigInt v) {
        this.jsonGenerator.writeNumber(v.bigInteger());
        return this;
    }

    public JacksonTokenWriter writeNumber(double v) {
        this.jsonGenerator.writeNumber(v);
        return this;
    }

    public JacksonTokenWriter writeNumber(float v) {
        this.jsonGenerator.writeNumber(v);
        return this;
    }

    public JacksonTokenWriter writeNumber(BigDecimal v) {
        this.jsonGenerator.writeNumber(v.bigDecimal());
        return this;
    }

    public JacksonTokenWriter writeRawJson(String json) {
        this.jsonGenerator.writeRawValue(json);
        return this;
    }

    public JacksonTokenWriter writeBoolean(boolean v) {
        this.jsonGenerator.writeBoolean(v);
        return this;
    }

    public JacksonTokenWriter writeNull() {
        this.jsonGenerator.writeNull();
        return this;
    }

    public void close() {
        this.jsonGenerator.close();
    }

    public void flush() {
        this.jsonGenerator.flush();
    }
}

