/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.interceptor.log;

import java.io.Serializable;
import java.time.Clock;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import sttp.tapir.DecodeResult;
import sttp.tapir.Endpoint;
import sttp.tapir.model.ServerRequest;
import sttp.tapir.server.interceptor.DecodeFailureContext;
import sttp.tapir.server.interceptor.DecodeSuccessContext;
import sttp.tapir.server.interceptor.SecurityFailureContext;
import sttp.tapir.server.interceptor.log.DefaultServerLog$;
import sttp.tapir.server.interceptor.log.ExceptionContext;
import sttp.tapir.server.interceptor.log.ServerLog;
import sttp.tapir.server.model.ServerResponse;

public class DefaultServerLog<F>
implements ServerLog<F>,
Product,
Serializable {
    private final Function1 doLogWhenReceived;
    private final Function2 doLogWhenHandled;
    private final Function2 doLogAllDecodeFailures;
    private final Function2 doLogExceptions;
    private final Object noLog;
    private final boolean logWhenReceived;
    private final boolean logWhenHandled;
    private final boolean logAllDecodeFailures;
    private final boolean logLogicExceptions;
    private final Function1 showEndpoint;
    private final Function1 showRequest;
    private final Function1 showResponse;
    private final boolean includeTiming;
    private final Clock clock;
    private final Set ignoreEndpoints;

    public static <F> DefaultServerLog<F> apply(Function1<String, Object> function1, Function2<String, Option<Throwable>, Object> function2, Function2<String, Option<Throwable>, Object> function22, Function2<String, Throwable, Object> function23, Object object, boolean bl, boolean bl2, boolean bl3, boolean bl4, Function1<Endpoint<?, ?, ?, ?, ?>, String> function12, Function1<ServerRequest, String> function13, Function1<ServerResponse<?>, String> function14, boolean bl5, Clock clock, Set<Endpoint<?, ?, ?, ?, ?>> set) {
        return DefaultServerLog$.MODULE$.apply(function1, function2, function22, function23, object, bl, bl2, bl3, bl4, function12, function13, function14, bl5, clock, set);
    }

    public static DefaultServerLog<?> fromProduct(Product product) {
        return DefaultServerLog$.MODULE$.fromProduct(product);
    }

    public static <F> DefaultServerLog<F> unapply(DefaultServerLog<F> defaultServerLog) {
        return DefaultServerLog$.MODULE$.unapply(defaultServerLog);
    }

    public static <F> boolean $lessinit$greater$default$6() {
        return DefaultServerLog$.MODULE$.$lessinit$greater$default$6();
    }

    public static <F> boolean $lessinit$greater$default$7() {
        return DefaultServerLog$.MODULE$.$lessinit$greater$default$7();
    }

    public static <F> boolean $lessinit$greater$default$8() {
        return DefaultServerLog$.MODULE$.$lessinit$greater$default$8();
    }

    public static <F> boolean $lessinit$greater$default$9() {
        return DefaultServerLog$.MODULE$.$lessinit$greater$default$9();
    }

    public static <F> Function1<Endpoint<?, ?, ?, ?, ?>, String> $lessinit$greater$default$10() {
        return DefaultServerLog$.MODULE$.$lessinit$greater$default$10();
    }

    public static <F> Function1<ServerRequest, String> $lessinit$greater$default$11() {
        return DefaultServerLog$.MODULE$.$lessinit$greater$default$11();
    }

    public static <F> Function1<ServerResponse<?>, String> $lessinit$greater$default$12() {
        return DefaultServerLog$.MODULE$.$lessinit$greater$default$12();
    }

    public static <F> boolean $lessinit$greater$default$13() {
        return DefaultServerLog$.MODULE$.$lessinit$greater$default$13();
    }

    public static <F> Clock $lessinit$greater$default$14() {
        return DefaultServerLog$.MODULE$.$lessinit$greater$default$14();
    }

    public static <F> Set<Endpoint<?, ?, ?, ?, ?>> $lessinit$greater$default$15() {
        return DefaultServerLog$.MODULE$.$lessinit$greater$default$15();
    }

    public DefaultServerLog(Function1<String, Object> doLogWhenReceived, Function2<String, Option<Throwable>, Object> doLogWhenHandled, Function2<String, Option<Throwable>, Object> doLogAllDecodeFailures, Function2<String, Throwable, Object> doLogExceptions, Object noLog, boolean logWhenReceived, boolean logWhenHandled, boolean logAllDecodeFailures, boolean logLogicExceptions, Function1<Endpoint<?, ?, ?, ?, ?>, String> showEndpoint, Function1<ServerRequest, String> showRequest, Function1<ServerResponse<?>, String> showResponse, boolean includeTiming, Clock clock, Set<Endpoint<?, ?, ?, ?, ?>> ignoreEndpoints) {
        this.doLogWhenReceived = doLogWhenReceived;
        this.doLogWhenHandled = doLogWhenHandled;
        this.doLogAllDecodeFailures = doLogAllDecodeFailures;
        this.doLogExceptions = doLogExceptions;
        this.noLog = noLog;
        this.logWhenReceived = logWhenReceived;
        this.logWhenHandled = logWhenHandled;
        this.logAllDecodeFailures = logAllDecodeFailures;
        this.logLogicExceptions = logLogicExceptions;
        this.showEndpoint = showEndpoint;
        this.showRequest = showRequest;
        this.showResponse = showResponse;
        this.includeTiming = includeTiming;
        this.clock = clock;
        this.ignoreEndpoints = ignoreEndpoints;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.doLogWhenReceived()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.doLogWhenHandled()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.doLogAllDecodeFailures()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.doLogExceptions()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.noLog()));
        n = Statics.mix((int)n, (int)(this.logWhenReceived() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.logWhenHandled() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.logAllDecodeFailures() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.logLogicExceptions() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.showEndpoint()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.showRequest()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.showResponse()));
        n = Statics.mix((int)n, (int)(this.includeTiming() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.clock()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.ignoreEndpoints()));
        return Statics.finalizeHash((int)n, (int)15);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DefaultServerLog)) return false;
        DefaultServerLog defaultServerLog = (DefaultServerLog)object;
        if (this.logWhenReceived() != defaultServerLog.logWhenReceived()) return false;
        if (this.logWhenHandled() != defaultServerLog.logWhenHandled()) return false;
        if (this.logAllDecodeFailures() != defaultServerLog.logAllDecodeFailures()) return false;
        if (this.logLogicExceptions() != defaultServerLog.logLogicExceptions()) return false;
        if (this.includeTiming() != defaultServerLog.includeTiming()) return false;
        Function1<String, F> function1 = this.doLogWhenReceived();
        Function1<String, F> function12 = defaultServerLog.doLogWhenReceived();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        Function2<String, Option<Throwable>, F> function2 = this.doLogWhenHandled();
        Function2<String, Option<Throwable>, F> function22 = defaultServerLog.doLogWhenHandled();
        if (function2 == null) {
            if (function22 != null) {
                return false;
            }
        } else if (!function2.equals(function22)) return false;
        Function2<String, Option<Throwable>, F> function23 = this.doLogAllDecodeFailures();
        Function2<String, Option<Throwable>, F> function24 = defaultServerLog.doLogAllDecodeFailures();
        if (function23 == null) {
            if (function24 != null) {
                return false;
            }
        } else if (!function23.equals(function24)) return false;
        Function2<String, Throwable, F> function25 = this.doLogExceptions();
        Function2<String, Throwable, F> function26 = defaultServerLog.doLogExceptions();
        if (function25 == null) {
            if (function26 != null) {
                return false;
            }
        } else if (!function25.equals(function26)) return false;
        if (!BoxesRunTime.equals(this.noLog(), defaultServerLog.noLog())) return false;
        Function1<Endpoint<?, ?, ?, ?, ?>, String> function13 = this.showEndpoint();
        Function1<Endpoint<?, ?, ?, ?, ?>, String> function14 = defaultServerLog.showEndpoint();
        if (function13 == null) {
            if (function14 != null) {
                return false;
            }
        } else if (!function13.equals(function14)) return false;
        Function1<ServerRequest, String> function15 = this.showRequest();
        Function1<ServerRequest, String> function16 = defaultServerLog.showRequest();
        if (function15 == null) {
            if (function16 != null) {
                return false;
            }
        } else if (!function15.equals(function16)) return false;
        Function1<ServerResponse<?>, String> function17 = this.showResponse();
        Function1<ServerResponse<?>, String> function18 = defaultServerLog.showResponse();
        if (function17 == null) {
            if (function18 != null) {
                return false;
            }
        } else if (!function17.equals(function18)) return false;
        Clock clock = this.clock();
        Clock clock2 = defaultServerLog.clock();
        if (clock == null) {
            if (clock2 != null) {
                return false;
            }
        } else if (!((Object)clock).equals(clock2)) return false;
        Set<Endpoint<?, ?, ?, ?, ?>> set = this.ignoreEndpoints();
        Set<Endpoint<?, ?, ?, ?, ?>> set2 = defaultServerLog.ignoreEndpoints();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        if (!defaultServerLog.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DefaultServerLog;
    }

    public int productArity() {
        return 15;
    }

    public String productPrefix() {
        return "DefaultServerLog";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return BoxesRunTime.boxToBoolean((boolean)this._6());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)this._7());
            }
            case 7: {
                return BoxesRunTime.boxToBoolean((boolean)this._8());
            }
            case 8: {
                return BoxesRunTime.boxToBoolean((boolean)this._9());
            }
            case 9: {
                return this._10();
            }
            case 10: {
                return this._11();
            }
            case 11: {
                return this._12();
            }
            case 12: {
                return BoxesRunTime.boxToBoolean((boolean)this._13());
            }
            case 13: {
                return this._14();
            }
            case 14: {
                return this._15();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "doLogWhenReceived";
            }
            case 1: {
                return "doLogWhenHandled";
            }
            case 2: {
                return "doLogAllDecodeFailures";
            }
            case 3: {
                return "doLogExceptions";
            }
            case 4: {
                return "noLog";
            }
            case 5: {
                return "logWhenReceived";
            }
            case 6: {
                return "logWhenHandled";
            }
            case 7: {
                return "logAllDecodeFailures";
            }
            case 8: {
                return "logLogicExceptions";
            }
            case 9: {
                return "showEndpoint";
            }
            case 10: {
                return "showRequest";
            }
            case 11: {
                return "showResponse";
            }
            case 12: {
                return "includeTiming";
            }
            case 13: {
                return "clock";
            }
            case 14: {
                return "ignoreEndpoints";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Function1<String, F> doLogWhenReceived() {
        return this.doLogWhenReceived;
    }

    public Function2<String, Option<Throwable>, F> doLogWhenHandled() {
        return this.doLogWhenHandled;
    }

    public Function2<String, Option<Throwable>, F> doLogAllDecodeFailures() {
        return this.doLogAllDecodeFailures;
    }

    public Function2<String, Throwable, F> doLogExceptions() {
        return this.doLogExceptions;
    }

    public F noLog() {
        return (F)this.noLog;
    }

    public boolean logWhenReceived() {
        return this.logWhenReceived;
    }

    public boolean logWhenHandled() {
        return this.logWhenHandled;
    }

    public boolean logAllDecodeFailures() {
        return this.logAllDecodeFailures;
    }

    public boolean logLogicExceptions() {
        return this.logLogicExceptions;
    }

    public Function1<Endpoint<?, ?, ?, ?, ?>, String> showEndpoint() {
        return this.showEndpoint;
    }

    public Function1<ServerRequest, String> showRequest() {
        return this.showRequest;
    }

    public Function1<ServerResponse<?>, String> showResponse() {
        return this.showResponse;
    }

    public boolean includeTiming() {
        return this.includeTiming;
    }

    public Clock clock() {
        return this.clock;
    }

    @Override
    public Set<Endpoint<?, ?, ?, ?, ?>> ignoreEndpoints() {
        return this.ignoreEndpoints;
    }

    public DefaultServerLog<F> doLogWhenReceived(Function1<String, F> f) {
        return this.copy(f, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> doLogWhenHandled(Function2<String, Option<Throwable>, F> f) {
        return this.copy(this.copy$default$1(), f, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> doLogAllDecodeFailures(Function2<String, Option<Throwable>, F> f) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), f, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> doLogExceptions(Function2<String, Throwable, F> f) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), f, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> noLog(F f) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), f, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> logWhenReceived(boolean doLog) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), doLog, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> logWhenHandled(boolean doLog) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), doLog, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> logAllDecodeFailures(boolean doLog) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), doLog, this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> logLogicExceptions(boolean doLog) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), doLog, this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> showEndpoint(Function1<Endpoint<?, ?, ?, ?, ?>, String> s) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), s, this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> showRequest(Function1<ServerRequest, String> s) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), s, this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> showResponse(Function1<ServerResponse<?>, String> s) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), s, this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> includeTiming(boolean doInclude) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), doInclude, this.copy$default$14(), this.copy$default$15());
    }

    public DefaultServerLog<F> clock(Clock c) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), c, this.copy$default$15());
    }

    public DefaultServerLog<F> ignoreEndpoints(Seq<Endpoint<?, ?, ?, ?, ?>> es) {
        Set set = es.toSet();
        Function1<String, F> function1 = this.copy$default$1();
        Function2<String, Option<Throwable>, F> function2 = this.copy$default$2();
        Function2<String, Option<Throwable>, F> function22 = this.copy$default$3();
        Function2<String, Throwable, F> function23 = this.copy$default$4();
        F f = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        boolean bl3 = this.copy$default$8();
        boolean bl4 = this.copy$default$9();
        Function1<Endpoint<?, ?, ?, ?, ?>, String> function12 = this.copy$default$10();
        Function1<ServerRequest, String> function13 = this.copy$default$11();
        Function1<ServerResponse<?>, String> function14 = this.copy$default$12();
        boolean bl5 = this.copy$default$13();
        Clock clock = this.copy$default$14();
        return this.copy(function1, function2, function22, function23, f, bl, bl2, bl3, bl4, function12, function13, function14, bl5, clock, set);
    }

    public long requestToken() {
        if (this.includeTiming()) {
            return this.now();
        }
        return 0L;
    }

    public F requestReceived(ServerRequest request, long token) {
        if (this.logWhenReceived()) {
            return (F)this.doLogWhenReceived().apply((Object)new StringBuilder(18).append("Request received: ").append(this.showRequest().apply((Object)request)).toString());
        }
        return this.noLog();
    }

    public F decodeFailureNotHandled(DecodeFailureContext ctx, long token) {
        if (this.logAllDecodeFailures()) {
            return (F)this.doLogAllDecodeFailures().apply((Object)new StringBuilder(57).append("Request: ").append(this.showRequest().apply((Object)ctx.request())).append(", not handled by: ").append(this.showEndpoint().apply(ctx.endpoint())).append(this.took(token)).append("; decode failure: ").append(ctx.failure()).append(", on input: ").append(ctx.failingInput().show()).toString(), this.exception(ctx));
        }
        return this.noLog();
    }

    public F decodeFailureHandled(DecodeFailureContext ctx, ServerResponse<?> response, long token) {
        if (this.logWhenHandled()) {
            return (F)this.doLogWhenHandled().apply((Object)new StringBuilder(65).append("Request: ").append(this.showRequest().apply((Object)ctx.request())).append(", handled by: ").append(this.showEndpoint().apply(ctx.endpoint())).append(this.took(token)).append("; decode failure: ").append(ctx.failure()).append(", on input: ").append(ctx.failingInput().show()).append("; response: ").append(this.showResponse().apply(response)).toString(), this.exception(ctx));
        }
        return this.noLog();
    }

    public F securityFailureHandled(SecurityFailureContext<F, ?> ctx, ServerResponse<?> response, long token) {
        if (this.logWhenHandled()) {
            return (F)this.doLogWhenHandled().apply((Object)new StringBuilder(56).append("Request: ").append(this.showRequest().apply((Object)ctx.request())).append(", handled by: ").append(this.showEndpoint().apply(ctx.endpoint())).append(this.took(token)).append("; security logic error response: ").append(this.showResponse().apply(response)).toString(), (Object)None$.MODULE$);
        }
        return this.noLog();
    }

    public F requestHandled(DecodeSuccessContext<F, ?, ?, ?> ctx, ServerResponse<?> response, long token) {
        if (this.logWhenHandled()) {
            return (F)this.doLogWhenHandled().apply((Object)new StringBuilder(35).append("Request: ").append(this.showRequest().apply((Object)ctx.request())).append(", handled by: ").append(this.showEndpoint().apply(ctx.endpoint())).append(this.took(token)).append("; response: ").append(this.showResponse().apply(response)).toString(), (Object)None$.MODULE$);
        }
        return this.noLog();
    }

    public F exception(ExceptionContext<?, ?> ctx, Throwable ex, long token) {
        if (this.logLogicExceptions()) {
            return (F)this.doLogExceptions().apply((Object)new StringBuilder(39).append("Exception when handling request: ").append(this.showRequest().apply((Object)ctx.request())).append(", by: ").append(this.showEndpoint().apply(ctx.endpoint())).append(this.took(token)).toString(), (Object)ex);
        }
        return this.noLog();
    }

    private long now() {
        return this.clock().instant().toEpochMilli();
    }

    private String took(long token) {
        if (this.includeTiming()) {
            return new StringBuilder(10).append(", took: ").append(this.now() - token).append("ms").toString();
        }
        return "";
    }

    private Option<Throwable> exception(DecodeFailureContext ctx) {
        DecodeResult.Failure failure = ctx.failure();
        if (failure instanceof DecodeResult.Error) {
            Throwable throwable;
            DecodeResult.Error error = DecodeResult.Error$.MODULE$.unapply((DecodeResult.Error)failure);
            String string = error._1();
            Throwable error2 = throwable = error._2();
            return Some$.MODULE$.apply((Object)error2);
        }
        return None$.MODULE$;
    }

    public <F> DefaultServerLog<F> copy(Function1<String, Object> doLogWhenReceived, Function2<String, Option<Throwable>, Object> doLogWhenHandled, Function2<String, Option<Throwable>, Object> doLogAllDecodeFailures, Function2<String, Throwable, Object> doLogExceptions, Object noLog, boolean logWhenReceived, boolean logWhenHandled, boolean logAllDecodeFailures, boolean logLogicExceptions, Function1<Endpoint<?, ?, ?, ?, ?>, String> showEndpoint, Function1<ServerRequest, String> showRequest, Function1<ServerResponse<?>, String> showResponse, boolean includeTiming, Clock clock, Set<Endpoint<?, ?, ?, ?, ?>> ignoreEndpoints) {
        return new DefaultServerLog<F>(doLogWhenReceived, doLogWhenHandled, doLogAllDecodeFailures, doLogExceptions, noLog, logWhenReceived, logWhenHandled, logAllDecodeFailures, logLogicExceptions, showEndpoint, showRequest, showResponse, includeTiming, clock, ignoreEndpoints);
    }

    public <F> Function1<String, F> copy$default$1() {
        return this.doLogWhenReceived();
    }

    public <F> Function2<String, Option<Throwable>, F> copy$default$2() {
        return this.doLogWhenHandled();
    }

    public <F> Function2<String, Option<Throwable>, F> copy$default$3() {
        return this.doLogAllDecodeFailures();
    }

    public <F> Function2<String, Throwable, F> copy$default$4() {
        return this.doLogExceptions();
    }

    public <F> F copy$default$5() {
        return this.noLog();
    }

    public boolean copy$default$6() {
        return this.logWhenReceived();
    }

    public boolean copy$default$7() {
        return this.logWhenHandled();
    }

    public boolean copy$default$8() {
        return this.logAllDecodeFailures();
    }

    public boolean copy$default$9() {
        return this.logLogicExceptions();
    }

    public <F> Function1<Endpoint<?, ?, ?, ?, ?>, String> copy$default$10() {
        return this.showEndpoint();
    }

    public <F> Function1<ServerRequest, String> copy$default$11() {
        return this.showRequest();
    }

    public <F> Function1<ServerResponse<?>, String> copy$default$12() {
        return this.showResponse();
    }

    public boolean copy$default$13() {
        return this.includeTiming();
    }

    public <F> Clock copy$default$14() {
        return this.clock();
    }

    public <F> Set<Endpoint<?, ?, ?, ?, ?>> copy$default$15() {
        return this.ignoreEndpoints();
    }

    public Function1<String, F> _1() {
        return this.doLogWhenReceived();
    }

    public Function2<String, Option<Throwable>, F> _2() {
        return this.doLogWhenHandled();
    }

    public Function2<String, Option<Throwable>, F> _3() {
        return this.doLogAllDecodeFailures();
    }

    public Function2<String, Throwable, F> _4() {
        return this.doLogExceptions();
    }

    public F _5() {
        return this.noLog();
    }

    public boolean _6() {
        return this.logWhenReceived();
    }

    public boolean _7() {
        return this.logWhenHandled();
    }

    public boolean _8() {
        return this.logAllDecodeFailures();
    }

    public boolean _9() {
        return this.logLogicExceptions();
    }

    public Function1<Endpoint<?, ?, ?, ?, ?>, String> _10() {
        return this.showEndpoint();
    }

    public Function1<ServerRequest, String> _11() {
        return this.showRequest();
    }

    public Function1<ServerResponse<?>, String> _12() {
        return this.showResponse();
    }

    public boolean _13() {
        return this.includeTiming();
    }

    public Clock _14() {
        return this.clock();
    }

    public Set<Endpoint<?, ?, ?, ?, ?>> _15() {
        return this.ignoreEndpoints();
    }
}

