/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.netty.sync;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ox.Ox;
import ox.OxUnsupervised;
import ox.resource$package$;
import ox.supervised$package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;
import sttp.capabilities.package;
import sttp.tapir.server.ServerEndpoint;
import sttp.tapir.server.model.ServerResponse;
import sttp.tapir.server.netty.NettyConfig;
import sttp.tapir.server.netty.NettyResponseContent;
import sttp.tapir.server.netty.NettyServerRequest;
import sttp.tapir.server.netty.internal.NettyBootstrap$;
import sttp.tapir.server.netty.internal.NettyServerHandler;
import sttp.tapir.server.netty.package;
import sttp.tapir.server.netty.sync.NettySyncDomainSocketBinding;
import sttp.tapir.server.netty.sync.NettySyncDomainSocketBinding$;
import sttp.tapir.server.netty.sync.NettySyncServer$;
import sttp.tapir.server.netty.sync.NettySyncServerBinding;
import sttp.tapir.server.netty.sync.NettySyncServerBinding$;
import sttp.tapir.server.netty.sync.NettySyncServerEndpointListOverridenOptions;
import sttp.tapir.server.netty.sync.NettySyncServerEndpointListOverridenOptions$;
import sttp.tapir.server.netty.sync.NettySyncServerInterpreter$;
import sttp.tapir.server.netty.sync.NettySyncServerOptions;
import sttp.tapir.server.netty.sync.internal.ox.OxDispatcher;
import sttp.tapir.server.netty.sync.internal.ox.OxDispatcher$;
import sttp.tapir.server.netty.sync.package$;

public class NettySyncServer
implements Product,
Serializable {
    private final List endpoints;
    private final List endpointsWithOptions;
    private final NettySyncServerOptions options;
    private final NettyConfig config;
    private final ExecutorService executor;
    private final Logger logger;

    public static NettySyncServer apply() {
        return NettySyncServer$.MODULE$.apply();
    }

    public static NettySyncServer apply(List<ServerEndpoint<package.WebSockets, Object>> list, List<NettySyncServerEndpointListOverridenOptions> list2, NettySyncServerOptions nettySyncServerOptions, NettyConfig nettyConfig) {
        return NettySyncServer$.MODULE$.apply(list, list2, nettySyncServerOptions, nettyConfig);
    }

    public static NettySyncServer apply(NettyConfig nettyConfig) {
        return NettySyncServer$.MODULE$.apply(nettyConfig);
    }

    public static NettySyncServer apply(NettySyncServerOptions nettySyncServerOptions) {
        return NettySyncServer$.MODULE$.apply(nettySyncServerOptions);
    }

    public static NettySyncServer apply(NettySyncServerOptions nettySyncServerOptions, NettyConfig nettyConfig) {
        return NettySyncServer$.MODULE$.apply(nettySyncServerOptions, nettyConfig);
    }

    public static NettySyncServer fromProduct(Product product) {
        return NettySyncServer$.MODULE$.fromProduct(product);
    }

    public static NettySyncServer unapply(NettySyncServer nettySyncServer) {
        return NettySyncServer$.MODULE$.unapply(nettySyncServer);
    }

    public NettySyncServer(List<ServerEndpoint<package.WebSockets, Object>> endpoints, List<NettySyncServerEndpointListOverridenOptions> endpointsWithOptions, NettySyncServerOptions options, NettyConfig config) {
        this.endpoints = endpoints;
        this.endpointsWithOptions = endpointsWithOptions;
        this.options = options;
        this.config = config;
        this.executor = Executors.newVirtualThreadPerTaskExecutor();
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof NettySyncServer)) return false;
        NettySyncServer nettySyncServer = (NettySyncServer)object;
        List<ServerEndpoint<package.WebSockets, Object>> list = this.endpoints();
        List<ServerEndpoint<package.WebSockets, Object>> list2 = nettySyncServer.endpoints();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<NettySyncServerEndpointListOverridenOptions> list3 = this.endpointsWithOptions();
        List<NettySyncServerEndpointListOverridenOptions> list4 = nettySyncServer.endpointsWithOptions();
        if (list3 == null) {
            if (list4 != null) {
                return false;
            }
        } else if (!list3.equals(list4)) return false;
        NettySyncServerOptions nettySyncServerOptions = this.options();
        NettySyncServerOptions nettySyncServerOptions2 = nettySyncServer.options();
        if (nettySyncServerOptions == null) {
            if (nettySyncServerOptions2 != null) {
                return false;
            }
        } else if (!((Object)nettySyncServerOptions).equals(nettySyncServerOptions2)) return false;
        NettyConfig nettyConfig = this.config();
        NettyConfig nettyConfig2 = nettySyncServer.config();
        if (nettyConfig == null) {
            if (nettyConfig2 != null) {
                return false;
            }
        } else if (!nettyConfig.equals(nettyConfig2)) return false;
        if (!nettySyncServer.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof NettySyncServer;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "NettySyncServer";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "endpoints";
            }
            case 1: {
                return "endpointsWithOptions";
            }
            case 2: {
                return "options";
            }
            case 3: {
                return "config";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public List<ServerEndpoint<package.WebSockets, Object>> endpoints() {
        return this.endpoints;
    }

    public List<NettySyncServerEndpointListOverridenOptions> endpointsWithOptions() {
        return this.endpointsWithOptions;
    }

    public NettySyncServerOptions options() {
        return this.options;
    }

    public NettyConfig config() {
        return this.config;
    }

    public NettySyncServer addEndpoint(ServerEndpoint<package.WebSockets, Object> se) {
        return this.addEndpoints((List<ServerEndpoint<package.WebSockets, Object>>)((List)new .colon.colon(se, (List)Nil$.MODULE$)));
    }

    public NettySyncServer addEndpoint(ServerEndpoint<package.WebSockets, Object> se, NettySyncServerOptions overrideOptions) {
        return this.addEndpoints((List<ServerEndpoint<package.WebSockets, Object>>)((List)new .colon.colon(se, (List)Nil$.MODULE$)), overrideOptions);
    }

    public NettySyncServer addEndpoints(List<ServerEndpoint<package.WebSockets, Object>> ses) {
        return this.copy((List<ServerEndpoint<package.WebSockets, Object>>)((List)this.endpoints().$plus$plus(ses)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public NettySyncServer addEndpoints(List<ServerEndpoint<package.WebSockets, Object>> ses, NettySyncServerOptions overrideOptions) {
        List list = (List)this.endpointsWithOptions().$colon$plus((Object)NettySyncServerEndpointListOverridenOptions$.MODULE$.apply(ses, overrideOptions));
        List<ServerEndpoint<package.WebSockets, Object>> list2 = this.copy$default$1();
        NettySyncServerOptions nettySyncServerOptions = this.copy$default$3();
        NettyConfig nettyConfig = this.copy$default$4();
        return this.copy(list2, (List<NettySyncServerEndpointListOverridenOptions>)list, nettySyncServerOptions, nettyConfig);
    }

    public NettySyncServer options(NettySyncServerOptions o) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), o, this.copy$default$4());
    }

    public NettySyncServer config(NettyConfig c) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), c);
    }

    public NettySyncServer modifyConfig(Function1<NettyConfig, NettyConfig> f) {
        return this.config((NettyConfig)f.apply((Object)this.config()));
    }

    public NettySyncServer host(String hostname) {
        return this.modifyConfig((Function1<NettyConfig, NettyConfig>)(Function1 & Serializable)_$1 -> _$1.host(hostname));
    }

    public NettySyncServer port(int p) {
        return this.modifyConfig((Function1<NettyConfig, NettyConfig>)(Function1 & Serializable)_$2 -> _$2.port(p));
    }

    public NettySyncServerBinding start(Ox x$1) {
        Tuple2 tuple2 = this.startUsingSocketOverride((Option)None$.MODULE$, OxDispatcher$.MODULE$.create(x$1));
        if (tuple2 != null) {
            InetSocketAddress socket = (InetSocketAddress)tuple2._1();
            Function0 stop = (Function0)tuple2._2();
            NettySyncServerBinding tt = NettySyncServerBinding$.MODULE$.apply(socket, (Function0<BoxedUnit>)stop);
            this.logger.info(new StringBuilder(31).append("Tapir Netty server started on ").append(tt.hostName()).append(":").append(tt.port()).toString());
            return tt;
        }
        throw new MatchError(tuple2);
    }

    public void startAndWait() {
        supervised$package$.MODULE$.supervised((Function1 & Serializable)evidence$1 -> {
            NettySyncServerBinding nettySyncServerBinding = (NettySyncServerBinding)resource$package$.MODULE$.useInScope(() -> this.startAndWait$$anonfun$1$$anonfun$1(evidence$1), (Function1)(JProcedure1 & Serializable)_$3 -> _$3.stop().apply$mcV$sp(), (OxUnsupervised)evidence$1);
            while (true) {
                LockSupport.park();
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
            throw new RuntimeException("can't get here");
        });
    }

    public NettySyncServerBinding start(List<Function1<NettyServerRequest, Option<ServerResponse<Function1<ChannelHandlerContext, NettyResponseContent>>>>> routes) {
        Tuple2 tuple2 = this.startUsingSocketOverride(routes, (Option)None$.MODULE$);
        if (tuple2 != null) {
            InetSocketAddress socket = (InetSocketAddress)tuple2._1();
            Function0 stop = (Function0)tuple2._2();
            return NettySyncServerBinding$.MODULE$.apply(socket, (Function0<BoxedUnit>)stop);
        }
        throw new MatchError(tuple2);
    }

    public NettySyncDomainSocketBinding startUsingDomainSocket(Path path, Ox x$2) {
        Tuple2 tuple2 = this.startUsingSocketOverride((Option)Some$.MODULE$.apply((Object)new DomainSocketAddress(path.toFile())), OxDispatcher$.MODULE$.create(x$2));
        if (tuple2 != null) {
            DomainSocketAddress socket = (DomainSocketAddress)tuple2._1();
            Function0 stop = (Function0)tuple2._2();
            return NettySyncDomainSocketBinding$.MODULE$.apply(socket, (Function0<BoxedUnit>)stop);
        }
        throw new MatchError(tuple2);
    }

    private <SA extends SocketAddress> Tuple2<SA, Function0<BoxedUnit>> startUsingSocketOverride(Option<SA> socketOverride, OxDispatcher oxDispatcher) {
        Function1<NettyServerRequest, Option<ServerResponse<Function1<ChannelHandlerContext, NettyResponseContent>>>> function1 = NettySyncServerInterpreter$.MODULE$.apply(this.options()).toRoute(this.endpoints(), oxDispatcher);
        List routes = this.endpointsWithOptions().map((Function1 & Serializable)e -> NettySyncServerInterpreter$.MODULE$.apply(e.overridenOptions()).toRoute(e.ses(), oxDispatcher)).$colon$colon(function1);
        return this.startUsingSocketOverride((List<Function1<NettyServerRequest, Option<ServerResponse<Function1<ChannelHandlerContext, NettyResponseContent>>>>>)routes, socketOverride);
    }

    private <SA extends SocketAddress> Tuple2<SA, Function0<BoxedUnit>> startUsingSocketOverride(List<Function1<NettyServerRequest, Option<ServerResponse<Function1<ChannelHandlerContext, NettyResponseContent>>>>> routes, Option<SA> socketOverride) {
        Tuple2 tuple2;
        EventLoopGroup eventLoopGroup = (EventLoopGroup)this.config().eventLoopConfig().initEventLoopGroup().apply();
        Function1 route = package.Route$.MODULE$.combine(routes, package$.MODULE$.idMonad());
        DefaultEventExecutor eventExecutor = new DefaultEventExecutor();
        DefaultChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)eventExecutor);
        AtomicBoolean isShuttingDown = new AtomicBoolean(false);
        ChannelFuture channelIdFuture = NettyBootstrap$.MODULE$.apply(this.config(), () -> this.$anonfun$2(route, channelGroup, isShuttingDown), eventLoopGroup, socketOverride);
        try {
            channelIdFuture.sync();
            Channel channelId = channelIdFuture.channel();
            tuple2 = Tuple2$.MODULE$.apply((Object)channelId.localAddress(), (JFunction0.mcV.sp & Serializable)() -> this.stop(channelId, eventLoopGroup, (ChannelGroup)channelGroup, eventExecutor, isShuttingDown, (Option<FiniteDuration>)this.config().gracefulShutdownTimeout()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable startFailureCause;
                block6: {
                    Throwable throwable3;
                    startFailureCause = throwable3 = (Throwable)option.get();
                    try {
                        this.stopRecovering(eventLoopGroup, (ChannelGroup)channelGroup, eventExecutor, isShuttingDown, (Option<FiniteDuration>)this.config().gracefulShutdownTimeout());
                    }
                    catch (Throwable throwable4) {
                        Option option2;
                        Throwable throwable5 = throwable4;
                        if (throwable5 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                            Throwable throwable6;
                            Throwable recoveryFailureCause = throwable6 = (Throwable)option2.get();
                            startFailureCause.addSuppressed(recoveryFailureCause);
                            break block6;
                        }
                        throw throwable4;
                    }
                }
                throw startFailureCause;
            }
            throw throwable;
        }
        return tuple2;
    }

    private void waitForClosedChannels(ChannelGroup channelGroup, long startNanos, Option<Object> gracefulShutdownTimeoutNanos) {
        while (!channelGroup.isEmpty() && gracefulShutdownTimeoutNanos.exists((Function1)(JFunction1.mcZJ.sp & Serializable)_$4 -> _$4 >= System.nanoTime() - startNanos)) {
            Thread.sleep(100L);
        }
        Void void_ = (Void)channelGroup.close().get();
    }

    private void stop(Channel ch, EventLoopGroup eventLoopGroup, ChannelGroup channelGroup, DefaultEventExecutor eventExecutor, AtomicBoolean isShuttingDown, Option<FiniteDuration> gracefulShutdownTimeout) {
        isShuttingDown.set(true);
        this.waitForClosedChannels(channelGroup, System.nanoTime(), (Option<Object>)gracefulShutdownTimeout.map((Function1 & Serializable)_$5 -> _$5.toNanos()));
        ch.close().get();
        if (this.config().shutdownEventLoopGroupOnClose()) {
            Object object = eventLoopGroup.shutdownGracefully().get();
            Object object2 = eventExecutor.shutdownGracefully().get();
            return;
        }
    }

    private void stopRecovering(EventLoopGroup eventLoopGroup, ChannelGroup channelGroup, DefaultEventExecutor eventExecutor, AtomicBoolean isShuttingDown, Option<FiniteDuration> gracefulShutdownTimeout) {
        isShuttingDown.set(true);
        this.waitForClosedChannels(channelGroup, System.nanoTime(), (Option<Object>)gracefulShutdownTimeout.map((Function1 & Serializable)_$6 -> _$6.toNanos()));
        if (this.config().shutdownEventLoopGroupOnClose()) {
            Object object = eventLoopGroup.shutdownGracefully().get();
            Object object2 = eventExecutor.shutdownGracefully().get();
            return;
        }
    }

    public NettySyncServer copy(List<ServerEndpoint<package.WebSockets, Object>> endpoints, List<NettySyncServerEndpointListOverridenOptions> endpointsWithOptions, NettySyncServerOptions options, NettyConfig config) {
        return new NettySyncServer(endpoints, endpointsWithOptions, options, config);
    }

    public List<ServerEndpoint<package.WebSockets, Object>> copy$default$1() {
        return this.endpoints();
    }

    public List<NettySyncServerEndpointListOverridenOptions> copy$default$2() {
        return this.endpointsWithOptions();
    }

    public NettySyncServerOptions copy$default$3() {
        return this.options();
    }

    public NettyConfig copy$default$4() {
        return this.config();
    }

    public List<ServerEndpoint<package.WebSockets, Object>> _1() {
        return this.endpoints();
    }

    public List<NettySyncServerEndpointListOverridenOptions> _2() {
        return this.endpointsWithOptions();
    }

    public NettySyncServerOptions _3() {
        return this.options();
    }

    public NettyConfig _4() {
        return this.config();
    }

    private final NettySyncServerBinding startAndWait$$anonfun$1$$anonfun$1(Ox evidence$1$1) {
        return this.start(evidence$1$1);
    }

    private final Tuple2 unsafeRunF$1(Function0 callToExecute) {
        Promise scalaPromise = Promise$.MODULE$.apply();
        Future<?> jFuture = this.executor.submit(new Runnable(callToExecute, scalaPromise){
            private final Function0 callToExecute$1;
            private final Promise scalaPromise$1;
            {
                this.callToExecute$1 = callToExecute$2;
                this.scalaPromise$1 = scalaPromise$2;
            }

            public void run() {
                try {
                    ServerResponse result = (ServerResponse)this.callToExecute$1.apply();
                    this.scalaPromise$1.success((Object)result);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable e = throwable3 = (Throwable)option.get();
                        this.scalaPromise$1.failure(e);
                    }
                    throw throwable;
                }
            }
        });
        return Tuple2$.MODULE$.apply((Object)scalaPromise.future(), (Function0 & Serializable)() -> {
            jFuture.cancel(true);
            return Future$.MODULE$.unit();
        });
    }

    private final NettyServerHandler $anonfun$2(Function1 route$1, DefaultChannelGroup channelGroup$1, AtomicBoolean isShuttingDown$1) {
        return new NettyServerHandler(route$1, (Function1 & Serializable)callToExecute -> this.unsafeRunF$1((Function0)callToExecute), (ChannelGroup)channelGroup$1, isShuttingDown$1, this.config(), package$.MODULE$.idMonad());
    }
}

