/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.pekkohttp;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.pekko.http.scaladsl.model.BodyPartEntity;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.HttpCharsets$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.Multipart;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.StreamConverters$;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import sttp.client4.BodyPart;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteArrayBody$;
import sttp.client4.ByteBufferBody;
import sttp.client4.ByteBufferBody$;
import sttp.client4.FileBody;
import sttp.client4.FileBody$;
import sttp.client4.GenericRequest;
import sttp.client4.GenericRequestBody;
import sttp.client4.InputStreamBody;
import sttp.client4.InputStreamBody$;
import sttp.client4.MultipartBody;
import sttp.client4.NoBody$;
import sttp.client4.StreamBody;
import sttp.client4.StreamBody$;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.client4.compression.Compressor;
import sttp.client4.compression.Compressor$;
import sttp.client4.internal.SttpFile;
import sttp.client4.pekkohttp.ToPekko$;
import sttp.client4.pekkohttp.Util$;
import sttp.model.Header;
import sttp.model.Part;

public final class BodyToPekko$
implements Serializable {
    public static final BodyToPekko$ MODULE$ = new BodyToPekko$();

    private BodyToPekko$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BodyToPekko$.class);
    }

    public <R> Try<HttpRequest> apply(GenericRequest<?, R> r, HttpRequest ar, List<Compressor<R>> compressors) {
        Tuple2 tuple2 = Compressor$.MODULE$.compressIfNeeded(r, compressors);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        GenericRequestBody body = (GenericRequestBody)tuple2._1();
        Option contentLength = (Option)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)body, (Object)contentLength);
        GenericRequestBody body2 = (GenericRequestBody)tuple22._1();
        Option contentLength2 = (Option)tuple22._2();
        return Util$.MODULE$.parseContentTypeOrOctetStream(r).flatMap((Function1 & Serializable)ct -> {
            GenericRequestBody genericRequestBody = body2;
            if (NoBody$.MODULE$.equals(genericRequestBody)) {
                return Success$.MODULE$.apply((Object)ar);
            }
            if (genericRequestBody instanceof StringBody) {
                StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)genericRequestBody);
                String string = stringBody._1();
                String string2 = stringBody._2();
                sttp.model.MediaType mediaType = stringBody._3();
                String b = string;
                String encoding = string2;
                return Success$.MODULE$.apply((Object)ar.withEntity((org.apache.pekko.http.javadsl.model.ContentType)this.ctWithCharset$1((ContentType)ct, encoding), b.getBytes(encoding)));
            }
            if (genericRequestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)genericRequestBody);
                byte[] byArray = byteArrayBody._1();
                sttp.model.MediaType mediaType = byteArrayBody._2();
                byte[] b = byArray;
                return Success$.MODULE$.apply((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, b)));
            }
            if (genericRequestBody instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)genericRequestBody);
                ByteBuffer byteBuffer = byteBufferBody._1();
                sttp.model.MediaType mediaType = byteBufferBody._2();
                ByteBuffer b = byteBuffer;
                return Success$.MODULE$.apply((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b))));
            }
            if (genericRequestBody instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = InputStreamBody$.MODULE$.unapply((InputStreamBody)genericRequestBody);
                InputStream inputStream = inputStreamBody._1();
                sttp.model.MediaType mediaType = inputStreamBody._2();
                InputStream b = inputStream;
                return Success$.MODULE$.apply((Object)ar.withEntity(this.streamEntity$1(contentLength2, (ContentType)ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> b, StreamConverters$.MODULE$.fromInputStream$default$2()))));
            }
            if (genericRequestBody instanceof FileBody) {
                FileBody fileBody = FileBody$.MODULE$.unapply((FileBody)genericRequestBody);
                SttpFile sttpFile = fileBody._1();
                sttp.model.MediaType mediaType = fileBody._2();
                SttpFile b = sttpFile;
                return Success$.MODULE$.apply((Object)ar.withEntity((org.apache.pekko.http.javadsl.model.ContentType)ct, b.toPath()));
            }
            if (genericRequestBody instanceof StreamBody) {
                Object object;
                StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)genericRequestBody);
                Object s = object = streamBody._1();
                return Success$.MODULE$.apply((Object)ar.withEntity(this.streamEntity$1(contentLength2, (ContentType)ct, (Source)s)));
            }
            if (genericRequestBody instanceof MultipartBody) {
                MultipartBody m = (MultipartBody)genericRequestBody;
                return Util$.MODULE$.traverseTry((Seq)m.parts().map((Function1 & Serializable)mp -> this.toBodyPart$1((Part)mp))).flatMap((Function1 & Serializable)bodyParts -> MODULE$.multipartEntity(r, (Seq<Multipart.FormData.BodyPart>)bodyParts).map((Function1 & Serializable)entity -> ar.withEntity(entity)));
            }
            throw new MatchError((Object)genericRequestBody);
        });
    }

    private Try<RequestEntity> multipartEntity(GenericRequest<?, ?> r, Seq<Multipart.FormData.BodyPart> bodyParts) {
        Option option = r.headers().find((Function1 & Serializable)header -> Util$.MODULE$.isContentType((Header)header));
        if (None$.MODULE$.equals(option)) {
            return Success$.MODULE$.apply((Object)Multipart.FormData$.MODULE$.apply(bodyParts).toEntity());
        }
        if (option instanceof Some) {
            Header ct = (Header)((Some)option).value();
            return Util$.MODULE$.parseContentType(ct.value()).map((Function1 & Serializable)_$1 -> _$1.mediaType()).flatMap((Function1 & Serializable)x$1 -> {
                MediaType mediaType = x$1;
                if (mediaType instanceof MediaType.Multipart) {
                    MediaType.Multipart m = (MediaType.Multipart)mediaType;
                    return Success$.MODULE$.apply((Object)Multipart.General$.MODULE$.apply(m, Source$.MODULE$.apply((Iterable)bodyParts.map((Function1 & Serializable)bp -> Multipart.General$.BodyPart$.MODULE$.apply(bp.entity(), bp.headers())))).toEntity());
                }
                return Failure$.MODULE$.apply((Throwable)new RuntimeException(new StringBuilder(28).append("Non-multipart content type: ").append(ct).toString()));
            });
        }
        throw new MatchError((Object)option);
    }

    private static final ContentType ctWithCharset$1$$anonfun$2(ContentType ct$2) {
        return ct$2;
    }

    private final ContentType ctWithCharset$1(ContentType ct, String charset) {
        return (ContentType)HttpCharsets$.MODULE$.getForKey((Object)charset).map((Function1 & Serializable)hc -> ContentType$.MODULE$.apply(ct.mediaType(), (Function0 & Serializable)() -> hc)).getOrElse(() -> BodyToPekko$.ctWithCharset$1$$anonfun$2(ct));
    }

    private final BodyPartEntity streamPartEntity$1(Part mp$1, ContentType contentType, Source s) {
        Option option = mp$1.contentLength();
        if (None$.MODULE$.equals(option)) {
            return HttpEntity.IndefiniteLength$.MODULE$.apply(contentType, s);
        }
        if (option instanceof Some) {
            long l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return HttpEntity$.MODULE$.apply(contentType, l, s);
        }
        throw new MatchError((Object)option);
    }

    private final BodyPartEntity entity$1(Part mp$2, ContentType ct) {
        BodyPart bodyPart = (BodyPart)mp$2.body();
        if (bodyPart instanceof StringBody) {
            StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)bodyPart);
            String string = stringBody._1();
            String string2 = stringBody._2();
            sttp.model.MediaType mediaType = stringBody._3();
            String b = string;
            String encoding = string2;
            return HttpEntity$.MODULE$.apply(this.ctWithCharset$1(ct, encoding), b.getBytes(encoding));
        }
        if (bodyPart instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)bodyPart);
            byte[] byArray = byteArrayBody._1();
            sttp.model.MediaType mediaType = byteArrayBody._2();
            byte[] b = byArray;
            return HttpEntity$.MODULE$.apply(ct, b);
        }
        if (bodyPart instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)bodyPart);
            ByteBuffer byteBuffer = byteBufferBody._1();
            sttp.model.MediaType mediaType = byteBufferBody._2();
            ByteBuffer b = byteBuffer;
            return HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b));
        }
        if (bodyPart instanceof InputStreamBody) {
            InputStreamBody isb = (InputStreamBody)bodyPart;
            return this.streamPartEntity$1(mp$2, ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> isb.b(), StreamConverters$.MODULE$.fromInputStream$default$2()));
        }
        if (bodyPart instanceof FileBody) {
            FileBody fileBody = FileBody$.MODULE$.unapply((FileBody)bodyPart);
            SttpFile sttpFile = fileBody._1();
            sttp.model.MediaType mediaType = fileBody._2();
            SttpFile b = sttpFile;
            return HttpEntity$.MODULE$.fromPath(ct, b.toPath(), HttpEntity$.MODULE$.fromPath$default$3());
        }
        if (bodyPart instanceof StreamBody) {
            Object object;
            StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)bodyPart);
            Object b = object = streamBody._1();
            return this.streamPartEntity$1(mp$2, ct, (Source)b);
        }
        throw new MatchError((Object)bodyPart);
    }

    private final Try toBodyPart$1(Part mp) {
        return Util$.MODULE$.parseContentTypeOrOctetStream((Option<String>)mp.contentType()).flatMap((Function1 & Serializable)ct -> ToPekko$.MODULE$.headers((Seq<Header>)mp.headers().toList()).map((Function1 & Serializable)headers -> Multipart.FormData$.BodyPart$.MODULE$.apply(mp.name(), this.entity$1(mp, (ContentType)ct), mp.dispositionParams(), headers)));
    }

    private final RequestEntity streamEntity$1(Option contentLength$1, ContentType contentType, Source s) {
        Option option = contentLength$1;
        if (None$.MODULE$.equals(option)) {
            return HttpEntity$.MODULE$.apply(contentType, s);
        }
        if (option instanceof Some) {
            long l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return HttpEntity$.MODULE$.apply(contentType, l, s);
        }
        throw new MatchError((Object)option);
    }
}

