/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.pekkohttp;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.pekko.http.scaladsl.model.BodyPartEntity;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.HttpCharsets$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.Multipart;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.StreamConverters$;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;
import sttp.client3.ByteArrayBody;
import sttp.client3.ByteArrayBody$;
import sttp.client3.ByteBufferBody;
import sttp.client3.ByteBufferBody$;
import sttp.client3.FileBody;
import sttp.client3.FileBody$;
import sttp.client3.InputStreamBody;
import sttp.client3.InputStreamBody$;
import sttp.client3.MultipartBody;
import sttp.client3.MultipartBody$;
import sttp.client3.NoBody$;
import sttp.client3.RequestBody;
import sttp.client3.RequestT;
import sttp.client3.StreamBody;
import sttp.client3.StreamBody$;
import sttp.client3.StringBody;
import sttp.client3.StringBody$;
import sttp.client3.internal.SttpFile;
import sttp.client3.internal.package$;
import sttp.client3.pekkohttp.ToPekko$;
import sttp.client3.pekkohttp.Util$;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.Part;

public final class BodyToPekko$
implements Serializable {
    public static final BodyToPekko$ MODULE$ = new BodyToPekko$();

    private BodyToPekko$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BodyToPekko$.class);
    }

    public <R> Try<HttpRequest> apply(RequestT<Object, ?, R> r, RequestBody<R> body, HttpRequest ar) {
        return Util$.MODULE$.parseContentTypeOrOctetStream(r).flatMap((Function1 & Serializable)ct -> {
            RequestBody requestBody = body;
            if (NoBody$.MODULE$.equals(requestBody)) {
                return Success$.MODULE$.apply((Object)ar);
            }
            if (requestBody instanceof StringBody) {
                StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)requestBody);
                String string = stringBody._1();
                String string2 = stringBody._2();
                sttp.model.MediaType mediaType = stringBody._3();
                String b = string;
                String encoding = string2;
                return Success$.MODULE$.apply((Object)ar.withEntity((org.apache.pekko.http.javadsl.model.ContentType)this.ctWithCharset$1((ContentType)ct, encoding), b.getBytes(encoding)));
            }
            if (requestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)requestBody);
                byte[] byArray = byteArrayBody._1();
                sttp.model.MediaType mediaType = byteArrayBody._2();
                byte[] b = byArray;
                return Success$.MODULE$.apply((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, b)));
            }
            if (requestBody instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)requestBody);
                ByteBuffer byteBuffer = byteBufferBody._1();
                sttp.model.MediaType mediaType = byteBufferBody._2();
                ByteBuffer b = byteBuffer;
                return Success$.MODULE$.apply((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b))));
            }
            if (requestBody instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = InputStreamBody$.MODULE$.unapply((InputStreamBody)requestBody);
                InputStream inputStream = inputStreamBody._1();
                sttp.model.MediaType mediaType = inputStreamBody._2();
                InputStream b = inputStream;
                return Success$.MODULE$.apply((Object)ar.withEntity(this.streamEntity$1(r, (ContentType)ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> b, StreamConverters$.MODULE$.fromInputStream$default$2()))));
            }
            if (requestBody instanceof FileBody) {
                FileBody fileBody = FileBody$.MODULE$.unapply((FileBody)requestBody);
                SttpFile sttpFile = fileBody._1();
                sttp.model.MediaType mediaType = fileBody._2();
                SttpFile b = sttpFile;
                return Success$.MODULE$.apply((Object)ar.withEntity((org.apache.pekko.http.javadsl.model.ContentType)ct, b.toPath()));
            }
            if (requestBody instanceof StreamBody) {
                Object object;
                StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)requestBody);
                Object s = object = streamBody._1();
                return Success$.MODULE$.apply((Object)ar.withEntity(this.streamEntity$1(r, (ContentType)ct, (Source)s)));
            }
            if (requestBody instanceof MultipartBody) {
                MultipartBody m = (MultipartBody)requestBody;
                return Util$.MODULE$.traverseTry((Seq)m.parts().map((Function1 & Serializable)mp -> this.toBodyPart$1((Part)mp))).flatMap((Function1 & Serializable)bodyParts -> this.multipartEntity(r, (Seq<Multipart.FormData.BodyPart>)bodyParts).map((Function1 & Serializable)entity -> ar.withEntity(entity)));
            }
            throw new MatchError((Object)requestBody);
        });
    }

    private Try<RequestEntity> multipartEntity(RequestT<Object, ?, ?> r, Seq<Multipart.FormData.BodyPart> bodyParts) {
        Option option = r.headers().find((Function1 & Serializable)header -> Util$.MODULE$.isContentType((Header)header));
        if (None$.MODULE$.equals(option)) {
            return Success$.MODULE$.apply((Object)Multipart.FormData$.MODULE$.apply(bodyParts).toEntity());
        }
        if (option instanceof Some) {
            Header ct = (Header)((Some)option).value();
            return Util$.MODULE$.parseContentType(ct.value()).map((Function1 & Serializable)_$2 -> _$2.mediaType()).flatMap((Function1 & Serializable)x$1 -> {
                MediaType mediaType = x$1;
                if (mediaType instanceof MediaType.Multipart) {
                    MediaType.Multipart m = (MediaType.Multipart)mediaType;
                    return Success$.MODULE$.apply((Object)Multipart.General$.MODULE$.apply(m, Source$.MODULE$.apply((Iterable)bodyParts.map((Function1 & Serializable)bp -> Multipart.General$.BodyPart$.MODULE$.apply(bp.entity(), bp.headers())))).toEntity());
                }
                return Failure$.MODULE$.apply((Throwable)new RuntimeException(new StringBuilder(28).append("Non-multipart content type: ").append(ct).toString()));
            });
        }
        throw new MatchError((Object)option);
    }

    private final ContentType ctWithCharset$1$$anonfun$2(ContentType ct$2) {
        return ct$2;
    }

    private final ContentType ctWithCharset$1(ContentType ct, String charset) {
        return (ContentType)HttpCharsets$.MODULE$.getForKey((Object)charset).map((Function1 & Serializable)hc -> ContentType$.MODULE$.apply(ct.mediaType(), (Function0 & Serializable)() -> hc)).getOrElse(() -> this.ctWithCharset$1$$anonfun$2(ct));
    }

    private final long contentLength$1$$anonfun$2$$anonfun$1(Header h$1) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(h$1.value()));
    }

    private final Option contentLength$1(RequestT r$1) {
        return r$1.headers().find((Function1 & Serializable)_$1 -> _$1.is(HeaderNames$.MODULE$.ContentLength())).flatMap((Function1 & Serializable)h -> Try$.MODULE$.apply(() -> this.contentLength$1$$anonfun$2$$anonfun$1(h)).toOption());
    }

    private final BodyPartEntity streamPartEntity$1(Part mp$1, ContentType contentType, Source s) {
        Option option = mp$1.contentLength();
        if (None$.MODULE$.equals(option)) {
            return HttpEntity.IndefiniteLength$.MODULE$.apply(contentType, s);
        }
        if (option instanceof Some) {
            long l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return HttpEntity$.MODULE$.apply(contentType, l, s);
        }
        throw new MatchError((Object)option);
    }

    private final BodyPartEntity entity$1(Part mp$2, ContentType ct) {
        RequestBody requestBody = (RequestBody)mp$2.body();
        if (requestBody instanceof StringBody) {
            StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)requestBody);
            String string = stringBody._1();
            String string2 = stringBody._2();
            sttp.model.MediaType mediaType = stringBody._3();
            String b = string;
            String encoding = string2;
            return HttpEntity$.MODULE$.apply(this.ctWithCharset$1(ct, encoding), b.getBytes(encoding));
        }
        if (requestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)requestBody);
            byte[] byArray = byteArrayBody._1();
            sttp.model.MediaType mediaType = byteArrayBody._2();
            byte[] b = byArray;
            return HttpEntity$.MODULE$.apply(ct, b);
        }
        if (requestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)requestBody);
            ByteBuffer byteBuffer = byteBufferBody._1();
            sttp.model.MediaType mediaType = byteBufferBody._2();
            ByteBuffer b = byteBuffer;
            return HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b));
        }
        if (requestBody instanceof InputStreamBody) {
            InputStreamBody isb = (InputStreamBody)requestBody;
            return this.streamPartEntity$1(mp$2, ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> isb.b(), StreamConverters$.MODULE$.fromInputStream$default$2()));
        }
        if (requestBody instanceof FileBody) {
            FileBody fileBody = FileBody$.MODULE$.unapply((FileBody)requestBody);
            SttpFile sttpFile = fileBody._1();
            sttp.model.MediaType mediaType = fileBody._2();
            SttpFile b = sttpFile;
            return HttpEntity$.MODULE$.fromPath(ct, b.toPath(), HttpEntity$.MODULE$.fromPath$default$3());
        }
        if (requestBody instanceof StreamBody) {
            Object object;
            StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)requestBody);
            Object b = object = streamBody._1();
            return this.streamPartEntity$1(mp$2, ct, (Source)b);
        }
        if (requestBody instanceof MultipartBody) {
            MultipartBody multipartBody = MultipartBody$.MODULE$.unapply((MultipartBody)requestBody);
            Seq seq = multipartBody._1();
            throw package$.MODULE$.throwNestedMultipartNotAllowed();
        }
        if (NoBody$.MODULE$.equals(requestBody)) {
            return HttpEntity$.MODULE$.Empty();
        }
        throw new MatchError((Object)requestBody);
    }

    private final Try toBodyPart$1(Part mp) {
        return Util$.MODULE$.parseContentTypeOrOctetStream((Option<String>)mp.contentType()).flatMap((Function1 & Serializable)ct -> ToPekko$.MODULE$.headers((Seq<Header>)mp.headers().toList()).map((Function1 & Serializable)headers -> Multipart.FormData$.BodyPart$.MODULE$.apply(mp.name(), this.entity$1(mp, (ContentType)ct), mp.dispositionParams(), headers)));
    }

    private final RequestEntity streamEntity$1(RequestT r$4, ContentType contentType, Source s) {
        Option option = this.contentLength$1(r$4);
        if (None$.MODULE$.equals(option)) {
            return HttpEntity$.MODULE$.apply(contentType, s);
        }
        if (option instanceof Some) {
            long l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return HttpEntity$.MODULE$.apply(contentType, l, s);
        }
        throw new MatchError((Object)option);
    }
}

