/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.jox;

import com.softwaremill.jox.Channel;
import com.softwaremill.jox.ChannelClosed;
import com.softwaremill.jox.ChannelError;
import com.softwaremill.jox.DefaultClause;
import com.softwaremill.jox.RestartSelectMarker;
import com.softwaremill.jox.SelectClause;
import com.softwaremill.jox.SelectInstance;
import com.softwaremill.jox.TimeoutMarker;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class Select {
    @SafeVarargs
    public static <U> U select(SelectClause<? extends U> ... clauses) throws InterruptedException {
        Object r = Select.selectOrClosed(clauses);
        if (r instanceof ChannelClosed) {
            ChannelClosed c = (ChannelClosed)r;
            throw c.toException();
        }
        return (U)r;
    }

    @SafeVarargs
    public static <U> Object selectOrClosed(SelectClause<? extends U> ... clauses) throws InterruptedException {
        Object r;
        do {
            if (clauses == null || clauses.length == 0) {
                throw new IllegalArgumentException("No clauses given");
            }
            if (!Arrays.stream(clauses).anyMatch(Objects::isNull)) continue;
            throw new IllegalArgumentException("Null clauses are not supported");
        } while ((r = Select.doSelectOrClosed(clauses)) == RestartSelectMarker.RESTART);
        return r;
    }

    @SafeVarargs
    public static <U> U selectWithin(Duration timeout, SelectClause<? extends U> ... clauses) throws InterruptedException, TimeoutException {
        TimeoutMarker timeoutValue = TimeoutMarker.INSTANCE;
        Object result = Select.selectOrClosedWithin(timeout, timeoutValue, clauses);
        if (result == timeoutValue) {
            throw new TimeoutException("Select timed out after " + timeout.toMillis() + " ms");
        }
        if (result instanceof ChannelClosed) {
            ChannelClosed c = (ChannelClosed)result;
            throw c.toException();
        }
        return (U)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public static <U> Object selectOrClosedWithin(Duration timeout, U timeoutValue, SelectClause<? extends U> ... clauses) throws InterruptedException {
        if (timeout.isNegative() || timeout.isZero()) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        Channel<TimeoutMarker> timeoutChannel = Channel.newBufferedChannel(1);
        Thread timeoutThread = Thread.ofVirtual().start(() -> {
            try {
                Thread.sleep(timeout.toMillis());
                timeoutChannel.sendOrClosed(TimeoutMarker.INSTANCE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        SelectClause[] clausesWithTimeout = (SelectClause[])Arrays.copyOf(clauses, clauses.length + 1, SelectClause[].class);
        clausesWithTimeout[clauses.length] = timeoutChannel.receiveClause(marker -> timeoutValue);
        try {
            Object object = Select.selectOrClosed(clausesWithTimeout);
            return object;
        }
        finally {
            timeoutThread.interrupt();
            Select.joinUninterruptibly(timeoutThread);
        }
    }

    private static void joinUninterruptibly(Thread thread) throws InterruptedException {
        InterruptedException intercepted = null;
        while (true) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                if (intercepted == null) {
                    intercepted = e;
                    continue;
                }
                intercepted.addSuppressed(e);
                continue;
            }
            break;
        }
        if (intercepted != null) {
            throw intercepted;
        }
    }

    @SafeVarargs
    private static <U> Object doSelectOrClosed(SelectClause<? extends U> ... clauses) throws InterruptedException {
        ChannelError anyError = Select.getAnyChannelInError(clauses);
        if (anyError != null) {
            return anyError;
        }
        boolean allRendezvous = Select.verifyChannelsUnique_getAreAllRendezvous(clauses);
        SelectInstance si = new SelectInstance(clauses.length);
        for (int i = 0; i < clauses.length; ++i) {
            SelectClause<U> clause = clauses[i];
            if (clause instanceof DefaultClause && i != clauses.length - 1) {
                throw new IllegalArgumentException("The default clause can only be the last one.");
            }
            if (!si.register(clause)) break;
        }
        return si.checkStateAndWait(allRendezvous);
    }

    private static boolean verifyChannelsUnique_getAreAllRendezvous(SelectClause<?>[] clauses) {
        boolean allRendezvous = true;
        for (int i = 0; i < clauses.length; ++i) {
            Channel<?> chi = clauses[i].getChannel();
            for (int j = i + 1; j < clauses.length; ++j) {
                if (chi != clauses[j].getChannel()) continue;
                throw new IllegalArgumentException("Channel " + String.valueOf(chi) + " is used in multiple clauses");
            }
            allRendezvous = allRendezvous && (chi == null || chi.isRendezvous);
        }
        return allRendezvous;
    }

    private static ChannelError getAnyChannelInError(SelectClause<?>[] clauses) {
        for (SelectClause<?> clause : clauses) {
            ChannelClosed closedForSend;
            Channel<?> ch = clause.getChannel();
            if (ch == null || !((closedForSend = clause.getChannel().closedForSend()) instanceof ChannelError)) continue;
            ChannelError ce = (ChannelError)closedForSend;
            return ce;
        }
        return null;
    }

    public static <T> SelectClause<T> defaultClause(T value) {
        return Select.defaultClause(() -> value);
    }

    public static <T> SelectClause<T> defaultClause(Supplier<T> callback) {
        return new DefaultClause<T>(callback);
    }
}

