/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.jox;

import com.softwaremill.jox.CellState;
import com.softwaremill.jox.ChannelClosed;
import com.softwaremill.jox.ChannelClosedMarker;
import com.softwaremill.jox.ChannelDone;
import com.softwaremill.jox.ChannelError;
import com.softwaremill.jox.Continuation;
import com.softwaremill.jox.ExpandBufferResult;
import com.softwaremill.jox.ReceiveResult;
import com.softwaremill.jox.Segment;
import com.softwaremill.jox.SelectClause;
import com.softwaremill.jox.SelectInstance;
import com.softwaremill.jox.SendResult;
import com.softwaremill.jox.SentClauseMarker;
import com.softwaremill.jox.Sink;
import com.softwaremill.jox.Source;
import com.softwaremill.jox.StoredSelectClause;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class Channel<T>
implements Source<T>,
Sink<T> {
    private final int capacity;
    final boolean isRendezvous;
    private final boolean isUnlimited;
    private volatile long sendersAndClosedFlag = 0L;
    private volatile long receivers = 0L;
    private volatile long bufferEnd;
    private volatile Segment sendSegment;
    private volatile Segment receiveSegment;
    private volatile Segment bufferEndSegment;
    private volatile ChannelClosed closedReason;
    private static final VarHandle SENDERS_AND_CLOSE_FLAG;
    private static final VarHandle RECEIVERS;
    private static final VarHandle BUFFER_END;
    private static final VarHandle SEND_SEGMENT;
    private static final VarHandle RECEIVE_SEGMENT;
    private static final VarHandle BUFFER_END_SEGMENT;
    private static final VarHandle CLOSED_REASON;
    private static final int UNLIMITED_CAPACITY = -1;
    private static final Function<Object, Object> IDENTITY;
    private static final int SENDERS_AND_CLOSED_FLAG_SHIFT = 60;
    private static final long SENDERS_COUNTER_MASK = 0xFFFFFFFFFFFFFFFL;

    public Channel() {
        this(0);
    }

    public Channel(int capacity) {
        Segment firstSegment;
        if (capacity < -1) {
            throw new IllegalArgumentException("Capacity must be 0 (rendezvous), positive (buffered) or -1 (unlimited channels).");
        }
        this.capacity = capacity;
        this.isRendezvous = (long)capacity == 0L;
        this.isUnlimited = capacity == -1;
        boolean isRendezvousOrUnlimited = this.isRendezvous || this.isUnlimited;
        this.sendSegment = firstSegment = new Segment(0L, null, isRendezvousOrUnlimited ? 2 : 3, isRendezvousOrUnlimited);
        this.receiveSegment = firstSegment;
        this.bufferEndSegment = isRendezvousOrUnlimited ? Segment.NULL_SEGMENT : firstSegment;
        this.processInitialBuffer();
        this.bufferEnd = capacity;
    }

    private void processInitialBuffer() {
        Segment currentSegment = this.bufferEndSegment;
        int segmentsToProcess = (int)Math.ceil((double)this.capacity / 32.0);
        for (int segmentId = 0; segmentId < segmentsToProcess; ++segmentId) {
            int cellsToProcess;
            currentSegment = Segment.findAndMoveForward(BUFFER_END_SEGMENT, this, currentSegment, segmentId);
            int n = cellsToProcess = segmentId == segmentsToProcess - 1 ? this.capacity % 32 : 32;
            if (cellsToProcess == 0) {
                cellsToProcess = 32;
            }
            currentSegment.setup_markCellsProcessed(cellsToProcess);
        }
    }

    public static <T> Channel<T> newUnlimitedChannel() {
        return new Channel<T>(-1);
    }

    @Override
    public void send(T value) throws InterruptedException {
        Object r = this.sendOrClosed(value);
        if (r instanceof ChannelClosed) {
            ChannelClosed c = (ChannelClosed)r;
            throw c.toException();
        }
    }

    @Override
    public Object sendOrClosed(T value) throws InterruptedException {
        return this.doSend(value, null, null);
    }

    private Object doSend(T value, SelectInstance select, SelectClause<?> selectClause) throws InterruptedException {
        Object sendResult;
        if (value == null) {
            throw new NullPointerException();
        }
        while (true) {
            Segment segment = this.sendSegment;
            long scf = SENDERS_AND_CLOSE_FLAG.getAndAdd(this, 1L);
            long s = Channel.getSendersCounter(scf);
            long id = s / 32L;
            int i = (int)(s % 32L);
            if (segment.getId() != id) {
                if ((segment = Segment.findAndMoveForward(SEND_SEGMENT, this, segment, id)) == null) {
                    return this.closedReason;
                }
                if (segment.getId() != id) {
                    SENDERS_AND_CLOSE_FLAG.compareAndSet(this, s, segment.getId() * 32L);
                    continue;
                }
            }
            if (Channel.isClosed(scf)) {
                return this.closedReason;
            }
            sendResult = this.updateCellSend(segment, i, s, value, select, selectClause);
            if (sendResult == SendResult.BUFFERED) {
                return null;
            }
            if (sendResult == SendResult.AWAITED) {
                return null;
            }
            if (sendResult == SendResult.RESUMED) {
                segment.cleanPrev();
                return null;
            }
            if (sendResult instanceof StoredSelectClause) {
                StoredSelectClause ss = (StoredSelectClause)sendResult;
                return ss;
            }
            if (sendResult != SendResult.FAILED) break;
            segment.cleanPrev();
        }
        if (sendResult == SendResult.CLOSED) {
            return this.closedReason;
        }
        throw new IllegalStateException("Unexpected result: " + String.valueOf(sendResult) + " in channel: " + String.valueOf(this));
    }

    private Object updateCellSend(Segment segment, int i, long s, T value, SelectInstance select, SelectClause<?> selectClause) throws InterruptedException {
        Object state;
        block11: {
            while (true) {
                if ((state = segment.getCell(i)) == null) {
                    if (!this.isUnlimited && s >= (this.isRendezvous ? 0L : this.bufferEnd) && s >= this.receivers) {
                        if (select != null) {
                            StoredSelectClause storedSelect = new StoredSelectClause(select, segment, i, true, selectClause, value);
                            if (!segment.casCell(i, state, storedSelect)) continue;
                            return storedSelect;
                        }
                        Continuation c = new Continuation(value);
                        if (!segment.casCell(i, null, c)) continue;
                        if (c.await(segment, i, this.isRendezvous) == ChannelClosedMarker.CLOSED) {
                            return SendResult.CLOSED;
                        }
                        return SendResult.AWAITED;
                    }
                    if (!segment.casCell(i, null, value)) continue;
                    return SendResult.BUFFERED;
                }
                if (state != CellState.IN_BUFFER) break block11;
                if (segment.casCell(i, (Object)CellState.IN_BUFFER, value)) break;
            }
            return SendResult.BUFFERED;
        }
        if (state instanceof Continuation) {
            Continuation c = (Continuation)state;
            if (c.tryResume(value)) {
                segment.setCell(i, (Object)CellState.DONE);
                return SendResult.RESUMED;
            }
            return SendResult.FAILED;
        }
        if (state instanceof StoredSelectClause) {
            StoredSelectClause ss = (StoredSelectClause)state;
            ss.setPayload(value);
            if (ss.getSelect().trySelect(ss)) {
                segment.setCell(i, (Object)CellState.DONE);
                return SendResult.RESUMED;
            }
            return SendResult.FAILED;
        }
        if (state == CellState.INTERRUPTED_RECEIVE || state == CellState.BROKEN) {
            return SendResult.FAILED;
        }
        if (state == CellState.CLOSED) {
            return SendResult.CLOSED;
        }
        throw new IllegalStateException("Unexpected state: " + String.valueOf(state) + " in channel: " + String.valueOf(this));
    }

    @Override
    public T receive() throws InterruptedException {
        Object r = this.receiveOrClosed();
        if (r instanceof ChannelClosed) {
            ChannelClosed c = (ChannelClosed)r;
            throw c.toException();
        }
        return (T)r;
    }

    @Override
    public Object receiveOrClosed() throws InterruptedException {
        return this.doReceive(null, null);
    }

    private Object doReceive(SelectInstance select, SelectClause<?> selectClause) throws InterruptedException {
        Object result;
        while (true) {
            Segment segment = this.receiveSegment;
            long r = RECEIVERS.getAndAdd(this, 1L);
            long id = r / 32L;
            int i = (int)(r % 32L);
            if (segment.getId() != id) {
                if ((segment = Segment.findAndMoveForward(RECEIVE_SEGMENT, this, segment, id)) == null) {
                    return this.closedReason;
                }
                if (segment.getId() != id) {
                    RECEIVERS.compareAndSet(this, r, segment.getId() * 32L);
                    continue;
                }
            }
            if ((result = this.updateCellReceive(segment, i, r, select, selectClause)) == ReceiveResult.CLOSED) {
                return this.closedReason;
            }
            if (!(result instanceof StoredSelectClause)) {
                segment.cleanPrev();
            }
            if (result != ReceiveResult.FAILED) break;
        }
        return result;
    }

    private Object updateCellReceive(Segment segment, int i, long r, SelectInstance select, SelectClause<?> selectClause) throws InterruptedException {
        Object state;
        block11: {
            while (true) {
                if ((state = segment.getCell(i)) == null || state == CellState.IN_BUFFER) {
                    if (r >= Channel.getSendersCounter(this.sendersAndClosedFlag)) {
                        if (select != null) {
                            StoredSelectClause storedSelect = new StoredSelectClause(select, segment, i, false, selectClause, null);
                            if (!segment.casCell(i, state, storedSelect)) continue;
                            this.expandBuffer();
                            return storedSelect;
                        }
                        Continuation c = new Continuation(null);
                        if (!segment.casCell(i, state, c)) continue;
                        this.expandBuffer();
                        Object result = c.await(segment, i, this.isRendezvous);
                        if (result == ChannelClosedMarker.CLOSED) {
                            return ReceiveResult.CLOSED;
                        }
                        return result;
                    }
                    if (!segment.casCell(i, state, (Object)CellState.BROKEN)) continue;
                    this.expandBuffer();
                    return ReceiveResult.FAILED;
                }
                if (state instanceof Continuation) {
                    Continuation c = (Continuation)state;
                    if (!segment.casCell(i, state, (Object)CellState.RESUMING)) continue;
                    if (c.tryResume(0)) {
                        segment.setCell(i, (Object)CellState.DONE);
                        this.expandBuffer();
                        return c.getPayload();
                    }
                    return ReceiveResult.FAILED;
                }
                if (state instanceof StoredSelectClause) {
                    StoredSelectClause ss = (StoredSelectClause)state;
                    if (!segment.casCell(i, state, (Object)CellState.RESUMING)) continue;
                    if (ss.getSelect().trySelect(ss)) {
                        segment.setCell(i, (Object)CellState.DONE);
                        this.expandBuffer();
                        return ss.getPayload();
                    }
                    return ReceiveResult.FAILED;
                }
                if (!(state instanceof CellState)) break block11;
                if (state == CellState.INTERRUPTED_SEND) {
                    return ReceiveResult.FAILED;
                }
                if (state != CellState.RESUMING) break;
                Thread.onSpinWait();
            }
            if (state == CellState.CLOSED) {
                return ReceiveResult.CLOSED;
            }
            throw new IllegalStateException("Unexpected state: " + String.valueOf(state) + " in channel: " + String.valueOf(this));
        }
        segment.setCell(i, (Object)CellState.DONE);
        this.expandBuffer();
        return state;
    }

    private void expandBuffer() {
        if (this.isRendezvous || this.isUnlimited) {
            return;
        }
        while (true) {
            ExpandBufferResult result;
            Segment segment = this.bufferEndSegment;
            long b = BUFFER_END.getAndAdd(this, 1L);
            long id = b / 32L;
            int i = (int)(b % 32L);
            if (segment.getId() != id) {
                if ((segment = Segment.findAndMoveForward(BUFFER_END_SEGMENT, this, segment, id)) == null) {
                    return;
                }
                if (segment.getId() != id) {
                    BUFFER_END.compareAndSet(this, b, segment.getId() * 32L);
                    continue;
                }
            }
            if ((result = this.updateCellExpandBuffer(segment, i)) == ExpandBufferResult.DONE) {
                segment.cellProcessed_notInterruptedSender();
                return;
            }
            if (result != ExpandBufferResult.CLOSED) continue;
            segment.cellProcessed_notInterruptedSender();
        }
    }

    private ExpandBufferResult updateCellExpandBuffer(Segment segment, int i) {
        block13: {
            Object state;
            while (true) {
                StoredSelectClause ss;
                Continuation c;
                if ((state = segment.getCell(i)) == null) {
                    if (!segment.casCell(i, null, (Object)CellState.IN_BUFFER)) continue;
                    return ExpandBufferResult.DONE;
                }
                if (state == CellState.DONE) {
                    return ExpandBufferResult.DONE;
                }
                if (state instanceof Continuation && (c = (Continuation)state).isSender()) {
                    if (!segment.casCell(i, state, (Object)CellState.RESUMING)) continue;
                    if (c.tryResume(0)) {
                        segment.setCell(i, c.getPayload());
                        return ExpandBufferResult.DONE;
                    }
                    return ExpandBufferResult.FAILED;
                }
                if (state instanceof Continuation) {
                    return ExpandBufferResult.DONE;
                }
                if (state instanceof StoredSelectClause && (ss = (StoredSelectClause)state).isSender()) {
                    if (!segment.casCell(i, state, (Object)CellState.RESUMING)) continue;
                    if (ss.getSelect().trySelect(ss)) {
                        segment.setCell(i, ss.getPayload());
                        return ExpandBufferResult.DONE;
                    }
                    return ExpandBufferResult.FAILED;
                }
                if (state instanceof StoredSelectClause) {
                    return ExpandBufferResult.DONE;
                }
                if (!(state instanceof CellState)) break block13;
                if (state == CellState.INTERRUPTED_SEND) {
                    return ExpandBufferResult.FAILED;
                }
                if (state == CellState.INTERRUPTED_RECEIVE) {
                    return ExpandBufferResult.DONE;
                }
                if (state == CellState.BROKEN) {
                    return ExpandBufferResult.DONE;
                }
                if (state != CellState.RESUMING) break;
                Thread.onSpinWait();
            }
            if (state == CellState.CLOSED) {
                return ExpandBufferResult.CLOSED;
            }
            throw new IllegalStateException("Unexpected state: " + String.valueOf(state) + " in channel: " + String.valueOf(this));
        }
        return ExpandBufferResult.DONE;
    }

    @Override
    public void done() {
        Object r = this.doneOrClosed();
        if (r instanceof ChannelClosed) {
            ChannelClosed c = (ChannelClosed)r;
            throw c.toException();
        }
    }

    @Override
    public Object doneOrClosed() {
        return this.closeOrClosed(new ChannelDone());
    }

    @Override
    public void error(Throwable reason) {
        if (reason == null) {
            throw new NullPointerException("Error reason cannot be null");
        }
        Object r = this.errorOrClosed(reason);
        if (r instanceof ChannelClosed) {
            ChannelClosed c = (ChannelClosed)r;
            throw c.toException();
        }
    }

    @Override
    public Object errorOrClosed(Throwable reason) {
        return this.closeOrClosed(new ChannelError(reason));
    }

    private Object closeOrClosed(ChannelClosed channelClosed) {
        long scf;
        long initialScf;
        if (!CLOSED_REASON.compareAndSet(this, null, channelClosed)) {
            return this.closedReason;
        }
        boolean scfUpdated = false;
        while (!(scfUpdated = SENDERS_AND_CLOSE_FLAG.compareAndSet(this, initialScf = this.sendersAndClosedFlag, scf = Channel.setClosedFlag(initialScf)))) {
        }
        long lastSender = Channel.getSendersCounter(scf);
        Segment lastSegment = this.sendSegment.close();
        if (channelClosed instanceof ChannelError) {
            this.closeCellsUntil(0L, lastSegment);
        } else {
            this.closeCellsUntil(lastSender, lastSegment);
        }
        if (this.capacity > 0) {
            long lastGlobalIndex = (lastSegment.getId() + 1L) * 32L - 1L;
            while (this.bufferEnd <= lastGlobalIndex) {
                this.expandBuffer();
            }
        }
        return null;
    }

    private void closeCellsUntil(long lastCellToClose, Segment segment) {
        int lastIndexToCloseInSegment;
        if (segment == null) {
            return;
        }
        long lastCellToCloseSegmentId = lastCellToClose / 32L;
        if (lastCellToCloseSegmentId == segment.getId()) {
            lastIndexToCloseInSegment = (int)(lastCellToClose % 32L);
        } else if (lastCellToCloseSegmentId < segment.getId()) {
            lastIndexToCloseInSegment = 0;
        } else {
            return;
        }
        for (int i = 31; i >= lastIndexToCloseInSegment; --i) {
            this.updateCellClose(segment, i);
        }
        this.closeCellsUntil(lastCellToClose, segment.getPrev());
    }

    private void updateCellClose(Segment segment, int i) {
        while (true) {
            Object state;
            if ((state = segment.getCell(i)) == null || state == CellState.IN_BUFFER) {
                if (!segment.casCell(i, state, (Object)CellState.CLOSED)) continue;
                segment.cellInterruptedReceiver();
                return;
            }
            if (state instanceof Continuation) {
                Continuation c = (Continuation)state;
                if (c.tryResume((Object)ChannelClosedMarker.CLOSED)) {
                    segment.setCell(i, (Object)CellState.CLOSED);
                    segment.cellInterruptedReceiver();
                    return;
                }
                Thread.onSpinWait();
                continue;
            }
            if (state instanceof StoredSelectClause) {
                StoredSelectClause ss = (StoredSelectClause)state;
                if (ss.getSelect().channelClosed(this.closedReason)) {
                    return;
                }
                Thread.onSpinWait();
                continue;
            }
            if (state instanceof CellState) {
                if (state == CellState.DONE || state == CellState.BROKEN) {
                    return;
                }
                if (state == CellState.INTERRUPTED_RECEIVE || state == CellState.INTERRUPTED_SEND) {
                    return;
                }
                if (state == CellState.RESUMING) {
                    Thread.onSpinWait();
                    continue;
                }
                throw new IllegalStateException("Unexpected state: " + String.valueOf(state) + " in channel: " + String.valueOf(this));
            }
            if (segment.casCell(i, state, (Object)CellState.CLOSED)) break;
        }
        segment.cellInterruptedReceiver();
    }

    @Override
    public ChannelClosed closedForSend() {
        return Channel.isClosed(this.sendersAndClosedFlag) ? this.closedReason : null;
    }

    @Override
    public ChannelClosed closedForReceive() {
        if (Channel.isClosed(this.sendersAndClosedFlag)) {
            ChannelClosed cr = this.closedReason;
            if (cr instanceof ChannelError) {
                return cr;
            }
            return this.hasValuesToReceive() ? null : cr;
        }
        return null;
    }

    private boolean hasValuesToReceive() {
        while (true) {
            Segment segment = this.receiveSegment;
            long r = this.receivers;
            long s = Channel.getSendersCounter(this.sendersAndClosedFlag);
            if (s <= r) {
                return false;
            }
            long id = r / 32L;
            int i = (int)(r % 32L);
            if (segment.getId() != id) {
                if ((segment = Segment.findAndMoveForward(RECEIVE_SEGMENT, this, segment, id)) == null) {
                    return false;
                }
                if (segment.getId() != id) {
                    RECEIVERS.compareAndSet(this, r, segment.getId() * 32L);
                    continue;
                }
            }
            segment.cleanPrev();
            if (this.hasValueToReceive(segment, i)) {
                return true;
            }
            RECEIVERS.compareAndSet(this, r, r + 1L);
        }
    }

    private boolean hasValueToReceive(Segment segment, int i) {
        block7: {
            Object state;
            while (true) {
                if ((state = segment.getCell(i)) == null || state == CellState.IN_BUFFER) {
                    Thread.onSpinWait();
                    continue;
                }
                if (state instanceof Continuation) {
                    Continuation c = (Continuation)state;
                    return c.isSender();
                }
                if (state instanceof StoredSelectClause) {
                    StoredSelectClause ss = (StoredSelectClause)state;
                    return ss.isSender();
                }
                if (!(state instanceof CellState)) break block7;
                if (state == CellState.INTERRUPTED_SEND || state == CellState.INTERRUPTED_RECEIVE) {
                    return false;
                }
                if (state != CellState.RESUMING) break;
                Thread.onSpinWait();
            }
            if (state == CellState.CLOSED) {
                return false;
            }
            if (state == CellState.DONE || state == CellState.BROKEN) {
                return false;
            }
            throw new IllegalStateException("Unexpected state: " + String.valueOf(state) + " in channel: " + String.valueOf(this));
        }
        return true;
    }

    @Override
    public SelectClause<T> receiveClause() {
        return this.receiveClause(IDENTITY);
    }

    @Override
    public <U> SelectClause<U> receiveClause(final Function<T, U> callback) {
        return new SelectClause<U>(){

            @Override
            Channel<?> getChannel() {
                return Channel.this;
            }

            @Override
            Object register(SelectInstance select) {
                try {
                    return Channel.this.doReceive(select, this);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            U transformedRawValue(Object rawValue) {
                return callback.apply(rawValue);
            }
        };
    }

    @Override
    public SelectClause<Void> sendClause(T value) {
        return this.sendClause(value, () -> null);
    }

    @Override
    public <U> SelectClause<U> sendClause(final T value, final Supplier<U> callback) {
        return new SelectClause<U>(){

            @Override
            Channel<?> getChannel() {
                return Channel.this;
            }

            @Override
            Object register(SelectInstance select) {
                try {
                    Object result = Channel.this.doSend(value, select, this);
                    return result == null ? SentClauseMarker.SENT : result;
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            U transformedRawValue(Object rawValue) {
                return callback.get();
            }
        };
    }

    void cleanupStoredSelectClause(Segment segment, int i, boolean isSender) {
        segment.setCell(i, (Object)(isSender ? CellState.INTERRUPTED_SEND : CellState.INTERRUPTED_RECEIVE));
        if (isSender) {
            segment.cellInterruptedSender();
        } else {
            segment.cellInterruptedReceiver();
        }
    }

    private static long getSendersCounter(long sendersAndClosedFlag) {
        return sendersAndClosedFlag & 0xFFFFFFFFFFFFFFFL;
    }

    private static boolean isClosed(long sendersAndClosedFlag) {
        return sendersAndClosedFlag >> 60 == 1L;
    }

    private static long setClosedFlag(long sendersAndClosedFlag) {
        return sendersAndClosedFlag | 0x1000000000000000L;
    }

    public String toString() {
        Segment smallestSegment = Stream.of(this.sendSegment, this.receiveSegment, this.bufferEndSegment).filter(s -> s != Segment.NULL_SEGMENT).min(Comparator.comparingLong(Segment::getId)).get();
        long scf = this.sendersAndClosedFlag;
        long sendersCounter = Channel.getSendersCounter(scf);
        boolean isClosed = Channel.isClosed(scf);
        StringBuilder sb = new StringBuilder();
        sb.append("Channel(capacity=").append(this.capacity).append(", closed=").append(isClosed).append(", sendSegment=").append(this.sendSegment.getId()).append(", sendCounter=").append(sendersCounter).append(", receiveSegment=").append(this.receiveSegment.getId()).append(", receiveCounter=").append(this.receivers).append(", bufferEndSegment=").append(this.bufferEndSegment.getId()).append(", bufferEndCounter=").append(this.bufferEnd).append("): \n");
        Segment s2 = smallestSegment;
        while (s2 != null) {
            sb.append("  ").append(s2).append(": ");
            for (int i = 0; i < 32; ++i) {
                StoredSelectClause ss;
                Continuation c;
                Object state = s2.getCell(i);
                if (state == null) {
                    sb.append("E");
                } else if (state == CellState.IN_BUFFER) {
                    sb.append("IB");
                } else if (state == CellState.DONE) {
                    sb.append("D");
                } else if (state == CellState.INTERRUPTED_SEND) {
                    sb.append("IS");
                } else if (state == CellState.INTERRUPTED_RECEIVE) {
                    sb.append("IR");
                } else if (state == CellState.BROKEN) {
                    sb.append("B");
                } else if (state == CellState.RESUMING) {
                    sb.append("R");
                } else if (state == CellState.CLOSED) {
                    sb.append("C");
                } else if (state instanceof Continuation && (c = (Continuation)state).isSender()) {
                    sb.append("WS(").append(c.getPayload()).append(")");
                } else if (state instanceof Continuation) {
                    sb.append("WR");
                } else if (state instanceof StoredSelectClause && (ss = (StoredSelectClause)state).isSender()) {
                    sb.append("SS");
                } else if (state instanceof StoredSelectClause) {
                    sb.append("SR");
                } else {
                    sb.append("V(").append(state).append(")");
                }
                if (i == 31) continue;
                sb.append(",");
            }
            if ((s2 = s2.getNext()) == null) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.privateLookupIn(Channel.class, MethodHandles.lookup());
            SENDERS_AND_CLOSE_FLAG = l.findVarHandle(Channel.class, "sendersAndClosedFlag", Long.TYPE);
            RECEIVERS = l.findVarHandle(Channel.class, "receivers", Long.TYPE);
            BUFFER_END = l.findVarHandle(Channel.class, "bufferEnd", Long.TYPE);
            SEND_SEGMENT = l.findVarHandle(Channel.class, "sendSegment", Segment.class);
            RECEIVE_SEGMENT = l.findVarHandle(Channel.class, "receiveSegment", Segment.class);
            BUFFER_END_SEGMENT = l.findVarHandle(Channel.class, "bufferEndSegment", Segment.class);
            CLOSED_REASON = l.findVarHandle(Channel.class, "closedReason", ChannelClosed.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        IDENTITY = Function.identity();
    }
}

