/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.requests.searches;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.sksamuel.elastic4s.HitReader;
import com.sksamuel.elastic4s.json.SourceAsContentBuilder$;
import com.sksamuel.elastic4s.json.XContentBuilder;
import com.sksamuel.elastic4s.requests.common.Shards;
import com.sksamuel.elastic4s.requests.common.Shards$;
import com.sksamuel.elastic4s.requests.searches.SearchHits;
import com.sksamuel.elastic4s.requests.searches.SearchResponse$;
import com.sksamuel.elastic4s.requests.searches.aggs.responses.Aggregations;
import com.sksamuel.elastic4s.requests.searches.aggs.responses.Aggregations$;
import com.sksamuel.elastic4s.requests.searches.suggestion.CompletionSuggestionResult;
import com.sksamuel.elastic4s.requests.searches.suggestion.PhraseSuggestionResult;
import com.sksamuel.elastic4s.requests.searches.suggestion.SuggestionResult;
import com.sksamuel.elastic4s.requests.searches.suggestion.TermSuggestionResult;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try;

public class SearchResponse
implements Product,
Serializable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(SearchResponse.class.getDeclaredField("aggregationsAsString$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SearchResponse.class.getDeclaredField("aggsAsContentBuilder$lzy1"));
    private final long took;
    private final boolean isTimedOut;
    private final boolean isTerminatedEarly;
    private final Map suggest;
    private final Shards _shards;
    private final Option scrollId;
    private final Map _aggregationsAsMap;
    private final SearchHits hits;
    private volatile Object aggsAsContentBuilder$lzy1;
    private volatile Object aggregationsAsString$lzy1;

    public static SearchResponse apply(long l, boolean bl, boolean bl2, Map<String, Seq<SuggestionResult>> map, Shards shards, Option<String> option, Map<String, Object> map2, SearchHits searchHits) {
        return SearchResponse$.MODULE$.apply(l, bl, bl2, map, shards, option, map2, searchHits);
    }

    public static SearchResponse fromProduct(Product product) {
        return SearchResponse$.MODULE$.fromProduct(product);
    }

    public static SearchResponse unapply(SearchResponse searchResponse) {
        return SearchResponse$.MODULE$.unapply(searchResponse);
    }

    public SearchResponse(long took, @JsonProperty(value="timed_out") boolean isTimedOut, @JsonProperty(value="terminated_early") boolean isTerminatedEarly, Map<String, Seq<SuggestionResult>> suggest, @JsonProperty(value="_shards") Shards _shards, @JsonProperty(value="_scroll_id") Option<String> scrollId, @JsonProperty(value="aggregations") Map<String, Object> _aggregationsAsMap, SearchHits hits) {
        this.took = took;
        this.isTimedOut = isTimedOut;
        this.isTerminatedEarly = isTerminatedEarly;
        this.suggest = suggest;
        this._shards = _shards;
        this.scrollId = scrollId;
        this._aggregationsAsMap = _aggregationsAsMap;
        this.hits = hits;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.took()));
        n = Statics.mix((int)n, (int)(this.isTimedOut() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.isTerminatedEarly() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.suggest()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this._shards()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.scrollId()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this._aggregationsAsMap()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.hits()));
        return Statics.finalizeHash((int)n, (int)8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SearchResponse)) return false;
        SearchResponse searchResponse = (SearchResponse)object;
        if (this.took() != searchResponse.took()) return false;
        if (this.isTimedOut() != searchResponse.isTimedOut()) return false;
        if (this.isTerminatedEarly() != searchResponse.isTerminatedEarly()) return false;
        Map<String, Seq<SuggestionResult>> map = this.suggest();
        Map<String, Seq<SuggestionResult>> map2 = searchResponse.suggest();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Shards shards = this._shards();
        Shards shards2 = searchResponse._shards();
        if (shards == null) {
            if (shards2 != null) {
                return false;
            }
        } else if (!((Object)shards).equals(shards2)) return false;
        Option<String> option = this.scrollId();
        Option<String> option2 = searchResponse.scrollId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Map<String, Object> map3 = this._aggregationsAsMap();
        Map<String, Object> map4 = searchResponse._aggregationsAsMap();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        SearchHits searchHits = this.hits();
        SearchHits searchHits2 = searchResponse.hits();
        if (searchHits == null) {
            if (searchHits2 != null) {
                return false;
            }
        } else if (!((Object)searchHits).equals(searchHits2)) return false;
        if (!searchResponse.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof SearchResponse;
    }

    public int productArity() {
        return 8;
    }

    public String productPrefix() {
        return "SearchResponse";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this._3());
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "took";
            }
            case 1: {
                return "isTimedOut";
            }
            case 2: {
                return "isTerminatedEarly";
            }
            case 3: {
                return "suggest";
            }
            case 4: {
                return "_shards";
            }
            case 5: {
                return "scrollId";
            }
            case 6: {
                return "_aggregationsAsMap";
            }
            case 7: {
                return "hits";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public long took() {
        return this.took;
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }

    public boolean isTerminatedEarly() {
        return this.isTerminatedEarly;
    }

    private Map<String, Seq<SuggestionResult>> suggest() {
        return this.suggest;
    }

    private Shards _shards() {
        return this._shards;
    }

    public Option<String> scrollId() {
        return this.scrollId;
    }

    private Map<String, Object> _aggregationsAsMap() {
        return this._aggregationsAsMap;
    }

    public SearchHits hits() {
        return this.hits;
    }

    public Map<String, Object> aggregationsAsMap() {
        return (Map)Option$.MODULE$.apply(this._aggregationsAsMap()).getOrElse(SearchResponse::aggregationsAsMap$$anonfun$1);
    }

    public long totalHits() {
        return this.hits().total().value();
    }

    public long size() {
        return this.hits().size();
    }

    public Seq<String> ids() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.hits().hits());
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.id(), ClassTag$.MODULE$.apply(String.class)));
    }

    public double maxScore() {
        return this.hits().maxScore();
    }

    public Shards shards() {
        return (Shards)Option$.MODULE$.apply((Object)this._shards()).getOrElse(SearchResponse::shards$$anonfun$1);
    }

    public boolean isEmpty() {
        return this.hits().isEmpty();
    }

    public boolean nonEmpty() {
        return this.hits().nonEmpty();
    }

    public XContentBuilder aggsAsContentBuilder() {
        Object object = this.aggsAsContentBuilder$lzy1;
        if (object instanceof XContentBuilder) {
            return (XContentBuilder)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (XContentBuilder)this.aggsAsContentBuilder$lzyINIT1();
    }

    private Object aggsAsContentBuilder$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.aggsAsContentBuilder$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    XContentBuilder xContentBuilder = null;
                    try {
                        xContentBuilder = SourceAsContentBuilder$.MODULE$.apply(this.aggregationsAsMap());
                        object2 = xContentBuilder == null ? LazyVals.NullValue$.MODULE$ : xContentBuilder;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.aggsAsContentBuilder$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return xContentBuilder;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String aggregationsAsString() {
        Object object = this.aggregationsAsString$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.aggregationsAsString$lzyINIT1();
    }

    private Object aggregationsAsString$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.aggregationsAsString$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = this.aggsAsContentBuilder().string();
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.aggregationsAsString$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Aggregations aggs() {
        return this.aggregations();
    }

    public Aggregations aggregations() {
        return Aggregations$.MODULE$.apply(this.aggregationsAsMap());
    }

    public Map<String, Seq<SuggestionResult>> suggestions() {
        return (Map)Option$.MODULE$.apply(this.suggest()).getOrElse(SearchResponse::suggestions$$anonfun$1);
    }

    private Map<String, SuggestionResult> suggestion(String name) {
        return ((IterableOnceOps)((IterableOps)this.suggestions().getOrElse((Object)name, SearchResponse::suggestion$$anonfun$1)).map((Function1 & Serializable)result -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)result.text());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, result);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, TermSuggestionResult> termSuggestion(String name) {
        return this.suggestion(name).mapValues((Function1 & Serializable)_$2 -> _$2.toTerm()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, CompletionSuggestionResult> completionSuggestion(String name) {
        return this.suggestion(name).mapValues((Function1 & Serializable)_$3 -> _$3.toCompletion()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, PhraseSuggestionResult> phraseSuggestion(String name) {
        return this.suggestion(name).mapValues((Function1 & Serializable)_$4 -> _$4.toPhrase()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <T> IndexedSeq<T> to(HitReader<T> evidence$1, ClassTag<T> evidence$2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.hits().hits());
        Object object2 = Predef$.MODULE$.genericArrayOps(ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$5 -> _$5.to(evidence$1), evidence$2));
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object2);
    }

    public <T> IndexedSeq<Try<T>> safeTo(HitReader<T> evidence$3) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.hits().hits());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$6 -> _$6.safeTo(evidence$3), ClassTag$.MODULE$.apply(Try.class)));
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object2);
    }

    public SearchResponse copy(long took, boolean isTimedOut, boolean isTerminatedEarly, Map<String, Seq<SuggestionResult>> suggest, Shards _shards, Option<String> scrollId, Map<String, Object> _aggregationsAsMap, SearchHits hits) {
        return new SearchResponse(took, isTimedOut, isTerminatedEarly, suggest, _shards, scrollId, _aggregationsAsMap, hits);
    }

    public long copy$default$1() {
        return this.took();
    }

    public boolean copy$default$2() {
        return this.isTimedOut();
    }

    public boolean copy$default$3() {
        return this.isTerminatedEarly();
    }

    public Map<String, Seq<SuggestionResult>> copy$default$4() {
        return this.suggest();
    }

    public Shards copy$default$5() {
        return this._shards();
    }

    public Option<String> copy$default$6() {
        return this.scrollId();
    }

    public Map<String, Object> copy$default$7() {
        return this._aggregationsAsMap();
    }

    public SearchHits copy$default$8() {
        return this.hits();
    }

    public long _1() {
        return this.took();
    }

    public boolean _2() {
        return this.isTimedOut();
    }

    public boolean _3() {
        return this.isTerminatedEarly();
    }

    public Map<String, Seq<SuggestionResult>> _4() {
        return this.suggest();
    }

    public Shards _5() {
        return this._shards();
    }

    public Option<String> _6() {
        return this.scrollId();
    }

    public Map<String, Object> _7() {
        return this._aggregationsAsMap();
    }

    public SearchHits _8() {
        return this.hits();
    }

    private static final Map aggregationsAsMap$$anonfun$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final Shards shards$$anonfun$1() {
        return Shards$.MODULE$.apply(-1, -1, -1);
    }

    private static final Map suggestions$$anonfun$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final Seq suggestion$$anonfun$1() {
        return package$.MODULE$.Nil();
    }
}

