/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.requests.analyzers;

import com.sksamuel.elastic4s.ext.OptionImplicits$;
import com.sksamuel.elastic4s.json.XContentBuilder;
import com.sksamuel.elastic4s.requests.analyzers.AnalyzerFilterDefinition;
import com.sksamuel.elastic4s.requests.analyzers.CompoundWordTokenFilter$;
import com.sksamuel.elastic4s.requests.analyzers.CompoundWordTokenFilterType;
import com.sksamuel.elastic4s.requests.analyzers.TokenFilterDefinition;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class CompoundWordTokenFilter
implements AnalyzerFilterDefinition,
TokenFilterDefinition,
Product,
Serializable {
    private final String name;
    private final CompoundWordTokenFilterType type;
    private final Iterable wordList;
    private final Option wordListPath;
    private final Option hyphenationPatternsPath;
    private final Option minWordSize;
    private final Option minSubwordSize;
    private final Option maxSubwordSize;
    private final Option onlyLongestMatch;
    private final String filterType;

    public static CompoundWordTokenFilter apply(String string, CompoundWordTokenFilterType compoundWordTokenFilterType, Iterable<String> iterable, Option<String> option, Option<String> option2, Option<Object> option3, Option<Object> option4, Option<Object> option5, Option<Object> option6) {
        return CompoundWordTokenFilter$.MODULE$.apply(string, compoundWordTokenFilterType, iterable, option, option2, option3, option4, option5, option6);
    }

    public static CompoundWordTokenFilter fromProduct(Product product) {
        return CompoundWordTokenFilter$.MODULE$.fromProduct(product);
    }

    public static CompoundWordTokenFilter unapply(CompoundWordTokenFilter compoundWordTokenFilter) {
        return CompoundWordTokenFilter$.MODULE$.unapply(compoundWordTokenFilter);
    }

    public static Iterable<String> $lessinit$greater$default$3() {
        return CompoundWordTokenFilter$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return CompoundWordTokenFilter$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$5() {
        return CompoundWordTokenFilter$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Object> $lessinit$greater$default$6() {
        return CompoundWordTokenFilter$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Object> $lessinit$greater$default$7() {
        return CompoundWordTokenFilter$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Object> $lessinit$greater$default$8() {
        return CompoundWordTokenFilter$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Object> $lessinit$greater$default$9() {
        return CompoundWordTokenFilter$.MODULE$.$lessinit$greater$default$9();
    }

    public CompoundWordTokenFilter(String name, CompoundWordTokenFilterType type, Iterable<String> wordList, Option<String> wordListPath, Option<String> hyphenationPatternsPath, Option<Object> minWordSize, Option<Object> minSubwordSize, Option<Object> maxSubwordSize, Option<Object> onlyLongestMatch) {
        this.name = name;
        this.type = type;
        this.wordList = wordList;
        this.wordListPath = wordListPath;
        this.hyphenationPatternsPath = hyphenationPatternsPath;
        this.minWordSize = minWordSize;
        this.minSubwordSize = minSubwordSize;
        this.maxSubwordSize = maxSubwordSize;
        this.onlyLongestMatch = onlyLongestMatch;
        this.filterType = type.name();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CompoundWordTokenFilter)) return false;
        CompoundWordTokenFilter compoundWordTokenFilter = (CompoundWordTokenFilter)object;
        String string = this.name();
        String string2 = compoundWordTokenFilter.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        CompoundWordTokenFilterType compoundWordTokenFilterType = this.type();
        CompoundWordTokenFilterType compoundWordTokenFilterType2 = compoundWordTokenFilter.type();
        if (compoundWordTokenFilterType == null) {
            if (compoundWordTokenFilterType2 != null) {
                return false;
            }
        } else if (!compoundWordTokenFilterType.equals(compoundWordTokenFilterType2)) return false;
        Iterable<String> iterable = this.wordList();
        Iterable<String> iterable2 = compoundWordTokenFilter.wordList();
        if (iterable == null) {
            if (iterable2 != null) {
                return false;
            }
        } else if (!iterable.equals(iterable2)) return false;
        Option<String> option = this.wordListPath();
        Option<String> option2 = compoundWordTokenFilter.wordListPath();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.hyphenationPatternsPath();
        Option<String> option4 = compoundWordTokenFilter.hyphenationPatternsPath();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Object> option5 = this.minWordSize();
        Option<Object> option6 = compoundWordTokenFilter.minWordSize();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<Object> option7 = this.minSubwordSize();
        Option<Object> option8 = compoundWordTokenFilter.minSubwordSize();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        Option<Object> option9 = this.maxSubwordSize();
        Option<Object> option10 = compoundWordTokenFilter.maxSubwordSize();
        if (option9 == null) {
            if (option10 != null) {
                return false;
            }
        } else if (!option9.equals(option10)) return false;
        Option<Object> option11 = this.onlyLongestMatch();
        Option<Object> option12 = compoundWordTokenFilter.onlyLongestMatch();
        if (option11 == null) {
            if (option12 != null) {
                return false;
            }
        } else if (!option11.equals(option12)) return false;
        if (!compoundWordTokenFilter.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CompoundWordTokenFilter;
    }

    public int productArity() {
        return 9;
    }

    public String productPrefix() {
        return "CompoundWordTokenFilter";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "name";
            }
            case 1: {
                return "type";
            }
            case 2: {
                return "wordList";
            }
            case 3: {
                return "wordListPath";
            }
            case 4: {
                return "hyphenationPatternsPath";
            }
            case 5: {
                return "minWordSize";
            }
            case 6: {
                return "minSubwordSize";
            }
            case 7: {
                return "maxSubwordSize";
            }
            case 8: {
                return "onlyLongestMatch";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public String name() {
        return this.name;
    }

    public CompoundWordTokenFilterType type() {
        return this.type;
    }

    public Iterable<String> wordList() {
        return this.wordList;
    }

    public Option<String> wordListPath() {
        return this.wordListPath;
    }

    public Option<String> hyphenationPatternsPath() {
        return this.hyphenationPatternsPath;
    }

    public Option<Object> minWordSize() {
        return this.minWordSize;
    }

    public Option<Object> minSubwordSize() {
        return this.minSubwordSize;
    }

    public Option<Object> maxSubwordSize() {
        return this.maxSubwordSize;
    }

    public Option<Object> onlyLongestMatch() {
        return this.onlyLongestMatch;
    }

    @Override
    public String filterType() {
        return this.filterType;
    }

    @Override
    public void build(XContentBuilder source) {
        if (this.wordList().nonEmpty()) {
            source.array("word_list", (String[])this.wordList().toArray(ClassTag$.MODULE$.apply(String.class)));
        }
        this.wordListPath().foreach((Function1 & Serializable)_$47 -> source.field("word_list_path", _$47));
        this.hyphenationPatternsPath().foreach((Function1 & Serializable)_$48 -> source.field("hyphenation_patterns_path", _$48));
        this.minWordSize().foreach((Function1 & Serializable)_$49 -> source.field("min_word_size", BoxesRunTime.unboxToInt((Object)_$49)));
        this.minSubwordSize().foreach((Function1 & Serializable)_$50 -> source.field("min_subword_size", BoxesRunTime.unboxToInt((Object)_$50)));
        this.maxSubwordSize().foreach((Function1 & Serializable)_$51 -> source.field("max_subword_size", BoxesRunTime.unboxToInt((Object)_$51)));
        this.onlyLongestMatch().foreach((Function1 & Serializable)_$52 -> source.field("only_longest_match", BoxesRunTime.unboxToBoolean((Object)_$52)));
    }

    public CompoundWordTokenFilter wordList(Iterable<String> wordList) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), wordList, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9());
    }

    public CompoundWordTokenFilter wordList(String word, Seq<String> rest) {
        Seq seq = (Seq)rest.$plus$colon((Object)word);
        String string = this.copy$default$1();
        CompoundWordTokenFilterType compoundWordTokenFilterType = this.copy$default$2();
        Option<String> option = this.copy$default$4();
        Option<String> option2 = this.copy$default$5();
        Option<Object> option3 = this.copy$default$6();
        Option<Object> option4 = this.copy$default$7();
        Option<Object> option5 = this.copy$default$8();
        Option<Object> option6 = this.copy$default$9();
        return this.copy(string, compoundWordTokenFilterType, (Iterable<String>)seq, option, option2, option3, option4, option5, option6);
    }

    public CompoundWordTokenFilter wordListPath(String wordListPath) {
        Option<String> option = OptionImplicits$.MODULE$.RichStringOptionImplicits(wordListPath).some();
        String string = this.copy$default$1();
        CompoundWordTokenFilterType compoundWordTokenFilterType = this.copy$default$2();
        Iterable<String> iterable = this.copy$default$3();
        Option<String> option2 = this.copy$default$5();
        Option<Object> option3 = this.copy$default$6();
        Option<Object> option4 = this.copy$default$7();
        Option<Object> option5 = this.copy$default$8();
        Option<Object> option6 = this.copy$default$9();
        return this.copy(string, compoundWordTokenFilterType, iterable, option, option2, option3, option4, option5, option6);
    }

    public CompoundWordTokenFilter hyphenationPatternsPath(String hyphenationPatternsPath) {
        Option<String> option = OptionImplicits$.MODULE$.RichStringOptionImplicits(hyphenationPatternsPath).some();
        String string = this.copy$default$1();
        CompoundWordTokenFilterType compoundWordTokenFilterType = this.copy$default$2();
        Iterable<String> iterable = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<Object> option3 = this.copy$default$6();
        Option<Object> option4 = this.copy$default$7();
        Option<Object> option5 = this.copy$default$8();
        Option<Object> option6 = this.copy$default$9();
        return this.copy(string, compoundWordTokenFilterType, iterable, option2, option, option3, option4, option5, option6);
    }

    public CompoundWordTokenFilter minWordSize(int minWordSize) {
        Option<Integer> option = OptionImplicits$.MODULE$.RichOptionImplicits(BoxesRunTime.boxToInteger((int)minWordSize)).some();
        String string = this.copy$default$1();
        CompoundWordTokenFilterType compoundWordTokenFilterType = this.copy$default$2();
        Iterable<String> iterable = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        Option<Object> option4 = this.copy$default$7();
        Option<Object> option5 = this.copy$default$8();
        Option<Object> option6 = this.copy$default$9();
        return this.copy(string, compoundWordTokenFilterType, iterable, option2, option3, option, option4, option5, option6);
    }

    public CompoundWordTokenFilter minSubwordSize(int minSubwordSize) {
        Option<Integer> option = OptionImplicits$.MODULE$.RichOptionImplicits(BoxesRunTime.boxToInteger((int)minSubwordSize)).some();
        String string = this.copy$default$1();
        CompoundWordTokenFilterType compoundWordTokenFilterType = this.copy$default$2();
        Iterable<String> iterable = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        Option<Object> option4 = this.copy$default$6();
        Option<Object> option5 = this.copy$default$8();
        Option<Object> option6 = this.copy$default$9();
        return this.copy(string, compoundWordTokenFilterType, iterable, option2, option3, option4, option, option5, option6);
    }

    public CompoundWordTokenFilter maxSubwordSize(int maxSubwordSize) {
        Option<Integer> option = OptionImplicits$.MODULE$.RichOptionImplicits(BoxesRunTime.boxToInteger((int)maxSubwordSize)).some();
        String string = this.copy$default$1();
        CompoundWordTokenFilterType compoundWordTokenFilterType = this.copy$default$2();
        Iterable<String> iterable = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        Option<Object> option4 = this.copy$default$6();
        Option<Object> option5 = this.copy$default$7();
        Option<Object> option6 = this.copy$default$9();
        return this.copy(string, compoundWordTokenFilterType, iterable, option2, option3, option4, option5, option, option6);
    }

    public CompoundWordTokenFilter onlyLongestMatch(boolean onlyLongestMatch) {
        Option<Boolean> option = OptionImplicits$.MODULE$.RichOptionImplicits(BoxesRunTime.boxToBoolean((boolean)onlyLongestMatch)).some();
        String string = this.copy$default$1();
        CompoundWordTokenFilterType compoundWordTokenFilterType = this.copy$default$2();
        Iterable<String> iterable = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        Option<Object> option4 = this.copy$default$6();
        Option<Object> option5 = this.copy$default$7();
        Option<Object> option6 = this.copy$default$8();
        return this.copy(string, compoundWordTokenFilterType, iterable, option2, option3, option4, option5, option6, option);
    }

    public CompoundWordTokenFilter copy(String name, CompoundWordTokenFilterType type, Iterable<String> wordList, Option<String> wordListPath, Option<String> hyphenationPatternsPath, Option<Object> minWordSize, Option<Object> minSubwordSize, Option<Object> maxSubwordSize, Option<Object> onlyLongestMatch) {
        return new CompoundWordTokenFilter(name, type, wordList, wordListPath, hyphenationPatternsPath, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    public String copy$default$1() {
        return this.name();
    }

    public CompoundWordTokenFilterType copy$default$2() {
        return this.type();
    }

    public Iterable<String> copy$default$3() {
        return this.wordList();
    }

    public Option<String> copy$default$4() {
        return this.wordListPath();
    }

    public Option<String> copy$default$5() {
        return this.hyphenationPatternsPath();
    }

    public Option<Object> copy$default$6() {
        return this.minWordSize();
    }

    public Option<Object> copy$default$7() {
        return this.minSubwordSize();
    }

    public Option<Object> copy$default$8() {
        return this.maxSubwordSize();
    }

    public Option<Object> copy$default$9() {
        return this.onlyLongestMatch();
    }

    public String _1() {
        return this.name();
    }

    public CompoundWordTokenFilterType _2() {
        return this.type();
    }

    public Iterable<String> _3() {
        return this.wordList();
    }

    public Option<String> _4() {
        return this.wordListPath();
    }

    public Option<String> _5() {
        return this.hyphenationPatternsPath();
    }

    public Option<Object> _6() {
        return this.minWordSize();
    }

    public Option<Object> _7() {
        return this.minSubwordSize();
    }

    public Option<Object> _8() {
        return this.maxSubwordSize();
    }

    public Option<Object> _9() {
        return this.onlyLongestMatch();
    }
}

