/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.sksamuel.elastic4s.aws.Aws4RequestSigner$;
import com.sksamuel.elastic4s.aws.CanonicalRequest;
import com.sksamuel.elastic4s.aws.CanonicalRequest$;
import com.sksamuel.elastic4s.aws.Crypto$;
import com.sksamuel.elastic4s.aws.StringToSign;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001-\u0011\u0011#Q<tiI+\u0017/^3tiNKwM\\3s\u0015\t\u0019A!A\u0002boNT!!\u0002\u0004\u0002\u0013\u0015d\u0017m\u001d;jGR\u001a(BA\u0004\t\u0003!\u00198n]1nk\u0016d'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u0003!\u0001(o\u001c<jI\u0016\u0014\bCA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\u0011\tW\u000f\u001e5\u000b\u0005eA\u0011!C1nCj|g.Y<t\u0013\tYbC\u0001\fB/N\u001b%/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3s\u0011!i\u0002A!A!\u0002\u0013q\u0012A\u0002:fO&|g\u000e\u0005\u0002 M9\u0011\u0001\u0005\n\t\u0003C9i\u0011A\t\u0006\u0003G)\ta\u0001\u0010:p_Rt\u0014BA\u0013\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0005\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015r\u0001\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u000fM,'O^5dK\")A\u0006\u0001C\u0001[\u00051A(\u001b8jiz\"BA\f\u00192eA\u0011q\u0006A\u0007\u0002\u0005!)1c\u000ba\u0001)!)Qd\u000ba\u0001=!9!f\u000bI\u0001\u0002\u0004q\u0002b\u0002\u001b\u0001\u0005\u0004%\t!N\u0001\u000bI\u0006$X\rS3bI\u0016\u0014X#\u0001\u001c\u0011\u0005]bT\"\u0001\u001d\u000b\u0005eR\u0014\u0001\u00027b]\u001eT\u0011aO\u0001\u0005U\u00064\u0018-\u0003\u0002(q!1a\b\u0001Q\u0001\nY\n1\u0002Z1uK\"+\u0017\rZ3sA!9\u0001\t\u0001b\u0001\n\u0003)\u0014AC1vi\"DU-\u00193fe\"1!\t\u0001Q\u0001\nY\n1\"Y;uQ\"+\u0017\rZ3sA!9A\t\u0001b\u0001\n\u0003)\u0014aE:fGV\u0014\u0018\u000e^=U_.,g\u000eS3bI\u0016\u0014\bB\u0002$\u0001A\u0003%a'\u0001\u000btK\u000e,(/\u001b;z)>\\WM\u001c%fC\u0012,'\u000f\t\u0005\u0006\u0011\u0002!\t!S\u0001\u0010o&$\b.Q<ti!+\u0017\rZ3sgR\u0011!\n\u0016\t\u0003\u0017Jk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bA\u0001\u001b;ua*\u0011q\nU\u0001\u0007CB\f7\r[3\u000b\u0003E\u000b1a\u001c:h\u0013\t\u0019FJA\u0006IiR\u0004(+Z9vKN$\b\"B+H\u0001\u0004Q\u0015a\u0002:fcV,7\u000f\u001e\u0005\u0006/\u0002!\t\u0002W\u0001\u0015EVLG\u000e\u001a#bi\u0016\fe\u000e\u001a#bi\u0016$\u0016.\\3\u0015\u0003e\u0003B!\u0004.\u001f=%\u00111L\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u000bu\u0003A\u0011\u00020\u00023\t,\u0018\u000e\u001c3BkRDWM\u001c;jG\u0006$\u0018n\u001c8IK\u0006$WM\u001d\u000b\u0005=}#\u0017\u000eC\u0003a9\u0002\u0007\u0011-\u0001\tdC:|g.[2bYJ+\u0017/^3tiB\u0011qFY\u0005\u0003G\n\u0011\u0001cQ1o_:L7-\u00197SKF,Xm\u001d;\t\u000b\u0015d\u0006\u0019\u00014\u0002\u0019M$(/\u001b8h)>\u001c\u0016n\u001a8\u0011\u0005=:\u0017B\u00015\u0003\u00051\u0019FO]5oOR{7+[4o\u0011\u0015QG\f1\u0001l\u0003-\u0019'/\u001a3f]RL\u0017\r\\:\u0011\u0005Ua\u0017BA7\u0017\u00059\tukU\"sK\u0012,g\u000e^5bYNDQa\u001c\u0001\u0005\nA\faBY;jY\u0012\u001c\u0016n\u001a8biV\u0014X\rF\u00027cJDQ!\u001a8A\u0002\u0019DQA\u001b8A\u0002-DQ\u0001\u001e\u0001\u0005\nU\faBY;jY\u0012\\U-\u001f+p'&<g\u000eF\u0002wyz\u00042!D<z\u0013\tAhBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u000eu&\u00111P\u0004\u0002\u0005\u0005f$X\rC\u0003~g\u0002\u0007a$A\u0004eCR,7\u000b\u001e:\t\u000b)\u001c\b\u0019A6\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004\u0005i1/\u001a;I_N$\b*Z1eKJ,\"!!\u0002\u0011\u000b5\t9A\u0013&\n\u0007\u0005%aBA\u0005Gk:\u001cG/[8oc!9\u0011Q\u0002\u0001\u0005\n\u0005=\u0011!C:fi\"+\u0017\rZ3s)\u0019\t\t\"!\u0006\u0002\u001aQ\u0019!*a\u0005\t\rU\u000bY\u00011\u0001K\u0011\u001d\t9\"a\u0003A\u0002y\t\u0011\u0001\u001b\u0005\t\u00037\tY\u00011\u0001\u0002\u001e\u0005\ta\r\u0005\u0004\u000e\u0003\u000f\tyB\b\t\u0004\u0017\u0006\u0005\u0012bAA\u0012\u0019\n1\u0001*Z1eKJ<\u0011\"a\n\u0003\u0003\u0003E\t!!\u000b\u0002#\u0005;8\u000f\u000e*fcV,7\u000f^*jO:,'\u000fE\u00020\u0003W1\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QF\n\u0004\u0003Wa\u0001b\u0002\u0017\u0002,\u0011\u0005\u0011\u0011\u0007\u000b\u0003\u0003SA!\"!\u000e\u0002,E\u0005I\u0011AA\u001c\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\b\u0016\u0004=\u0005m2FAA\u001f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dc\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0013\u0002B\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class Aws4RequestSigner {
    private final AWSCredentialsProvider provider;
    private final String region;
    private final String service;
    private final String dateHeader;
    private final String authHeader;
    private final String securityTokenHeader;

    public static String $lessinit$greater$default$3() {
        return Aws4RequestSigner$.MODULE$.$lessinit$greater$default$3();
    }

    public String dateHeader() {
        return this.dateHeader;
    }

    public String authHeader() {
        return this.authHeader;
    }

    public String securityTokenHeader() {
        return this.securityTokenHeader;
    }

    public HttpRequest withAws4Headers(HttpRequest request) {
        AWSCredentials credentials = this.provider.getCredentials();
        Tuple2<String, String> tuple2 = this.buildDateAndDateTime();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String date = (String)tuple2._1();
        String dateTime = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)date, (Object)dateTime);
        Tuple2 tuple23 = tuple22;
        String date2 = (String)tuple23._1();
        String dateTime2 = (String)tuple23._2();
        this.setHostHeader().apply((Object)request);
        request.setHeader(this.dateHeader(), dateTime2);
        CanonicalRequest canonicalRequest = CanonicalRequest$.MODULE$.apply(request);
        StringToSign stringToSign = new StringToSign(this.service, this.region, canonicalRequest, date2, dateTime2);
        String authHeaderValue = this.buildAuthenticationHeader(canonicalRequest, stringToSign, credentials);
        request.addHeader(this.authHeader(), authHeaderValue);
        AWSCredentials aWSCredentials = credentials;
        if (aWSCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials aWSSessionCredentials = (AWSSessionCredentials)aWSCredentials;
            request.addHeader(this.securityTokenHeader(), aWSSessionCredentials.getSessionToken());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return request;
    }

    public Tuple2<String, String> buildDateAndDateTime() {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        String dateTime = now.format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'"));
        String date = now.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        return new Tuple2((Object)date, (Object)dateTime);
    }

    private String buildAuthenticationHeader(CanonicalRequest canonicalRequest, StringToSign stringToSign, AWSCredentials credentials) {
        String credentialStr = new StringBuilder(12).append("Credential=").append(credentials.getAWSAccessKeyId()).append("/").append(stringToSign.credentialsScope()).toString();
        String signedHeadersStr = new StringBuilder(14).append("SignedHeaders=").append(canonicalRequest.signedHeaders()).toString();
        String signatureStr = new StringBuilder(10).append("Signature=").append(this.buildSignature(stringToSign, credentials)).toString();
        return new StringBuilder(5).append(Crypto$.MODULE$.Algorithm()).append(" ").append(credentialStr).append(", ").append(signedHeadersStr).append(", ").append(signatureStr).toString();
    }

    private String buildSignature(StringToSign stringToSign, AWSCredentials credentials) {
        byte[] signatureKey = this.buildKeyToSign(stringToSign.date(), credentials);
        byte[] signature = Crypto$.MODULE$.sign(stringToSign.toString(), signatureKey);
        return Crypto$.MODULE$.hexOf(signature).toLowerCase();
    }

    private byte[] buildKeyToSign(String dateStr, AWSCredentials credentials) {
        byte[] kSecret = new StringBuilder(4).append("AWS4").append(credentials.getAWSSecretKey()).toString().getBytes("utf-8");
        byte[] dateKey = Crypto$.MODULE$.sign(dateStr, kSecret);
        byte[] regionKey = Crypto$.MODULE$.sign(this.region, dateKey);
        byte[] serviceKey = Crypto$.MODULE$.sign(this.service, regionKey);
        return Crypto$.MODULE$.sign("aws4_request", serviceKey);
    }

    private Function1<HttpRequest, HttpRequest> setHostHeader() {
        Function1 & Serializable & scala.Serializable found = (Function1 & Serializable & scala.Serializable)header -> header.getValue().replaceFirst(":[0-9]+", "");
        return (Function1 & Serializable & scala.Serializable)request -> this.setHeader("Host", (Function1<Header, String>)found, (HttpRequest)request);
    }

    private HttpRequest setHeader(String h, Function1<Header, String> f, HttpRequest request) {
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])request.getAllHeaders())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Aws4RequestSigner.$anonfun$setHeader$1(h, x$2)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Header header = (Header)some.value();
            request.setHeader(h, (String)f.apply((Object)header));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return request;
    }

    public static final /* synthetic */ boolean $anonfun$setHeader$1(String h$1, Header x$2) {
        String string = x$2.getName();
        String string2 = h$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public Aws4RequestSigner(AWSCredentialsProvider provider, String region, String service) {
        this.provider = provider;
        this.region = region;
        this.service = service;
        Predef$.MODULE$.require(provider.getCredentials() != null, (Function0 & Serializable & scala.Serializable)() -> "AWS Credentials are mandatory. AWSCredentialsProvider provided none.");
        this.dateHeader = "X-Amz-Date";
        this.authHeader = "Authorization";
        this.securityTokenHeader = "X-Amz-Security-Token";
    }
}

