/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.internal;

import fs2.io.internal.Synchronizer;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public final class PipedStreamBuffer {
    public final int fs2$io$internal$PipedStreamBuffer$$capacity;
    public final byte[] fs2$io$internal$PipedStreamBuffer$$buffer;
    public int fs2$io$internal$PipedStreamBuffer$$head;
    public int fs2$io$internal$PipedStreamBuffer$$tail;
    public boolean fs2$io$internal$PipedStreamBuffer$$closed;
    public final Synchronizer fs2$io$internal$PipedStreamBuffer$$readerPermit;
    public final Synchronizer fs2$io$internal$PipedStreamBuffer$$writerPermit;
    private final InputStream inputStream;
    private final OutputStream outputStream;

    public PipedStreamBuffer(int capacity) {
        this.fs2$io$internal$PipedStreamBuffer$$capacity = capacity;
        this.fs2$io$internal$PipedStreamBuffer$$buffer = new byte[capacity];
        this.fs2$io$internal$PipedStreamBuffer$$head = 0;
        this.fs2$io$internal$PipedStreamBuffer$$tail = 0;
        this.fs2$io$internal$PipedStreamBuffer$$closed = false;
        this.fs2$io$internal$PipedStreamBuffer$$readerPermit = new Synchronizer();
        this.fs2$io$internal$PipedStreamBuffer$$writerPermit = new Synchronizer();
        this.inputStream = new InputStream(this){
            private final /* synthetic */ PipedStreamBuffer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int read() {
                try {
                    this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.acquire();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                while (true) {
                    block11: {
                        PipedStreamBuffer pipedStreamBuffer = this.$outer;
                        synchronized (pipedStreamBuffer) {
                            int n;
                            block10: {
                                if (this.$outer.fs2$io$internal$PipedStreamBuffer$$head != this.$outer.fs2$io$internal$PipedStreamBuffer$$tail) {
                                    int n2 = this.$outer.fs2$io$internal$PipedStreamBuffer$$buffer[Integer.remainderUnsigned(this.$outer.fs2$io$internal$PipedStreamBuffer$$head, this.$outer.fs2$io$internal$PipedStreamBuffer$$capacity)] & 0xFF;
                                    ++this.$outer.fs2$io$internal$PipedStreamBuffer$$head;
                                    this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.release();
                                    this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.release();
                                    n = n2;
                                    break block10;
                                }
                                if (this.$outer.fs2$io$internal$PipedStreamBuffer$$closed) {
                                    this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.release();
                                    n = -1;
                                    break block10;
                                }
                                break block11;
                            }
                            return n;
                        }
                    }
                    try {
                        this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                }
                return -1;
            }

            public int read(byte[] b, int off, int len) {
                if (b == null) {
                    throw new NullPointerException("Cannot read into a null byte array");
                }
                if (off < 0) {
                    throw new IndexOutOfBoundsException(new StringBuilder(37).append("Negative offset into the byte array: ").append(off).toString());
                }
                if (len < 0) {
                    throw new IndexOutOfBoundsException(new StringBuilder(32).append("Negative read length specified: ").append(len).toString());
                }
                if (len > b.length - off) {
                    throw new IndexOutOfBoundsException(new StringBuilder(109).append("Specified length is greater than the remaining length of the byte array after the offset: len = ").append(len).append(", capacity = ").append(b.length - off).toString());
                }
                try {
                    this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.acquire();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                int offset = off;
                int length = len;
                boolean success = false;
                int res = 0;
                boolean cont = true;
                while (cont) {
                    PipedStreamBuffer pipedStreamBuffer = this.$outer;
                    synchronized (pipedStreamBuffer) {
                        BoxedUnit boxedUnit;
                        if (this.$outer.fs2$io$internal$PipedStreamBuffer$$head != this.$outer.fs2$io$internal$PipedStreamBuffer$$tail) {
                            int available = this.$outer.fs2$io$internal$PipedStreamBuffer$$tail - this.$outer.fs2$io$internal$PipedStreamBuffer$$head;
                            int toRead = package$.MODULE$.min(available, length);
                            this.circularRead(this.$outer.fs2$io$internal$PipedStreamBuffer$$buffer, this.$outer.fs2$io$internal$PipedStreamBuffer$$head, this.$outer.fs2$io$internal$PipedStreamBuffer$$capacity, b, offset, toRead);
                            this.$outer.fs2$io$internal$PipedStreamBuffer$$head += toRead;
                            offset += toRead;
                            res += toRead;
                            success = true;
                            this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.release();
                            if ((length -= toRead) == 0) {
                                this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.release();
                                cont = false;
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else if (this.$outer.fs2$io$internal$PipedStreamBuffer$$closed) {
                            this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.release();
                            cont = false;
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    if (this.$outer.fs2$io$internal$PipedStreamBuffer$$closed || !cont) continue;
                    try {
                        this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                }
                if (success) {
                    return res;
                }
                return -1;
            }

            public void close() {
                PipedStreamBuffer pipedStreamBuffer = this.$outer;
                synchronized (pipedStreamBuffer) {
                    BoxedUnit boxedUnit;
                    if (!this.$outer.fs2$io$internal$PipedStreamBuffer$$closed) {
                        this.$outer.fs2$io$internal$PipedStreamBuffer$$closed = true;
                        this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.release();
                        this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.release();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public int available() {
                int n;
                PipedStreamBuffer pipedStreamBuffer = this.$outer;
                synchronized (pipedStreamBuffer) {
                    n = this.$outer.fs2$io$internal$PipedStreamBuffer$$closed ? 0 : this.$outer.fs2$io$internal$PipedStreamBuffer$$tail - this.$outer.fs2$io$internal$PipedStreamBuffer$$head;
                }
                return n;
            }

            private void circularRead(byte[] src, int srcPos, int srcCap, byte[] dst, int dstPos, int length) {
                int srcOffset = Integer.remainderUnsigned(srcPos, srcCap);
                if (srcOffset + length >= srcCap) {
                    int batch1 = srcCap - srcOffset;
                    int batch2 = length - batch1;
                    System.arraycopy(src, srcOffset, dst, dstPos, batch1);
                    System.arraycopy(src, 0, dst, dstPos + batch1, batch2);
                    return;
                }
                System.arraycopy(src, srcOffset, dst, dstPos, length);
            }
        };
        this.outputStream = new OutputStream(this){
            private final /* synthetic */ PipedStreamBuffer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void write(int b) {
                try {
                    this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.acquire();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                while (true) {
                    block11: {
                        PipedStreamBuffer pipedStreamBuffer = this.$outer;
                        synchronized (pipedStreamBuffer) {
                            block10: {
                                if (this.$outer.fs2$io$internal$PipedStreamBuffer$$tail - this.$outer.fs2$io$internal$PipedStreamBuffer$$head < this.$outer.fs2$io$internal$PipedStreamBuffer$$capacity) {
                                    this.$outer.fs2$io$internal$PipedStreamBuffer$$buffer[Integer.remainderUnsigned((int)this.$outer.fs2$io$internal$PipedStreamBuffer$$tail, (int)this.$outer.fs2$io$internal$PipedStreamBuffer$$capacity)] = (byte)(b & 0xFF);
                                    ++this.$outer.fs2$io$internal$PipedStreamBuffer$$tail;
                                    this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.release();
                                    this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.release();
                                    break block10;
                                }
                                if (this.$outer.fs2$io$internal$PipedStreamBuffer$$closed) {
                                    this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.release();
                                    break block10;
                                }
                                break block11;
                            }
                            return;
                        }
                    }
                    try {
                        this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                }
            }

            public void write(byte[] b, int off, int len) {
                if (b == null) {
                    throw new NullPointerException("Cannot read into a null byte array");
                }
                if (off < 0) {
                    throw new IndexOutOfBoundsException(new StringBuilder(37).append("Negative offset into the byte array: ").append(off).toString());
                }
                if (len < 0) {
                    throw new IndexOutOfBoundsException(new StringBuilder(33).append("Negative write length specified: ").append(len).toString());
                }
                if (len > b.length - off) {
                    throw new IndexOutOfBoundsException(new StringBuilder(109).append("Specified length is greater than the remaining length of the byte array after the offset: len = ").append(len).append(", capacity = ").append(b.length - off).toString());
                }
                try {
                    this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.acquire();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                int offset = off;
                int length = len;
                while (true) {
                    block17: {
                        PipedStreamBuffer pipedStreamBuffer = this.$outer;
                        synchronized (pipedStreamBuffer) {
                            block16: {
                                BoxedUnit boxedUnit;
                                if (this.$outer.fs2$io$internal$PipedStreamBuffer$$tail - this.$outer.fs2$io$internal$PipedStreamBuffer$$head < this.$outer.fs2$io$internal$PipedStreamBuffer$$capacity) {
                                    int available = this.$outer.fs2$io$internal$PipedStreamBuffer$$capacity - (this.$outer.fs2$io$internal$PipedStreamBuffer$$tail - this.$outer.fs2$io$internal$PipedStreamBuffer$$head);
                                    int toWrite = package$.MODULE$.min(available, length);
                                    this.circularWrite(b, offset, this.$outer.fs2$io$internal$PipedStreamBuffer$$buffer, this.$outer.fs2$io$internal$PipedStreamBuffer$$tail, this.$outer.fs2$io$internal$PipedStreamBuffer$$capacity, toWrite);
                                    this.$outer.fs2$io$internal$PipedStreamBuffer$$tail += toWrite;
                                    offset += toWrite;
                                    this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.release();
                                    if ((length -= toWrite) == 0) {
                                        this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.release();
                                        break block16;
                                    }
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    if (this.$outer.fs2$io$internal$PipedStreamBuffer$$closed) {
                                        this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.release();
                                        break block16;
                                    }
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                break block17;
                            }
                            return;
                        }
                    }
                    if (this.$outer.fs2$io$internal$PipedStreamBuffer$$closed) continue;
                    try {
                        this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                }
            }

            public void close() {
                PipedStreamBuffer pipedStreamBuffer = this.$outer;
                synchronized (pipedStreamBuffer) {
                    BoxedUnit boxedUnit;
                    if (!this.$outer.fs2$io$internal$PipedStreamBuffer$$closed) {
                        this.$outer.fs2$io$internal$PipedStreamBuffer$$closed = true;
                        this.$outer.fs2$io$internal$PipedStreamBuffer$$writerPermit.release();
                        this.$outer.fs2$io$internal$PipedStreamBuffer$$readerPermit.release();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            private void circularWrite(byte[] src, int srcPos, byte[] dst, int dstPos, int dstCap, int length) {
                int dstOffset = Integer.remainderUnsigned(dstPos, dstCap);
                if (dstOffset + length >= dstCap) {
                    int batch1 = dstCap - dstOffset;
                    int batch2 = length - batch1;
                    System.arraycopy(src, srcPos, dst, dstOffset, batch1);
                    System.arraycopy(src, srcPos + batch1, dst, 0, batch2);
                    return;
                }
                System.arraycopy(src, srcPos, dst, dstOffset, length);
            }
        };
    }

    public InputStream inputStream() {
        return this.inputStream;
    }

    public OutputStream outputStream() {
        return this.outputStream;
    }
}

