/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tls;

import cats.Applicative;
import cats.Applicative$;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.effect.concurrent.Semaphore;
import cats.effect.concurrent.Semaphore$;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapOps$;
import fs2.Chunk;
import fs2.io.tls.InputOutputBuffer;
import fs2.io.tls.InputOutputBuffer$;
import fs2.io.tls.SSLEngineTaskRunner;
import fs2.io.tls.SSLEngineTaskRunner$;
import fs2.io.tls.TLSEngine;
import fs2.io.tls.TLSEngine$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class TLSEngine$ {
    public static final TLSEngine$ MODULE$ = new TLSEngine$();

    public <F> F apply(SSLEngine engine, ExecutionContext blocker, Option<Function1<String, F>> logger, Concurrent<F> evidence$1, ContextShift<F> evidence$2) {
        return (F)implicits$.MODULE$.toFlatMapOps(InputOutputBuffer$.MODULE$.apply(engine.getSession().getApplicationBufferSize(), engine.getSession().getPacketBufferSize(), evidence$1), evidence$1).flatMap((Function1 & Serializable)wrapBuffer -> implicits$.MODULE$.toFlatMapOps(InputOutputBuffer$.MODULE$.apply(engine.getSession().getPacketBufferSize(), engine.getSession().getApplicationBufferSize(), evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)unwrapBuffer -> implicits$.MODULE$.toFlatMapOps(Semaphore$.MODULE$.apply(1L, evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)wrapSem -> implicits$.MODULE$.toFlatMapOps(Semaphore$.MODULE$.apply(1L, evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)unwrapSem -> implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFunctorOps(Semaphore$.MODULE$.apply(1L, evidence$1), (Functor)evidence$1).map((Function1 & Serializable)handshakeSem -> {
            SSLEngineTaskRunner sslEngineTaskRunner = SSLEngineTaskRunner$.MODULE$.apply(engine, blocker, evidence$1, evidence$2);
            return new Tuple2(handshakeSem, sslEngineTaskRunner);
        }), (Functor)evidence$1).map((Function1 & Serializable)x$10 -> {
            Tuple2 tuple2 = x$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Semaphore handshakeSem = (Semaphore)tuple2._1();
            SSLEngineTaskRunner sslEngineTaskRunner = (SSLEngineTaskRunner)tuple2._2();
            TLSEngine tLSEngine = new TLSEngine<F>(logger, evidence$1, engine, (Semaphore)wrapSem, (InputOutputBuffer)wrapBuffer, (Semaphore)unwrapSem, (InputOutputBuffer)unwrapBuffer, handshakeSem, sslEngineTaskRunner){
                private final Option logger$1;
                private final Concurrent evidence$1$1;
                private final SSLEngine engine$1;
                private final Semaphore wrapSem$1;
                private final InputOutputBuffer wrapBuffer$1;
                private final Semaphore unwrapSem$1;
                private final InputOutputBuffer unwrapBuffer$1;
                private final Semaphore handshakeSem$1;
                private final SSLEngineTaskRunner sslEngineTaskRunner$1;

                private F log(String msg) {
                    return (F)this.logger$1.map((Function1 & Serializable)x$1 -> x$1.apply((Object)msg)).getOrElse((Function0 & Serializable)() -> Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit());
                }

                public F beginHandshake() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.engine$1.beginHandshake());
                }

                public F session() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0 & Serializable)() -> $this.engine$1.getSession());
                }

                public F stopWrap() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.engine$1.closeOutbound());
                }

                public F stopUnwrap() {
                    return (F)implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.engine$1.closeInbound()), (ApplicativeError)this.evidence$1$1), (ApplicativeError)this.evidence$1$1), (Functor)this.evidence$1$1).void();
                }

                public F wrap(Chunk<Object> data, TLSEngine.Binding<F> binding) {
                    return (F)this.wrapSem$1.withPermit(FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.wrapBuffer$1.input(data), (FlatMap)this.evidence$1$1), (Function0 & Serializable)() -> this.doWrap(binding), (FlatMap)this.evidence$1$1));
                }

                private F doWrap(TLSEngine.Binding<F> binding) {
                    return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFlatMapOps(this.wrapBuffer$1.perform((Function2 & Serializable)(x$2, x$3) -> $this.engine$1.wrap((ByteBuffer)x$2, (ByteBuffer)x$3)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log(new StringBuilder(15).append("doWrap result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.doWrite(binding), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> {
                                SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                                Object object = ((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING))).equals((Object)((Object)handshakeStatus)) ? Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit() : FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.handshake((SSLEngineResult)result, true, binding), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.doWrap(binding), (FlatMap)$this.evidence$1$1);
                                return object;
                            }, (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            object = this.doWrite(binding);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps($this.wrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.doWrap(binding), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stopUnwrap(), (FlatMap)$this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                private F doWrite(TLSEngine.Binding<F> binding) {
                    return (F)implicits$.MODULE$.toFlatMapOps(this.wrapBuffer$1.output(), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)out -> out.isEmpty() ? Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit() : binding.write((Chunk<Object>)out));
                }

                public F unwrap(Chunk<Object> data, TLSEngine.Binding<F> binding) {
                    return (F)this.unwrapSem$1.withPermit(FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.unwrapBuffer$1.input(data), (FlatMap)this.evidence$1$1), (Function0 & Serializable)() -> this.doUnwrap(binding), (FlatMap)this.evidence$1$1));
                }

                private F doUnwrap(TLSEngine.Binding<F> binding) {
                    return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.perform((Function2 & Serializable)(x$4, x$5) -> $this.engine$1.unwrap((ByteBuffer)x$4, (ByteBuffer)x$5)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log(new StringBuilder(15).append("unwrap result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                            Object object2 = ((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING))).equals((Object)((Object)handshakeStatus)) ? this.dequeueUnwrap() : (((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.FINISHED))).equals((Object)((Object)handshakeStatus)) ? this.doUnwrap(binding) : FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.handshake((SSLEngineResult)result, false, binding), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.doUnwrap(binding), (FlatMap)$this.evidence$1$1));
                            object = object2;
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            object = this.dequeueUnwrap();
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.doUnwrap(binding), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stopUnwrap(), (FlatMap)$this.evidence$1$1), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.dequeueUnwrap(), (FlatMap)$this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                private F dequeueUnwrap() {
                    return (F)implicits$.MODULE$.toFunctorOps(this.unwrapBuffer$1.output(), (Functor)this.evidence$1$1).map((Function1 & Serializable)out -> out.isEmpty() ? None$.MODULE$ : new Some(out));
                }

                private F handshake(SSLEngineResult result, boolean lastOperationWrap, TLSEngine.Binding<F> binding) {
                    return (F)this.handshakeSem$1.withPermit(this.stepHandshake(result, lastOperationWrap, binding));
                }

                private F stepHandshake(SSLEngineResult result, boolean lastOperationWrap, TLSEngine.Binding<F> binding) {
                    Object object;
                    SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                    if (((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)).equals((Object)((Object)handshakeStatus))) {
                        object = Applicative$.MODULE$.apply((Applicative)this.evidence$1$1).unit();
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.FINISHED)).equals((Object)((Object)handshakeStatus))) {
                        object = implicits$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.inputRemains(), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)remaining -> anon.1.$anonfun$stepHandshake$1(this, binding, BoxesRunTime.unboxToInt((Object)remaining)));
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_TASK)).equals((Object)((Object)handshakeStatus))) {
                        object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.sslEngineTaskRunner$1.runDelegatedTasks(), (FlatMap)this.evidence$1$1), (Function0 & Serializable)() -> lastOperationWrap ? this.doHsWrap(binding) : this.doHsUnwrap(binding), (FlatMap)this.evidence$1$1);
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP)).equals((Object)((Object)handshakeStatus))) {
                        object = this.doHsWrap(binding);
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP)).equals((Object)((Object)handshakeStatus))) {
                        object = implicits$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.inputRemains(), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)remaining -> anon.1.$anonfun$stepHandshake$3(this, result, binding, BoxesRunTime.unboxToInt((Object)remaining)));
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN)).equals((Object)((Object)handshakeStatus))) {
                        object = this.doHsUnwrap(binding);
                    } else {
                        throw new MatchError((Object)((Object)handshakeStatus));
                    }
                    return (F)object;
                }

                private F doHsWrap(TLSEngine.Binding<F> binding) {
                    return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFlatMapOps(this.wrapBuffer$1.perform((Function2 & Serializable)(x$6, x$7) -> $this.engine$1.wrap((ByteBuffer)x$6, (ByteBuffer)x$7)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log(new StringBuilder(17).append("doHsWrap result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        boolean bl = ((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status)) ? true : ((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status));
                        if (bl) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.doWrite(binding), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stepHandshake((SSLEngineResult)result, true, binding), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps($this.wrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.doHsWrap(binding), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stopUnwrap(), (FlatMap)$this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                private F doHsUnwrap(TLSEngine.Binding<F> binding) {
                    return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.perform((Function2 & Serializable)(x$8, x$9) -> $this.engine$1.unwrap((ByteBuffer)x$8, (ByteBuffer)x$9)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log(new StringBuilder(19).append("doHsUnwrap result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            object = this.stepHandshake((SSLEngineResult)result, false, binding);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            object = this.stepHandshake((SSLEngineResult)result, false, binding);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.doHsUnwrap(binding), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stopUnwrap(), (FlatMap)$this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                public static final /* synthetic */ Object $anonfun$stepHandshake$1(anon.1 $this, TLSEngine.Binding binding$6, int remaining) {
                    return remaining > 0 ? $this.doHsUnwrap(binding$6) : Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit();
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public static final /* synthetic */ Object $anonfun$stepHandshake$3(anon.1 $this, SSLEngineResult result$2, TLSEngine.Binding binding$6, int remaining) {
                    Object object;
                    if (remaining > 0) {
                        SSLEngineResult.Status status = result$2.getStatus();
                        SSLEngineResult.Status status2 = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                        if (status == null ? status2 != null : !((Object)((Object)status)).equals((Object)((Object)status2))) {
                            object = $this.doHsUnwrap(binding$6);
                            return object;
                        }
                    }
                    object = implicits$.MODULE$.toFlatMapOps(binding$6.read(), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x0$1 -> {
                        Object object;
                        Option option = x0$1;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Chunk c = (Chunk)some.value();
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.input((Chunk<Object>)c), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> $this.doHsUnwrap(binding$6), (FlatMap)$this.evidence$1$1);
                        } else if (None$.MODULE$.equals(option)) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps($this.stopWrap(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> $this.stopUnwrap(), (FlatMap)$this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return object;
                    });
                    return object;
                }
                {
                    this.logger$1 = logger$1;
                    this.evidence$1$1 = evidence$1$1;
                    this.engine$1 = engine$1;
                    this.wrapSem$1 = wrapSem$1;
                    this.wrapBuffer$1 = wrapBuffer$1;
                    this.unwrapSem$1 = unwrapSem$1;
                    this.unwrapBuffer$1 = unwrapBuffer$1;
                    this.handshakeSem$1 = handshakeSem$1;
                    this.sslEngineTaskRunner$1 = sslEngineTaskRunner$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$beginHandshake$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$dequeueUnwrap$1(fs2.Chunk ), $anonfun$doHsUnwrap$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$doHsUnwrap$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$doHsUnwrap$3(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding javax.net.ssl.SSLEngineResult ), $anonfun$doHsUnwrap$4(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding ), $anonfun$doHsUnwrap$5(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$doHsWrap$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$doHsWrap$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$doHsWrap$3(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding javax.net.ssl.SSLEngineResult ), $anonfun$doHsWrap$4(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult fs2.io.tls.TLSEngine$Binding ), $anonfun$doHsWrap$5(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding ), $anonfun$doHsWrap$6(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$doUnwrap$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$doUnwrap$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$doUnwrap$3(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding javax.net.ssl.SSLEngineResult ), $anonfun$doUnwrap$4(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding ), $anonfun$doUnwrap$5(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding ), $anonfun$doUnwrap$6(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$doUnwrap$7(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$doWrap$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$doWrap$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$doWrap$3(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding javax.net.ssl.SSLEngineResult ), $anonfun$doWrap$4(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult fs2.io.tls.TLSEngine$Binding ), $anonfun$doWrap$5(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding ), $anonfun$doWrap$6(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding ), $anonfun$doWrap$7(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$doWrite$1(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding fs2.Chunk ), $anonfun$log$1(java.lang.String scala.Function1 ), $anonfun$log$2(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$session$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$stepHandshake$1$adapted(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding java.lang.Object ), $anonfun$stepHandshake$2(fs2.io.tls.TLSEngine$$anon$1 boolean fs2.io.tls.TLSEngine$Binding ), $anonfun$stepHandshake$3$adapted(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult fs2.io.tls.TLSEngine$Binding java.lang.Object ), $anonfun$stepHandshake$4(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding scala.Option ), $anonfun$stepHandshake$5(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding ), $anonfun$stepHandshake$6(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$stopUnwrap$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$stopWrap$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$unwrap$1(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding ), $anonfun$wrap$1(fs2.io.tls.TLSEngine$$anon$1 fs2.io.tls.TLSEngine$Binding )}, serializedLambda);
                }
            };
            return tLSEngine;
        })))));
    }

    public <F> None$ apply$default$3() {
        return None$.MODULE$;
    }

    private TLSEngine$() {
    }
}

