/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DomainClassPropertyEditor<T, ID extends Serializable>
extends PropertyEditorSupport {
    private final RepositoryInvoker invoker;
    private final EntityInformation<T, ID> information;
    private final PropertyEditorRegistry registry;

    public DomainClassPropertyEditor(RepositoryInvoker invoker, EntityInformation<T, ID> information, PropertyEditorRegistry registry) {
        Assert.notNull((Object)invoker, (String)"Invoker must not be null!");
        Assert.notNull(information, (String)"Information must not be null!");
        Assert.notNull((Object)registry, (String)"Registry must not be null!");
        this.invoker = invoker;
        this.information = information;
        this.registry = registry;
    }

    @Override
    public void setAsText(String idAsString) {
        if (!StringUtils.hasText((String)idAsString)) {
            this.setValue(null);
            return;
        }
        this.setValue(this.invoker.invokeFindOne((Serializable)this.getId(idAsString)));
    }

    @Override
    public String getAsText() {
        Object entity = this.getValue();
        if (null == entity) {
            return null;
        }
        ID id = this.getId(entity);
        return id == null ? null : id.toString();
    }

    private ID getId(T entity) {
        return this.information.getId(entity);
    }

    private ID getId(String idAsString) {
        Class<ID> idClass = this.information.getIdType();
        PropertyEditor idEditor = this.registry.findCustomEditor(idClass, null);
        if (idEditor != null) {
            idEditor.setAsText(idAsString);
            return (ID)((Serializable)idEditor.getValue());
        }
        return (ID)((Serializable)new SimpleTypeConverter().convertIfNecessary((Object)idAsString, idClass));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DomainClassPropertyEditor that = (DomainClassPropertyEditor)obj;
        return this.invoker.equals(that.invoker) && this.registry.equals(that.registry) && this.information.equals(that.information);
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode += this.invoker.hashCode() * 32;
        hashCode += this.information.hashCode() * 32;
        return hashCode += this.registry.hashCode() * 32;
    }
}

