/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AnnotationUtils {
    public static <A extends Annotation> Annotation[] unwrapContainerAnnotations(A[] AArray) {
        LinkedList<Annotation> linkedList = new LinkedList<Annotation>();
        for (A a : AArray) {
            List<Annotation> list = AnnotationUtils.getIndirectlyPresentAnnotations(a);
            if (!list.isEmpty()) {
                linkedList.addAll(list);
                continue;
            }
            linkedList.add((Annotation)a);
        }
        return linkedList.toArray(new Annotation[linkedList.size()]);
    }

    public static <A extends Annotation> List<Annotation> getIndirectlyPresentAnnotations(A a) {
        try {
            Annotation[] annotationArray;
            Method method = a.annotationType().getMethod("value", new Class[0]);
            Object object = method.invoke(a, new Object[0]);
            if (Annotation[].class.isAssignableFrom(object.getClass()) && (annotationArray = (Annotation[])object).length > 0 && annotationArray[0].annotationType().isAnnotationPresent(Repeatable.class)) {
                return Arrays.asList(annotationArray);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
        return Collections.emptyList();
    }
}

