/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.stream.AbruptTerminationException$;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.impl.BatchingInputBuffer;
import org.apache.pekko.stream.impl.ExposedPublisher;
import org.apache.pekko.stream.impl.ExposedPublisherReceive;
import org.apache.pekko.stream.impl.Inputs;
import org.apache.pekko.stream.impl.Outputs;
import org.apache.pekko.stream.impl.Pump;
import org.apache.pekko.stream.impl.SimpleOutputs;
import org.apache.pekko.stream.impl.TransferPhase;
import org.apache.pekko.stream.impl.TransferState;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public abstract class ActorProcessorImpl
implements Actor,
ActorLogging,
Pump {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private TransferState org$apache$pekko$stream$impl$Pump$$transferState;
    private Function0 org$apache$pekko$stream$impl$Pump$$currentAction;
    private TransferPhase completedPhase;
    private final boolean debugLoggingEnabled;
    private final Inputs primaryInputs;
    private final Outputs primaryOutputs;

    public ActorProcessorImpl(Attributes attributes) {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        Pump.$init$(this);
        this.debugLoggingEnabled = ((ActorAttributes.DebugLogging)attributes.mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.DebugLogging.class))).enabled();
        int initialInputBufferSize = ((Attributes.InputBuffer)attributes.mandatoryAttribute(ClassTag$.MODULE$.apply(Attributes.InputBuffer.class))).initial();
        this.primaryInputs = new BatchingInputBuffer(initialInputBufferSize, this){
            private final /* synthetic */ ActorProcessorImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(initialInputBufferSize$1, $outer);
            }

            public void inputOnError(Throwable e) {
                this.$outer.onError(e);
            }
        };
        this.primaryOutputs = new SimpleOutputs(this.self(), this);
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public TransferState org$apache$pekko$stream$impl$Pump$$transferState() {
        return this.org$apache$pekko$stream$impl$Pump$$transferState;
    }

    public Function0 org$apache$pekko$stream$impl$Pump$$currentAction() {
        return this.org$apache$pekko$stream$impl$Pump$$currentAction;
    }

    @Override
    public final TransferPhase completedPhase() {
        return this.completedPhase;
    }

    @Override
    public void org$apache$pekko$stream$impl$Pump$$transferState_$eq(TransferState x$1) {
        this.org$apache$pekko$stream$impl$Pump$$transferState = x$1;
    }

    public void org$apache$pekko$stream$impl$Pump$$currentAction_$eq(Function0 x$1) {
        this.org$apache$pekko$stream$impl$Pump$$currentAction = x$1;
    }

    @Override
    public void org$apache$pekko$stream$impl$Pump$_setter_$completedPhase_$eq(TransferPhase x$0) {
        this.completedPhase = x$0;
    }

    public Inputs primaryInputs() {
        return this.primaryInputs;
    }

    public Outputs primaryOutputs() {
        return this.primaryOutputs;
    }

    public abstract PartialFunction<Object, BoxedUnit> subTimeoutHandling();

    public final PartialFunction<Object, BoxedUnit> receive() {
        return new ExposedPublisherReceive(this){
            private final /* synthetic */ ActorProcessorImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.activeReceive(), (Function1<Object, BoxedUnit>)$outer.org$apache$pekko$stream$impl$ActorProcessorImpl$$_$$anon$superArg$1$1());
            }

            public void receiveExposedPublisher(ExposedPublisher ep) {
                this.$outer.primaryOutputs().subreceive().apply(ep);
                this.$outer.context().become(this.$outer.activeReceive());
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> activeReceive() {
        return this.primaryInputs().subreceive().orElse(this.primaryOutputs().subreceive()).orElse(this.subTimeoutHandling());
    }

    public void onError(Throwable e) {
        this.fail(e);
    }

    public void fail(Throwable e) {
        if (this.debugLoggingEnabled) {
            this.log().debug("fail due to: {}", (Object)e.getMessage());
        }
        this.primaryInputs().cancel();
        this.primaryOutputs().error(e);
        this.context().stop(this.self());
    }

    @Override
    public void pumpFinished() {
        this.primaryInputs().cancel();
        this.primaryOutputs().complete();
        this.context().stop(this.self());
    }

    @Override
    public void pumpFailed(Throwable e) {
        this.fail(e);
    }

    public void postStop() {
        this.primaryInputs().cancel();
        this.primaryOutputs().error(AbruptTerminationException$.MODULE$.apply(this.self()));
    }

    public void postRestart(Throwable reason) {
        Actor.postRestart$((Actor)this, (Throwable)reason);
        throw new IllegalStateException("This actor cannot be restarted", reason);
    }

    public final Function1 org$apache$pekko$stream$impl$ActorProcessorImpl$$_$$anon$superArg$1$1() {
        return (JProcedure1 & Serializable)message -> this.unhandled(message);
    }
}

