/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.File;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.server.ConjunctionMagnet$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.directives.CodingDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.ContentTypeResolver;
import org.apache.pekko.http.scaladsl.server.directives.FileAndResourceDirectives;
import org.apache.pekko.http.scaladsl.server.directives.RangeDirectives$;
import org.apache.pekko.http.scaladsl.server.util.TupleOps$Join$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;

public final class FileAndResourceDirectives$
implements FileAndResourceDirectives {
    public static FileAndResourceDirectives$ MODULE$;
    private final Directive<BoxedUnit> org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport;

    static {
        new FileAndResourceDirectives$();
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(String fileName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, fileName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, file, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentType contentType) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, file, contentType);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromResource$(this, resourceName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentType contentType, ClassLoader classLoader) {
        return FileAndResourceDirectives.getFromResource$(this, resourceName, contentType, classLoader);
    }

    @Override
    public ClassLoader getFromResource$default$3() {
        return FileAndResourceDirectives.getFromResource$default$3$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromDirectory(String directoryName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromDirectory$(this, directoryName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> listDirectoryContents(Seq<String> directories, FileAndResourceDirectives.DirectoryRenderer renderer) {
        return FileAndResourceDirectives.listDirectoryContents$(this, directories, renderer);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectory(String directory, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromBrowseableDirectory$(this, directory, renderer, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectories(Seq<String> directories, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromBrowseableDirectories$(this, directories, renderer, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResourceDirectory(String directoryName, ClassLoader classLoader, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromResourceDirectory$(this, directoryName, classLoader, resolver);
    }

    @Override
    public ClassLoader getFromResourceDirectory$default$2() {
        return FileAndResourceDirectives.getFromResourceDirectory$default$2$(this);
    }

    @Override
    public ClassLoader _defaultClassLoader() {
        return FileAndResourceDirectives._defaultClassLoader$(this);
    }

    public Directive<BoxedUnit> org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport() {
        return this.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport;
    }

    public String org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$withTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path;
        }
        return new StringBuilder(0).append(path).append('/').toString();
    }

    public String org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath(String basePath, Uri.Path path, LoggingAdapter log, char separator) {
        String string = this.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths(basePath, path, log, separator);
        if ("".equals(string)) {
            return "";
        }
        return this.checkIsSafeDescendant(basePath, string, log);
    }

    public char org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath$default$4() {
        return File.separatorChar;
    }

    public String org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths(String base, Uri.Path path, LoggingAdapter log, char separator) {
        return this.rec$1(path.startsWithSlash() ? path.tail() : path, FileAndResourceDirectives$.rec$default$2$1(base), separator, log, base, path);
    }

    private String checkIsSafeDescendant(String basePath, String finalPath, LoggingAdapter log) {
        File baseFile = new File(basePath);
        File finalFile = new File(finalPath);
        String canonicalFinalPath = finalFile.getCanonicalPath();
        if (!canonicalFinalPath.startsWith(baseFile.getCanonicalPath())) {
            log.warning(new StringBuilder(92).append("[").append(finalFile).append("] points to a location that is not part of [").append(baseFile).append("]. This might be a directory ").append("traversal attempt.").toString());
            return "";
        }
        return canonicalFinalPath;
    }

    private final String rec$1(Uri.Path p, StringBuilder result, char separator$1, LoggingAdapter log$1, String base$2, Uri.Path path$2) {
        Uri.Path path;
        while (true) {
            Uri.Path.SlashOrEmpty tail;
            String head;
            block7: {
                block6: {
                    if (Uri.Path$.Empty$.MODULE$.equals(path = p)) {
                        return result.toString();
                    }
                    if (path instanceof Uri.Path$.Slash) {
                        Uri.Path$.Slash slash = (Uri.Path$.Slash)path;
                        Uri.Path tail2 = slash.tail();
                        result = result.append(separator$1);
                        p = tail2;
                        continue;
                    }
                    if (!(path instanceof Uri.Path$.Segment)) break;
                    Uri.Path$.Segment segment = (Uri.Path$.Segment)path;
                    head = segment.head();
                    tail = segment.tail();
                    if (head.indexOf(47) >= 0 || head.indexOf(92) >= 0) break block6;
                    String string = head;
                    String string2 = "..";
                    if (string != null ? !string.equals(string2) : string2 != null) break block7;
                }
                log$1.warning("File-system path for base [{}] and Uri.Path [{}] contains suspicious path segment [{}], GET access was disallowed", (Object)base$2, (Object)path$2, (Object)head);
                return "";
            }
            result = result.append(head);
            p = tail;
        }
        throw new MatchError((Object)path);
    }

    private static final StringBuilder rec$default$2$1(String base$2) {
        return new StringBuilder(base$2);
    }

    private FileAndResourceDirectives$() {
        MODULE$ = this;
        FileAndResourceDirectives.$init$(this);
        this.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport = (Directive)RangeDirectives$.MODULE$.withRangeSupport().$amp(ConjunctionMagnet$.MODULE$.fromDirective(CodingDirectives$.MODULE$.withPrecompressedMediaTypeSupport(), TupleOps$Join$.MODULE$.join0P()));
    }
}

