/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.grpc;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import io.micrometer.core.instrument.binder.grpc.GrpcServerObservationContext;
import io.micrometer.observation.Observation;

class ObservationGrpcServerCall<ReqT, RespT>
extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
    private final Observation observation;

    ObservationGrpcServerCall(ServerCall<ReqT, RespT> delegate, Observation observation) {
        super(delegate);
        this.observation = observation;
    }

    public void sendHeaders(Metadata headers) {
        super.sendHeaders(headers);
        Observation.Context context = this.observation.getContext();
        if (context instanceof GrpcServerObservationContext) {
            Metadata headersToKeep = new Metadata();
            headersToKeep.merge(headers);
            ((GrpcServerObservationContext)context).setHeaders(headersToKeep);
        }
    }

    public void sendMessage(RespT message) {
        this.observation.event((Observation.Event)GrpcObservationDocumentation.GrpcServerEvents.MESSAGE_SENT);
        super.sendMessage(message);
    }

    public void close(Status status, Metadata trailers) {
        if (status.getCause() != null) {
            this.observation.error(status.getCause());
        }
        Metadata trailersToKeep = new Metadata();
        trailersToKeep.merge(trailers);
        GrpcServerObservationContext context = (GrpcServerObservationContext)this.observation.getContext();
        context.setStatusCode(status.getCode());
        context.setTrailers(trailersToKeep);
        super.close(status, trailers);
    }
}

