/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.LazyValue;
import io.helidon.common.configurable.spi.ExecutorServiceSupplierObserver;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class ObserverManager {
    private static final System.Logger LOGGER = System.getLogger(ObserverManager.class.getName());
    private static final LazyValue<List<ExecutorServiceSupplierObserver>> OBSERVERS = LazyValue.create(ObserverManager::loadObservers);
    private static final Map<Supplier<? extends ExecutorService>, SupplierInfo> SUPPLIERS = new ConcurrentHashMap<Supplier<? extends ExecutorService>, SupplierInfo>();
    private static final Map<String, AtomicInteger> SUPPLIER_CATEGORY_NEXT_INDEX_VALUES = new ConcurrentHashMap<String, AtomicInteger>();
    private static final Map<ExecutorService, SupplierInfo> EXECUTOR_SERVICES = new ConcurrentHashMap<ExecutorService, SupplierInfo>();

    private ObserverManager() {
    }

    static void registerSupplier(Supplier<? extends ExecutorService> supplier, String supplierCategory, String executorServiceCategory) {
        int supplierIndex = SUPPLIER_CATEGORY_NEXT_INDEX_VALUES.computeIfAbsent(supplierCategory, key -> new AtomicInteger()).getAndIncrement();
        SUPPLIERS.computeIfAbsent(supplier, s -> SupplierInfo.create(s, executorServiceCategory, supplierCategory, supplierIndex));
    }

    static <E extends ExecutorService> E registerExecutorService(Supplier<E> supplier, E executorService) {
        SupplierInfo supplierInfo = SUPPLIERS.get(supplier);
        if (supplierInfo == null) {
            throw new IllegalStateException("Attempt to register an executor service to an unregistered supplier");
        }
        supplierInfo.registerExecutorService(executorService);
        return executorService;
    }

    static void unregisterExecutorService(ExecutorService executorService) {
        SupplierInfo supplierInfo = EXECUTOR_SERVICES.get(executorService);
        if (supplierInfo == null) {
            LOGGER.log(System.Logger.Level.WARNING, String.format("Executor service %s is being unregistered but could not locate supplier to notify observers", executorService));
            return;
        }
        supplierInfo.unregisterExecutorService(executorService);
    }

    private static List<ExecutorServiceSupplierObserver> loadObservers() {
        ServiceLoader<ExecutorServiceSupplierObserver> loader = ServiceLoader.load(ExecutorServiceSupplierObserver.class);
        return loader.stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
    }

    private static class SupplierInfo {
        private final Supplier<? extends ExecutorService> supplier;
        private final String executorServiceCategory;
        private final String supplierCategory;
        private final int supplierIndex;
        private final AtomicInteger nextThreadPoolIndex = new AtomicInteger(0);
        private final List<ExecutorServiceSupplierObserver.SupplierObserverContext> observerContexts;

        private static SupplierInfo create(Supplier<? extends ExecutorService> supplier, String executorServiceCategory, String supplierCategory, int supplierIndex) {
            return new SupplierInfo(supplier, supplierCategory, executorServiceCategory, supplierIndex);
        }

        private SupplierInfo(Supplier<? extends ExecutorService> supplier, String supplierCategory, String executorServiceCategory, int supplierIndex) {
            this.supplier = supplier;
            this.supplierCategory = supplierCategory;
            this.executorServiceCategory = executorServiceCategory;
            this.supplierIndex = supplierIndex;
            this.observerContexts = this.collectObserverContexts();
        }

        private List<ExecutorServiceSupplierObserver.SupplierObserverContext> collectObserverContexts() {
            return ((List)OBSERVERS.get()).stream().map(this::apply).collect(Collectors.toList());
        }

        void registerExecutorService(ExecutorService executorService) {
            int threadPoolIndex = this.nextThreadPoolIndex.getAndIncrement();
            EXECUTOR_SERVICES.put(executorService, this);
            this.observerContexts.forEach(observer -> observer.registerExecutorService(executorService, threadPoolIndex));
        }

        void unregisterExecutorService(ExecutorService executorService) {
            this.observerContexts.forEach(observer -> observer.unregisterExecutorService(executorService));
            EXECUTOR_SERVICES.remove(executorService);
        }

        private ExecutorServiceSupplierObserver.SupplierObserverContext apply(ExecutorServiceSupplierObserver observer) {
            return observer.registerSupplier(this.supplier, this.supplierIndex, this.supplierCategory);
        }
    }
}

