/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.configurable.LruCacheConfig;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;

@RuntimeType.PrototypedBy(value=LruCacheConfig.class)
public final class LruCache<K, V>
implements RuntimeType.Api<LruCacheConfig<K, V>> {
    public static final int DEFAULT_CAPACITY = 10000;
    private final LinkedHashMap<K, V> backingMap = new LinkedHashMap();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final int capacity;
    private final LruCacheConfig<K, V> config;

    private LruCache(LruCacheConfig<K, V> config) {
        this.capacity = config.capacity();
        this.config = config;
    }

    public static <K, V> LruCacheConfig.Builder<K, V> builder() {
        return LruCacheConfig.builder();
    }

    public static <K, V> LruCache<K, V> create() {
        return LruCacheConfig.builder().build();
    }

    public static <K, V> LruCache<K, V> create(LruCacheConfig<K, V> config) {
        return new LruCache<K, V>(config);
    }

    public static <K, V> LruCache<K, V> create(Consumer<LruCacheConfig.Builder<K, V>> consumer) {
        LruCacheConfig.Builder builder = LruCacheConfig.builder();
        consumer.accept(builder);
        return builder.build();
    }

    public LruCacheConfig<K, V> prototype() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<V> get(K key) {
        V value;
        this.readLock.lock();
        try {
            value = this.backingMap.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (null == value) {
            return Optional.empty();
        }
        this.writeLock.lock();
        try {
            value = this.backingMap.get(key);
            if (null == value) {
                Optional optional = Optional.empty();
                return optional;
            }
            this.backingMap.remove(key);
            this.backingMap.put(key, value);
            Optional<V> optional = Optional.of(value);
            return optional;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Optional<V> remove(K key) {
        this.writeLock.lock();
        try {
            Optional optional = Optional.ofNullable(this.backingMap.remove(key));
            return optional;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<V> put(K key, V value) {
        this.writeLock.lock();
        try {
            Object currentValue = this.backingMap.remove(key);
            if (null == currentValue && this.backingMap.size() >= this.capacity) {
                Iterator<V> iterator = this.backingMap.values().iterator();
                iterator.next();
                iterator.remove();
            }
            this.backingMap.put(key, value);
            Optional optional = Optional.ofNullable(currentValue);
            return optional;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Optional<V> computeValue(K key, Supplier<Optional<V>> valueSupplier) {
        Optional<V> currentValue = this.get(key);
        if (currentValue.isPresent()) {
            return currentValue;
        }
        Optional<V> newValue = valueSupplier.get();
        newValue.ifPresent(theValue -> this.put(key, theValue));
        return newValue;
    }

    public int size() {
        this.readLock.lock();
        try {
            int n = this.backingMap.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.backingMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    V directGet(K key) {
        return this.backingMap.get(key);
    }
}

