/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.Serializable;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesInitializer$;
import java.time.zone.ZoneRulesProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import scala.runtime.ModuleSerializationProxy;

public final class ZoneRulesProvider$
implements Serializable {
    private ArrayList PROVIDERS$lzy1;
    private boolean PROVIDERSbitmap$1;
    private Map ZONES$lzy1;
    private boolean ZONESbitmap$1;
    public static final ZoneRulesProvider$ MODULE$ = new ZoneRulesProvider$();

    private ZoneRulesProvider$() {
    }

    static {
        ZoneRulesInitializer$.MODULE$.initialize();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ZoneRulesProvider$.class);
    }

    private ArrayList<ZoneRulesProvider> PROVIDERS() {
        if (!this.PROVIDERSbitmap$1) {
            this.PROVIDERS$lzy1 = new ArrayList();
            this.PROVIDERSbitmap$1 = true;
        }
        return this.PROVIDERS$lzy1;
    }

    private Map<String, ZoneRulesProvider> ZONES() {
        if (!this.ZONESbitmap$1) {
            this.ZONES$lzy1 = new HashMap();
            this.ZONESbitmap$1 = true;
        }
        return this.ZONES$lzy1;
    }

    public Set<String> getAvailableZoneIds() {
        return Collections.unmodifiableSet(this.ZONES().keySet());
    }

    public ZoneRules getRules(String zoneId, boolean forCaching) {
        Objects.requireNonNull(zoneId, "zoneId");
        return this.getProvider(zoneId).provideRules(zoneId, forCaching);
    }

    public NavigableMap<String, ZoneRules> getVersions(String zoneId) {
        Objects.requireNonNull(zoneId, "zoneId");
        return this.getProvider(zoneId).provideVersions(zoneId);
    }

    private ZoneRulesProvider getProvider(String zoneId) {
        ZoneRulesProvider provider = this.ZONES().get(zoneId);
        if (provider == null) {
            if (this.ZONES().isEmpty()) {
                throw new ZoneRulesException("No time-zone data files registered");
            }
            throw new ZoneRulesException(new StringBuilder(22).append("Unknown time-zone ID: ").append(zoneId).toString());
        }
        return provider;
    }

    public void registerProvider(ZoneRulesProvider provider) {
        Objects.requireNonNull(provider, "provider");
        this.registerProvider0(provider);
        this.PROVIDERS().add(provider);
    }

    private void registerProvider0(ZoneRulesProvider provider) {
        for (String zoneId : provider.provideZoneIds()) {
            Objects.requireNonNull(zoneId, "zoneId");
            ZoneRulesProvider old = this.ZONES().put(zoneId, provider);
            if (old == null) continue;
            throw new ZoneRulesException(new StringBuilder(99).append("Unable to register zone as one already registered with that ID: ").append(zoneId).append(", currently loading from provider: ").append(provider).toString());
        }
    }

    public boolean refresh() {
        boolean changed = false;
        for (ZoneRulesProvider provider : this.PROVIDERS()) {
            changed |= provider.provideRefresh();
        }
        return changed;
    }
}

