/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.LocalDateTime;
import java.time.LocalDateTime$;
import java.time.LocalTime;
import java.time.LocalTime$;
import java.time.Month;
import java.time.Month$;
import java.time.Year$;
import java.time.ZoneOffset;
import java.time.ZoneOffset$;
import java.time.chrono.IsoChronology$;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalAdjusters$;
import java.time.zone.StandardZoneRules$;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneOffsetTransitionRule$TimeDefinition$;
import java.time.zone.ZoneRules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class ZoneRulesBuilder {
    private final List<TZWindow> windowList = new ArrayList<TZWindow>();
    private Map<Object, Object> deduplicateMap = null;
    public final TZRuleComparator java$time$zone$ZoneRulesBuilder$$ruleComparator = new TZRuleComparator();

    public ZoneRulesBuilder addWindow(ZoneOffset standardOffset, LocalDateTime until, ZoneOffsetTransitionRule.TimeDefinition untilDefinition) {
        Objects.requireNonNull(standardOffset, "standardOffset");
        Objects.requireNonNull(until, "until");
        Objects.requireNonNull(untilDefinition, "untilDefinition");
        TZWindow window = new TZWindow(this, standardOffset, until, untilDefinition);
        if (this.windowList.size() > 0) {
            TZWindow previous = this.windowList.get(this.windowList.size() - 1);
            window.validateWindowOrder(previous);
        }
        this.windowList.add(window);
        return this;
    }

    public ZoneRulesBuilder addWindowForever(ZoneOffset standardOffset) {
        return this.addWindow(standardOffset, LocalDateTime$.MODULE$.MAX(), ZoneOffsetTransitionRule$TimeDefinition$.WALL);
    }

    public ZoneRulesBuilder setFixedSavingsToWindow(int fixedSavingAmountSecs) {
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("Must add a window before setting the fixed savings");
        }
        TZWindow window = this.windowList.get(this.windowList.size() - 1);
        window.setFixedSavings(fixedSavingAmountSecs);
        return this;
    }

    public ZoneRulesBuilder addRuleToWindow(LocalDateTime transitionDateTime, ZoneOffsetTransitionRule.TimeDefinition timeDefinition, int savingAmountSecs) {
        Objects.requireNonNull(transitionDateTime, "transitionDateTime");
        return this.addRuleToWindow(transitionDateTime.getYear(), transitionDateTime.getYear(), transitionDateTime.getMonth(), transitionDateTime.getDayOfMonth(), null, transitionDateTime.toLocalTime(), false, timeDefinition, savingAmountSecs);
    }

    public ZoneRulesBuilder addRuleToWindow(int year, Month month, int dayOfMonthIndicator, LocalTime time, boolean timeEndOfDay, ZoneOffsetTransitionRule.TimeDefinition timeDefinition, int savingAmountSecs) {
        return this.addRuleToWindow(year, year, month, dayOfMonthIndicator, null, time, timeEndOfDay, timeDefinition, savingAmountSecs);
    }

    public ZoneRulesBuilder addRuleToWindow(int startYear, int endYear, Month month, int dayOfMonthIndicator, DayOfWeek dayOfWeek, LocalTime time, boolean timeEndOfDay, ZoneOffsetTransitionRule.TimeDefinition timeDefinition, int savingAmountSecs) {
        Objects.requireNonNull(month, "month");
        Objects.requireNonNull(time, "time");
        Objects.requireNonNull(timeDefinition, "timeDefinition");
        ChronoField$.YEAR.checkValidValue(startYear);
        ChronoField$.YEAR.checkValidValue(endYear);
        if (dayOfMonthIndicator < -28 || dayOfMonthIndicator > 31 || dayOfMonthIndicator == 0) {
            throw new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
        }
        if (timeEndOfDay) {
            LocalTime localTime = time;
            LocalTime localTime2 = LocalTime$.MODULE$.MIDNIGHT();
            if (localTime == null ? localTime2 != null : !((Object)localTime).equals(localTime2)) {
                throw new IllegalArgumentException("Time must be midnight when end of day flag is true");
            }
        }
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("Must add a window before adding a rule");
        }
        TZWindow window = this.windowList.get(this.windowList.size() - 1);
        window.addRule(startYear, endYear, month, dayOfMonthIndicator, dayOfWeek, time, timeEndOfDay, timeDefinition, savingAmountSecs);
        return this;
    }

    public ZoneRules toRules(String zoneId) {
        return this.toRules(zoneId, new HashMap<Object, Object>());
    }

    public ZoneRules toRules(String zoneId, Map<Object, Object> deduplicateMap) {
        Objects.requireNonNull(zoneId, "zoneId");
        this.deduplicateMap = deduplicateMap;
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("No windows have been added to the builder");
        }
        ArrayList<ZoneOffsetTransition> standardTransitionList = new ArrayList<ZoneOffsetTransition>(4);
        ArrayList<ZoneOffsetTransition> transitionList = new ArrayList<ZoneOffsetTransition>(256);
        ArrayList<ZoneOffsetTransitionRule> lastTransitionRuleList = new ArrayList<ZoneOffsetTransitionRule>(2);
        TZWindow firstWindow = this.windowList.get(0);
        ZoneOffset loopStandardOffset = firstWindow.standardOffset();
        int loopSavings = 0;
        if (firstWindow.fixedSavingAmountSecs() != null) {
            loopSavings = Predef$.MODULE$.Integer2int(firstWindow.fixedSavingAmountSecs());
        }
        ZoneOffset firstWallOffset = this.deduplicate(ZoneOffset$.MODULE$.ofTotalSeconds(loopStandardOffset.getTotalSeconds() + loopSavings));
        LocalDateTime loopWindowStart = this.deduplicate(LocalDateTime$.MODULE$.of(Year$.MODULE$.MIN_VALUE(), 1, 1, 0, 0));
        ZoneOffset loopWindowOffset = firstWallOffset;
        for (TZWindow window : this.windowList) {
            window.tidy(loopWindowStart.getYear());
            Integer effectiveSavings = window.fixedSavingAmountSecs();
            if (effectiveSavings == null) {
                effectiveSavings = Predef$.MODULE$.int2Integer(0);
                boolean bl = false;
                Iterator<TZRule> rules = window.ruleList().iterator();
                while (!bl && rules.hasNext()) {
                    TZRule rule = rules.next();
                    ZoneOffsetTransition trans = rule.toTransition(loopStandardOffset, loopSavings);
                    if (trans.toEpochSecond() > loopWindowStart.toEpochSecond(loopWindowOffset)) {
                        bl = true;
                    }
                    if (bl) continue;
                    effectiveSavings = Predef$.MODULE$.int2Integer(rule.savingAmountSecs());
                }
            }
            ZoneOffset zoneOffset = loopStandardOffset;
            ZoneOffset zoneOffset2 = window.standardOffset();
            if (zoneOffset == null ? zoneOffset2 != null : !((Object)zoneOffset).equals(zoneOffset2)) {
                standardTransitionList.add(this.deduplicate(new ZoneOffsetTransition(LocalDateTime$.MODULE$.ofEpochSecond(loopWindowStart.toEpochSecond(loopWindowOffset), 0, loopStandardOffset), loopStandardOffset, window.standardOffset())));
                loopStandardOffset = this.deduplicate(window.standardOffset());
            }
            ZoneOffset effectiveWallOffset = this.deduplicate(ZoneOffset$.MODULE$.ofTotalSeconds(loopStandardOffset.getTotalSeconds() + Predef$.MODULE$.Integer2int(effectiveSavings)));
            ZoneOffset zoneOffset3 = loopWindowOffset;
            ZoneOffset zoneOffset4 = effectiveWallOffset;
            if (zoneOffset3 == null ? zoneOffset4 != null : !((Object)zoneOffset3).equals(zoneOffset4)) {
                ZoneOffsetTransition trans = this.deduplicate(new ZoneOffsetTransition(loopWindowStart, loopWindowOffset, effectiveWallOffset));
                transitionList.add(trans);
            }
            loopSavings = Predef$.MODULE$.Integer2int(effectiveSavings);
            for (TZRule rule : window.ruleList()) {
                ZoneOffsetTransition trans = this.deduplicate(rule.toTransition(loopStandardOffset, loopSavings));
                if (trans.toEpochSecond() < loopWindowStart.toEpochSecond(loopWindowOffset) || trans.toEpochSecond() >= window.createDateTimeEpochSecond(loopSavings)) continue;
                ZoneOffset zoneOffset5 = trans.getOffsetBefore();
                ZoneOffset zoneOffset6 = trans.getOffsetAfter();
                if (!(zoneOffset5 == null ? zoneOffset6 != null : !((Object)zoneOffset5).equals(zoneOffset6))) continue;
                transitionList.add(trans);
                loopSavings = rule.savingAmountSecs();
            }
            for (TZRule lastRule : window.lastRuleList()) {
                ZoneOffsetTransitionRule transitionRule = this.deduplicate(lastRule.toTransitionRule(loopStandardOffset, loopSavings));
                lastTransitionRuleList.add(transitionRule);
                loopSavings = lastRule.savingAmountSecs();
            }
            loopWindowOffset = this.deduplicate(window.createWallOffset(loopSavings));
            loopWindowStart = this.deduplicate(LocalDateTime$.MODULE$.ofEpochSecond(window.createDateTimeEpochSecond(loopSavings), 0, loopWindowOffset));
        }
        return StandardZoneRules$.MODULE$.apply(firstWindow.standardOffset(), firstWallOffset, standardTransitionList, transitionList, lastTransitionRuleList);
    }

    public <T> T deduplicate(T object) {
        if (!this.deduplicateMap.containsKey(object)) {
            this.deduplicateMap.put(object, object);
        }
        return (T)this.deduplicateMap.get(object);
    }

    public class TZRule {
        private int year;
        private Month month;
        private int dayOfMonthIndicator;
        private DayOfWeek dayOfWeek;
        private LocalTime time;
        private boolean timeEndOfDay;
        private ZoneOffsetTransitionRule.TimeDefinition timeDefinition;
        private int savingAmountSecs;
        private final /* synthetic */ ZoneRulesBuilder $outer;

        public TZRule(ZoneRulesBuilder $outer, int year, Month month, int dayOfMonthIndicator, DayOfWeek dayOfWeek, LocalTime time, boolean timeEndOfDay, ZoneOffsetTransitionRule.TimeDefinition timeDefinition, int savingAmountSecs) {
            this.year = year;
            this.month = month;
            this.dayOfMonthIndicator = dayOfMonthIndicator;
            this.dayOfWeek = dayOfWeek;
            this.time = time;
            this.timeEndOfDay = timeEndOfDay;
            this.timeDefinition = timeDefinition;
            this.savingAmountSecs = savingAmountSecs;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int year() {
            return this.year;
        }

        public void year_$eq(int x$1) {
            this.year = x$1;
        }

        public Month month() {
            return this.month;
        }

        public void month_$eq(Month x$1) {
            this.month = x$1;
        }

        public int dayOfMonthIndicator() {
            return this.dayOfMonthIndicator;
        }

        public void dayOfMonthIndicator_$eq(int x$1) {
            this.dayOfMonthIndicator = x$1;
        }

        public DayOfWeek dayOfWeek() {
            return this.dayOfWeek;
        }

        public void dayOfWeek_$eq(DayOfWeek x$1) {
            this.dayOfWeek = x$1;
        }

        public LocalTime time() {
            return this.time;
        }

        public void time_$eq(LocalTime x$1) {
            this.time = x$1;
        }

        public boolean timeEndOfDay() {
            return this.timeEndOfDay;
        }

        public void timeEndOfDay_$eq(boolean x$1) {
            this.timeEndOfDay = x$1;
        }

        public ZoneOffsetTransitionRule.TimeDefinition timeDefinition() {
            return this.timeDefinition;
        }

        public void timeDefinition_$eq(ZoneOffsetTransitionRule.TimeDefinition x$1) {
            this.timeDefinition = x$1;
        }

        public int savingAmountSecs() {
            return this.savingAmountSecs;
        }

        public void savingAmountSecs_$eq(int x$1) {
            this.savingAmountSecs = x$1;
        }

        public ZoneOffsetTransition toTransition(ZoneOffset standardOffset, int savingsBeforeSecs) {
            LocalDate date = this.toLocalDate();
            date = this.$outer.deduplicate(date);
            LocalDateTime ldt = this.$outer.deduplicate(LocalDateTime$.MODULE$.of(date, this.time()));
            ZoneOffset wallOffset = this.$outer.deduplicate(ZoneOffset$.MODULE$.ofTotalSeconds(standardOffset.getTotalSeconds() + savingsBeforeSecs));
            LocalDateTime dt = this.$outer.deduplicate(this.timeDefinition().createDateTime(ldt, standardOffset, wallOffset));
            ZoneOffset offsetAfter = this.$outer.deduplicate(ZoneOffset$.MODULE$.ofTotalSeconds(standardOffset.getTotalSeconds() + this.savingAmountSecs()));
            return new ZoneOffsetTransition(dt, wallOffset, offsetAfter);
        }

        public ZoneOffsetTransitionRule toTransitionRule(ZoneOffset standardOffset, int savingsBeforeSecs) {
            if (this.dayOfMonthIndicator() < 0 && this.month() != Month$.FEBRUARY) {
                this.dayOfMonthIndicator_$eq(this.month().maxLength() - 6);
            }
            if (this.timeEndOfDay() && this.dayOfMonthIndicator() > 0 && (this.dayOfMonthIndicator() != 28 || this.month() != Month$.FEBRUARY)) {
                LocalDate date = LocalDate$.MODULE$.of(2004, this.month(), this.dayOfMonthIndicator()).plusDays(1L);
                this.month_$eq(date.getMonth());
                this.dayOfMonthIndicator_$eq(date.getDayOfMonth());
                if (this.dayOfWeek() != null) {
                    this.dayOfWeek_$eq(this.dayOfWeek().plus(1L));
                }
                this.timeEndOfDay_$eq(false);
            }
            ZoneOffsetTransition trans = this.toTransition(standardOffset, savingsBeforeSecs);
            return new ZoneOffsetTransitionRule(this.month(), this.dayOfMonthIndicator(), this.dayOfWeek(), this.time(), this.timeEndOfDay(), this.timeDefinition(), standardOffset, trans.getOffsetBefore(), trans.getOffsetAfter());
        }

        public LocalDate toLocalDate() {
            LocalDate date = null;
            if (this.dayOfMonthIndicator() < 0) {
                int monthLen = this.month().length(IsoChronology$.MODULE$.INSTANCE().isLeapYear(this.year()));
                date = LocalDate$.MODULE$.of(this.year(), this.month(), monthLen + 1 + this.dayOfMonthIndicator());
                if (this.dayOfWeek() != null) {
                    date = date.with(TemporalAdjusters$.MODULE$.previousOrSame(this.dayOfWeek()));
                }
            } else {
                date = LocalDate$.MODULE$.of(this.year(), this.month(), this.dayOfMonthIndicator());
                if (this.dayOfWeek() != null) {
                    date = date.with(TemporalAdjusters$.MODULE$.nextOrSame(this.dayOfWeek()));
                }
            }
            if (this.timeEndOfDay()) {
                date = date.plusDays(1L);
            }
            return date;
        }

        public final /* synthetic */ ZoneRulesBuilder java$time$zone$ZoneRulesBuilder$TZRule$$$outer() {
            return this.$outer;
        }
    }

    public class TZRuleComparator
    implements Comparator<TZRule> {
        public TZRuleComparator() {
            if (ZoneRulesBuilder.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public int compare(TZRule that, TZRule other) {
            int cmp = that.year() - other.year();
            int n = cmp = cmp == 0 ? that.month().compareTo(other.month()) : cmp;
            if (cmp == 0) {
                LocalDate thisDate = that.toLocalDate();
                LocalDate otherDate = other.toLocalDate();
                cmp = thisDate.compareTo(otherDate);
            }
            cmp = cmp == 0 ? that.time().compareTo(other.time()) : cmp;
            return cmp;
        }

        public final /* synthetic */ ZoneRulesBuilder java$time$zone$ZoneRulesBuilder$TZRuleComparator$$$outer() {
            return ZoneRulesBuilder.this;
        }
    }

    public class TZWindow {
        private final ZoneOffset standardOffset;
        private final LocalDateTime windowEnd;
        private final ZoneOffsetTransitionRule.TimeDefinition timeDefinition;
        private Integer fixedSavingAmountSecs;
        private List ruleList;
        private int maxLastRuleStartYear;
        private List lastRuleList;
        private final /* synthetic */ ZoneRulesBuilder $outer;

        public TZWindow(ZoneRulesBuilder $outer, ZoneOffset standardOffset, LocalDateTime windowEnd, ZoneOffsetTransitionRule.TimeDefinition timeDefinition) {
            this.standardOffset = standardOffset;
            this.windowEnd = windowEnd;
            this.timeDefinition = timeDefinition;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.fixedSavingAmountSecs = null;
            this.ruleList = new ArrayList();
            this.maxLastRuleStartYear = Year$.MODULE$.MIN_VALUE();
            this.lastRuleList = new ArrayList();
        }

        public ZoneOffset standardOffset() {
            return this.standardOffset;
        }

        private LocalDateTime windowEnd() {
            return this.windowEnd;
        }

        private ZoneOffsetTransitionRule.TimeDefinition timeDefinition() {
            return this.timeDefinition;
        }

        public Integer fixedSavingAmountSecs() {
            return this.fixedSavingAmountSecs;
        }

        public void fixedSavingAmountSecs_$eq(Integer x$1) {
            this.fixedSavingAmountSecs = x$1;
        }

        public List<TZRule> ruleList() {
            return this.ruleList;
        }

        public void ruleList_$eq(List<TZRule> x$1) {
            this.ruleList = x$1;
        }

        public List<TZRule> lastRuleList() {
            return this.lastRuleList;
        }

        public void lastRuleList_$eq(List<TZRule> x$1) {
            this.lastRuleList = x$1;
        }

        public void setFixedSavings(int fixedSavingAmount) {
            if (this.ruleList().size() > 0 || this.lastRuleList().size() > 0) {
                throw new IllegalStateException("Window has DST rules, so cannot have fixed savings");
            }
            this.fixedSavingAmountSecs_$eq(Predef$.MODULE$.int2Integer(fixedSavingAmount));
        }

        public void addRule(int startYear, int endYear, Month month, int dayOfMonthIndicator, DayOfWeek dayOfWeek, LocalTime time, boolean timeEndOfDay, ZoneOffsetTransitionRule.TimeDefinition timeDefinition, int savingAmountSecs) {
            int _endYear = endYear;
            if (this.fixedSavingAmountSecs() != null) {
                throw new IllegalStateException("Window has a fixed DST saving, so cannot have DST rules");
            }
            if (this.ruleList().size() >= 2000) {
                throw new IllegalStateException("Window has reached the maximum number of allowed rules");
            }
            boolean lastRule = false;
            if (_endYear == Year$.MODULE$.MAX_VALUE()) {
                lastRule = true;
                _endYear = startYear;
            }
            for (int year = startYear; year <= _endYear; ++year) {
                Boolean bl;
                TZRule rule = new TZRule(this.$outer, year, month, dayOfMonthIndicator, dayOfWeek, time, timeEndOfDay, timeDefinition, savingAmountSecs);
                if (lastRule) {
                    this.lastRuleList().add(rule);
                    this.maxLastRuleStartYear = Math.max(startYear, this.maxLastRuleStartYear);
                    bl = BoxedUnit.UNIT;
                    continue;
                }
                bl = BoxesRunTime.boxToBoolean((boolean)this.ruleList().add(rule));
            }
        }

        public void validateWindowOrder(TZWindow previous) {
            if (this.windowEnd().isBefore(previous.windowEnd())) {
                throw new IllegalStateException(new StringBuilder(45).append("Windows must be added in date-time order: ").append(this.windowEnd()).append(" < ").append(previous.windowEnd()).toString());
            }
        }

        public void tidy(int windowStartYear) {
            if (this.lastRuleList().size() == 1) {
                throw new IllegalStateException("Cannot have only one rule defined as being forever");
            }
            LocalDateTime localDateTime = this.windowEnd();
            LocalDateTime localDateTime2 = LocalDateTime$.MODULE$.MAX();
            if (!(localDateTime != null ? !((Object)localDateTime).equals(localDateTime2) : localDateTime2 != null)) {
                this.maxLastRuleStartYear = Math.max(this.maxLastRuleStartYear, windowStartYear) + 1;
                for (TZRule lastRule : this.lastRuleList()) {
                    this.addRule(lastRule.year(), this.maxLastRuleStartYear, lastRule.month(), lastRule.dayOfMonthIndicator(), lastRule.dayOfWeek(), lastRule.time(), lastRule.timeEndOfDay(), lastRule.timeDefinition(), lastRule.savingAmountSecs());
                    lastRule.year_$eq(this.maxLastRuleStartYear + 1);
                }
                if (this.maxLastRuleStartYear == Year$.MODULE$.MAX_VALUE()) {
                    this.lastRuleList().clear();
                } else {
                    ++this.maxLastRuleStartYear;
                }
            } else {
                int endYear = this.windowEnd().getYear();
                for (TZRule lastRule : this.lastRuleList()) {
                    this.addRule(lastRule.year(), endYear + 1, lastRule.month(), lastRule.dayOfMonthIndicator(), lastRule.dayOfWeek(), lastRule.time(), lastRule.timeEndOfDay(), lastRule.timeDefinition(), lastRule.savingAmountSecs());
                }
                this.lastRuleList().clear();
                this.maxLastRuleStartYear = Year$.MODULE$.MAX_VALUE();
            }
            Collections.sort(this.ruleList(), this.$outer.java$time$zone$ZoneRulesBuilder$$ruleComparator);
            Collections.sort(this.lastRuleList(), this.$outer.java$time$zone$ZoneRulesBuilder$$ruleComparator);
            if (this.ruleList().size() == 0 && this.fixedSavingAmountSecs() == null) {
                this.fixedSavingAmountSecs_$eq(Predef$.MODULE$.int2Integer(0));
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isSingleWindowStandardOffset() {
            LocalDateTime localDateTime = this.windowEnd();
            LocalDateTime localDateTime2 = LocalDateTime$.MODULE$.MAX();
            if (localDateTime == null) {
                if (localDateTime2 != null) {
                    return false;
                }
            } else if (!((Object)localDateTime).equals(localDateTime2)) return false;
            if (this.timeDefinition() != ZoneOffsetTransitionRule$TimeDefinition$.WALL) return false;
            if (this.fixedSavingAmountSecs() != null) return false;
            if (!this.lastRuleList().isEmpty()) return false;
            if (!this.ruleList().isEmpty()) return false;
            return true;
        }

        public ZoneOffset createWallOffset(int savingsSecs) {
            return ZoneOffset$.MODULE$.ofTotalSeconds(this.standardOffset().getTotalSeconds() + savingsSecs);
        }

        public long createDateTimeEpochSecond(int savingsSecs) {
            ZoneOffset wallOffset = this.createWallOffset(savingsSecs);
            LocalDateTime ldt = this.timeDefinition().createDateTime(this.windowEnd(), this.standardOffset(), wallOffset);
            return ldt.toEpochSecond(wallOffset);
        }

        public final /* synthetic */ ZoneRulesBuilder java$time$zone$ZoneRulesBuilder$TZWindow$$$outer() {
            return this.$outer;
        }
    }
}

