/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.Serializable;
import java.time.Duration;
import java.time.Duration$;
import java.time.Instant;
import java.time.Instant$;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.zone.StandardZoneRules;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules$;
import java.util.Collections;
import java.util.List;

public abstract class ZoneRules {
    public static ZoneRules of(ZoneOffset zoneOffset) {
        return ZoneRules$.MODULE$.of(zoneOffset);
    }

    public static ZoneRules of(ZoneOffset zoneOffset, ZoneOffset zoneOffset2, List<ZoneOffsetTransition> list, List<ZoneOffsetTransition> list2, List<ZoneOffsetTransitionRule> list3) {
        return ZoneRules$.MODULE$.of(zoneOffset, zoneOffset2, list, list2, list3);
    }

    public abstract boolean isFixedOffset();

    public abstract ZoneOffset getOffset(Instant var1);

    public abstract ZoneOffset getOffset(LocalDateTime var1);

    public abstract List<ZoneOffset> getValidOffsets(LocalDateTime var1);

    public abstract ZoneOffsetTransition getTransition(LocalDateTime var1);

    public abstract ZoneOffset getStandardOffset(Instant var1);

    public abstract Duration getDaylightSavings(Instant var1);

    public abstract boolean isDaylightSavings(Instant var1);

    public abstract boolean isValidOffset(LocalDateTime var1, ZoneOffset var2);

    public abstract ZoneOffsetTransition nextTransition(Instant var1);

    public abstract ZoneOffsetTransition previousTransition(Instant var1);

    public abstract List<ZoneOffsetTransition> getTransitions();

    public abstract List<ZoneOffsetTransitionRule> getTransitionRules();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static final class Fixed
    extends ZoneRules
    implements Serializable {
        private static final long serialVersionUID = -8733721350312276297L;
        private final ZoneOffset offset;

        public Fixed(ZoneOffset offset) {
            this.offset = offset;
        }

        private ZoneOffset offset() {
            return this.offset;
        }

        @Override
        public boolean isFixedOffset() {
            return true;
        }

        @Override
        public ZoneOffset getOffset(Instant instant) {
            return this.offset();
        }

        @Override
        public ZoneOffset getOffset(LocalDateTime localDateTime) {
            return this.offset();
        }

        @Override
        public List<ZoneOffset> getValidOffsets(LocalDateTime localDateTime) {
            return Collections.singletonList(this.offset());
        }

        @Override
        public ZoneOffsetTransition getTransition(LocalDateTime localDateTime) {
            return null;
        }

        @Override
        public boolean isValidOffset(LocalDateTime dateTime, ZoneOffset offset) {
            ZoneOffset zoneOffset = this.offset();
            ZoneOffset zoneOffset2 = offset;
            return !(zoneOffset != null ? !((Object)zoneOffset).equals(zoneOffset2) : zoneOffset2 != null);
        }

        @Override
        public ZoneOffset getStandardOffset(Instant instant) {
            return this.offset();
        }

        @Override
        public Duration getDaylightSavings(Instant instant) {
            return Duration$.MODULE$.ZERO();
        }

        @Override
        public boolean isDaylightSavings(Instant instant) {
            return false;
        }

        @Override
        public ZoneOffsetTransition nextTransition(Instant instant) {
            return null;
        }

        @Override
        public ZoneOffsetTransition previousTransition(Instant instant) {
            return null;
        }

        @Override
        public List<ZoneOffsetTransition> getTransitions() {
            return Collections.emptyList();
        }

        @Override
        public List<ZoneOffsetTransitionRule> getTransitionRules() {
            return Collections.emptyList();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof Fixed) {
                Fixed fixed = (Fixed)object;
                if (this == fixed) return true;
                ZoneOffset zoneOffset = this.offset();
                ZoneOffset zoneOffset2 = fixed.offset();
                if (zoneOffset != null) {
                    if (!((Object)zoneOffset).equals(zoneOffset2)) return false;
                    return true;
                }
                if (zoneOffset2 == null) return true;
                return false;
            }
            if (!(object instanceof StandardZoneRules)) return false;
            StandardZoneRules rules = (StandardZoneRules)object;
            if (!rules.isFixedOffset()) return false;
            ZoneOffset zoneOffset = this.offset();
            ZoneOffset zoneOffset3 = rules.getOffset(Instant$.MODULE$.EPOCH());
            if (zoneOffset != null) {
                if (!((Object)zoneOffset).equals(zoneOffset3)) return false;
                return true;
            }
            if (zoneOffset3 == null) return true;
            return false;
        }

        @Override
        public int hashCode() {
            return 1 ^ 31 + this.offset().hashCode() ^ 1 ^ 31 + this.offset().hashCode() ^ 1;
        }

        public String toString() {
            return new StringBuilder(11).append("FixedRules:").append(this.offset()).toString();
        }
    }
}

