/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.LocalDateTime;
import java.time.LocalDateTime$;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.ZoneOffset$;
import java.time.chrono.IsoChronology$;
import java.time.temporal.TemporalAdjusters$;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule$;
import java.time.zone.ZoneOffsetTransitionRule$TimeDefinition$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Enum;

public final class ZoneOffsetTransitionRule
implements Serializable {
    private static final long serialVersionUID = 6889046316657758795L;
    private final Month month;
    private final DayOfWeek dayOfWeek;
    private final LocalTime time;
    private final boolean timeEndOfDay;
    private final TimeDefinition timeDefinition;
    private final ZoneOffset standardOffset;
    private final ZoneOffset offsetBefore;
    private final ZoneOffset offsetAfter;
    private final byte dom;

    public static ZoneOffsetTransitionRule of(Month month, int n, DayOfWeek dayOfWeek, LocalTime localTime, boolean bl, TimeDefinition timeDefinition, ZoneOffset zoneOffset, ZoneOffset zoneOffset2, ZoneOffset zoneOffset3) {
        return ZoneOffsetTransitionRule$.MODULE$.of(month, n, dayOfWeek, localTime, bl, timeDefinition, zoneOffset, zoneOffset2, zoneOffset3);
    }

    public static ZoneOffsetTransitionRule readExternal(DataInput dataInput) throws IOException {
        return ZoneOffsetTransitionRule$.MODULE$.readExternal(dataInput);
    }

    public ZoneOffsetTransitionRule(Month month, int dayOfMonthIndicator, DayOfWeek dayOfWeek, LocalTime time, boolean timeEndOfDay, TimeDefinition timeDefinition, ZoneOffset standardOffset, ZoneOffset offsetBefore, ZoneOffset offsetAfter) {
        this.month = month;
        this.dayOfWeek = dayOfWeek;
        this.time = time;
        this.timeEndOfDay = timeEndOfDay;
        this.timeDefinition = timeDefinition;
        this.standardOffset = standardOffset;
        this.offsetBefore = offsetBefore;
        this.offsetAfter = offsetAfter;
        this.dom = (byte)dayOfMonthIndicator;
    }

    private Month month() {
        return this.month;
    }

    private DayOfWeek dayOfWeek() {
        return this.dayOfWeek;
    }

    private LocalTime time() {
        return this.time;
    }

    private boolean timeEndOfDay() {
        return this.timeEndOfDay;
    }

    private TimeDefinition timeDefinition() {
        return this.timeDefinition;
    }

    private ZoneOffset standardOffset() {
        return this.standardOffset;
    }

    private ZoneOffset offsetBefore() {
        return this.offsetBefore;
    }

    private ZoneOffset offsetAfter() {
        return this.offsetAfter;
    }

    private byte dom() {
        return this.dom;
    }

    public Month getMonth() {
        return this.month();
    }

    public int getDayOfMonthIndicator() {
        return this.dom();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek();
    }

    public LocalTime getLocalTime() {
        return this.time();
    }

    public boolean isMidnightEndOfDay() {
        return this.timeEndOfDay();
    }

    public TimeDefinition getTimeDefinition() {
        return this.timeDefinition();
    }

    public ZoneOffset getStandardOffset() {
        return this.standardOffset();
    }

    public ZoneOffset getOffsetBefore() {
        return this.offsetBefore();
    }

    public ZoneOffset getOffsetAfter() {
        return this.offsetAfter();
    }

    public ZoneOffsetTransition createTransition(int year) {
        LocalDate date = null;
        if (this.dom() < 0) {
            date = LocalDate$.MODULE$.of(year, this.month(), this.month().length(IsoChronology$.MODULE$.INSTANCE().isLeapYear(year)) + 1 + this.dom());
            if (this.dayOfWeek() != null) {
                date = date.with(TemporalAdjusters$.MODULE$.previousOrSame(this.dayOfWeek()));
            }
        } else {
            date = LocalDate$.MODULE$.of(year, this.month(), (int)this.dom());
            if (this.dayOfWeek() != null) {
                date = date.with(TemporalAdjusters$.MODULE$.nextOrSame(this.dayOfWeek()));
            }
        }
        if (this.timeEndOfDay()) {
            date = date.plusDays(1L);
        }
        LocalDateTime localDT = LocalDateTime$.MODULE$.of(date, this.time());
        LocalDateTime transition = this.timeDefinition().createDateTime(localDT, this.standardOffset(), this.offsetBefore());
        return new ZoneOffsetTransition(transition, this.offsetBefore(), this.offsetAfter());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object otherRule) {
        Object object = otherRule;
        if (!(object instanceof ZoneOffsetTransitionRule)) return false;
        ZoneOffsetTransitionRule other = (ZoneOffsetTransitionRule)object;
        if (this == other) return true;
        if (this.month() != other.month()) return false;
        if (this.dom() != other.dom()) return false;
        if (this.dayOfWeek() != other.dayOfWeek()) return false;
        if (this.timeDefinition() != other.timeDefinition()) return false;
        LocalTime localTime = this.time();
        LocalTime localTime2 = other.time();
        if (localTime == null) {
            if (localTime2 != null) {
                return false;
            }
        } else if (!((Object)localTime).equals(localTime2)) return false;
        if (this.timeEndOfDay() != other.timeEndOfDay()) return false;
        ZoneOffset zoneOffset = this.standardOffset();
        ZoneOffset zoneOffset2 = other.standardOffset();
        if (zoneOffset == null) {
            if (zoneOffset2 != null) {
                return false;
            }
        } else if (!((Object)zoneOffset).equals(zoneOffset2)) return false;
        ZoneOffset zoneOffset3 = this.offsetBefore();
        ZoneOffset zoneOffset4 = other.offsetBefore();
        if (zoneOffset3 == null) {
            if (zoneOffset4 != null) {
                return false;
            }
        } else if (!((Object)zoneOffset3).equals(zoneOffset4)) return false;
        ZoneOffset zoneOffset5 = this.offsetAfter();
        ZoneOffset zoneOffset6 = other.offsetAfter();
        if (zoneOffset5 == null) {
            if (zoneOffset6 == null) return true;
            return false;
        } else {
            if (!((Object)zoneOffset5).equals(zoneOffset6)) return false;
            return true;
        }
    }

    public int hashCode() {
        int hash = (this.time().toSecondOfDay() + (this.timeEndOfDay() ? 1 : 0) << 15) + (this.month().ordinal() << 11) + (this.dom() + 32 << 5) + ((this.dayOfWeek() == null ? 7 : this.dayOfWeek().ordinal()) << 2) + this.timeDefinition().ordinal();
        return hash ^ this.standardOffset().hashCode() ^ this.offsetBefore().hashCode() ^ this.offsetAfter().hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("TransitionRule[").append(this.offsetBefore().compareTo(this.offsetAfter()) > 0 ? "Gap " : "Overlap ").append((Object)this.offsetBefore()).append(" to ").append((Object)this.offsetAfter()).append(", ");
        StringBuilder stringBuilder = this.dayOfWeek() != null ? (this.dom() == -1 ? buf.append(this.dayOfWeek().name()).append(" on or before last day of ").append(this.month().name()) : (this.dom() < 0 ? buf.append(this.dayOfWeek().name()).append(" on or before last day minus ").append(-this.dom() - 1).append(" of ").append(this.month().name()) : buf.append(this.dayOfWeek().name()).append(" on or after ").append(this.month().name()).append(' ').append(this.dom()))) : buf.append(this.month().name()).append(' ').append(this.dom());
        buf.append(" at ").append(this.timeEndOfDay() ? "24:00" : this.time().toString()).append(" ").append((Object)this.timeDefinition()).append(", standard offset ").append((Object)this.standardOffset()).append(']');
        return buf.toString();
    }

    public static abstract class TimeDefinition
    extends java.lang.Enum<TimeDefinition>
    implements Enum {
        public static TimeDefinition fromOrdinal(int n) {
            return ZoneOffsetTransitionRule$TimeDefinition$.MODULE$.fromOrdinal(n);
        }

        public static TimeDefinition valueOf(String string) {
            return ZoneOffsetTransitionRule$TimeDefinition$.MODULE$.valueOf(string);
        }

        public static TimeDefinition[] values() {
            return ZoneOffsetTransitionRule$TimeDefinition$.MODULE$.values();
        }

        public TimeDefinition(String _$name, int _$ordinal) {
        }

        public static TimeDefinition UTC() {
            return ZoneOffsetTransitionRule$TimeDefinition$.UTC;
        }

        public static TimeDefinition WALL() {
            return ZoneOffsetTransitionRule$TimeDefinition$.WALL;
        }

        public static TimeDefinition STANDARD() {
            return ZoneOffsetTransitionRule$TimeDefinition$.STANDARD;
        }

        public LocalDateTime createDateTime(LocalDateTime dateTime, ZoneOffset standardOffset, ZoneOffset wallOffset) {
            TimeDefinition timeDefinition = this;
            TimeDefinition timeDefinition2 = ZoneOffsetTransitionRule$TimeDefinition$.UTC;
            TimeDefinition timeDefinition3 = timeDefinition;
            if (!(timeDefinition2 != null ? !((Object)((Object)timeDefinition2)).equals((Object)timeDefinition3) : timeDefinition3 != null)) {
                int difference = wallOffset.getTotalSeconds() - ZoneOffset$.MODULE$.UTC().getTotalSeconds();
                return dateTime.plusSeconds(difference);
            }
            TimeDefinition timeDefinition4 = ZoneOffsetTransitionRule$TimeDefinition$.STANDARD;
            TimeDefinition timeDefinition5 = timeDefinition;
            if (!(timeDefinition4 != null ? !((Object)((Object)timeDefinition4)).equals((Object)timeDefinition5) : timeDefinition5 != null)) {
                int difference = wallOffset.getTotalSeconds() - standardOffset.getTotalSeconds();
                return dateTime.plusSeconds(difference);
            }
            return dateTime;
        }
    }
}

