/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.DayOfWeek$;
import java.time.LocalTime;
import java.time.LocalTime$;
import java.time.Month;
import java.time.Month$;
import java.time.ZoneOffset;
import java.time.ZoneOffset$;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneOffsetTransitionRule$TimeDefinition$;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class ZoneOffsetTransitionRule$
implements Serializable {
    public static final ZoneOffsetTransitionRule$TimeDefinition$ TimeDefinition;
    public static final ZoneOffsetTransitionRule$ MODULE$;

    private ZoneOffsetTransitionRule$() {
    }

    static {
        MODULE$ = new ZoneOffsetTransitionRule$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ZoneOffsetTransitionRule$.class);
    }

    public ZoneOffsetTransitionRule of(Month month, int dayOfMonthIndicator, DayOfWeek dayOfWeek, LocalTime time, boolean timeEndOfDay, ZoneOffsetTransitionRule.TimeDefinition timeDefnition, ZoneOffset standardOffset, ZoneOffset offsetBefore, ZoneOffset offsetAfter) {
        Objects.requireNonNull(month, "month");
        Objects.requireNonNull(time, "time");
        Objects.requireNonNull(timeDefnition, "timeDefnition");
        Objects.requireNonNull(standardOffset, "standardOffset");
        Objects.requireNonNull(offsetBefore, "offsetBefore");
        Objects.requireNonNull(offsetAfter, "offsetAfter");
        if (dayOfMonthIndicator < -28 || dayOfMonthIndicator > 31 || dayOfMonthIndicator == 0) {
            throw new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
        }
        if (timeEndOfDay) {
            LocalTime localTime = time;
            LocalTime localTime2 = LocalTime$.MODULE$.MIDNIGHT();
            if (localTime == null ? localTime2 != null : !((Object)localTime).equals(localTime2)) {
                throw new IllegalArgumentException("Time must be midnight when end of day flag is true");
            }
        }
        return new ZoneOffsetTransitionRule(month, dayOfMonthIndicator, dayOfWeek, time, timeEndOfDay, timeDefnition, standardOffset, offsetBefore, offsetAfter);
    }

    public ZoneOffsetTransitionRule readExternal(DataInput in) throws IOException {
        int data = in.readInt();
        Month month = Month$.MODULE$.of(data >>> 28);
        int dom = ((data & 0xFC00000) >>> 22) - 32;
        int dowByte = (data & 0x380000) >>> 19;
        DayOfWeek dow = dowByte == 0 ? null : DayOfWeek$.MODULE$.of(dowByte);
        int timeByte = (data & 0x7C000) >>> 14;
        ZoneOffsetTransitionRule.TimeDefinition defn = ZoneOffsetTransitionRule$TimeDefinition$.MODULE$.values()[(data & 0x3000) >>> 12];
        int stdByte = (data & 0xFF0) >>> 4;
        int beforeByte = (data & 0xC) >>> 2;
        int afterByte = data & 3;
        LocalTime time = timeByte == 31 ? LocalTime$.MODULE$.ofSecondOfDay(in.readInt()) : LocalTime$.MODULE$.of(timeByte % 24, 0);
        ZoneOffset std = stdByte == 255 ? ZoneOffset$.MODULE$.ofTotalSeconds(in.readInt()) : ZoneOffset$.MODULE$.ofTotalSeconds((stdByte - 128) * 900);
        ZoneOffset before = beforeByte == 3 ? ZoneOffset$.MODULE$.ofTotalSeconds(in.readInt()) : ZoneOffset$.MODULE$.ofTotalSeconds(std.getTotalSeconds() + beforeByte * 1800);
        ZoneOffset after = afterByte == 3 ? ZoneOffset$.MODULE$.ofTotalSeconds(in.readInt()) : ZoneOffset$.MODULE$.ofTotalSeconds(std.getTotalSeconds() + afterByte * 1800);
        return this.of(month, dom, dow, time, timeByte == 24, defn, std, before, after);
    }
}

