/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.Serializable;
import java.time.Duration;
import java.time.Duration$;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalDateTime$;
import java.time.ZoneOffset;
import java.time.zone.ZoneOffsetTransition$;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordered;

public final class ZoneOffsetTransition
implements Ordered<ZoneOffsetTransition>,
Serializable {
    private final LocalDateTime transition;
    private final ZoneOffset offsetBefore;
    private final ZoneOffset offsetAfter;

    public static ZoneOffsetTransition of(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneOffset zoneOffset2) {
        return ZoneOffsetTransition$.MODULE$.of(localDateTime, zoneOffset, zoneOffset2);
    }

    public ZoneOffsetTransition(LocalDateTime transition, ZoneOffset offsetBefore, ZoneOffset offsetAfter) {
        this.transition = transition;
        this.offsetBefore = offsetBefore;
        this.offsetAfter = offsetAfter;
        Ordered.$init$((Ordered)this);
    }

    private LocalDateTime transition() {
        return this.transition;
    }

    private ZoneOffset offsetBefore() {
        return this.offsetBefore;
    }

    private ZoneOffset offsetAfter() {
        return this.offsetAfter;
    }

    public ZoneOffsetTransition(long epochSecond, ZoneOffset offsetBefore, ZoneOffset offsetAfter) {
        this(LocalDateTime$.MODULE$.ofEpochSecond(epochSecond, 0, offsetBefore), offsetBefore, offsetAfter);
    }

    public Instant getInstant() {
        return this.transition().toInstant(this.offsetBefore());
    }

    public long toEpochSecond() {
        return this.transition().toEpochSecond(this.offsetBefore());
    }

    public LocalDateTime getDateTimeBefore() {
        return this.transition();
    }

    public LocalDateTime getDateTimeAfter() {
        return this.transition().plusSeconds(this.getDurationSeconds());
    }

    public ZoneOffset getOffsetBefore() {
        return this.offsetBefore();
    }

    public ZoneOffset getOffsetAfter() {
        return this.offsetAfter();
    }

    public Duration getDuration() {
        return Duration$.MODULE$.ofSeconds(this.getDurationSeconds());
    }

    private int getDurationSeconds() {
        return this.getOffsetAfter().getTotalSeconds() - this.getOffsetBefore().getTotalSeconds();
    }

    public boolean isGap() {
        return this.getOffsetAfter().getTotalSeconds() > this.getOffsetBefore().getTotalSeconds();
    }

    public boolean isOverlap() {
        return this.getOffsetAfter().getTotalSeconds() < this.getOffsetBefore().getTotalSeconds();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidOffset(ZoneOffset offset) {
        if (this.isGap()) {
            return false;
        }
        ZoneOffset zoneOffset = this.getOffsetBefore();
        ZoneOffset zoneOffset2 = offset;
        if (zoneOffset == null) {
            if (zoneOffset2 == null) return true;
        } else if (((Object)zoneOffset).equals(zoneOffset2)) return true;
        ZoneOffset zoneOffset3 = this.getOffsetAfter();
        ZoneOffset zoneOffset4 = offset;
        if (zoneOffset3 != null) {
            if (!((Object)zoneOffset3).equals(zoneOffset4)) return false;
            return true;
        }
        if (zoneOffset4 == null) return true;
        return false;
    }

    public List<ZoneOffset> getValidOffsets() {
        if (this.isGap()) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.getOffsetBefore(), this.getOffsetAfter());
    }

    public int compare(ZoneOffsetTransition transition) {
        return this.getInstant().compareTo(transition.getInstant());
    }

    public int compareTo(ZoneOffsetTransition other) {
        return this.compare(other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof ZoneOffsetTransition)) return false;
        ZoneOffsetTransition zot = (ZoneOffsetTransition)object;
        if (this == zot) return true;
        LocalDateTime localDateTime = this.transition();
        LocalDateTime localDateTime2 = zot.transition();
        if (localDateTime == null) {
            if (localDateTime2 != null) {
                return false;
            }
        } else if (!((Object)localDateTime).equals(localDateTime2)) return false;
        ZoneOffset zoneOffset = this.offsetBefore();
        ZoneOffset zoneOffset2 = zot.offsetBefore();
        if (zoneOffset == null) {
            if (zoneOffset2 != null) {
                return false;
            }
        } else if (!((Object)zoneOffset).equals(zoneOffset2)) return false;
        ZoneOffset zoneOffset3 = this.offsetAfter();
        ZoneOffset zoneOffset4 = zot.offsetAfter();
        if (zoneOffset3 == null) {
            if (zoneOffset4 == null) return true;
            return false;
        } else {
            if (!((Object)zoneOffset3).equals(zoneOffset4)) return false;
            return true;
        }
    }

    public int hashCode() {
        return this.transition().hashCode() ^ this.offsetBefore().hashCode() ^ Integer.rotateLeft(this.offsetAfter().hashCode(), 16);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Transition[").append(this.isGap() ? "Gap" : "Overlap").append(" at ").append((Object)this.transition()).append((Object)this.offsetBefore()).append(" to ").append((Object)this.offsetAfter()).append(']');
        return buf.toString();
    }
}

