/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.Serializable;
import java.time.Duration;
import java.time.Duration$;
import java.time.Instant;
import java.time.Instant$;
import java.time.LocalDate$;
import java.time.LocalDateTime;
import java.time.Year$;
import java.time.ZoneOffset;
import java.time.zone.StandardZoneRules$;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class StandardZoneRules
extends ZoneRules
implements Serializable {
    private static final long serialVersionUID = 3044319355680032515L;
    private final long[] standardTransitions;
    private final ZoneOffset[] standardOffsets;
    private final long[] savingsInstantTransitions;
    private final ZoneOffset[] wallOffsets;
    private final ZoneOffsetTransitionRule[] lastRules;
    private final LocalDateTime[] savingsLocalTransitions;
    private final Map<Integer, ZoneOffsetTransition[]> lastRulesCache;

    public static StandardZoneRules apply(ZoneOffset zoneOffset, ZoneOffset zoneOffset2, List<ZoneOffsetTransition> list, List<ZoneOffsetTransition> list2, List<ZoneOffsetTransitionRule> list3) {
        return StandardZoneRules$.MODULE$.apply(zoneOffset, zoneOffset2, list, list2, list3);
    }

    public StandardZoneRules(long[] standardTransitions, ZoneOffset[] standardOffsets, long[] savingsInstantTransitions, ZoneOffset[] wallOffsets, ZoneOffsetTransitionRule[] lastRules, LocalDateTime[] savingsLocalTransitions) {
        this.standardTransitions = standardTransitions;
        this.standardOffsets = standardOffsets;
        this.savingsInstantTransitions = savingsInstantTransitions;
        this.wallOffsets = wallOffsets;
        this.lastRules = lastRules;
        this.savingsLocalTransitions = savingsLocalTransitions;
        this.lastRulesCache = new HashMap<Integer, ZoneOffsetTransition[]>();
    }

    private long[] standardTransitions() {
        return this.standardTransitions;
    }

    private ZoneOffset[] standardOffsets() {
        return this.standardOffsets;
    }

    private long[] savingsInstantTransitions() {
        return this.savingsInstantTransitions;
    }

    private ZoneOffset[] wallOffsets() {
        return this.wallOffsets;
    }

    private ZoneOffsetTransitionRule[] lastRules() {
        return this.lastRules;
    }

    private LocalDateTime[] savingsLocalTransitions() {
        return this.savingsLocalTransitions;
    }

    public StandardZoneRules(long[] standardTransitions, ZoneOffset[] standardOffsets, long[] savingsInstantTransitions, ZoneOffset[] wallOffsets, ZoneOffsetTransitionRule[] lastRules) {
        ArrayList<LocalDateTime> localTransitionList = new ArrayList<LocalDateTime>();
        for (int i = 0; i < savingsInstantTransitions.length; ++i) {
            boolean bl;
            ZoneOffset before = wallOffsets[i];
            ZoneOffset after = wallOffsets[i + 1];
            ZoneOffsetTransition trans = new ZoneOffsetTransition(savingsInstantTransitions[i], before, after);
            if (trans.isGap()) {
                localTransitionList.add(trans.getDateTimeBefore());
                bl = localTransitionList.add(trans.getDateTimeAfter());
                continue;
            }
            localTransitionList.add(trans.getDateTimeAfter());
            bl = localTransitionList.add(trans.getDateTimeBefore());
        }
        this(standardTransitions, standardOffsets, savingsInstantTransitions, wallOffsets, lastRules, (LocalDateTime[])localTransitionList.toArray((Object[])new LocalDateTime[localTransitionList.size()]));
    }

    @Override
    public boolean isFixedOffset() {
        return this.savingsInstantTransitions().length == 0;
    }

    @Override
    public ZoneOffset getOffset(Instant instant) {
        long epochSec = instant.getEpochSecond();
        if (this.lastRules().length > 0 && epochSec > this.savingsInstantTransitions()[this.savingsInstantTransitions().length - 1]) {
            int year = this.findYear(epochSec, this.wallOffsets()[this.wallOffsets().length - 1]);
            ZoneOffsetTransition[] transArray = this.findTransitionArray(year);
            ZoneOffsetTransition trans = null;
            for (int i = 0; i < transArray.length; ++i) {
                trans = transArray[i];
                if (epochSec >= trans.toEpochSecond()) continue;
                return trans.getOffsetBefore();
            }
            return trans.getOffsetAfter();
        }
        int index = Arrays.binarySearch(this.savingsInstantTransitions(), epochSec);
        if (index < 0) {
            index = -index - 2;
        }
        return this.wallOffsets()[index + 1];
    }

    @Override
    public ZoneOffset getOffset(LocalDateTime localDateTime) {
        Either<ZoneOffsetTransition, ZoneOffset> either = this.getOffsetInfo(localDateTime);
        if (either instanceof Left) {
            ZoneOffsetTransition transition = (ZoneOffsetTransition)((Left)either).value();
            return transition.getOffsetBefore();
        }
        if (either instanceof Right) {
            ZoneOffset offset = (ZoneOffset)((Right)either).value();
            return offset;
        }
        throw new MatchError(either);
    }

    @Override
    public List<ZoneOffset> getValidOffsets(LocalDateTime localDateTime) {
        Either<ZoneOffsetTransition, ZoneOffset> either = this.getOffsetInfo(localDateTime);
        if (either instanceof Left) {
            ZoneOffsetTransition transition = (ZoneOffsetTransition)((Left)either).value();
            return transition.getValidOffsets();
        }
        if (either instanceof Right) {
            ZoneOffset offset = (ZoneOffset)((Right)either).value();
            return Collections.singletonList(offset);
        }
        throw new MatchError(either);
    }

    @Override
    public ZoneOffsetTransition getTransition(LocalDateTime localDateTime) {
        Either<ZoneOffsetTransition, ZoneOffset> either = this.getOffsetInfo(localDateTime);
        if (either instanceof Left) {
            ZoneOffsetTransition transition = (ZoneOffsetTransition)((Left)either).value();
            return transition;
        }
        return null;
    }

    private Either<ZoneOffsetTransition, ZoneOffset> getOffsetInfo(LocalDateTime dt) {
        Either either;
        Object object = new Object();
        try {
            if (this.lastRules().length > 0 && dt.isAfter(this.savingsLocalTransitions()[this.savingsLocalTransitions().length - 1])) {
                Object[] transArray = this.findTransitionArray(dt.getYear());
                ObjectRef info = ObjectRef.create(null);
                Object object2 = Predef$.MODULE$.refArrayOps(transArray);
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)trans -> {
                    this.getOffsetInfo$$anonfun$1(dt, info, object, (ZoneOffsetTransition)trans);
                    return BoxedUnit.UNIT;
                });
                return (Either)info.elem;
            }
            int index = Arrays.binarySearch(this.savingsLocalTransitions(), dt);
            if (index == -1) {
                return package$.MODULE$.Right().apply((Object)this.wallOffsets()[0]);
            }
            if (index < 0) {
                index = -index - 2;
            } else if (index < this.savingsLocalTransitions().length - 1) {
                LocalDateTime localDateTime = this.savingsLocalTransitions()[index];
                LocalDateTime localDateTime2 = this.savingsLocalTransitions()[index + 1];
                if (!(localDateTime != null ? !((Object)localDateTime).equals(localDateTime2) : localDateTime2 != null)) {
                    ++index;
                }
            }
            if ((index & 1) == 0) {
                LocalDateTime dtBefore = this.savingsLocalTransitions()[index];
                LocalDateTime dtAfter = this.savingsLocalTransitions()[index + 1];
                ZoneOffset offsetBefore = this.wallOffsets()[index / 2];
                ZoneOffset offsetAfter = this.wallOffsets()[index / 2 + 1];
                either = offsetAfter.getTotalSeconds() > offsetBefore.getTotalSeconds() ? package$.MODULE$.Left().apply((Object)new ZoneOffsetTransition(dtBefore, offsetBefore, offsetAfter)) : package$.MODULE$.Left().apply((Object)new ZoneOffsetTransition(dtAfter, offsetBefore, offsetAfter));
            } else {
                either = package$.MODULE$.Right().apply((Object)this.wallOffsets()[index / 2 + 1]);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                either = (Either)ex.value();
            }
            throw ex;
        }
        return either;
    }

    private Either<ZoneOffsetTransition, ZoneOffset> findOffsetInfo(LocalDateTime dt, ZoneOffsetTransition trans) {
        LocalDateTime localTransition = trans.getDateTimeBefore();
        if (trans.isGap()) {
            if (dt.isBefore(localTransition)) {
                return package$.MODULE$.Right().apply((Object)trans.getOffsetBefore());
            }
            if (dt.isBefore(trans.getDateTimeAfter())) {
                return package$.MODULE$.Left().apply((Object)trans);
            }
            return package$.MODULE$.Right().apply((Object)trans.getOffsetAfter());
        }
        if (!dt.isBefore(localTransition)) {
            return package$.MODULE$.Right().apply((Object)trans.getOffsetAfter());
        }
        if (dt.isBefore(trans.getDateTimeAfter())) {
            return package$.MODULE$.Right().apply((Object)trans.getOffsetBefore());
        }
        return package$.MODULE$.Left().apply((Object)trans);
    }

    @Override
    public boolean isValidOffset(LocalDateTime localDateTime, ZoneOffset offset) {
        return this.getValidOffsets(localDateTime).contains(offset);
    }

    private ZoneOffsetTransition[] findTransitionArray(int year) {
        Integer yearObj = Predef$.MODULE$.int2Integer(year);
        ZoneOffsetTransition[] transArray = this.lastRulesCache.get(yearObj);
        if (transArray != null) {
            return transArray;
        }
        ZoneOffsetTransitionRule[] ruleArray = this.lastRules();
        transArray = new ZoneOffsetTransition[ruleArray.length];
        for (int i = 0; i < ruleArray.length; ++i) {
            transArray[i] = ruleArray[i].createTransition(year);
        }
        if (year < 2100) {
            this.lastRulesCache.put(yearObj, transArray);
        }
        return transArray;
    }

    @Override
    public ZoneOffset getStandardOffset(Instant instant) {
        long epochSec = instant.getEpochSecond();
        int index = Arrays.binarySearch(this.standardTransitions(), epochSec);
        if (index < 0) {
            index = -index - 2;
        }
        return this.standardOffsets()[index + 1];
    }

    @Override
    public Duration getDaylightSavings(Instant instant) {
        ZoneOffset standardOffset = this.getStandardOffset(instant);
        ZoneOffset actualOffset = this.getOffset(instant);
        return Duration$.MODULE$.ofSeconds((long)actualOffset.getTotalSeconds() - (long)standardOffset.getTotalSeconds());
    }

    @Override
    public boolean isDaylightSavings(Instant instant) {
        ZoneOffset zoneOffset = this.getStandardOffset(instant);
        ZoneOffset zoneOffset2 = this.getOffset(instant);
        return zoneOffset == null ? zoneOffset2 != null : !((Object)zoneOffset).equals(zoneOffset2);
    }

    @Override
    public ZoneOffsetTransition nextTransition(Instant instant) {
        ZoneOffsetTransition zoneOffsetTransition;
        Object object = new Object();
        try {
            if (this.savingsInstantTransitions().length == 0) {
                return null;
            }
            long epochSec = instant.getEpochSecond();
            if (epochSec >= this.savingsInstantTransitions()[this.savingsInstantTransitions().length - 1]) {
                if (this.lastRules().length == 0) {
                    return null;
                }
                int year = this.findYear(epochSec, this.wallOffsets()[this.wallOffsets().length - 1]);
                Object[] transArray = this.findTransitionArray(year);
                Object object2 = Predef$.MODULE$.refArrayOps(transArray);
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)trans -> {
                    StandardZoneRules.nextTransition$$anonfun$1(epochSec, object, trans);
                    return BoxedUnit.UNIT;
                });
                if (year < Year$.MODULE$.MAX_VALUE()) {
                    transArray = this.findTransitionArray(year + 1);
                    return transArray[0];
                }
                return null;
            }
            int index = Arrays.binarySearch(this.savingsInstantTransitions(), epochSec);
            index = index < 0 ? -index - 1 : ++index;
            zoneOffsetTransition = new ZoneOffsetTransition(this.savingsInstantTransitions()[index], this.wallOffsets()[index], this.wallOffsets()[index + 1]);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                zoneOffsetTransition = (ZoneOffsetTransition)ex.value();
            }
            throw ex;
        }
        return zoneOffsetTransition;
    }

    @Override
    public ZoneOffsetTransition previousTransition(Instant instant) {
        int index;
        if (this.savingsInstantTransitions().length == 0) {
            return null;
        }
        long epochSec = instant.getEpochSecond();
        if (instant.getNano() > 0 && epochSec < Long.MAX_VALUE) {
            ++epochSec;
        }
        long lastHistoric = this.savingsInstantTransitions()[this.savingsInstantTransitions().length - 1];
        if (this.lastRules().length > 0 && epochSec > lastHistoric) {
            ZoneOffset lastHistoricOffset = this.wallOffsets()[this.wallOffsets().length - 1];
            int year = this.findYear(epochSec, lastHistoricOffset);
            ZoneOffsetTransition[] transArray = this.findTransitionArray(year);
            for (int i = transArray.length - 1; i >= 0; --i) {
                if (epochSec <= transArray[i].toEpochSecond()) continue;
                return transArray[i];
            }
            int lastHistoricYear = this.findYear(lastHistoric, lastHistoricOffset);
            if (--year > lastHistoricYear) {
                transArray = this.findTransitionArray(year);
                return transArray[transArray.length - 1];
            }
        }
        if ((index = Arrays.binarySearch(this.savingsInstantTransitions(), epochSec)) < 0) {
            index = -index - 1;
        }
        if (index <= 0) {
            return null;
        }
        return new ZoneOffsetTransition(this.savingsInstantTransitions()[index - 1], this.wallOffsets()[index - 1], this.wallOffsets()[index]);
    }

    private int findYear(long epochSecond, ZoneOffset offset) {
        long localSecond = epochSecond + (long)offset.getTotalSeconds();
        long localEpochDay = Math.floorDiv(localSecond, 86400L);
        return LocalDate$.MODULE$.ofEpochDay(localEpochDay).getYear();
    }

    @Override
    public List<ZoneOffsetTransition> getTransitions() {
        ArrayList<ZoneOffsetTransition> list = new ArrayList<ZoneOffsetTransition>();
        for (int i = 0; i < this.savingsInstantTransitions().length; ++i) {
            list.add(new ZoneOffsetTransition(this.savingsInstantTransitions()[i], this.wallOffsets()[i], this.wallOffsets()[i + 1]));
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<ZoneOffsetTransitionRule> getTransitionRules() {
        return Collections.unmodifiableList(Arrays.asList(this.lastRules()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof StandardZoneRules) {
            StandardZoneRules other = (StandardZoneRules)object;
            if (this == other) return true;
            if (!Arrays.equals(this.standardTransitions(), other.standardTransitions())) return false;
            if (!Arrays.equals(this.standardOffsets(), other.standardOffsets())) return false;
            if (!Arrays.equals(this.savingsInstantTransitions(), other.savingsInstantTransitions())) return false;
            if (!Arrays.equals(this.wallOffsets(), other.wallOffsets())) return false;
            if (!Arrays.equals(this.lastRules(), other.lastRules())) return false;
            return true;
        }
        if (!(object instanceof ZoneRules.Fixed)) return false;
        if (!this.isFixedOffset()) return false;
        ZoneOffset zoneOffset = this.getOffset(Instant$.MODULE$.EPOCH());
        ZoneOffset zoneOffset2 = ((ZoneRules.Fixed)obj).getOffset(Instant$.MODULE$.EPOCH());
        if (zoneOffset != null) {
            if (!((Object)zoneOffset).equals(zoneOffset2)) return false;
            return true;
        }
        if (zoneOffset2 == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.standardTransitions()) ^ Arrays.hashCode(this.standardOffsets()) ^ Arrays.hashCode(this.savingsInstantTransitions()) ^ Arrays.hashCode(this.wallOffsets()) ^ Arrays.hashCode(this.lastRules());
    }

    public String toString() {
        return new StringBuilder(41).append("StandardZoneRules[currentStandardOffset=").append(this.standardOffsets()[this.standardOffsets().length - 1]).append("]").toString();
    }

    private final /* synthetic */ void getOffsetInfo$$anonfun$1(LocalDateTime dt$1, ObjectRef info$1, Object nonLocalReturnKey1$1, ZoneOffsetTransition trans) {
        block3: {
            block2: {
                Either either;
                info$1.elem = either = this.findOffsetInfo(dt$1, trans);
                either = null;
                if (((Either)info$1.elem).isLeft()) break block2;
                Either either2 = (Either)info$1.elem;
                Right right = package$.MODULE$.Right().apply((Object)trans.getOffsetBefore());
                if (either2 != null ? !either2.equals(right) : right != null) break block3;
            }
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)((Either)info$1.elem));
        }
    }

    private static final /* synthetic */ void nextTransition$$anonfun$1(long epochSec$1, Object nonLocalReturnKey2$1, ZoneOffsetTransition trans) {
        if (epochSec$1 < trans.toEpochSecond()) {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)trans);
        }
    }
}

