/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.zone.StandardZoneRules;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.util.ArrayList;
import java.util.List;
import scala.runtime.ModuleSerializationProxy;

public final class StandardZoneRules$
implements Serializable {
    private static final long serialVersionUID = 3044319355680032515L;
    public static final StandardZoneRules$ MODULE$ = new StandardZoneRules$();

    private StandardZoneRules$() {
    }

    static {
        int LAST_CACHED_YEAR = 2100;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StandardZoneRules$.class);
    }

    public StandardZoneRules apply(ZoneOffset baseStandardOffset, ZoneOffset baseWallOffset, List<ZoneOffsetTransition> standardOffsetTransitionList, List<ZoneOffsetTransition> transitionList, List<ZoneOffsetTransitionRule> lastRules) {
        long[] standardTransitions = new long[standardOffsetTransitionList.size()];
        ZoneOffset[] standardOffsets = new ZoneOffset[standardOffsetTransitionList.size() + 1];
        standardOffsets[0] = baseStandardOffset;
        for (int i = 0; i < standardOffsetTransitionList.size(); ++i) {
            standardTransitions[i] = standardOffsetTransitionList.get(i).toEpochSecond();
            standardOffsets[i + 1] = standardOffsetTransitionList.get(i).getOffsetAfter();
        }
        ArrayList<LocalDateTime> localTransitionList = new ArrayList<LocalDateTime>();
        ArrayList<ZoneOffset> localTransitionOffsetList = new ArrayList<ZoneOffset>();
        localTransitionOffsetList.add(baseWallOffset);
        for (ZoneOffsetTransition trans : transitionList) {
            boolean bl;
            if (trans.isGap()) {
                localTransitionList.add(trans.getDateTimeBefore());
                bl = localTransitionList.add(trans.getDateTimeAfter());
            } else {
                localTransitionList.add(trans.getDateTimeAfter());
                bl = localTransitionList.add(trans.getDateTimeBefore());
            }
            localTransitionOffsetList.add(trans.getOffsetAfter());
        }
        LocalDateTime[] savingsLocalTransitions = (LocalDateTime[])localTransitionList.toArray((Object[])new LocalDateTime[localTransitionList.size()]);
        ZoneOffset[] wallOffsets = (ZoneOffset[])localTransitionOffsetList.toArray((Object[])new ZoneOffset[localTransitionOffsetList.size()]);
        long[] savingsInstantTransitions = new long[transitionList.size()];
        for (int i = 0; i < transitionList.size(); ++i) {
            savingsInstantTransitions[i] = transitionList.get(i).getInstant().getEpochSecond();
        }
        if (lastRules.size() > 15) {
            throw new IllegalArgumentException("Too many transition rules");
        }
        ZoneOffsetTransitionRule[] resultLastRules = (ZoneOffsetTransitionRule[])lastRules.toArray((Object[])new ZoneOffsetTransitionRule[lastRules.size()]);
        return new StandardZoneRules(standardTransitions, standardOffsets, savingsInstantTransitions, wallOffsets, resultLastRules, savingsLocalTransitions);
    }
}

