/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Year$;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.Chronology$;
import java.time.format.ResolverStyle;
import java.time.format.ResolverStyle$;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.IsoFields$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.time.temporal.ValueRange$;
import java.time.temporal.WeekFields$;
import java.time.temporal.WeekFields$ComputedDayOfField$;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class WeekFields
implements Serializable {
    private static final long serialVersionUID = -1177360819670808121L;
    private final DayOfWeek firstDayOfWeek;
    private final int minimalDays;
    private final transient TemporalField dayOfWeek;
    private final transient TemporalField weekOfMonth;
    private final transient TemporalField weekOfYear;
    private final transient TemporalField weekOfWeekBasedYear;
    private final transient TemporalField weekBasedYear;

    public static WeekFields ISO() {
        return WeekFields$.MODULE$.ISO();
    }

    public static WeekFields SUNDAY_START() {
        return WeekFields$.MODULE$.SUNDAY_START();
    }

    public static WeekFields of(DayOfWeek dayOfWeek, int n) {
        return WeekFields$.MODULE$.of(dayOfWeek, n);
    }

    public static WeekFields of(Locale locale) {
        return WeekFields$.MODULE$.of(locale);
    }

    public WeekFields(DayOfWeek firstDayOfWeek, int minimalDays) {
        this.firstDayOfWeek = firstDayOfWeek;
        this.minimalDays = minimalDays;
        Objects.requireNonNull(firstDayOfWeek, "firstDayOfWeek");
        if (minimalDays < 1 || minimalDays > 7) {
            throw new IllegalArgumentException("Minimal number of days is invalid");
        }
        this.dayOfWeek = WeekFields$ComputedDayOfField$.MODULE$.ofDayOfWeekField(this);
        this.weekOfMonth = WeekFields$ComputedDayOfField$.MODULE$.ofWeekOfMonthField(this);
        this.weekOfYear = WeekFields$ComputedDayOfField$.MODULE$.ofWeekOfYearField(this);
        this.weekOfWeekBasedYear = WeekFields$ComputedDayOfField$.MODULE$.ofWeekOfWeekBasedYearField(this);
        this.weekBasedYear = WeekFields$ComputedDayOfField$.MODULE$.ofWeekBasedYearField(this);
    }

    private DayOfWeek firstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    private int minimalDays() {
        return this.minimalDays;
    }

    public TemporalField dayOfWeek() {
        return this.dayOfWeek;
    }

    public TemporalField weekOfMonth() {
        return this.weekOfMonth;
    }

    public TemporalField weekOfYear() {
        return this.weekOfYear;
    }

    public TemporalField weekOfWeekBasedYear() {
        return this.weekOfWeekBasedYear;
    }

    public TemporalField weekBasedYear() {
        return this.weekBasedYear;
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek();
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDays();
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof WeekFields) {
            WeekFields that2 = (WeekFields)object;
            return this == that2 || this.hashCode() == that2.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.firstDayOfWeek().ordinal() * 7 + this.minimalDays();
    }

    public String toString() {
        return new StringBuilder(13).append("WeekFields[").append(this.firstDayOfWeek()).append(",").append(this.minimalDays()).append("]").toString();
    }

    public static class ComputedDayOfField
    implements TemporalField {
        private final String name;
        private final WeekFields weekDef;
        private final TemporalUnit baseUnit;
        private final TemporalUnit rangeUnit;
        private final ValueRange range;

        public static ComputedDayOfField ofDayOfWeekField(WeekFields weekFields) {
            return WeekFields$ComputedDayOfField$.MODULE$.ofDayOfWeekField(weekFields);
        }

        public static ComputedDayOfField ofWeekBasedYearField(WeekFields weekFields) {
            return WeekFields$ComputedDayOfField$.MODULE$.ofWeekBasedYearField(weekFields);
        }

        public static ComputedDayOfField ofWeekOfMonthField(WeekFields weekFields) {
            return WeekFields$ComputedDayOfField$.MODULE$.ofWeekOfMonthField(weekFields);
        }

        public static ComputedDayOfField ofWeekOfWeekBasedYearField(WeekFields weekFields) {
            return WeekFields$ComputedDayOfField$.MODULE$.ofWeekOfWeekBasedYearField(weekFields);
        }

        public static ComputedDayOfField ofWeekOfYearField(WeekFields weekFields) {
            return WeekFields$ComputedDayOfField$.MODULE$.ofWeekOfYearField(weekFields);
        }

        public ComputedDayOfField(String name, WeekFields weekDef, TemporalUnit baseUnit, TemporalUnit rangeUnit, ValueRange range) {
            this.name = name;
            this.weekDef = weekDef;
            this.baseUnit = baseUnit;
            this.rangeUnit = rangeUnit;
            this.range = range;
        }

        public String name() {
            return this.name;
        }

        public WeekFields weekDef() {
            return this.weekDef;
        }

        public TemporalUnit baseUnit() {
            return this.baseUnit;
        }

        public TemporalUnit rangeUnit() {
            return this.rangeUnit;
        }

        @Override
        public ValueRange range() {
            return this.range;
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            int sow = this.weekDef().getFirstDayOfWeek().getValue();
            int isoDow = temporal.get(ChronoField$.DAY_OF_WEEK);
            int dow = Math.floorMod(isoDow - sow, 7) + 1;
            if (this.rangeUnit() == ChronoUnit$.WEEKS) {
                return dow;
            }
            if (this.rangeUnit() == ChronoUnit$.MONTHS) {
                int dom = temporal.get(ChronoField$.DAY_OF_MONTH);
                int offset = this.startOfWeekOffset(dom, dow);
                return this.computeWeek(offset, dom);
            }
            if (this.rangeUnit() == ChronoUnit$.YEARS) {
                int doy = temporal.get(ChronoField$.DAY_OF_YEAR);
                int offset = this.startOfWeekOffset(doy, dow);
                return this.computeWeek(offset, doy);
            }
            if (this.rangeUnit() == IsoFields$.MODULE$.WEEK_BASED_YEARS()) {
                return this.localizedWOWBY(temporal);
            }
            if (this.rangeUnit() == ChronoUnit$.FOREVER) {
                return this.localizedWBY(temporal);
            }
            throw new IllegalStateException("unreachable");
        }

        private int localizedDayOfWeek(TemporalAccessor temporal, int sow) {
            int isoDow = temporal.get(ChronoField$.DAY_OF_WEEK);
            return Math.floorMod(isoDow - sow, 7) + 1;
        }

        private long localizedWeekOfMonth(TemporalAccessor temporal, int dow) {
            int dom = temporal.get(ChronoField$.DAY_OF_MONTH);
            int offset = this.startOfWeekOffset(dom, dow);
            return this.computeWeek(offset, dom);
        }

        private long localizedWeekOfYear(TemporalAccessor temporal, int dow) {
            int doy = temporal.get(ChronoField$.DAY_OF_YEAR);
            int offset = this.startOfWeekOffset(doy, dow);
            return this.computeWeek(offset, doy);
        }

        private int localizedWOWBY(TemporalAccessor temporal) {
            int year;
            int yearLen;
            int offset;
            int weekIndexOfFirstWeekNextYear;
            int sow = this.weekDef().getFirstDayOfWeek().getValue();
            int isoDow = temporal.get(ChronoField$.DAY_OF_WEEK);
            int dow = Math.floorMod(isoDow - sow, 7) + 1;
            long woy = this.localizedWeekOfYear(temporal, dow);
            if (woy == 0L) {
                ChronoLocalDate previous = Chronology$.MODULE$.from(temporal).date(temporal).minus(1L, ChronoUnit$.WEEKS);
                return (int)this.localizedWeekOfYear(previous, dow) + 1;
            }
            if (woy >= 53L && woy >= (long)(weekIndexOfFirstWeekNextYear = this.computeWeek(offset = this.startOfWeekOffset(temporal.get(ChronoField$.DAY_OF_YEAR), dow), (yearLen = Year$.MODULE$.isLeap(year = temporal.get(ChronoField$.YEAR)) ? 366 : 365) + this.weekDef().getMinimalDaysInFirstWeek()))) {
                return (int)(woy - (long)(weekIndexOfFirstWeekNextYear - 1));
            }
            return (int)woy;
        }

        private int localizedWBY(TemporalAccessor temporal) {
            int yearLen;
            int sow = this.weekDef().getFirstDayOfWeek().getValue();
            int isoDow = temporal.get(ChronoField$.DAY_OF_WEEK);
            int dow = Math.floorMod(isoDow - sow, 7) + 1;
            int year = temporal.get(ChronoField$.YEAR);
            long woy = this.localizedWeekOfYear(temporal, dow);
            if (woy == 0L) {
                return year - 1;
            }
            if (woy < 53L) {
                return year;
            }
            int offset = this.startOfWeekOffset(temporal.get(ChronoField$.DAY_OF_YEAR), dow);
            int weekIndexOfFirstWeekNextYear = this.computeWeek(offset, (yearLen = Year$.MODULE$.isLeap(year) ? 366 : 365) + this.weekDef().getMinimalDaysInFirstWeek());
            if (woy >= (long)weekIndexOfFirstWeekNextYear) {
                return year + 1;
            }
            return year;
        }

        private int startOfWeekOffset(int day, int dow) {
            int weekStart = Math.floorMod(day - dow, 7);
            int offset = -weekStart;
            if (weekStart + 1 > this.weekDef().getMinimalDaysInFirstWeek()) {
                offset = 7 - weekStart;
            }
            return offset;
        }

        private int computeWeek(int offset, int day) {
            return (7 + offset + (day - 1)) / 7;
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            int currentVal;
            int newVal = this.range().checkValidIntValue(newValue, this);
            if (newVal == (currentVal = temporal.get(this))) {
                return temporal;
            }
            if (this.rangeUnit() == ChronoUnit$.FOREVER) {
                int baseWowby = temporal.get(this.weekDef().weekOfWeekBasedYear());
                long diffWeeks = (long)((double)(newValue - (long)currentVal) * 52.1775);
                Temporal result = temporal.plus(diffWeeks, ChronoUnit$.WEEKS);
                if (result.get(this) > newVal) {
                    int newWowby = result.get(this.weekDef().weekOfWeekBasedYear());
                    result = result.minus(newWowby, ChronoUnit$.WEEKS);
                } else {
                    int newWowby;
                    if (result.get(this) < newVal) {
                        result = result.plus(2L, ChronoUnit$.WEEKS);
                    }
                    if ((result = result.plus((long)baseWowby - (long)(newWowby = result.get(this.weekDef().weekOfWeekBasedYear())), ChronoUnit$.WEEKS)).get(this) > newVal) {
                        result = result.minus(1L, ChronoUnit$.WEEKS);
                    }
                }
                return (R)result;
            }
            int delta = newVal - currentVal;
            return (R)temporal.plus(delta, this.baseUnit());
        }

        @Override
        public TemporalAccessor resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            int sow = this.weekDef().getFirstDayOfWeek().getValue();
            if (this.rangeUnit() == ChronoUnit$.WEEKS) {
                long value = Predef$.MODULE$.Long2long(fieldValues.remove(this));
                int localDow = this.range().checkValidIntValue(value, this);
                int isoDow = Math.floorMod(sow - 1 + (localDow - 1), 7) + 1;
                fieldValues.put(ChronoField$.DAY_OF_WEEK, Predef$.MODULE$.long2Long((long)isoDow));
                return null;
            }
            if (!fieldValues.containsKey(ChronoField$.DAY_OF_WEEK)) {
                return null;
            }
            if (this.rangeUnit() == ChronoUnit$.FOREVER) {
                if (!fieldValues.containsKey(this.weekDef().weekOfWeekBasedYear())) {
                    return null;
                }
                Chronology chrono = Chronology$.MODULE$.from(partialTemporal);
                int isoDow = ChronoField$.DAY_OF_WEEK.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.get(ChronoField$.DAY_OF_WEEK)));
                int dow = Math.floorMod(isoDow - sow, 7) + 1;
                int wby = this.range().checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.get(this)), this);
                ChronoLocalDate date = null;
                long days = 0L;
                if (resolverStyle == ResolverStyle$.LENIENT) {
                    date = chrono.date(wby, 1, this.weekDef().getMinimalDaysInFirstWeek());
                    long wowby = Predef$.MODULE$.Long2long(fieldValues.get(this.weekDef().weekOfWeekBasedYear()));
                    int dateDow = this.localizedDayOfWeek(date, sow);
                    long weeks = wowby - this.localizedWeekOfYear(date, dateDow);
                    days = weeks * 7L + (long)(dow - dateDow);
                } else {
                    date = chrono.date(wby, 1, this.weekDef().getMinimalDaysInFirstWeek());
                    long wowby = this.weekDef().weekOfWeekBasedYear().range().checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.get(this.weekDef().weekOfWeekBasedYear())), this.weekDef().weekOfWeekBasedYear());
                    int dateDow = this.localizedDayOfWeek(date, sow);
                    long weeks = wowby - this.localizedWeekOfYear(date, dateDow);
                    days = weeks * 7L + (long)(dow - dateDow);
                }
                date = date.plus(days, ChronoUnit$.DAYS);
                if (resolverStyle == ResolverStyle$.STRICT && !BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)date.getLong(this)), (Object)fieldValues.get(this))) {
                    throw new DateTimeException("Strict mode rejected date parsed to a different year");
                }
                fieldValues.remove(this);
                fieldValues.remove(this.weekDef().weekOfWeekBasedYear());
                fieldValues.remove(ChronoField$.DAY_OF_WEEK);
                return date;
            }
            if (!fieldValues.containsKey(ChronoField$.YEAR)) {
                return null;
            }
            int isoDow = ChronoField$.DAY_OF_WEEK.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.get(ChronoField$.DAY_OF_WEEK)));
            int dow = Math.floorMod(isoDow - sow, 7) + 1;
            int year = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.get(ChronoField$.YEAR)));
            Chronology chrono = Chronology$.MODULE$.from(partialTemporal);
            if (this.rangeUnit() == ChronoUnit$.MONTHS) {
                if (!fieldValues.containsKey(ChronoField$.MONTH_OF_YEAR)) {
                    return null;
                }
                long value = Predef$.MODULE$.Long2long(fieldValues.remove(this));
                ChronoLocalDate date = null;
                long days = 0L;
                if (resolverStyle == ResolverStyle$.LENIENT) {
                    long month = Predef$.MODULE$.Long2long(fieldValues.get(ChronoField$.MONTH_OF_YEAR));
                    date = chrono.date(year, 1, 1);
                    date = date.plus(month - 1L, ChronoUnit$.MONTHS);
                    int dateDow = this.localizedDayOfWeek(date, sow);
                    long weeks = value - this.localizedWeekOfMonth(date, dateDow);
                    days = weeks * 7L + (long)(dow - dateDow);
                } else {
                    int month = ChronoField$.MONTH_OF_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.get(ChronoField$.MONTH_OF_YEAR)));
                    date = chrono.date(year, month, 8);
                    int dateDow = this.localizedDayOfWeek(date, sow);
                    int wom = this.range().checkValidIntValue(value, this);
                    long weeks = (long)wom - this.localizedWeekOfMonth(date, dateDow);
                    days = weeks * 7L + (long)(dow - dateDow);
                }
                date = date.plus(days, ChronoUnit$.DAYS);
                if (resolverStyle == ResolverStyle$.STRICT && !BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)date.getLong(ChronoField$.MONTH_OF_YEAR)), (Object)fieldValues.get(ChronoField$.MONTH_OF_YEAR))) {
                    throw new DateTimeException("Strict mode rejected date parsed to a different month");
                }
                fieldValues.remove(this);
                fieldValues.remove(ChronoField$.YEAR);
                fieldValues.remove(ChronoField$.MONTH_OF_YEAR);
                fieldValues.remove(ChronoField$.DAY_OF_WEEK);
                return date;
            }
            if (this.rangeUnit() == ChronoUnit$.YEARS) {
                long value = Predef$.MODULE$.Long2long(fieldValues.remove(this));
                ChronoLocalDate date = chrono.date(year, 1, 1);
                long days = 0L;
                if (resolverStyle == ResolverStyle$.LENIENT) {
                    int dateDow = this.localizedDayOfWeek(date, sow);
                    long weeks = value - this.localizedWeekOfYear(date, dateDow);
                    days = weeks * 7L + (long)(dow - dateDow);
                } else {
                    int dateDow = this.localizedDayOfWeek(date, sow);
                    int woy = this.range().checkValidIntValue(value, this);
                    long weeks = (long)woy - this.localizedWeekOfYear(date, dateDow);
                    days = weeks * 7L + (long)(dow - dateDow);
                }
                date = date.plus(days, ChronoUnit$.DAYS);
                if (resolverStyle == ResolverStyle$.STRICT && !BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)date.getLong(ChronoField$.YEAR)), (Object)fieldValues.get(ChronoField$.YEAR))) {
                    throw new DateTimeException("Strict mode rejected date parsed to a different year");
                }
                fieldValues.remove(this);
                fieldValues.remove(ChronoField$.YEAR);
                fieldValues.remove(ChronoField$.DAY_OF_WEEK);
                return date;
            }
            throw new IllegalStateException("unreachable");
        }

        @Override
        public TemporalUnit getBaseUnit() {
            return this.baseUnit();
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return this.rangeUnit();
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            if (temporal.isSupported(ChronoField$.DAY_OF_WEEK)) {
                if (this.rangeUnit() == ChronoUnit$.WEEKS) {
                    return true;
                }
                if (this.rangeUnit() == ChronoUnit$.MONTHS) {
                    return temporal.isSupported(ChronoField$.DAY_OF_MONTH);
                }
                if (this.rangeUnit() == ChronoUnit$.YEARS) {
                    return temporal.isSupported(ChronoField$.DAY_OF_YEAR);
                }
                if (this.rangeUnit() == IsoFields$.MODULE$.WEEK_BASED_YEARS()) {
                    return temporal.isSupported(ChronoField$.EPOCH_DAY);
                }
                if (this.rangeUnit() == ChronoUnit$.FOREVER) {
                    return temporal.isSupported(ChronoField$.EPOCH_DAY);
                }
                return false;
            }
            return false;
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            if (this.rangeUnit() == ChronoUnit$.WEEKS) {
                return this.range();
            }
            ChronoField field = null;
            if (this.rangeUnit() == ChronoUnit$.MONTHS) {
                field = ChronoField$.DAY_OF_MONTH;
            } else if (this.rangeUnit() == ChronoUnit$.YEARS) {
                field = ChronoField$.DAY_OF_YEAR;
            } else {
                if (this.rangeUnit() == IsoFields$.MODULE$.WEEK_BASED_YEARS()) {
                    return this.rangeWOWBY(temporal);
                }
                if (this.rangeUnit() == ChronoUnit$.FOREVER) {
                    return temporal.range(ChronoField$.YEAR);
                }
                throw new IllegalStateException("unreachable");
            }
            int sow = this.weekDef().getFirstDayOfWeek().getValue();
            int isoDow = temporal.get(ChronoField$.DAY_OF_WEEK);
            int dow = Math.floorMod(isoDow - sow, 7) + 1;
            int offset = this.startOfWeekOffset(temporal.get(field), dow);
            ValueRange fieldRange = temporal.range(field);
            return ValueRange$.MODULE$.of(this.computeWeek(offset, (int)fieldRange.getMinimum()), this.computeWeek(offset, (int)fieldRange.getMaximum()));
        }

        private ValueRange rangeWOWBY(TemporalAccessor temporal) {
            int weekIndexOfFirstWeekNextYear;
            while (true) {
                int year;
                int yearLen;
                int sow = this.weekDef().getFirstDayOfWeek().getValue();
                int isoDow = temporal.get(ChronoField$.DAY_OF_WEEK);
                int dow = Math.floorMod(isoDow - sow, 7) + 1;
                long woy = this.localizedWeekOfYear(temporal, dow);
                if (woy == 0L) {
                    temporal = Chronology$.MODULE$.from(temporal).date(temporal).minus(2L, ChronoUnit$.WEEKS);
                    continue;
                }
                int offset = this.startOfWeekOffset(temporal.get(ChronoField$.DAY_OF_YEAR), dow);
                weekIndexOfFirstWeekNextYear = this.computeWeek(offset, (yearLen = Year$.MODULE$.isLeap(year = temporal.get(ChronoField$.YEAR)) ? 366 : 365) + this.weekDef().getMinimalDaysInFirstWeek());
                if (woy < (long)weekIndexOfFirstWeekNextYear) break;
                temporal = Chronology$.MODULE$.from(temporal).date(temporal).plus(2L, ChronoUnit$.WEEKS);
            }
            return ValueRange$.MODULE$.of(1L, (long)weekIndexOfFirstWeekNextYear - 1L);
        }

        @Override
        public String getDisplayName(Locale locale) {
            Objects.requireNonNull(locale, "locale");
            if (this.rangeUnit() == ChronoUnit$.YEARS) {
                return "Week";
            }
            return this.toString();
        }

        public String toString() {
            return new StringBuilder(2).append(this.name()).append("[").append(this.weekDef().toString()).append("]").toString();
        }
    }
}

