/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange$;

public final class ValueRange
implements Serializable {
    private final long minSmallest;
    private final long minLargest;
    private final long maxSmallest;
    private final long maxLargest;

    public static ValueRange of(long l, long l2) {
        return ValueRange$.MODULE$.of(l, l2);
    }

    public static ValueRange of(long l, long l2, long l3) {
        return ValueRange$.MODULE$.of(l, l2, l3);
    }

    public static ValueRange of(long l, long l2, long l3, long l4) {
        return ValueRange$.MODULE$.of(l, l2, l3, l4);
    }

    public ValueRange(long minSmallest, long minLargest, long maxSmallest, long maxLargest) {
        this.minSmallest = minSmallest;
        this.minLargest = minLargest;
        this.maxSmallest = maxSmallest;
        this.maxLargest = maxLargest;
    }

    private long minSmallest() {
        return this.minSmallest;
    }

    private long minLargest() {
        return this.minLargest;
    }

    private long maxSmallest() {
        return this.maxSmallest;
    }

    private long maxLargest() {
        return this.maxLargest;
    }

    public boolean isFixed() {
        return this.minSmallest() == this.minLargest() && this.maxSmallest() == this.maxLargest();
    }

    public long getMinimum() {
        return this.minSmallest();
    }

    public long getLargestMinimum() {
        return this.minLargest();
    }

    public long getSmallestMaximum() {
        return this.maxSmallest();
    }

    public long getMaximum() {
        return this.maxLargest();
    }

    public boolean isIntValue() {
        return this.getMinimum() >= Integer.MIN_VALUE && this.getMaximum() <= Integer.MAX_VALUE;
    }

    public boolean isValidValue(long value) {
        return value >= this.getMinimum() && value <= this.getMaximum();
    }

    public boolean isValidIntValue(long value) {
        return this.isIntValue() && this.isValidValue(value);
    }

    public long checkValidValue(long value, TemporalField field) {
        if (!this.isValidValue(value)) {
            if (field != null) {
                throw new DateTimeException(new StringBuilder(36).append("Invalid value for ").append(field).append(" (valid values ").append(this).append("): ").append(value).toString());
            }
            throw new DateTimeException(new StringBuilder(31).append("Invalid value (valid values ").append(this).append("): ").append(value).toString());
        }
        return value;
    }

    public int checkValidIntValue(long value, TemporalField field) {
        if (!this.isValidIntValue(value)) {
            throw new DateTimeException(new StringBuilder(24).append("Invalid int value for ").append(field).append(": ").append(value).toString());
        }
        return (int)value;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ValueRange) {
            ValueRange other = (ValueRange)object;
            return this == other || this.minSmallest() == other.minSmallest() && this.minLargest() == other.minLargest() && this.maxSmallest() == other.maxSmallest() && this.maxLargest() == other.maxLargest();
        }
        return false;
    }

    public int hashCode() {
        long hash = this.minSmallest() + this.minLargest() << (int)(16L + this.minLargest()) >> (int)(48L + this.maxSmallest()) << (int)(32L + this.maxSmallest()) >> (int)(32L + this.maxLargest()) << (int)(48L + this.maxLargest()) >> 16;
        return (int)(hash ^ hash >>> 32);
    }

    public String toString() {
        String ss = this.minSmallest() != this.minLargest() ? new StringBuilder(1).append("/").append(this.minLargest()).toString() : "";
        String sl = this.maxSmallest() != this.maxLargest() ? new StringBuilder(1).append("/").append(this.maxLargest()).toString() : "";
        return new StringBuilder(3).append(this.minSmallest()).append(ss).append(" - ").append(this.maxSmallest()).append(sl).toString();
    }
}

