/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters$;
import java.time.temporal.TemporalAdjusters$Impl$;
import java.util.Objects;
import scala.Function1;

public final class TemporalAdjusters {
    public static TemporalAdjuster dayOfWeekInMonth(int n, DayOfWeek dayOfWeek) {
        return TemporalAdjusters$.MODULE$.dayOfWeekInMonth(n, dayOfWeek);
    }

    public static TemporalAdjuster firstDayOfMonth() {
        return TemporalAdjusters$.MODULE$.firstDayOfMonth();
    }

    public static TemporalAdjuster firstDayOfNextMonth() {
        return TemporalAdjusters$.MODULE$.firstDayOfNextMonth();
    }

    public static TemporalAdjuster firstDayOfNextYear() {
        return TemporalAdjusters$.MODULE$.firstDayOfNextYear();
    }

    public static TemporalAdjuster firstDayOfYear() {
        return TemporalAdjusters$.MODULE$.firstDayOfYear();
    }

    public static TemporalAdjuster firstInMonth(DayOfWeek dayOfWeek) {
        return TemporalAdjusters$.MODULE$.firstInMonth(dayOfWeek);
    }

    public static TemporalAdjuster lastDayOfMonth() {
        return TemporalAdjusters$.MODULE$.lastDayOfMonth();
    }

    public static TemporalAdjuster lastDayOfYear() {
        return TemporalAdjusters$.MODULE$.lastDayOfYear();
    }

    public static TemporalAdjuster lastInMonth(DayOfWeek dayOfWeek) {
        return TemporalAdjusters$.MODULE$.lastInMonth(dayOfWeek);
    }

    public static TemporalAdjuster next(DayOfWeek dayOfWeek) {
        return TemporalAdjusters$.MODULE$.next(dayOfWeek);
    }

    public static TemporalAdjuster nextOrSame(DayOfWeek dayOfWeek) {
        return TemporalAdjusters$.MODULE$.nextOrSame(dayOfWeek);
    }

    public static TemporalAdjuster ofDateAdjuster(Function1<LocalDate, LocalDate> function1) {
        return TemporalAdjusters$.MODULE$.ofDateAdjuster(function1);
    }

    public static TemporalAdjuster previous(DayOfWeek dayOfWeek) {
        return TemporalAdjusters$.MODULE$.previous(dayOfWeek);
    }

    public static TemporalAdjuster previousOrSame(DayOfWeek dayOfWeek) {
        return TemporalAdjusters$.MODULE$.previousOrSame(dayOfWeek);
    }

    public static final class DayOfWeekInMonth
    implements TemporalAdjuster {
        private final int ordinal;
        private final int dowValue;

        public DayOfWeekInMonth(int ordinal, DayOfWeek dow) {
            this.ordinal = ordinal;
            this.dowValue = dow.getValue();
        }

        private int ordinal() {
            return this.ordinal;
        }

        @Override
        public Temporal adjustInto(Temporal temporal) {
            if (this.ordinal() >= 0) {
                Temporal temp = temporal.with(ChronoField$.DAY_OF_MONTH, 1L);
                int curDow = temp.get(ChronoField$.DAY_OF_WEEK);
                int dowDiff = (this.dowValue - curDow + 7) % 7;
                return temp.plus(dowDiff += (int)(((long)this.ordinal() - 1L) * 7L), ChronoUnit$.DAYS);
            }
            Temporal temp = temporal.with(ChronoField$.DAY_OF_MONTH, temporal.range(ChronoField$.DAY_OF_MONTH).getMaximum());
            int curDow = temp.get(ChronoField$.DAY_OF_WEEK);
            int daysDiff = this.dowValue - curDow;
            daysDiff = daysDiff == 0 ? 0 : (daysDiff > 0 ? daysDiff - 7 : daysDiff);
            return temp.plus(daysDiff -= (int)(((long)(-this.ordinal()) - 1L) * 7L), ChronoUnit$.DAYS);
        }
    }

    public static class Impl
    implements TemporalAdjuster {
        private final int ordinal;

        public static Impl FIRST_DAY_OF_MONTH() {
            return TemporalAdjusters$Impl$.MODULE$.FIRST_DAY_OF_MONTH();
        }

        public static Impl FIRST_DAY_OF_NEXT_MONTH() {
            return TemporalAdjusters$Impl$.MODULE$.FIRST_DAY_OF_NEXT_MONTH();
        }

        public static Impl FIRST_DAY_OF_NEXT_YEAR() {
            return TemporalAdjusters$Impl$.MODULE$.FIRST_DAY_OF_NEXT_YEAR();
        }

        public static Impl FIRST_DAY_OF_YEAR() {
            return TemporalAdjusters$Impl$.MODULE$.FIRST_DAY_OF_YEAR();
        }

        public static Impl LAST_DAY_OF_MONTH() {
            return TemporalAdjusters$Impl$.MODULE$.LAST_DAY_OF_MONTH();
        }

        public static Impl LAST_DAY_OF_YEAR() {
            return TemporalAdjusters$Impl$.MODULE$.LAST_DAY_OF_YEAR();
        }

        public Impl(int ordinal) {
            this.ordinal = ordinal;
        }

        private int ordinal() {
            return this.ordinal;
        }

        @Override
        public Temporal adjustInto(Temporal temporal) {
            int n = this.ordinal();
            switch (n) {
                case 0: {
                    return temporal.with(ChronoField$.DAY_OF_MONTH, 1L);
                }
                case 1: {
                    return temporal.with(ChronoField$.DAY_OF_MONTH, temporal.range(ChronoField$.DAY_OF_MONTH).getMaximum());
                }
                case 2: {
                    return temporal.with(ChronoField$.DAY_OF_MONTH, 1L).plus(1L, ChronoUnit$.MONTHS);
                }
                case 3: {
                    return temporal.with(ChronoField$.DAY_OF_YEAR, 1L);
                }
                case 4: {
                    return temporal.with(ChronoField$.DAY_OF_YEAR, temporal.range(ChronoField$.DAY_OF_YEAR).getMaximum());
                }
                case 5: {
                    return temporal.with(ChronoField$.DAY_OF_YEAR, 1L).plus(1L, ChronoUnit$.YEARS);
                }
            }
            throw new IllegalStateException("Unreachable");
        }
    }

    public static final class RelativeDayOfWeek
    implements TemporalAdjuster {
        private final int relative;
        private final int dowValue;

        public RelativeDayOfWeek(int relative, DayOfWeek dayOfWeek) {
            this.relative = relative;
            Objects.requireNonNull(dayOfWeek, "dayOfWeek");
            this.dowValue = dayOfWeek.getValue();
        }

        private int relative() {
            return this.relative;
        }

        @Override
        public Temporal adjustInto(Temporal temporal) {
            int calDow = temporal.get(ChronoField$.DAY_OF_WEEK);
            if (this.relative() < 2 && calDow == this.dowValue) {
                return temporal;
            }
            if ((this.relative() & 1) == 0) {
                int daysDiff = calDow - this.dowValue;
                return temporal.plus(daysDiff >= 0 ? 7L - (long)daysDiff : -((long)daysDiff), ChronoUnit$.DAYS);
            }
            int daysDiff = this.dowValue - calDow;
            return temporal.minus(daysDiff >= 0 ? 7L - (long)daysDiff : -((long)daysDiff), ChronoUnit$.DAYS);
        }
    }
}

