/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.time.DateTimeException;
import java.time.chrono.Chronology;
import java.time.chrono.Chronology$;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField$;
import java.time.temporal.JulianFields$;
import java.time.temporal.JulianFields$Field$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.temporal.ValueRange$;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import scala.Predef$;
import scala.reflect.Enum;

public final class JulianFields {
    public static TemporalField JULIAN_DAY() {
        return JulianFields$.MODULE$.JULIAN_DAY();
    }

    public static TemporalField MODIFIED_JULIAN_DAY() {
        return JulianFields$.MODULE$.MODIFIED_JULIAN_DAY();
    }

    public static TemporalField RATA_DIE() {
        return JulianFields$.MODULE$.RATA_DIE();
    }

    public static abstract class Field
    extends java.lang.Enum<Field>
    implements TemporalField,
    Enum {
        private final String name;
        private final TemporalUnit baseUnit;
        private final TemporalUnit rangeUnit;
        private final long offset;
        private final ValueRange range;

        public static Field fromOrdinal(int n) {
            return JulianFields$Field$.MODULE$.fromOrdinal(n);
        }

        public static Field valueOf(String string) {
            return JulianFields$Field$.MODULE$.valueOf(string);
        }

        public static Field[] values() {
            return JulianFields$Field$.MODULE$.values();
        }

        public Field(TemporalUnit baseUnit, TemporalUnit rangeUnit, long offset, String _$name, int _$ordinal) {
            this.name = name;
            this.baseUnit = baseUnit;
            this.rangeUnit = rangeUnit;
            this.offset = offset;
            this.range = ValueRange$.MODULE$.of(-365243219162L + offset, 365241780471L + offset);
        }

        private TemporalUnit baseUnit() {
            return this.baseUnit;
        }

        private TemporalUnit rangeUnit() {
            return this.rangeUnit;
        }

        private long offset() {
            return this.offset;
        }

        public static Field JULIAN_DAY() {
            return JulianFields$Field$.JULIAN_DAY;
        }

        public static Field MODIFIED_JULIAN_DAY() {
            return JulianFields$Field$.MODIFIED_JULIAN_DAY;
        }

        public static Field RATA_DIE() {
            return JulianFields$Field$.RATA_DIE;
        }

        @Override
        public ValueRange range() {
            return this.range;
        }

        @Override
        public TemporalUnit getBaseUnit() {
            return this.baseUnit();
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return this.rangeUnit();
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField$.EPOCH_DAY);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            if (!this.isSupportedBy(temporal)) {
                throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(this).toString());
            }
            return this.range();
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            return temporal.getLong(ChronoField$.EPOCH_DAY) + this.offset();
        }

        @Override
        public <R extends Temporal> R adjustInto(R dateTime, long newValue) {
            if (!this.range().isValidValue(newValue)) {
                throw new DateTimeException(new StringBuilder(16).append("Invalid value: ").append(this.name).append(" ").append(newValue).toString());
            }
            return (R)dateTime.with(ChronoField$.EPOCH_DAY, Math.subtractExact(newValue, this.offset()));
        }

        @Override
        public String getDisplayName(Locale locale) {
            Objects.requireNonNull(locale, "locale");
            return this.toString();
        }

        @Override
        public TemporalAccessor resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            Long value = fieldValues.remove(this);
            Chronology chrono = Chronology$.MODULE$.from(partialTemporal);
            return chrono.dateEpochDay(Math.subtractExact(Predef$.MODULE$.Long2long(value), this.offset()));
        }

        public String toString() {
            return this.name;
        }
    }
}

