/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.time.DayOfWeek$;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.chrono.Chronology;
import java.time.chrono.Chronology$;
import java.time.chrono.IsoChronology;
import java.time.chrono.IsoChronology$;
import java.time.format.ResolverStyle;
import java.time.format.ResolverStyle$;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.IsoFields$;
import java.time.temporal.IsoFields$Field$;
import java.time.temporal.IsoFields$Unit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.temporal.ValueRange$;
import java.time.temporal.package$;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;

public final class IsoFields {
    public static TemporalField DAY_OF_QUARTER() {
        return IsoFields$.MODULE$.DAY_OF_QUARTER();
    }

    public static TemporalField QUARTER_OF_YEAR() {
        return IsoFields$.MODULE$.QUARTER_OF_YEAR();
    }

    public static TemporalUnit QUARTER_YEARS() {
        return IsoFields$.MODULE$.QUARTER_YEARS();
    }

    public static TemporalField WEEK_BASED_YEAR() {
        return IsoFields$.MODULE$.WEEK_BASED_YEAR();
    }

    public static TemporalUnit WEEK_BASED_YEARS() {
        return IsoFields$.MODULE$.WEEK_BASED_YEARS();
    }

    public static TemporalField WEEK_OF_WEEK_BASED_YEAR() {
        return IsoFields$.MODULE$.WEEK_OF_WEEK_BASED_YEAR();
    }

    public static abstract class Field
    extends java.lang.Enum<Field>
    implements TemporalField,
    Enum {
        private int[] QUARTER_DAYS$lzy1;
        private boolean QUARTER_DAYSbitmap$1;

        public static Field fromOrdinal(int n) {
            return IsoFields$Field$.MODULE$.fromOrdinal(n);
        }

        public static Field valueOf(String string) {
            return IsoFields$Field$.MODULE$.valueOf(string);
        }

        public static Field[] values() {
            return IsoFields$Field$.MODULE$.values();
        }

        public Field(String _$name, int _$ordinal) {
        }

        public static Field DAY_OF_QUARTER() {
            return IsoFields$Field$.DAY_OF_QUARTER;
        }

        public static Field QUARTER_OF_YEAR() {
            return IsoFields$Field$.QUARTER_OF_YEAR;
        }

        public static Field WEEK_OF_WEEK_BASED_YEAR() {
            return IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR;
        }

        public static Field WEEK_BASED_YEAR() {
            return IsoFields$Field$.WEEK_BASED_YEAR;
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            Field field = this;
            Field field2 = IsoFields$Field$.DAY_OF_QUARTER;
            Field field3 = field;
            if (!(field2 != null ? !field2.equals(field3) : field3 != null)) {
                long curValue = this.getFrom(temporal);
                this.range().checkValidValue(newValue, this);
                return (R)temporal.with(ChronoField$.DAY_OF_YEAR, temporal.getLong(ChronoField$.DAY_OF_YEAR) + (newValue - curValue));
            }
            Field field4 = IsoFields$Field$.QUARTER_OF_YEAR;
            Field field5 = field;
            if (!(field4 != null ? !field4.equals(field5) : field5 != null)) {
                long curValue = this.getFrom(temporal);
                this.range().checkValidValue(newValue, this);
                return (R)temporal.with(ChronoField$.MONTH_OF_YEAR, temporal.getLong(ChronoField$.MONTH_OF_YEAR) + (newValue - curValue) * 3L);
            }
            Field field6 = IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR;
            Field field7 = field;
            if (!(field6 != null ? !field6.equals(field7) : field7 != null)) {
                this.range().checkValidValue(newValue, this);
                return (R)temporal.plus(Math.subtractExact(newValue, this.getFrom(temporal)), ChronoUnit$.WEEKS);
            }
            Field field8 = IsoFields$Field$.WEEK_BASED_YEAR;
            Field field9 = field;
            if (!(field8 != null ? !field8.equals(field9) : field9 != null)) {
                if (!this.isSupportedBy(temporal)) {
                    throw this.unsupportedEx(package$.MODULE$.WBY());
                }
                int newWby = this.range().checkValidIntValue(newValue, IsoFields$Field$.WEEK_BASED_YEAR);
                LocalDate date = LocalDate$.MODULE$.from(temporal);
                int dow = date.get(ChronoField$.DAY_OF_WEEK);
                int week = this.getWeek(date);
                if (week == 53 && this.getWeekRange(newWby) == 52) {
                    week = 52;
                }
                LocalDate resolved = LocalDate$.MODULE$.of(newWby, 1, 4);
                int days = dow - resolved.get(ChronoField$.DAY_OF_WEEK) + (week - 1) * 7;
                return (R)temporal.with(resolved.plusDays(days));
            }
            throw new MatchError((Object)field);
        }

        @Override
        public TemporalUnit getBaseUnit() {
            Field field = this;
            Field field2 = IsoFields$Field$.DAY_OF_QUARTER;
            Field field3 = field;
            if (!(field2 != null ? !field2.equals(field3) : field3 != null)) {
                return ChronoUnit$.DAYS;
            }
            Field field4 = IsoFields$Field$.QUARTER_OF_YEAR;
            Field field5 = field;
            if (!(field4 != null ? !field4.equals(field5) : field5 != null)) {
                return IsoFields$.MODULE$.QUARTER_YEARS();
            }
            Field field6 = IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR;
            Field field7 = field;
            if (!(field6 != null ? !field6.equals(field7) : field7 != null)) {
                return ChronoUnit$.WEEKS;
            }
            Field field8 = IsoFields$Field$.WEEK_BASED_YEAR;
            Field field9 = field;
            if (!(field8 != null ? !field8.equals(field9) : field9 != null)) {
                return IsoFields$.MODULE$.WEEK_BASED_YEARS();
            }
            throw new MatchError((Object)field);
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            Field field = this;
            Field field2 = IsoFields$Field$.DAY_OF_QUARTER;
            Field field3 = field;
            if (!(field2 != null ? !field2.equals(field3) : field3 != null)) {
                if (!temporal.isSupported(this)) {
                    throw this.unsupportedEx(IsoFields$.MODULE$.java$time$temporal$IsoFields$$$DQ());
                }
                int doy = temporal.get(ChronoField$.DAY_OF_YEAR);
                int moy = temporal.get(ChronoField$.MONTH_OF_YEAR);
                long year = temporal.getLong(ChronoField$.YEAR);
                return (long)doy - (long)this.QUARTER_DAYS()[(moy - 1) / 3 + (IsoChronology$.MODULE$.INSTANCE().isLeapYear(year) ? 4 : 0)];
            }
            Field field4 = IsoFields$Field$.QUARTER_OF_YEAR;
            Field field5 = field;
            if (!(field4 != null ? !field4.equals(field5) : field5 != null)) {
                if (!temporal.isSupported(this)) {
                    throw this.unsupportedEx(this.QY());
                }
                long moy = temporal.getLong(ChronoField$.MONTH_OF_YEAR);
                return (moy + 2L) / 3L;
            }
            Field field6 = IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR;
            Field field7 = field;
            if (!(field6 != null ? !field6.equals(field7) : field7 != null)) {
                if (!temporal.isSupported(this)) {
                    throw this.unsupportedEx(package$.MODULE$.WWBY());
                }
                return this.getWeek(LocalDate$.MODULE$.from(temporal));
            }
            Field field8 = IsoFields$Field$.WEEK_BASED_YEAR;
            Field field9 = field;
            if (!(field8 != null ? !field8.equals(field9) : field9 != null)) {
                if (!temporal.isSupported(this)) {
                    throw this.unsupportedEx(package$.MODULE$.WBY());
                }
                return this.getWeekBasedYear(LocalDate$.MODULE$.from(temporal));
            }
            throw new MatchError((Object)field);
        }

        @Override
        public TemporalUnit getRangeUnit() {
            Field field = this;
            Field field2 = IsoFields$Field$.DAY_OF_QUARTER;
            Field field3 = field;
            if (!(field2 != null ? !field2.equals(field3) : field3 != null)) {
                return IsoFields$.MODULE$.QUARTER_YEARS();
            }
            Field field4 = IsoFields$Field$.QUARTER_OF_YEAR;
            Field field5 = field;
            if (!(field4 != null ? !field4.equals(field5) : field5 != null)) {
                return ChronoUnit$.YEARS;
            }
            Field field6 = IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR;
            Field field7 = field;
            if (!(field6 != null ? !field6.equals(field7) : field7 != null)) {
                return IsoFields$.MODULE$.WEEK_BASED_YEARS();
            }
            Field field8 = IsoFields$Field$.WEEK_BASED_YEAR;
            Field field9 = field;
            if (!(field8 != null ? !field8.equals(field9) : field9 != null)) {
                return ChronoUnit$.FOREVER;
            }
            throw new MatchError((Object)field);
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            Field field = this;
            Field field2 = IsoFields$Field$.DAY_OF_QUARTER;
            Field field3 = field;
            if (!(field2 != null ? !field2.equals(field3) : field3 != null)) {
                return temporal.isSupported(ChronoField$.DAY_OF_YEAR) && temporal.isSupported(ChronoField$.MONTH_OF_YEAR) && temporal.isSupported(ChronoField$.YEAR) && this.isIso(temporal);
            }
            Field field4 = IsoFields$Field$.QUARTER_OF_YEAR;
            Field field5 = field;
            if (!(field4 != null ? !field4.equals(field5) : field5 != null)) {
                return temporal.isSupported(ChronoField$.MONTH_OF_YEAR) && this.isIso(temporal);
            }
            Field field6 = IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR;
            Field field7 = field;
            if (!(field6 != null ? !field6.equals(field7) : field7 != null)) {
                return temporal.isSupported(ChronoField$.EPOCH_DAY) && this.isIso(temporal);
            }
            Field field8 = IsoFields$Field$.WEEK_BASED_YEAR;
            Field field9 = field;
            if (!(field8 != null ? !field8.equals(field9) : field9 != null)) {
                return temporal.isSupported(ChronoField$.EPOCH_DAY) && this.isIso(temporal);
            }
            throw new MatchError((Object)field);
        }

        @Override
        public ValueRange range() {
            Field field = this;
            Field field2 = IsoFields$Field$.DAY_OF_QUARTER;
            Field field3 = field;
            if (!(field2 != null ? !field2.equals(field3) : field3 != null)) {
                return ValueRange$.MODULE$.of(1L, 90L, 92L);
            }
            Field field4 = IsoFields$Field$.QUARTER_OF_YEAR;
            Field field5 = field;
            if (!(field4 != null ? !field4.equals(field5) : field5 != null)) {
                return ValueRange$.MODULE$.of(1L, 4L);
            }
            Field field6 = IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR;
            Field field7 = field;
            if (!(field6 != null ? !field6.equals(field7) : field7 != null)) {
                return ValueRange$.MODULE$.of(1L, 52L, 53L);
            }
            Field field8 = IsoFields$Field$.WEEK_BASED_YEAR;
            Field field9 = field;
            if (!(field8 != null ? !field8.equals(field9) : field9 != null)) {
                return ChronoField$.YEAR.range();
            }
            throw new MatchError((Object)field);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            Field field = this;
            Field field2 = IsoFields$Field$.DAY_OF_QUARTER;
            Field field3 = field;
            if (!(field2 != null ? !field2.equals(field3) : field3 != null)) {
                if (!temporal.isSupported(this)) {
                    throw this.unsupportedEx(IsoFields$.MODULE$.java$time$temporal$IsoFields$$$DQ());
                }
                long qoy = temporal.getLong(IsoFields$Field$.QUARTER_OF_YEAR);
                if (qoy == 1L) {
                    long year = temporal.getLong(ChronoField$.YEAR);
                    if (IsoChronology$.MODULE$.INSTANCE().isLeapYear(year)) {
                        return ValueRange$.MODULE$.of(1L, 91L);
                    }
                    return ValueRange$.MODULE$.of(1L, 90L);
                }
                if (qoy == 2L) {
                    return ValueRange$.MODULE$.of(1L, 91L);
                }
                if (qoy == 3L || qoy == 4L) {
                    return ValueRange$.MODULE$.of(1L, 92L);
                }
                return this.range();
            }
            Field field4 = IsoFields$Field$.QUARTER_OF_YEAR;
            Field field5 = field;
            if (!(field4 != null ? !field4.equals(field5) : field5 != null)) {
                return this.range();
            }
            Field field6 = IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR;
            Field field7 = field;
            if (!(field6 != null ? !field6.equals(field7) : field7 != null)) {
                if (!temporal.isSupported(this)) {
                    throw this.unsupportedEx(package$.MODULE$.WWBY());
                }
                return this.getWeekRange(LocalDate$.MODULE$.from(temporal));
            }
            Field field8 = IsoFields$Field$.WEEK_BASED_YEAR;
            Field field9 = field;
            if (!(field8 != null ? !field8.equals(field9) : field9 != null)) {
                return ChronoField$.YEAR.range();
            }
            throw new MatchError((Object)field);
        }

        public String toString() {
            Field field = this;
            Field field2 = IsoFields$Field$.DAY_OF_QUARTER;
            Field field3 = field;
            if (!(field2 != null ? !field2.equals(field3) : field3 != null)) {
                return IsoFields$.MODULE$.java$time$temporal$IsoFields$$$DQ();
            }
            Field field4 = IsoFields$Field$.QUARTER_OF_YEAR;
            Field field5 = field;
            if (!(field4 != null ? !field4.equals(field5) : field5 != null)) {
                return this.QY();
            }
            Field field6 = IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR;
            Field field7 = field;
            if (!(field6 != null ? !field6.equals(field7) : field7 != null)) {
                return package$.MODULE$.WWBY();
            }
            Field field8 = IsoFields$Field$.WEEK_BASED_YEAR;
            Field field9 = field;
            if (!(field8 != null ? !field8.equals(field9) : field9 != null)) {
                return package$.MODULE$.WBY();
            }
            throw new MatchError((Object)field);
        }

        @Override
        public TemporalAccessor resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            Field field = this;
            Field field2 = IsoFields$Field$.DAY_OF_QUARTER;
            Field field3 = field;
            if (!(field2 != null ? !field2.equals(field3) : field3 != null)) {
                Long yearLong = fieldValues.get(ChronoField$.YEAR);
                Long qoyLong = fieldValues.get(IsoFields$Field$.QUARTER_OF_YEAR);
                if (yearLong == null || qoyLong == null) {
                    return null;
                }
                int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(yearLong));
                long doq = Predef$.MODULE$.Long2long(fieldValues.get(IsoFields$Field$.DAY_OF_QUARTER));
                LocalDate date = null;
                if (resolverStyle == ResolverStyle$.LENIENT) {
                    long qoy = Predef$.MODULE$.Long2long(qoyLong);
                    date = LocalDate$.MODULE$.of(y, 1, 1);
                    date = date.plusMonths(Math.multiplyExact(Math.subtractExact(qoy, 1L), 3L));
                    date = date.plusDays(Math.subtractExact(doq, 1L));
                } else {
                    long l;
                    int qoy = IsoFields$Field$.QUARTER_OF_YEAR.range().checkValidIntValue(Predef$.MODULE$.Long2long(qoyLong), IsoFields$Field$.QUARTER_OF_YEAR);
                    if (resolverStyle == ResolverStyle$.STRICT) {
                        int max = qoy == 1 ? (IsoChronology$.MODULE$.INSTANCE().isLeapYear(y) ? 91 : 90) : (qoy == 2 ? 91 : 92);
                        l = ValueRange$.MODULE$.of(1L, max).checkValidValue(doq, this);
                    } else {
                        l = this.range().checkValidValue(doq, this);
                    }
                    date = LocalDate$.MODULE$.of(y, (qoy - 1) * 3 + 1, 1).plusDays(doq - 1L);
                }
                fieldValues.remove(this);
                fieldValues.remove(ChronoField$.YEAR);
                fieldValues.remove(IsoFields$Field$.QUARTER_OF_YEAR);
                return date;
            }
            Field field4 = IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR;
            Field field5 = field;
            if (!(field4 != null ? !field4.equals(field5) : field5 != null)) {
                Long wbyLong = fieldValues.get(IsoFields$Field$.WEEK_BASED_YEAR);
                long dowLong = Predef$.MODULE$.Long2long(fieldValues.get(ChronoField$.DAY_OF_WEEK));
                if (wbyLong == null || !fieldValues.containsKey(ChronoField$.DAY_OF_WEEK)) {
                    return null;
                }
                int wby = IsoFields$Field$.WEEK_BASED_YEAR.range().checkValidIntValue(Predef$.MODULE$.Long2long(wbyLong), IsoFields$Field$.WEEK_BASED_YEAR);
                long wowby = Predef$.MODULE$.Long2long(fieldValues.get(IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR));
                LocalDate date = null;
                if (resolverStyle == ResolverStyle$.LENIENT) {
                    Tuple2 tuple2 = dowLong > 7L ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)((dowLong - 1L) % 7L + 1L)), (Object)BoxesRunTime.boxToLong((long)((dowLong - 1L) / 7L))) : (dowLong < 1L ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(dowLong % 7L + 7L)), (Object)BoxesRunTime.boxToLong((long)(dowLong / 7L - 1L))) : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)dowLong), (Object)BoxesRunTime.boxToLong((long)0L)));
                    long dow = BoxesRunTime.unboxToLong((Object)tuple2._1());
                    long weeks = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    date = LocalDate$.MODULE$.of(wby, 1, 4).plusWeeks(wowby - 1L).plusWeeks(weeks).with(ChronoField$.DAY_OF_WEEK, dow);
                } else {
                    long l;
                    int dow = ChronoField$.DAY_OF_WEEK.checkValidIntValue(dowLong);
                    if (resolverStyle == ResolverStyle$.STRICT) {
                        LocalDate temp = LocalDate$.MODULE$.of(wby, 1, 4);
                        ValueRange range = this.getWeekRange(temp);
                        l = range.checkValidValue(wowby, this);
                    } else {
                        l = this.range().checkValidValue(wowby, this);
                    }
                    date = LocalDate$.MODULE$.of(wby, 1, 4).plusWeeks(wowby - 1L).with(ChronoField$.DAY_OF_WEEK, dow);
                }
                fieldValues.remove(this);
                fieldValues.remove(IsoFields$Field$.WEEK_BASED_YEAR);
                fieldValues.remove(ChronoField$.DAY_OF_WEEK);
                return date;
            }
            return null;
        }

        @Override
        public String getDisplayName(Locale locale) {
            Field field = this;
            Field field2 = IsoFields$Field$.WEEK_OF_WEEK_BASED_YEAR;
            Field field3 = field;
            if (!(field2 != null ? !field2.equals(field3) : field3 != null)) {
                Objects.requireNonNull(locale, "locale");
                return "Week";
            }
            Objects.requireNonNull(locale, "locale");
            return this.toString();
        }

        private String QY() {
            return "QuarterOfYear";
        }

        private UnsupportedTemporalTypeException unsupportedEx(String f) {
            return new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(f).toString());
        }

        private int[] QUARTER_DAYS() {
            if (!this.QUARTER_DAYSbitmap$1) {
                this.QUARTER_DAYS$lzy1 = new int[]{0, 90, 181, 273, 0, 91, 182, 274};
                this.QUARTER_DAYSbitmap$1 = true;
            }
            return this.QUARTER_DAYS$lzy1;
        }

        private boolean isIso(TemporalAccessor temporal) {
            Chronology chronology = Chronology$.MODULE$.from(temporal);
            IsoChronology isoChronology = IsoChronology$.MODULE$.INSTANCE();
            return !(chronology != null ? !((Object)chronology).equals(isoChronology) : isoChronology != null);
        }

        private ValueRange getWeekRange(LocalDate date) {
            int wby = this.getWeekBasedYear(date);
            return ValueRange$.MODULE$.of(1L, this.getWeekRange(wby));
        }

        private int getWeekRange(int wby) {
            LocalDate date = LocalDate$.MODULE$.of(wby, 1, 1);
            if (date.getDayOfWeek() == DayOfWeek$.THURSDAY || date.getDayOfWeek() == DayOfWeek$.WEDNESDAY && date.isLeapYear()) {
                return 53;
            }
            return 52;
        }

        private int getWeek(LocalDate date) {
            int alignedWeek;
            int dow0 = date.getDayOfWeek().ordinal();
            int doy0 = date.getDayOfYear() - 1;
            int doyThu0 = doy0 + (3 - dow0);
            int firstThuDoy0 = doyThu0 - (alignedWeek = doyThu0 / 7) * 7;
            int firstMonDoy0 = firstThuDoy0 - 3;
            if (firstMonDoy0 < -3) {
                firstMonDoy0 += 7;
            }
            if (doy0 < firstMonDoy0) {
                return (int)this.getWeekRange(date.withDayOfYear(180).minusYears(1L)).getMaximum();
            }
            int week = (doy0 - firstMonDoy0) / 7 + 1;
            if (!(week != 53 || firstMonDoy0 == -3 || firstMonDoy0 == -2 && date.isLeapYear())) {
                week = 1;
            }
            return week;
        }

        private int getWeekBasedYear(LocalDate date) {
            int year = date.getYear();
            int doy = date.getDayOfYear();
            if (doy <= 3) {
                int dow = date.getDayOfWeek().ordinal();
                if (doy - dow < -2) {
                    --year;
                }
            } else if (doy >= 363) {
                int dow = date.getDayOfWeek().ordinal();
                if ((doy = doy - 363 - (date.isLeapYear() ? 1 : 0)) - dow >= 0) {
                    ++year;
                }
            }
            return year;
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }
    }

    public static abstract class Unit
    extends java.lang.Enum<Unit>
    implements TemporalUnit,
    Enum {
        private final String name;
        private final Duration duration;

        public static Unit fromOrdinal(int n) {
            return IsoFields$Unit$.MODULE$.fromOrdinal(n);
        }

        public static Unit valueOf(String string) {
            return IsoFields$Unit$.MODULE$.valueOf(string);
        }

        public static Unit[] values() {
            return IsoFields$Unit$.MODULE$.values();
        }

        public Unit(Duration duration, String _$name, int _$ordinal) {
            this.name = name;
            this.duration = duration;
        }

        private Duration duration() {
            return this.duration;
        }

        public static Unit WEEK_BASED_YEARS() {
            return IsoFields$Unit$.WEEK_BASED_YEARS;
        }

        public static Unit QUARTER_YEARS() {
            return IsoFields$Unit$.QUARTER_YEARS;
        }

        @Override
        public Duration getDuration() {
            return this.duration();
        }

        @Override
        public boolean isDurationEstimated() {
            return true;
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public boolean isSupportedBy(Temporal temporal) {
            return temporal.isSupported(ChronoField$.EPOCH_DAY);
        }

        @Override
        public <R extends Temporal> R addTo(R temporal, long periodToAdd) {
            Unit unit = this;
            Unit unit2 = IsoFields$Unit$.WEEK_BASED_YEARS;
            Unit unit3 = unit;
            if (!(unit2 != null ? !unit2.equals(unit3) : unit3 != null)) {
                long added = Math.addExact((long)temporal.get(IsoFields$.MODULE$.WEEK_BASED_YEAR()), periodToAdd);
                return (R)temporal.with(IsoFields$.MODULE$.WEEK_BASED_YEAR(), added);
            }
            Unit unit4 = IsoFields$Unit$.QUARTER_YEARS;
            Unit unit5 = unit;
            if (!(unit4 != null ? !unit4.equals(unit5) : unit5 != null)) {
                return (R)temporal.plus(periodToAdd / 256L, ChronoUnit$.YEARS).plus(periodToAdd % 256L * 3L, ChronoUnit$.MONTHS);
            }
            if (unit == null) {
                throw new IllegalStateException("Unreachable");
            }
            throw new MatchError((Object)unit);
        }

        @Override
        public long between(Temporal temporal1, Temporal temporal2) {
            Unit unit = this;
            Unit unit2 = IsoFields$Unit$.WEEK_BASED_YEARS;
            Unit unit3 = unit;
            if (!(unit2 != null ? !unit2.equals(unit3) : unit3 != null)) {
                return Math.subtractExact(temporal2.getLong(IsoFields$.MODULE$.WEEK_BASED_YEAR()), temporal1.getLong(IsoFields$.MODULE$.WEEK_BASED_YEAR()));
            }
            Unit unit4 = IsoFields$Unit$.QUARTER_YEARS;
            Unit unit5 = unit;
            if (!(unit4 != null ? !unit4.equals(unit5) : unit5 != null)) {
                return temporal1.until(temporal2, ChronoUnit$.MONTHS) / 3L;
            }
            if (unit == null) {
                throw new IllegalStateException("Unreachable");
            }
            throw new MatchError((Object)unit);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

