/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.time.Duration;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import scala.reflect.Enum;

public abstract class ChronoUnit
extends java.lang.Enum<ChronoUnit>
implements TemporalUnit,
Enum {
    private final String name;
    private final Duration duration;
    private ChronoUnit[] values$lzy1;
    private boolean valuesbitmap$1;

    public static ChronoUnit fromOrdinal(int n) {
        return ChronoUnit$.MODULE$.fromOrdinal(n);
    }

    public static ChronoUnit valueOf(String string) {
        return ChronoUnit$.MODULE$.valueOf(string);
    }

    public ChronoUnit(Duration duration, String _$name, int _$ordinal) {
        this.name = name;
        this.duration = duration;
    }

    private Duration duration() {
        return this.duration;
    }

    public static ChronoUnit NANOS() {
        return ChronoUnit$.NANOS;
    }

    public static ChronoUnit MICROS() {
        return ChronoUnit$.MICROS;
    }

    public static ChronoUnit MILLIS() {
        return ChronoUnit$.MILLIS;
    }

    public static ChronoUnit SECONDS() {
        return ChronoUnit$.SECONDS;
    }

    public static ChronoUnit MINUTES() {
        return ChronoUnit$.MINUTES;
    }

    public static ChronoUnit HOURS() {
        return ChronoUnit$.HOURS;
    }

    public static ChronoUnit HALF_DAYS() {
        return ChronoUnit$.HALF_DAYS;
    }

    public static ChronoUnit DAYS() {
        return ChronoUnit$.DAYS;
    }

    public static ChronoUnit WEEKS() {
        return ChronoUnit$.WEEKS;
    }

    public static ChronoUnit MONTHS() {
        return ChronoUnit$.MONTHS;
    }

    public static ChronoUnit YEARS() {
        return ChronoUnit$.YEARS;
    }

    public static ChronoUnit DECADES() {
        return ChronoUnit$.DECADES;
    }

    public static ChronoUnit CENTURIES() {
        return ChronoUnit$.CENTURIES;
    }

    public static ChronoUnit MILLENNIA() {
        return ChronoUnit$.MILLENNIA;
    }

    public static ChronoUnit ERAS() {
        return ChronoUnit$.ERAS;
    }

    public static ChronoUnit FOREVER() {
        return ChronoUnit$.FOREVER;
    }

    public ChronoUnit[] values() {
        if (!this.valuesbitmap$1) {
            this.values$lzy1 = new ChronoUnit[]{ChronoUnit$.NANOS, ChronoUnit$.MICROS, ChronoUnit$.MILLIS, ChronoUnit$.SECONDS, ChronoUnit$.MINUTES, ChronoUnit$.HOURS, ChronoUnit$.HALF_DAYS, ChronoUnit$.DAYS, ChronoUnit$.WEEKS, ChronoUnit$.MONTHS, ChronoUnit$.YEARS, ChronoUnit$.DECADES, ChronoUnit$.CENTURIES, ChronoUnit$.MILLENNIA, ChronoUnit$.ERAS, ChronoUnit$.FOREVER};
            this.valuesbitmap$1 = true;
        }
        return this.values$lzy1;
    }

    @Override
    public Duration getDuration() {
        return this.duration();
    }

    @Override
    public boolean isDurationEstimated() {
        return this.isDateBased() || this == ChronoUnit$.FOREVER;
    }

    @Override
    public boolean isDateBased() {
        return this.compareTo(ChronoUnit$.DAYS) >= 0 && this != ChronoUnit$.FOREVER;
    }

    @Override
    public boolean isTimeBased() {
        return this.compareTo(ChronoUnit$.DAYS) < 0;
    }

    @Override
    public boolean isSupportedBy(Temporal temporal) {
        boolean bl;
        if (this == ChronoUnit$.FOREVER) {
            return false;
        }
        if (temporal instanceof ChronoLocalDate) {
            return this.isDateBased();
        }
        if (temporal instanceof ChronoLocalDateTime || temporal instanceof ChronoZonedDateTime) {
            return true;
        }
        try {
            temporal.plus(1L, this);
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            try {
                temporal.plus(-1L, this);
                bl = true;
            }
            catch (RuntimeException runtimeException2) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public <R extends Temporal> R addTo(R dateTime, long periodToAdd) {
        return (R)dateTime.plus(periodToAdd, this);
    }

    @Override
    public long between(Temporal temporal1, Temporal temporal2) {
        return temporal1.until(temporal2, this);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

