/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import scala.reflect.Enum;

public abstract class ChronoField
extends java.lang.Enum<ChronoField>
implements TemporalField,
Enum {
    private final String name;
    private final int ordinal;
    private final TemporalUnit baseUnit;
    private final TemporalUnit rangeUnit;
    private final ValueRange _range;
    private ChronoField[] values$lzy1;
    private boolean valuesbitmap$1;

    public static ChronoField fromOrdinal(int n) {
        return ChronoField$.MODULE$.fromOrdinal(n);
    }

    public static ChronoField valueOf(String string) {
        return ChronoField$.MODULE$.valueOf(string);
    }

    public ChronoField(TemporalUnit baseUnit, TemporalUnit rangeUnit, ValueRange _range, String _$name, int _$ordinal) {
        this.name = name;
        this.ordinal = ordinal;
        this.baseUnit = baseUnit;
        this.rangeUnit = rangeUnit;
        this._range = _range;
    }

    private TemporalUnit baseUnit() {
        return this.baseUnit;
    }

    private TemporalUnit rangeUnit() {
        return this.rangeUnit;
    }

    private ValueRange _range() {
        return this._range;
    }

    public static ChronoField NANO_OF_SECOND() {
        return ChronoField$.NANO_OF_SECOND;
    }

    public static ChronoField NANO_OF_DAY() {
        return ChronoField$.NANO_OF_DAY;
    }

    public static ChronoField MICRO_OF_SECOND() {
        return ChronoField$.MICRO_OF_SECOND;
    }

    public static ChronoField MICRO_OF_DAY() {
        return ChronoField$.MICRO_OF_DAY;
    }

    public static ChronoField MILLI_OF_SECOND() {
        return ChronoField$.MILLI_OF_SECOND;
    }

    public static ChronoField MILLI_OF_DAY() {
        return ChronoField$.MILLI_OF_DAY;
    }

    public static ChronoField SECOND_OF_MINUTE() {
        return ChronoField$.SECOND_OF_MINUTE;
    }

    public static ChronoField SECOND_OF_DAY() {
        return ChronoField$.SECOND_OF_DAY;
    }

    public static ChronoField MINUTE_OF_HOUR() {
        return ChronoField$.MINUTE_OF_HOUR;
    }

    public static ChronoField MINUTE_OF_DAY() {
        return ChronoField$.MINUTE_OF_DAY;
    }

    public static ChronoField HOUR_OF_AMPM() {
        return ChronoField$.HOUR_OF_AMPM;
    }

    public static ChronoField CLOCK_HOUR_OF_AMPM() {
        return ChronoField$.CLOCK_HOUR_OF_AMPM;
    }

    public static ChronoField HOUR_OF_DAY() {
        return ChronoField$.HOUR_OF_DAY;
    }

    public static ChronoField CLOCK_HOUR_OF_DAY() {
        return ChronoField$.CLOCK_HOUR_OF_DAY;
    }

    public static ChronoField AMPM_OF_DAY() {
        return ChronoField$.AMPM_OF_DAY;
    }

    public static ChronoField DAY_OF_WEEK() {
        return ChronoField$.DAY_OF_WEEK;
    }

    public static ChronoField ALIGNED_DAY_OF_WEEK_IN_MONTH() {
        return ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH;
    }

    public static ChronoField ALIGNED_DAY_OF_WEEK_IN_YEAR() {
        return ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR;
    }

    public static ChronoField DAY_OF_MONTH() {
        return ChronoField$.DAY_OF_MONTH;
    }

    public static ChronoField DAY_OF_YEAR() {
        return ChronoField$.DAY_OF_YEAR;
    }

    public static ChronoField EPOCH_DAY() {
        return ChronoField$.EPOCH_DAY;
    }

    public static ChronoField ALIGNED_WEEK_OF_MONTH() {
        return ChronoField$.ALIGNED_WEEK_OF_MONTH;
    }

    public static ChronoField ALIGNED_WEEK_OF_YEAR() {
        return ChronoField$.ALIGNED_WEEK_OF_YEAR;
    }

    public static ChronoField MONTH_OF_YEAR() {
        return ChronoField$.MONTH_OF_YEAR;
    }

    public static ChronoField PROLEPTIC_MONTH() {
        return ChronoField$.PROLEPTIC_MONTH;
    }

    public static ChronoField YEAR_OF_ERA() {
        return ChronoField$.YEAR_OF_ERA;
    }

    public static ChronoField YEAR() {
        return ChronoField$.YEAR;
    }

    public static ChronoField ERA() {
        return ChronoField$.ERA;
    }

    public static ChronoField INSTANT_SECONDS() {
        return ChronoField$.INSTANT_SECONDS;
    }

    public static ChronoField OFFSET_SECONDS() {
        return ChronoField$.OFFSET_SECONDS;
    }

    public ChronoField[] values() {
        if (!this.valuesbitmap$1) {
            this.values$lzy1 = new ChronoField[]{ChronoField$.NANO_OF_SECOND, ChronoField$.NANO_OF_DAY, ChronoField$.MICRO_OF_SECOND, ChronoField$.MICRO_OF_DAY, ChronoField$.MILLI_OF_SECOND, ChronoField$.MILLI_OF_DAY, ChronoField$.SECOND_OF_MINUTE, ChronoField$.SECOND_OF_DAY, ChronoField$.MINUTE_OF_HOUR, ChronoField$.MINUTE_OF_DAY, ChronoField$.HOUR_OF_AMPM, ChronoField$.CLOCK_HOUR_OF_AMPM, ChronoField$.HOUR_OF_DAY, ChronoField$.CLOCK_HOUR_OF_DAY, ChronoField$.AMPM_OF_DAY, ChronoField$.DAY_OF_WEEK, ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH, ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR, ChronoField$.DAY_OF_MONTH, ChronoField$.DAY_OF_YEAR, ChronoField$.EPOCH_DAY, ChronoField$.ALIGNED_WEEK_OF_MONTH, ChronoField$.ALIGNED_WEEK_OF_YEAR, ChronoField$.MONTH_OF_YEAR, ChronoField$.PROLEPTIC_MONTH, ChronoField$.YEAR_OF_ERA, ChronoField$.YEAR, ChronoField$.ERA, ChronoField$.INSTANT_SECONDS, ChronoField$.OFFSET_SECONDS};
            this.valuesbitmap$1 = true;
        }
        return this.values$lzy1;
    }

    @Override
    public ValueRange range() {
        return this._range();
    }

    @Override
    public TemporalUnit getBaseUnit() {
        return this.baseUnit();
    }

    @Override
    public TemporalUnit getRangeUnit() {
        return this.rangeUnit();
    }

    @Override
    public boolean isDateBased() {
        return this.ordinal >= ChronoField$.DAY_OF_WEEK.ordinal() && this.ordinal <= ChronoField$.ERA.ordinal();
    }

    @Override
    public boolean isTimeBased() {
        return this.ordinal < ChronoField$.DAY_OF_WEEK.ordinal();
    }

    public long checkValidValue(long value) {
        return this._range().checkValidValue(value, this);
    }

    public int checkValidIntValue(long value) {
        return this._range().checkValidIntValue(value, this);
    }

    @Override
    public boolean isSupportedBy(TemporalAccessor temporal) {
        return temporal.isSupported(this);
    }

    @Override
    public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
        return temporal.range(this);
    }

    @Override
    public long getFrom(TemporalAccessor temporal) {
        return temporal.getLong(this);
    }

    @Override
    public <R extends Temporal> R adjustInto(R temporal, long newValue) {
        return (R)temporal.with(this, newValue);
    }

    @Override
    public String getDisplayName(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        return this.toString();
    }

    @Override
    public TemporalAccessor resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
        return null;
    }

    public String toString() {
        return this.name;
    }
}

