/*
 * Decompiled with CFR 0.152.
 */
package java.time.format.internal;

import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.format.internal.TTBPDateTimePrintContext$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.util.Locale;
import java.util.Objects;
import scala.Predef$;

public final class TTBPDateTimePrintContext {
    private TemporalAccessor temporal;
    private Locale locale;
    private DecimalStyle symbols;
    private int optional;

    public static TemporalAccessor adjust(TemporalAccessor temporalAccessor, DateTimeFormatter dateTimeFormatter) {
        return TTBPDateTimePrintContext$.MODULE$.adjust(temporalAccessor, dateTimeFormatter);
    }

    public TTBPDateTimePrintContext(TemporalAccessor temporal, Locale locale, DecimalStyle symbols) {
        this.temporal = temporal;
        this.locale = locale;
        this.symbols = symbols;
        this.optional = 0;
    }

    private TemporalAccessor temporal() {
        return this.temporal;
    }

    private void temporal_$eq(TemporalAccessor x$0) {
        this.temporal = x$0;
    }

    private Locale locale() {
        return this.locale;
    }

    private void locale_$eq(Locale x$0) {
        this.locale = x$0;
    }

    private DecimalStyle symbols() {
        return this.symbols;
    }

    private void symbols_$eq(DecimalStyle x$0) {
        this.symbols = x$0;
    }

    public TTBPDateTimePrintContext(TemporalAccessor temporal, DateTimeFormatter formatter) {
        this(TTBPDateTimePrintContext$.MODULE$.adjust(temporal, formatter), formatter.getLocale(), formatter.getDecimalStyle());
    }

    public TemporalAccessor getTemporal() {
        return this.temporal();
    }

    public Locale getLocale() {
        return this.locale();
    }

    public DecimalStyle getSymbols() {
        return this.symbols();
    }

    public void startOptional() {
        ++this.optional;
    }

    public void endOptional() {
        --this.optional;
    }

    public <R> R getValue(TemporalQuery<R> query) {
        R result = this.temporal().query(query);
        if (result == null && this.optional == 0) {
            throw new DateTimeException(new StringBuilder(25).append("Unable to extract value: ").append(this.temporal().getClass()).toString());
        }
        return result;
    }

    public Long getValue(TemporalField field) {
        Long l;
        try {
            l = Predef$.MODULE$.long2Long(this.temporal().getLong(field));
        }
        catch (DateTimeException ex) {
            if (this.optional <= 0) {
                throw ex;
            }
            l = null;
        }
        return l;
    }

    public String toString() {
        return this.temporal().toString();
    }

    public void setDateTime(TemporalAccessor temporal) {
        Objects.requireNonNull(temporal, "temporal");
        this.temporal_$eq(temporal);
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        this.locale_$eq(locale);
    }
}

