/*
 * Decompiled with CFR 0.152.
 */
package java.time.format.internal;

import java.time.Period;
import java.time.Period$;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology$;
import java.time.format.DateTimeBuilder;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.format.internal.TTBPDateTimeFormatterBuilder;
import java.time.format.internal.TTBPDateTimeParseContext$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class TTBPDateTimeParseContext {
    private Locale locale;
    private DecimalStyle symbols;
    private Chronology overrideChronology;
    private ZoneId overrideZone;
    private boolean caseSensitive;
    private boolean strict;
    private final ArrayList<Parsed> parsed;

    public static boolean charEqualsIgnoreCase(char c, char c2) {
        return TTBPDateTimeParseContext$.MODULE$.charEqualsIgnoreCase(c, c2);
    }

    public static boolean $lessinit$greater$default$5() {
        return TTBPDateTimeParseContext$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$6() {
        return TTBPDateTimeParseContext$.MODULE$.$lessinit$greater$default$6();
    }

    public TTBPDateTimeParseContext(Locale locale, DecimalStyle symbols, Chronology overrideChronology, ZoneId overrideZone, boolean caseSensitive, boolean strict) {
        this.locale = locale;
        this.symbols = symbols;
        this.overrideChronology = overrideChronology;
        this.overrideZone = overrideZone;
        this.caseSensitive = caseSensitive;
        this.strict = strict;
        ArrayList<Parsed> list = new ArrayList<Parsed>();
        list.add(new Parsed());
        this.parsed = list;
    }

    private Locale locale() {
        return this.locale;
    }

    private void locale_$eq(Locale x$0) {
        this.locale = x$0;
    }

    private DecimalStyle symbols() {
        return this.symbols;
    }

    private void symbols_$eq(DecimalStyle x$0) {
        this.symbols = x$0;
    }

    private Chronology overrideChronology() {
        return this.overrideChronology;
    }

    private void overrideChronology_$eq(Chronology x$0) {
        this.overrideChronology = x$0;
    }

    public ZoneId java$time$format$internal$TTBPDateTimeParseContext$$overrideZone() {
        return this.overrideZone;
    }

    private void overrideZone_$eq(ZoneId x$0) {
        this.overrideZone = x$0;
    }

    private boolean caseSensitive() {
        return this.caseSensitive;
    }

    private void caseSensitive_$eq(boolean x$0) {
        this.caseSensitive = x$0;
    }

    private boolean strict() {
        return this.strict;
    }

    private void strict_$eq(boolean x$0) {
        this.strict = x$0;
    }

    public TTBPDateTimeParseContext(DateTimeFormatter formatter) {
        this(formatter.getLocale(), formatter.getDecimalStyle(), formatter.getChronology(), formatter.getZone(), TTBPDateTimeParseContext$.MODULE$.$lessinit$greater$default$5(), TTBPDateTimeParseContext$.MODULE$.$lessinit$greater$default$6());
    }

    public TTBPDateTimeParseContext(Locale locale, DecimalStyle symbols, Chronology chronology) {
        this(locale, symbols, chronology, null, TTBPDateTimeParseContext$.MODULE$.$lessinit$greater$default$5(), TTBPDateTimeParseContext$.MODULE$.$lessinit$greater$default$6());
    }

    public TTBPDateTimeParseContext(TTBPDateTimeParseContext other) {
        this(other.locale(), other.symbols(), other.overrideChronology(), other.java$time$format$internal$TTBPDateTimeParseContext$$overrideZone(), other.caseSensitive(), other.strict());
    }

    public TTBPDateTimeParseContext copy() {
        return new TTBPDateTimeParseContext(this);
    }

    public Locale getLocale() {
        return this.locale();
    }

    public DecimalStyle getSymbols() {
        return this.symbols();
    }

    public Chronology getEffectiveChronology() {
        Chronology chrono = this.currentParsed().chrono();
        if (chrono == null && (chrono = this.overrideChronology()) == null) {
            chrono = IsoChronology$.MODULE$.INSTANCE();
        }
        return chrono;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive_$eq(caseSensitive);
    }

    public boolean subSequenceEquals(CharSequence cs1, int offset1, CharSequence cs2, int offset2, int length) {
        if (offset1 + length > cs1.length() || offset2 + length > cs2.length()) {
            return false;
        }
        if (this.isCaseSensitive()) {
            for (int i = 0; i < length; ++i) {
                char ch2;
                char ch1 = cs1.charAt(offset1 + i);
                if (ch1 == (ch2 = cs2.charAt(offset2 + i))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                char ch2;
                char ch1 = cs1.charAt(offset1 + i);
                if (ch1 == (ch2 = cs2.charAt(offset2 + i)) || Character.toUpperCase(ch1) == Character.toUpperCase(ch2) || Character.toLowerCase(ch1) == Character.toLowerCase(ch2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean charEquals(char ch1, char ch2) {
        if (this.isCaseSensitive()) {
            return ch1 == ch2;
        }
        return TTBPDateTimeParseContext$.MODULE$.charEqualsIgnoreCase(ch1, ch2);
    }

    public boolean isStrict() {
        return this.strict();
    }

    public void setStrict(boolean strict) {
        this.strict_$eq(strict);
    }

    public void startOptional() {
        this.parsed.add(this.currentParsed().copy());
    }

    public void endOptional(boolean successful) {
        if (successful) {
            this.parsed.remove(this.parsed.size() - 2);
            return;
        }
        this.parsed.remove(this.parsed.size() - 1);
    }

    private Parsed currentParsed() {
        return this.parsed.get(this.parsed.size() - 1);
    }

    public Long getParsed(TemporalField field) {
        return this.currentParsed().fieldValues().get(field);
    }

    public int setParsedField(TemporalField field, long value, int errorPos, int successPos) {
        Objects.requireNonNull(field, "field");
        Long old = this.currentParsed().fieldValues().put(field, Predef$.MODULE$.long2Long(value));
        if (old != null && old != value) {
            return ~errorPos;
        }
        return successPos;
    }

    public void setParsed(Chronology chrono) {
        Objects.requireNonNull(chrono, "chrono");
        Parsed _currentParsed = this.currentParsed();
        _currentParsed.chrono_$eq(chrono);
        if (_currentParsed.callbacks() != null) {
            Iterator<Object[]> callbacks = new ArrayList<Object[]>(_currentParsed.callbacks()).iterator();
            _currentParsed.callbacks().clear();
            while (callbacks.hasNext()) {
                Object[] objects = callbacks.next();
                TTBPDateTimeFormatterBuilder.ReducedPrinterParser pp = (TTBPDateTimeFormatterBuilder.ReducedPrinterParser)objects[0];
                pp.setValue(this, (Long)objects[1], Predef$.MODULE$.Integer2int((Integer)objects[2]), Predef$.MODULE$.Integer2int((Integer)objects[3]));
            }
            return;
        }
    }

    public void addChronologyChangedParser(TTBPDateTimeFormatterBuilder.ReducedPrinterParser reducedPrinterParser, long value, int errorPos, int successPos) {
        Parsed _currentParsed = this.currentParsed();
        if (_currentParsed.callbacks() == null) {
            _currentParsed.callbacks_$eq(new ArrayList<Object[]>(2));
        }
        _currentParsed.callbacks().add(new Object[]{reducedPrinterParser, BoxesRunTime.boxToLong((long)value), BoxesRunTime.boxToInteger((int)errorPos), BoxesRunTime.boxToInteger((int)successPos)});
    }

    public void setParsed(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        this.currentParsed().zone_$eq(zone);
    }

    public void setParsedLeapSecond() {
        this.currentParsed().leapSecond_$eq(true);
    }

    public Parsed toParsed() {
        return this.currentParsed();
    }

    public String toString() {
        return this.currentParsed().toString();
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        this.locale_$eq(locale);
    }

    public final class Parsed
    implements TemporalAccessor {
        private Chronology chrono;
        private ZoneId zone;
        private final Map fieldValues;
        private boolean leapSecond;
        private Period excessDays;
        private List callbacks;

        public Parsed() {
            if (TTBPDateTimeParseContext.this == null) {
                throw new NullPointerException();
            }
            this.chrono = null;
            this.zone = null;
            this.fieldValues = new HashMap();
            this.leapSecond = false;
            this.excessDays = Period$.MODULE$.ZERO();
            this.callbacks = null;
        }

        public Chronology chrono() {
            return this.chrono;
        }

        public void chrono_$eq(Chronology x$1) {
            this.chrono = x$1;
        }

        public ZoneId zone() {
            return this.zone;
        }

        public void zone_$eq(ZoneId x$1) {
            this.zone = x$1;
        }

        public Map<TemporalField, Long> fieldValues() {
            return this.fieldValues;
        }

        public boolean leapSecond() {
            return this.leapSecond;
        }

        public void leapSecond_$eq(boolean x$1) {
            this.leapSecond = x$1;
        }

        public Period excessDays() {
            return this.excessDays;
        }

        public void excessDays_$eq(Period x$1) {
            this.excessDays = x$1;
        }

        public List<Object[]> callbacks() {
            return this.callbacks;
        }

        public void callbacks_$eq(List<Object[]> x$1) {
            this.callbacks = x$1;
        }

        public Parsed copy() {
            Parsed cloned = new Parsed();
            cloned.chrono_$eq(this.chrono());
            cloned.zone_$eq(this.zone());
            cloned.fieldValues().putAll(this.fieldValues());
            cloned.leapSecond_$eq(this.leapSecond());
            return cloned;
        }

        public String toString() {
            return new StringBuilder(2).append(this.fieldValues().toString()).append(",").append(this.chrono()).append(",").append(this.zone()).toString();
        }

        @Override
        public boolean isSupported(TemporalField field) {
            return this.fieldValues().containsKey(field);
        }

        @Override
        public int get(TemporalField field) {
            if (!this.fieldValues().containsKey(field)) {
                throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
            }
            long value = Predef$.MODULE$.Long2long(this.fieldValues().get(field));
            return Math.toIntExact(value);
        }

        @Override
        public long getLong(TemporalField field) {
            if (!this.fieldValues().containsKey(field)) {
                throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
            }
            return Predef$.MODULE$.Long2long(this.fieldValues().get(field));
        }

        @Override
        public <R> R query(TemporalQuery<R> query) {
            if (query == TemporalQueries$.MODULE$.chronology()) {
                return (R)this.chrono();
            }
            if (query == TemporalQueries$.MODULE$.zoneId() || query == TemporalQueries$.MODULE$.zone()) {
                return (R)this.zone();
            }
            return (R)TemporalAccessor.query$(this, query);
        }

        public DateTimeBuilder toBuilder() {
            DateTimeBuilder builder = new DateTimeBuilder();
            builder.fieldValues().putAll(this.fieldValues());
            builder.chrono_$eq(TTBPDateTimeParseContext.this.getEffectiveChronology());
            if (this.zone() != null) {
                builder.zone_$eq(this.zone());
            } else {
                builder.zone_$eq(TTBPDateTimeParseContext.this.java$time$format$internal$TTBPDateTimeParseContext$$overrideZone());
            }
            builder.leapSecond_$eq(this.leapSecond());
            builder.excessDays_$eq(this.excessDays());
            return builder;
        }

        public final /* synthetic */ TTBPDateTimeParseContext java$time$format$internal$TTBPDateTimeParseContext$Parsed$$$outer() {
            return TTBPDateTimeParseContext.this;
        }
    }
}

